/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : I2C1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : InternalI2C
**     Version     : Component 01.282, Driver 02.04, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 12:14, # CodeGen: 3
**     Abstract    :
**          This component encapsulates the internal I2C communication 
**          interface. The implementation of the interface is based 
**          on the Philips I2C-bus specification version 2.0. 
**          Interface features:
**          MASTER mode
**            - Multi master communication
**            - The combined format of communication possible 
**              (see "Automatic stop condition" property)
**            - 7-bit slave addressing (10-bit addressing can be made as well)
**            - Acknowledge polling provided
**            - No wait state initiated when a slave device holds the SCL line low
**            - Holding of the SCL line low by slave device recognized as 'not available bus'
**            - Invalid start/stop condition detection provided
**          SLAVE mode
**            - 7-bit slave addressing
**            - General call address detection provided
**     Settings    :
**         Serial channel              : I2C0
**
**         Protocol
**             Mode                    : MASTER
**             Auto stop condition     : yes
**             SCL frequency           : 223.214 kHz
**
**         Initialization
**
**             Target slave address    : 80
**             Component init          : Enabled
**             Events                  : Enabled
**
**         Registers
**             Input buffer            : I2C0_D    [E0E4]
**             Output buffer           : I2C0_D    [E0E4]
**             Control register        : I2C0_C1   [E0E2]
**             Status register         : I2C0_S    [E0E3]
**             Baud setting reg.       : I2C0_F    [E0E1]
**             Address register        : I2C0_A1   [E0E0]
**             Glitch filter register  : I2C0_FLT  [E0E6]
**
**         Interrupt
**             Vector name             : INT_IIC0
**             Priority                : 1
**
**         Used pins                   :
**       ----------------------------------------------------------
**            Function    | On package |    Name
**       ----------------------------------------------------------
**              SDA       |     87     |  GPIOC14/SDA0/XB_OUT4
**              SCL       |     88     |  GPIOC15/SCL0/XB_OUT5
**       ----------------------------------------------------------
**     Contents    :
**         SendChar        - byte I2C1_SendChar(byte Chr);
**         RecvChar        - byte I2C1_RecvChar(byte *Chr);
**         SendBlock       - byte I2C1_SendBlock(void* Ptr, word Siz, word *Snt);
**         RecvBlock       - byte I2C1_RecvBlock(void* Ptr, word Siz, word *Rcv);
**         GetCharsInTxBuf - word I2C1_GetCharsInTxBuf(void);
**         GetCharsInRxBuf - word I2C1_GetCharsInRxBuf(void);
**         SelectSlave     - byte I2C1_SelectSlave(byte Slv);
**         CheckBus        - byte I2C1_CheckBus(void);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/


/* MODULE I2C1. */


#include "Events.h"
#include "I2C1.h"

#define OVERRUN_ERR      0x01U         /* Overrun error flag bit   */
#define WAIT_RX_CHAR     0x02U         /* Wait for received char. flag bit (Master)  */
#define CHAR_IN_TX       0x04U         /* Char is in TX buffer (Master)    */
#define CHAR_IN_RX       0x08U         /* Char is in RX buffer     */
#define FULL_TX          0x10U         /* Full transmit buffer     */
#define IN_PROGRES       0x20U         /* Communication is in progress (Master) */
#define FULL_RX          0x40U         /* Full receive buffer      */
#define MSxSL            0x80U         /* Master x Slave flag bit  */

static byte I2C1_SlaveAddr;            /* Variable for Slave address */
static word InpLenM;                   /* Length of input bufer's content */
static byte *InpPtrM;                  /* Pointer to input buffer for Master mode */
static word OutLenM;                   /* Length of output bufer's content */
static byte *OutPtrM;                  /* Pointer to output buffer for Master mode */
volatile word I2C1_SndRcvTemp;         /* Temporary variable for SendChar (RecvChar) when they call SendBlock (RecvBlock) */
static byte ChrTemp;                   /* Temporary variable for SendChar method */
static volatile byte I2C1_SerFlag;     /* Flags for serial communication */
                                       /* Bits: 0 - OverRun error */
                                       /*       1 - Wait for received char. flag bit (Master) */
                                       /*       2 - Char is in TX buffer (Master) */
                                       /*       3 - Char in RX buffer */
                                       /*       4 - Full TX buffer */
                                       /*       5 - Running int from TX */
                                       /*       6 - Full RX buffer */
                                       /*       7 - Master x Slave */

/*
** ===================================================================
**     Method      :  I2C1_Interrupt (component InternalI2C)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#define RXAK 0x01U
#define SRW  0x04U
#define IBAL 0x10U
#define IAAS 0x40U

#define ON_ARBIT_LOST 0x01U
#define ON_FULL_RX    0x02U
#define ON_RX_CHAR    0x04U
#define ON_FREE_TX    0x08U
#define ON_TX_CHAR    0x10U
#define ON_OVERRUN    0x20U
#define ON_TX_EMPTY   0x40U

#pragma interrupt alignsp saveall
void I2C1_Interrupt(void)
{
  register word Status;                /* Temporary variable for status register */

  Status = getReg(I2C0_S);             /* Safe status register */
  setRegBit(I2C0_S,IICIF);             /* Clear interrupt flag */
  if (getRegBit(I2C0_C1,MST) != 0x00U) { /* Is device in master mode? */
    I2C1_OnByteTransfer();             /* Invoke OnByteTransfer event */
    if (getRegBit(I2C0_C1,TX) != 0x00U) { /* Is device in Tx mode? */
      if ((Status & I2C0_S_RXAK_MASK) != 0x00U) { /* NACK received? */
        clrRegBit(I2C0_C1,MST);        /* Switch device to slave mode (stop signal sent) */
        OutLenM = 0U;                  /* No character for sending */
        InpLenM = 0U;                  /* No character for reception */
        I2C1_SerFlag &= (byte)~((byte)(CHAR_IN_TX|WAIT_RX_CHAR|IN_PROGRES)); /* No character for sending or reception */
        I2C1_OnNACK();                 /* Invoke OnNACK event */
      } else {
        if (OutLenM != 0x00U) {        /* Is any char. for transmitting? */
          OutLenM--;                   /* Decrease number of chars for the transmit */
          setReg(I2C0_D,*(OutPtrM)++); /* Send character */
        }
        else {
          if (InpLenM != 0x00U) {      /* Is any char. for reception? */
            if (InpLenM == 0x01U) {    /* If only one char to receive */
              setRegBit(I2C0_C1,TXAK); /* then transmit ACK disable */
            } else {
              clrRegBit(I2C0_C1,TXAK); /* else transmit ACK enable */
            }
            clrRegBit(I2C0_C1,TX);     /* Switch to Rx mode */
            getReg(I2C0_D);            /* Dummy read character */
          }
          else {
            I2C1_SerFlag &= (byte)~(IN_PROGRES); /* Clear flag "busy" */
            clrRegBit(I2C0_C1,MST);    /* Switch device to slave mode (stop signal sent) */
            clrRegBit(I2C0_C1,TX);     /* Switch to Rx mode */
            I2C1_OnTransmitData();     /* Invoke OnTransmitData event */
          }
        }
      }
    }
    else {
      InpLenM--;                       /* Decrease number of chars for the receive */
      if (InpLenM != 0x00U) {          /* Is any char. for reception? */
        if (InpLenM == 0x01U) {
          setRegBit(I2C0_C1,TXAK);     /* Transmit ACK disable */
        }
      } else {
        clrRegBit(I2C0_C1,MST);        /* If no, switch device to slave mode (stop signal sent) */
        clrRegBit(I2C0_C1,TXAK);       /* Transmit ACK enable */
      }
      *(InpPtrM)++ = (byte)getReg(I2C0_D); /* Receive character */
      if (InpLenM == 0x00U) {          /* Is any char. for reception? */
        I2C1_OnReceiveData();          /* Invoke OnReceiveData event */
      }
    }
  } else {
    if ((Status & I2C0_S_ARBL_MASK) != 0x00U) { /* Arbitration lost? */
      OutLenM = 0U;                    /* Any character is not for sent */
      InpLenM = 0U;                    /* Any character is not for reception */
      I2C1_SerFlag &= (byte)~((byte)(CHAR_IN_TX|WAIT_RX_CHAR|IN_PROGRES)); /* Any character is not for sent or reception*/
      clrRegBit(I2C0_C1,TX);           /* Switch to Rx mode */
      I2C1_OnArbitLost();              /* Invoke OnArbitLost event */
    }
  }
}

/*
** ===================================================================
**     Method      :  I2C1_SendChar (component InternalI2C)
**
**     Description :
**         When working as a MASTER, this method writes one (7-bit
**         addressing) or two (10-bit addressing) slave address bytes
**         inclusive of R/W bit = 0 to the I2C bus and then writes one
**         character (byte) to the bus. The slave address must be
**         specified before, by the "SelectSlave" or "SelectSlave10"
**         method or in the component initialization section, "Target
**         slave address init" property. If interrupt service is
**         enabled and the method returns ERR_OK, it doesn't mean that
**         transmission was successful. The state of transmission is
**         obtainable from (OnTransmitData, OnError or OnArbitLost)
**         events. 
**         When working as a SLAVE, this method writes a character to
**         the internal output slave buffer and, after the master
**         starts the communication, to the I2C bus. If no character is
**         ready for a transmission (internal output slave buffer is
**         empty), the Empty character will be sent (see "Empty
**         character" property).
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED -  Device is disabled
**                           ERR_BUSY - The slave device is busy, it
**                           does not respond by an acknowledge (only in
**                           master mode and when interrupt service is
**                           disabled)
**                           ERR_BUSOFF - Clock timeout elapsed or
**                           device cannot transmit data
**                           ERR_TXFULL - Transmitter is full (slave
**                           mode only)
**                           ERR_ARBITR - Arbitration lost (only when
**                           interrupt service is disabled and in master
**                           mode)
** ===================================================================
*/
byte I2C1_SendChar(byte Chr)
{
  if (getRegBit(I2C0_S,BUSY) != 0x00U) { /* Is the bus busy? */
    return ERR_BUSOFF;                 /* If yes then error */
  }
  if (InpLenM != 0x00U) {              /* Are any data to receiving? */
    return ERR_BUSOFF;                 /* If yes then error */
  }
  if ((I2C1_SerFlag & (byte)(CHAR_IN_TX|WAIT_RX_CHAR|IN_PROGRES)) != 0x00U) { /* Is the bus busy? */
    return ERR_BUSOFF;                 /* If yes then error */
  }
  ChrTemp = Chr;                       /* Save character */
  return (I2C1_SendBlock(&ChrTemp, 1U, ((void *)&I2C1_SndRcvTemp))); /* Send character and return */
}

/*
** ===================================================================
**     Method      :  I2C1_RecvChar (component InternalI2C)
**
**     Description :
**         When working as a MASTER, this method writes one (7-bit
**         addressing) or two (10-bit addressing) slave address bytes
**         inclusive of R/W bit = 1 to the I2C bus, then reads one
**         character (byte) from the bus and then sends the stop
**         condition. The slave address must be specified before, by
**         the "SelectSlave" or "SelectSlave10" method or in component
**         initialization section, property "Target slave address init".
**         If interrupt service is enabled and the method returns
**         ERR_OK, it doesn't mean that transmission was finished
**         successfully. The state of transmission must be tested by
**         means of events (OnReceiveData, OnError or OnArbitLost). In
**         case of successful transmission, received data is ready
**         after OnReceiveData event is called. 
**         When working as a SLAVE, this method reads a character from
**         the input slave buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - Received character.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED -  Device is disabled
**                           ERR_BUSY - The slave device is busy, it
**                           does not respond by the acknowledge (only
**                           in master mode and when interrupt service
**                           is disabled)
**                           ERR_BUSOFF - Clock timeout elapsed or
**                           device cannot receive data
**                           ERR_RXEMPTY - No data in receiver (slave
**                           mode only)
**                           ERR_OVERRUN - Overrun error was detected
**                           from the last character or block received
**                           (slave mode only)
**                           ERR_ARBITR - Arbitration lost (only when
**                           interrupt service is disabled and in master
**                           mode)
**                           ERR_NOTAVAIL - Method is not available in
**                           current mode - see the comment in the
**                           generated code
** ===================================================================
*/
/*
byte I2C1_RecvChar(byte *Chr)

**  This method is implemented as a macro. See I2C1.h file.  **
*/

/*
** ===================================================================
**     Method      :  I2C1_SendBlock (component InternalI2C)
**
**     Description :
**         When working as a MASTER, this method writes one (7-bit
**         addressing) or two (10-bit addressing) slave address bytes
**         inclusive of R/W bit = 0 to the I2C bus and then writes the
**         block of characters to the bus. The slave address must be
**         specified before, by the "SelectSlave" or "SlaveSelect10"
**         method or in component initialization section, "Target slave
**         address init" property. If interrupt service is enabled and
**         the method returns ERR_OK, it doesn't mean that transmission
**         was successful. The state of transmission is detectable by
**         means of events (OnTransmitData, OnError or OnArbitLost).
**         Data to be send is not copied to an internal buffer and
**         remains in the original location. Therefore the content of
**         the buffer should not be changed until the transmission is
**         complete. Event OnTransmitData can be used to detect the end
**         of the transmission.
**         When working as a SLAVE, this method writes a block of
**         characters to the internal output slave buffer and then,
**         after the master starts the communication, to the I2C bus.
**         If no character is ready for a transmission (internal output
**         slave buffer is empty), the "Empty character" will be sent
**         (see "Empty character" property). In SLAVE mode the data are
**         copied to an internal buffer, if specified by "Output buffer
**         size" property.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - Pointer to the block of data to send.
**         Siz             - Size of the block.
**       * Snt             - Amount of data sent (moved to a buffer).
**                           In master mode, if interrupt support is
**                           enabled, the parameter always returns the
**                           same value as the parameter 'Siz' of this
**                           method.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED -  Device is disabled
**                           ERR_BUSY - The slave device is busy, it
**                           does not respond by the acknowledge (only
**                           in master mode and when interrupt service
**                           is disabled)
**                           ERR_BUSOFF - Clock timeout elapsed or
**                           device cannot transmit data
**                           ERR_TXFULL - Transmitter is full. Some data
**                           has not been sent. (slave mode only)
**                           ERR_ARBITR - Arbitration lost (only when
**                           interrupt service is disabled and in master
**                           mode)
** ===================================================================
*/
byte I2C1_SendBlock(void* Ptr,word Siz,word *Snt)
{
  if (Siz == 0x00U) {                  /* Test variable Size on zero */
    *Snt = 0U;
    return ERR_OK;                     /* If zero then OK */
  }
  if (getRegBit(I2C0_S,BUSY) != 0x00U) { /* Is the bus busy? */
    return ERR_BUSOFF;                 /* If yes then error */
  }
  if (InpLenM != 0x00U) {              /* Are any data to receiving? */
    return ERR_BUSOFF;                 /* If yes then error */
  }
  if ((I2C1_SerFlag & (byte)(CHAR_IN_TX|WAIT_RX_CHAR|IN_PROGRES)) != 0x00U) { /* Is the bus busy? */
    return ERR_BUSOFF;                 /* If yes then error */
  }
  EnterCritical();                     /* Enter the critical section */
  I2C1_SerFlag |= IN_PROGRES;          /* Set flag "busy" */
  OutLenM = Siz;                       /* Set lenght of data */
  OutPtrM = (byte *)Ptr;               /* Save pointer to data for transmitting */
  setRegBit(I2C0_C1,TX);               /* Set TX mode */
  if (getRegBit(I2C0_C1,MST) != 0x00U) { /* Is device in master mode? */
    setRegBit(I2C0_C1,RSTA);           /* If yes then repeat start cycle generated */
  } else {
    setRegBit(I2C0_C1,MST);            /* If no then start signal generated */
  }
  setReg(I2C0_D,I2C1_SlaveAddr);       /* Send slave address */
  ExitCritical();                      /* Exit the critical section */
  *Snt = Siz;                          /* Dummy number of really sent chars */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  I2C1_RecvBlock (component InternalI2C)
**
**     Description :
**         When working as a MASTER, this method writes one (7-bit
**         addressing) or two (10-bit addressing) slave address bytes
**         inclusive of R/W bit = 1 to the I2C bus, then reads the
**         block of characters from the bus and then sends the stop
**         condition. The slave address must be specified before, by
**         the "SelectSlave" or "SelectSlave10" method or in component
**         initialization section, "Target slave address init" property.
**         If interrupt service is enabled and the method returns
**         ERR_OK, it doesn't mean that transmission was finished
**         successfully. The state of transmission must be tested by
**         means of events (OnReceiveData, OnError or OnArbitLost). In
**         case of successful transmission, received data is ready
**         after OnReceiveData event is called. 
**         When working as a SLAVE, this method reads a block of
**         characters from the input slave buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Ptr             - A pointer to the block space for received
**                           data.
**         Siz             - The size of the block.
**       * Rcv             - Amount of received data. In master mode,
**                           if interrupt support is enabled, the
**                           parameter always returns the same value as
**                           the parameter 'Siz' of this method.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED -  Device is disabled
**                           ERR_BUSY - The slave device is busy, it
**                           does not respond by an acknowledge (only in
**                           master mode and when interrupt service is
**                           disabled)
**                           ERR_BUSOFF - Clock timeout elapsed or
**                           device cannot receive data
**                           ERR_RXEMPTY - The receive buffer didn't
**                           contain the requested number of data. Only
**                           available data (or no data) has been
**                           returned  (slave mode only).
**                           ERR_OVERRUN - Overrun error was detected
**                           from last character or block receiving
**                           (slave mode only)
**                           ERR_ARBITR - Arbitration lost (only when
**                           interrupt service is disabled and in master
**                           mode)
**                           ERR_NOTAVAIL - Method is not available in
**                           current mode - see the comment in the
**                           generated code.
** ===================================================================
*/
byte I2C1_RecvBlock(void* Ptr,word Siz,word *Rcv)
{
  if (Siz == 0x00U) {                  /* Test variable Size on zero */
    *Rcv = 0U;
    return ERR_OK;                     /* If zero then OK */
  }
  if (getRegBit(I2C0_S,BUSY) != 0x00U) { /* Is the bus busy? */
    return ERR_BUSOFF;                 /* If yes then error */
  }
  if (InpLenM != 0x00U) {              /* Are any data to receiving? */
    return ERR_BUSOFF;                 /* If yes then error */
  }
  if ((I2C1_SerFlag & (byte)(CHAR_IN_TX|WAIT_RX_CHAR|IN_PROGRES)) != 0x00U) { /* Is the bus busy? */
    return ERR_BUSOFF;                 /* If yes then error */
  }
  EnterCritical();                     /* Enter the critical section */
  InpLenM = Siz;                       /* Set lenght of data */
  InpPtrM = (byte *)Ptr;               /* Save pointer to data for reception */
  setRegBit(I2C0_C1,TX);               /* Set TX mode */
  if (getRegBit(I2C0_C1,MST) != 0x00U) { /* Is device in master mode? */
    setRegBit(I2C0_C1,RSTA);           /* If yes then repeat start cycle generated */
  } else {
    setRegBit(I2C0_C1,MST);            /* If no then start signal generated */
  }
  setReg(I2C0_D,(word)((word)I2C1_SlaveAddr+1U)); /* Send slave address */
  ExitCritical();                      /* Exit the critical section */
  *Rcv = Siz;                          /* Dummy number of really received chars */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  I2C1_GetCharsInTxBuf (component InternalI2C)
**
**     Description :
**         Returns number of characters in the output buffer. In SLAVE
**         mode returns the number of characters in the internal slave
**         output buffer. In MASTER mode returns number of characters
**         to be sent from the user buffer (passed by SendBlock method).
**         This method is not supported in polling mode.
**     Parameters  : None
**     Returns     :
**         ---             - Number of characters in the output buffer.
** ===================================================================
*/
word I2C1_GetCharsInTxBuf(void)
{
  return OutLenM;                      /* Return number of chars remaining in the Master Tx buffer */
}

/*
** ===================================================================
**     Method      :  I2C1_GetCharsInRxBuf (component InternalI2C)
**
**     Description :
**         Returns number of characters in the input buffer. In SLAVE
**         mode returns the number of characters in the internal slave
**         input buffer. In MASTER mode returns number of characters to
**         be received into a user buffer (passed by RecvChar or
**         RecvBlock method).
**         This method is not supported in polling mode.
**     Parameters  : None
**     Returns     :
**         ---             - Number of characters in the input buffer.
** ===================================================================
*/
word I2C1_GetCharsInRxBuf(void)
{
  return InpLenM;                      /* Return number of chars remaining in the Master Rx buffer */
}

/*
** ===================================================================
**     Method      :  I2C1_SelectSlave (component InternalI2C)
**
**     Description :
**         This method selects a new slave for communication by its
**         7-bit slave address value. Any send or receive method
**         directs to or from selected device, until a new slave device
**         is selected by this method. This method is not available for
**         the SLAVE mode.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Slv             - 7-bit slave address value.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_BUSY - The device is busy, wait until
**                           the current operation is finished.
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED -  The device is disabled
** ===================================================================
*/
byte I2C1_SelectSlave(byte Slv)
{
  if (getRegBit(I2C0_C1,MST) != 0x00U) { /* Is the device in the active state? */
    return ERR_BUSY;                   /* If yes then error */
  }
  I2C1_SlaveAddr = (byte)(Slv << 1);   /* Set slave address */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  I2C1_Init (component InternalI2C)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void I2C1_Init(void)
{
  /* I2C0_C1: IICEN=0,IICIE=0,MST=0,TX=0,TXAK=0,RSTA=0,WUEN=0,DMAEN=0 */
  setReg(I2C0_C1,0U);                  /* Clear control register */
  I2C1_SerFlag = 0x80U;                /* Reset all flags */
  I2C1_SlaveAddr = 0xA0U;              /* Set variable for slave address */
  /* I2C0_FLT: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,SHEN=0,??=0,??=0,FLT=0 */
  setReg(I2C0_FLT,0x00U);              /* Set glitch filter register */
  /* I2C0_F: MULT=1,ICR=0x22 */
  setReg(I2C0_F,0x62U);                /* Set prescaler bits */
  /* I2C0_SMB: FACK=0,ALERTEN=0,SIICAEN=0,TCKSEL=0,SLTF=1,SHTF1=0,SHTF2=0,SHTF2IE=0 */
  setReg(I2C0_SMB,0x08U);
  setRegBit(I2C0_C1,IICEN);            /* Enable device */
  /* I2C0_C1: IICEN=1,IICIE=1,MST=0,TX=0,TXAK=0,RSTA=0,WUEN=0,DMAEN=0 */
  setReg(I2C0_C1,0xC0U);               /* Control register settings */
}

/*
** ===================================================================
**     Method      :  I2C1_CheckBus (component InternalI2C)
**
**     Description :
**         This method returns the status of the bus. If the START
**         condition has been detected, the method returns
**         'ComponentName'_BUSY. If the STOP condition has been
**         detected, the method returns 'ComponentName'_IDLE.
**     Parameters  : None
**     Returns     :
**         ---             - Status of the bus.
** ===================================================================
*/
/*
byte I2C1_CheckBus(void)

**  This method is implemented as a macro. See I2C1.h file.  **
*/


/* END I2C1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
