/** ###################################################################
**     Filename    : Events.h
**     Project     : IntI2C
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 11:39, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/

#ifndef __Events_H
#define __Events_H
/* MODULE Events */

#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "I2C1.h"
#include "TEST1.h"

void I2C1_OnReceiveData(void);
/*
** ===================================================================
**     Event       :  I2C1_OnReceiveData (module Events)
**
**     Component   :  I2C1 [InternalI2C]
**     Description :
**         This event is invoked when I2C finishes the reception of
**         the data successfully. This event is not available for
**         the SLAVE mode and if both RecvChar and RecvBlock are
**         disabled. This event is enabled only if interrupts/events
**         are enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void I2C1_OnTransmitData(void);
/*
** ===================================================================
**     Event       :  I2C1_OnTransmitData (module Events)
**
**     Component   :  I2C1 [InternalI2C]
**     Description :
**         This event is invoked when I2C finishes the transmission
**         of the data successfully. This event is not available for
**         the SLAVE mode and if both SendChar and SendBlock are
**         disabled. This event is enabled only if interrupts/events
**         are enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/


void I2C1_OnByteTransfer(void);
/*
** ===================================================================
**     Event       :  I2C1_OnByteTransfer (module Events)
**
**     Component   :  I2C1 [InternalI2C]
**     Description :
**         This event is called when one-byte transfer (including
**         the acknowledge bit) is successfully finished (slave
**         address or one data byte is transmitted or received).
**         This event is not available for the SLAVE mode and if all
**         RecvChar, RecvBlock, SendChar and SendBlock are disabled.
**         Note: It is possible to use the event for slowing down
**         communication, when slower slave needs some time for data
**         processing.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void I2C1_OnArbitLost(void);
/*
** ===================================================================
**     Event       :  I2C1_OnArbitLost (module Events)
**
**     Component   :  I2C1 [InternalI2C]
**     Description :
**         This event is called when the master lost the bus
**         arbitration or the device detects an error on the bus.
**         This event is enabled only if interrupts/events are
**         enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void I2C1_OnNACK(void);
/*
** ===================================================================
**     Event       :  I2C1_OnNACK (module Events)
**
**     Component   :  I2C1 [InternalI2C]
**     Description :
**         Called when a no slave acknowledge (NAK) occurs during
**         communication. This event is not available for the SLAVE
**         mode. This event is enabled only if interrupts/events are
**         enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

/* END Events */
#endif /* __Events_H*/

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
