/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : IntI2C
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 11:39, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_IntI2C */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "I2C1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

volatile word OnReceiveDataNum = 0;
volatile word OnTransmitDataNum = 0;
volatile word OnByteTransferNum = 0;
volatile word OnArbitLostNum = 0;
volatile word OnNACKNum = 0;

volatile word OnSendRecvDataNum;
volatile word OnErrorNum;


/* Communication with I2C EEPROM 24xx08 */

/* 
Scenario:
0 Wrong slave address

1 a) Send memory address + data (1..10)
  b) Send memory address
  c) Receive 10 bytes

2 a) Send memory address + data (0xAA's)
  b) Send memory address
  c) Receive 10 bytes

*/

volatile byte Err;

void main(void)
{
  test_sRec testRec;
  byte Data[11];
  byte RecvData[10];
  word rcv;
  bool Error = FALSE;
  byte i;
  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "InternalI2C test");
  TEST1_testComment(&testRec, "Please interconnect the pins GPIOC14_SDA0_XB_OUT0 and GPIOC15_SCL0_XB_OUT1 with 24xx08 serial EEPROM.");
  
  Data[0] = 0;
  
  /* Wrong address slave */	
  OnErrorNum = 0;
  I2C1_SelectSlave(88);
  Err = I2C1_SendBlock(&Data[0],1,&rcv);
  Cpu_Delay100US(1);
  I2C1_SelectSlave(80);

  /* Send memory address + data (1..10) */
  for (i=1; i<11; i++) {
    Data[i] = i;
  }
  while ((OnSendRecvDataNum == 0) && (OnErrorNum == 0)) {}
  while (I2C1_CheckBus() == I2C1_BUSOFF) {}
  OnErrorNum = 0;
  OnSendRecvDataNum = 0;
  Err = I2C1_SendBlock(&Data[0],11,&rcv);
  if ((Err) || (rcv != 11)) {
    Error = TRUE;
  }
  while ((OnSendRecvDataNum == 0) && (OnErrorNum == 0)) {}
  while (I2C1_CheckBus() == I2C1_BUSOFF) {}
  OnErrorNum = 0;
  OnSendRecvDataNum = 0;
  Cpu_Delay100US(100);
  /* Send memory address */
  Err = I2C1_SendBlock(&Data[0],1,&rcv);
  if ((Err) || (rcv != 1)) {
    Error = TRUE;
  }
  while ((OnSendRecvDataNum == 0) && (OnErrorNum == 0)) {}
  while (I2C1_CheckBus() == I2C1_BUSOFF) {}
  OnErrorNum = 0;
  OnSendRecvDataNum = 0;
  /* Receive 10 bytes */
  do {
    Err = I2C1_RecvBlock(&RecvData[0],10,&rcv);
  } while (Err == ERR_BUSOFF);
  
  while ((OnSendRecvDataNum == 0) && (OnErrorNum == 0)) {}
  while (I2C1_CheckBus() == I2C1_BUSOFF) {}
  if ((Err) || (rcv != 10) || (OnSendRecvDataNum != 1)) {
    Error = TRUE;
  }
  for (i=1; i<11; i++) {
    if (RecvData[i-1] != i) {
      Error = TRUE;
    }
  }
  

  /* Send memory address + data (0xAA's) */
  for (i=1; i<11; i++) {
    Data[i] = 0xAA;
  }
  OnErrorNum = 0;
  OnSendRecvDataNum = 0;
  Err = I2C1_SendBlock(&Data[0],11,&rcv);
  if ((Err) || (rcv != 11)) {
    Error = TRUE;
  }
  while ((OnSendRecvDataNum == 0) && (OnErrorNum == 0)) {}
  while (I2C1_CheckBus() == I2C1_BUSOFF) {}
  OnErrorNum = 0;
  OnSendRecvDataNum = 0;
  Cpu_Delay100US(100);
  /* Send memory address */
  Err = I2C1_SendBlock(&Data[0],1,&rcv);
  if ((Err) || (rcv != 1)) {
    Error = TRUE;
  }
  while ((OnSendRecvDataNum == 0) && (OnErrorNum == 0)) {}
  while (I2C1_CheckBus() == I2C1_BUSOFF) {}
  OnErrorNum = 0;
  OnSendRecvDataNum = 0;
  /* Receive 10 bytes */
  do {
    Err = I2C1_RecvBlock(&RecvData[0],10,&rcv);
  } while (Err == ERR_BUSOFF);
  while ((OnSendRecvDataNum == 0) && (OnErrorNum == 0)) {}
  while (I2C1_CheckBus() == I2C1_BUSOFF) {}
  if ((Err) || (rcv != 10) || (OnSendRecvDataNum != 1)) {
    Error = TRUE;
  }
  for (i=1; i<11; i++) {
    if (RecvData[i-1] != 0xAA) {
      Error = TRUE;
    }
  }
  if (!Error) {
    TEST1_testComment(&testRec, "Stored data verification OK.");
  }
  else {
    TEST1_testFailed(&testRec, "Stored data verification.");
  }

  /* Event test */
  Error = FALSE;
  if (OnReceiveDataNum != 2) {
    Error = TRUE;
  }
  if (OnTransmitDataNum != 4) {
    Error = TRUE;
  }
  if (OnByteTransferNum != 51) {
    Error = TRUE;
  }
  if (OnArbitLostNum != 0) {
    Error = TRUE;
  }
  if (OnNACKNum != 1) {
    Error = TRUE;
  }
  if (!Error) {
    TEST1_testComment(&testRec, "Event test OK.");
  }
  else {
    TEST1_testFailed(&testRec, "Event test.");
  }
  
  TEST1_testEnd(&testRec);
}


/* END demo_IntI2C */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
