/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : IntVect
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 12:00, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_IntVect */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "IV1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define TEST_COUNT 5

void TmrInt(void);

volatile byte count=0;

void main(void)
{
  test_sRec testRec;
  

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "InterruptVector test");
  TEST1_testComment(&testRec, "Waiting for interrupts ...");

  setReg16Bits(SIM_PCE0, 0x8000U);     /* Enable prph.clocks in the SIM_PCE0 register before Common initialization */
  /* TMR0_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=0,DIR=0,Co_INIT=0,OM=0 */
  setReg(TMRA_0_CTRL,0);                /* Stop all functions of the timer */
  /* TMR0_SCR: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,Capture_Mode=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMRA_0_SCTRL,0);
  setReg(TMRA_0_CNTR,0);                /* Reset counter register */
  setReg(TMRA_0_LOAD,0);                /* Reset load register */
  setRegBit(TMRA_0_SCTRL,TOFIE);        /* Enable counter overflow interrupt */
  setRegBitGroup(TMRA_0_CTRL,PCS,15);   /* Store given value to the prescaler */
  setReg(TMRA_0_CNTR,0);                /* Reset counter */
  setRegBitGroup(TMRA_0_CTRL,CM,1);     /* Run counter */
  setReg16Bits(TMRA_0_ENBL, 0x01U);      /* TMRA_ENBL: ENBL|=1 */
  //
  while (count < TEST_COUNT){}
  TEST1_testComment(&testRec, "PASSED");
  TEST1_testEnd(&testRec);
  //
}

#pragma interrupt alignsp
void TmrInt(void)
{
  clrRegBit(TMRA_0_SCTRL,TOF);            /* Reset interrupt request flag */
  if (++count == TEST_COUNT)
    clrRegBit(TMRA_0_SCTRL,TOFIE);        /* Disable counter overflow interrupt */
}

/* END demo_IntVect */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
