/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Cpu.h
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : MC56F84789VLL
**     Version     : Component 01.066, Driver 01.00, CPU db: 3.50.001
**     Datasheet   : MC56F847XXRM Rev.0RC 10/201
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 21:21, # CodeGen: 28
**     Abstract    :
**
**     Settings    :
**
**     Contents    :
**         EnableInt  - void Cpu_EnableInt(void);
**         DisableInt - void Cpu_DisableInt(void);
**         Delay100US - asm void Cpu_Delay100US(word us100);
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

#ifndef __Cpu_H
#define __Cpu_H

/* MODULE Cpu. */

/* Active PE project configuration */
#define PEcfg_MC56F84789VLL_Internal_PFlash_SDM 1

/* Active CPU bean */
#define PE_CPU_TYPE_MC56F84789VLL

/* Active CPU variant */
#define PE_CPU_VARIANT_MC56F84789VLL

/* Active CPU family */
#define PE_CPU_FAMILY_56800

/* Active CPU subfamily */
#define PE_CPU_SUBFAMILY_56F84xxx

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "PESL.h"
#include "assert.h"

#ifndef __BWUserType_TShadowRegs
#define __BWUserType_TShadowRegs
  typedef struct {                     /* Shadow register type. */
    int32_t N;                         /* Shadow register N. */
    int16_t N3;                        /* Shadow register N3. */
    int16_t M01;                       /* Shadow register M01. */
    word* R0;                          /* Shadow register R0. */
    word* R1;                          /* Shadow register R1. */
    word* R3;                          /* Shadow register R3. */
    word* R4;                          /* Shadow register R4. */
    word* R5;                          /* Shadow register R5. */
    word* R2;                          /* Shadow register R2. In InitShadowRegs() this register is used to index through TShadowRegs so is placed as last struct item */
  } TShadowRegs;
#endif

/*lint -esym(765,SR_reg,SR_lock,_EntryPoint,_vect,_vectboot) Disable MISRA rule (8.10) checking for symbols (SR_reg,SR_lock,_EntryPoint,_vect,_vectboot). */
/* Global variables */
extern volatile word SR_lock;          /* Lock */
extern volatile word SR_reg;           /* Current value of the SR register */



/*lint -save  -e586 Disable MISRA rule (2.1) checking. Method is implemented using assembler. */
asm void Cpu_Delay100US(word us100);
/*
** ===================================================================
**     Method      :  Cpu_Delay100US (component MC56F84789VLL)
**
**     Description :
**         This method realizes software delay. The length of delay
**         is at least 100 microsecond multiply input parameter
**         [us100]. As the delay implementation is not based on real
**         clock, the delay time may be increased by interrupt
**         service routines processed during the delay. Adding read
**         wait states for external program memory can cause delay
**         extension as well. The method is independent on selected
**         speed mode.
**     Parameters  :
**         NAME            - DESCRIPTION
**         us100           - Number of 100 us delay repetitions.
**     Returns     : Nothing
** ===================================================================
*/
/*lint -restore Enable MISRA rule (2.1) checking. */

#define   Cpu_DisableInt()  __DI()     /* Disable interrupts */
/*
** ===================================================================
**     Method      :  Cpu_DisableInt (component MC56F84789VLL)
**
**     Description :
**         Disables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

#define   Cpu_EnableInt()  __EI(0)     /* Enable interrupts */
/*
** ===================================================================
**     Method      :  Cpu_EnableInt (component MC56F84789VLL)
**
**     Description :
**         Enables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void Cpu__ivINT_GPIOF(void);
/*
** ===================================================================
**     Method      :  Cpu__ivINT_GPIOF (component MC56F84789VLL)
**
**     Description :
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void PE_low_level_init(void);
/*
** ===================================================================
**     Method      :  PE_low_level_init (component MC56F84789VLL)
**
**     Description :
**         Initializes beans and provides common register initialization. 
**         The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void Cpu_Interrupt(void);
/*
** ===================================================================
**     Method      :  Cpu_Interrupt (component MC56F84789VLL)
**
**     Description :
**         The method services unhandled interrupt vectors.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/


void _EntryPoint(void);
/*
** ===================================================================
**     Method      :  _EntryPoint (component MC56F84789VLL)
**
**     Description :
**         Initializes the whole system like timing and so on. At the end 
**         of this function, the C startup is invoked to initialize stack,
**         memory areas and so on.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/* END Cpu. */

#endif
/* __Cpu_H */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
