/** ###################################################################
**     Filename    : Events.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-09, 16:14, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

/* User includes (#include below this line is not maintained by Processor Expert) */
#include "globals.h"

/* External variables from main.c */
extern APPCONTROL_T appControl;
extern UWord16 directionOfRotation;
extern UWord16 captureHall1, captureHall2, captureHall3;
extern UWord16 hs_period;
extern UWord16 lowspeed_cntr;
extern Frac16 motor_speed;
extern Frac16 motor_speed_cmd;
extern Frac16 motor_speed_ramp;
extern Frac16 pwm_duty_cycle;
extern Frac16 i_dc_bus_filt;
extern Word16 i_sample_delay;
extern Frac16 i_dc_bus_limit;
extern mc_sPIparams1_limitSc speedCtrlParams;
extern mc_sPIparams1_limitSc currentCtrlParams;
extern UWord16 ref_a_value;

/*
** ===================================================================
**     Event       :  Cap3_OnCapture (module Events)
**
**     Component   :  Cap3 [Capture]
**     Description :
**         This event is called on capturing of Timer/Counter actual
**         value (only when the component is enabled - <Enable> and the
**         events are enabled - <EnableEvent>.This event is available
**         only if a <interrupt service/event> is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void Cap3_OnCapture(void)
{
	Cap3_TCapturedValue capture_temp;
		
	ComutateBLDC(directionOfRotation);
	capture_temp = getReg(TMRA_2_CAPT);
	hs_period = (capture_temp - captureHall3)>>1;
	captureHall3 = capture_temp;
	lowspeed_cntr = 0;
	appControl.B.lowspeed = 0;
}

/*
** ===================================================================
**     Event       :  Cap2_OnCapture (module Events)
**
**     Component   :  Cap2 [Capture]
**     Description :
**         This event is called on capturing of Timer/Counter actual
**         value (only when the component is enabled - <Enable> and the
**         events are enabled - <EnableEvent>.This event is available
**         only if a <interrupt service/event> is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void Cap2_OnCapture(void)
{
	Cap2_TCapturedValue capture_temp;
		
	ComutateBLDC(directionOfRotation);
	capture_temp = getReg(TMRA_3_CAPT);
	hs_period = (capture_temp - captureHall2)>>1;
	captureHall2 = capture_temp;
	lowspeed_cntr = 0;
	appControl.B.lowspeed = 0;
}

/*
** ===================================================================
**     Event       :  Cap1_OnCapture (module Events)
**
**     Component   :  Cap1 [Capture]
**     Description :
**         This event is called on capturing of Timer/Counter actual
**         value (only when the component is enabled - <Enable> and the
**         events are enabled - <EnableEvent>.This event is available
**         only if a <interrupt service/event> is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void Cap1_OnCapture(void)
{
	Cap1_TCapturedValue capture_temp;
		
	ComutateBLDC(directionOfRotation);
	capture_temp = getReg(TMRA_0_CAPT);
	hs_period = (capture_temp - captureHall1)>>1;
	captureHall1 = capture_temp;
	lowspeed_cntr = 0;
	appControl.B.lowspeed = 0;
}

/*
** ===================================================================
**     Event       :  EInt2_OnInterrupt (module Events)
**
**     Component   :  EInt2 [ExtInt]
**     Description :
**         This event is called when an active signal edge/level has
**         occurred.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void EInt2_OnInterrupt(void)
{
	appControl.B.button_up = 1;
	EInt2_Disable();
}


/*
** ===================================================================
**     Event       :  EInt1_OnInterrupt (module Events)
**
**     Component   :  EInt1 [ExtInt]
**     Description :
**         This event is called when an active signal edge/level has
**         occurred.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void EInt1_OnInterrupt(void)
{
	appControl.B.button_down = 1;
	EInt1_Disable();
}


/*
** ===================================================================
**     Event       :  TI1_OnInterrupt (module Events)
**
**     Component   :  TI1 [TimerInt]
**     Description :
**         When a timer interrupt occurs this event is called (only
**         when the component is enabled - <Enable> and the events are
**         enabled - <EnableEvent>). This event is enabled only if a
**         <interrupt service/event> is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void TI1_OnInterrupt(void)
{
	UWord16 val3, val1;
	Frac16 motor_speed_ramp_abs, motor_speed_fb;
		
	if(appControl.B.lowspeed == 1)
	{
		/* if low speed detected motor speed = 0 */
		motor_speed_fb = 0;
	}
	else
	{
		/* if speed > minimum speed calculate speed */
		if(hs_period <= SPEED_DIV_CONST) hs_period=SPEED_DIV_CONST;
		motor_speed_fb = div_s(SPEED_DIV_CONST, (Frac16)hs_period);
	}
		
	if(directionOfRotation == 1) 
		motor_speed= - motor_speed_fb;
	else
		motor_speed= motor_speed_fb;
		
	/* Motor required speed limit */
	if(motor_speed_cmd > SPEED_CMD_MAX)
		motor_speed_cmd = SPEED_CMD_MAX;
	else if(motor_speed_cmd < -SPEED_CMD_MAX)
		motor_speed_cmd = -SPEED_CMD_MAX;
	
	/* Motor required speed ramp */
	motor_speed_ramp =	MC2_rampGetValue(SPEED_RAMP_INC, SPEED_RAMP_INC, &motor_speed_ramp ,&motor_speed_cmd);

	/* Execute DC-Bus Current PI Controller */
	/* Current controller sets output limit of the speed current controller */
	speedCtrlParams.PositivePILimit = MC1_controllerPItype1_asmSc(i_dc_bus_limit, i_dc_bus_filt, &currentCtrlParams);

	/* Execute Speed PI Controller */
	motor_speed_ramp_abs = abs_s(motor_speed_ramp);
	pwm_duty_cycle = MC1_controllerPItype1_asmSc(motor_speed_ramp_abs, motor_speed_fb, &speedCtrlParams);

	/* Apply required PWM duty-cycle */	
	val3 = (UWord16)mult(PWM_MODULO, pwm_duty_cycle);
	PESL(PWMA, PWM_SM0_WRITE_VALUE_REG3, val3);
	PESL(PWMA, PWM_SM1_WRITE_VALUE_REG3, val3);
	PESL(PWMA, PWM_SM2_WRITE_VALUE_REG3, val3);
	/* dc-bus current sampling point */
	if(val3>i_sample_delay)
		val1 = val3 - i_sample_delay;
	else
		val1= val3;
	PESL(PWMA, PWM_SM3_WRITE_VALUE_REG1, val1);
	PESL(PWMA, PWM_SET_LDOK, PWM_SM0);
}

/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
