/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : PWM
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 13:36, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_PWM */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "PWM1.h"
#include "Cap1.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

void main(void)
{
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/


  TEST1_testStart(&testRec, "PWM test");
  TEST1_testComment(&testRec, "Please interconnect pins GPIOC3_TA0_CMPA_O_RXD0 and GPIOC4_TA1_CMPB_O.");

  
  overflow = FALSE;
  end = FALSE;
  event = 0;

  TEST1_testComment(&testRec, "PWM bean will generate 3 pulses (26.2144ms period/3ms duty)");
  Cap1_Enable();        /* enable measuring */
  PWM1_Enable();        /* start pulse generation */
  Cpu_Delay100US(800);  /* wait 80ms */
  Cap1_Disable();   /* 3 pulses should be measured then disable capture bean */
  
  TEST1_testComment(&testRec, "test capture overflow");
  if (overflow) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "OK");
  }  
  TEST1_testComment(&testRec, "test PWM event OnEnd");
  if (!end) {
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "OK");
  }  
  event=0;
  TEST1_testComment(&testRec, "first pulse - low level (1%)");
  if ((Ticks[event] < (1877-18)) || (Ticks[event] > (1877+18))) {   
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  
  event++;
  TEST1_testComment(&testRec, "first pulse - high level (1%)");
  if ((Ticks[event] < (16384-163)) || (Ticks[event] > (16384+163))) {   
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  
  event++;
  TEST1_testComment(&testRec, "second pulse - low level (1%)");
  if ((Ticks[event] < (18261-182)) || (Ticks[event] > (19196+182))) { 
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  
  event++;
  TEST1_testComment(&testRec, "second pulse - high level (1%)");
  if ((Ticks[event] < (32768-327)) || (Ticks[event] > (32768+327))) { 
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  
  event++;
  TEST1_testComment(&testRec, "third pulse - low level (1%)");
  if ((Ticks[event] < (34645-346)) || (Ticks[event] > (34645+346))) { 
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  
  event++;
  TEST1_testComment(&testRec, "third pulse - high level (1%)");
  if ((Ticks[event] < (49152-491)) || (Ticks[event] > (49152+491))) { 
    TEST1_testFailed(&testRec, "");
  } else {
    TEST1_testComment(&testRec, "number of ticks OK");
  }  

  TEST1_testEnd(&testRec);

}

/* END demo_PWM */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
