/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Puls1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : PulseAccumulator
**     Version     : Component 01.191, Driver 02.05, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 12:22, # CodeGen: 7
**     Abstract    :
**          Pulse accumulator counts the number of active edges at the input of its
**          channel.
**     Settings    :
**             Pulse accumulator       : TMRA1_PACNT
**
**
**         Used input pin              :
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       12            |  GPIOC4/TA1/CMPB_O/XB_IN8/EWM_OUT_B
**             ----------------------------------------------------
**
**         Mode                        : Count
**
**         Initialization:
**              Pulse accumulator      : Enabled
**              Events                 : Enabled
**
**         Timer registers
**              Counter                : TMRA_1_CNTR [E155]
**              Hold                   : TMRA_1_HOLD [E154]
**              Run                    : TMRA_1_CTRL [E156]
**              Prescaler              : TMRA_1_CTRL [E156]
**
**         Handling procedure          : Puls1_OnOverflow
**
**     Contents    :
**         ResetCounter     - void Puls1_ResetCounter(void);
**         GetCounterValue  - void Puls1_GetCounterValue(Puls1_TCounterValue *Value);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Puls1. */

#include "Events.h"
#include "Puls1.h"

/*
** ===================================================================
**     Method      :  Puls1_ResetCounter (component PulseAccumulator)
**
**     Description :
**         This method resets the pulse accumulator counter (sets to
**         zero).
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Puls1_ResetCounter(void)
{
  setReg(TMRA_1_CNTR,0x00);            /* Reset counter register */
}

/*
** ===================================================================
**     Method      :  Puls1_GetCounterValue (component PulseAccumulator)
**
**     Description :
**         This method returns the content of the pulse accumulator
**         counter.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Value           - Pointer to returned value. [Note:]
**                           Parameter type depends on the width of the
**                           selected counter (may be 8, 16, 32 or 64
**                           bits long). See the method prototype in the
**                           generated module.
**     Returns     : Nothing
** ===================================================================
*/
void Puls1_GetCounterValue(Puls1_TCounterValue *Value)
{
  *Value = getReg(TMRA_1_CNTR);        /* Return counter value */
}

/*
** ===================================================================
**     Method      :  Puls1_Init (component PulseAccumulator)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void Puls1_Init(void)
{
  /* TMRA_1_CTRL: CM=0,PCS=1,SCS=0,ONCE=0,LENGTH=0,DIR=0,COINIT=0,OUTMODE=0 */
  setReg(TMRA_1_CTRL,0x0200);          /* Set up mode */
  /* TMRA_1_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=1,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMRA_1_SCTRL,0x1000);
  setReg(TMRA_1_CNTR,0x00);            /* Reset counter register */
  setReg(TMRA_1_LOAD,0x00);            /* Reset load register */
  /* TMRA_1_FILT: ??=0,??=0,??=0,??=0,??=0,FILT_CNT=0,FILT_PER=0 */
  setReg(TMRA_1_FILT,0x00);            /* Set up input filter register */
  setRegBitGroup(TMRA_1_CTRL,CM,0x02); /* Run counter */
}

/*
** ===================================================================
**     Method      :  Puls1_Interrupt (component PulseAccumulator)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void Puls1_Interrupt(void)
{
  clrRegBit(TMRA_1_SCTRL,TOF);         /* Reset interrupt request flag */
  Puls1_OnOverflow();                  /* Invoke user event */
}

/* END Puls1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
