/** ###################################################################
**     Filename    : Events.c
**     Project     : PulsAccu
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 13:04, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

bool end;
bool overflow;

/*
** ===================================================================
**     Event       :  PS1_OnEnd (module Events)
**
**     Component   :  PS1 [PulseStream]
**     Description :
**         This event is called after all pulses have been generated (only
**         if the events are enabled - <"EnableEvent">). The event
**         may be selected only if interrupt service is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void PS1_OnEnd(void)
{
  end=TRUE;
}

/*
** ===================================================================
**     Event       :  Puls1_OnOverflow (module Events)
**
**     Component   :  Puls1 [PulseAccumulator]
**     Description :
**         This event is called when the pulse accumulator overflows,
**         only if the bean is enabled - <"Enable"> and the events are
**         enabled - <"EnableEvent">. 
**         This event is available only if timer supports overflow
**         interrupt.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void Puls1_OnOverflow(void)
{
  overflow=TRUE;
}

/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
