/** ###################################################################
**     Filename    : Events.h
**     Project     : PulsAccu
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 13:04, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/

#ifndef __Events_H
#define __Events_H
/* MODULE Events */

#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Puls1.h"
#include "PS1.h"
#include "TEST1.h"

extern bool end;
extern bool overflow;

void PS1_OnEnd(void);
/*
** ===================================================================
**     Event       :  PS1_OnEnd (module Events)
**
**     Component   :  PS1 [PulseStream]
**     Description :
**         This event is called after all pulses have been generated (only
**         if the events are enabled - <"EnableEvent">). The event
**         may be selected only if interrupt service is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void Puls1_OnOverflow(void);
/*
** ===================================================================
**     Event       :  Puls1_OnOverflow (module Events)
**
**     Component   :  Puls1 [PulseAccumulator]
**     Description :
**         This event is called when the pulse accumulator overflows,
**         only if the bean is enabled - <"Enable"> and the events are
**         enabled - <"EnableEvent">. 
**         This event is available only if timer supports overflow
**         interrupt.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/


/* END Events */
#endif /* __Events_H*/

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
