/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : RTIshare
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 13:57, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_RTIshare */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "shareTmr.h"
#include "timer1.h"
#include "timer2.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

extern word Counter1, Counter2;

#define COUNT 3

void main(void)
{
  word Ticks1[COUNT];
  word Ticks2[COUNT];
  byte i;
  test_sRec testRec;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "Real Time Interrupt Shareable test");
  
  Counter1 = Counter2 = 0;

  for(i=0;i<COUNT;i++) {
    Cpu_Delay100US(10000); /* delay 1s */
    Ticks1[i]=Counter1;
    Ticks2[i]=Counter2;
  }
  TEST1_testComment(&testRec, "test measured ticks (5%)");
  for(i=0;i<COUNT;i++) {
    if ((Ticks1[i] < (i+1)*(10-1)) || (Ticks1[i] > (i+1)*(10+1))) {
      TEST1_testFailed(&testRec, "");
    } else {
      TEST1_testComment(&testRec, "number of ticks OK");
    }  
    if ((Ticks2[i] < (i+1)*(50-3)) || (Ticks1[i] > (i+1)*(50+3))) {
      TEST1_testFailed(&testRec, "");
    } else {
      TEST1_testComment(&testRec, "number of ticks OK");
    }  
  }

  TEST1_testEnd(&testRec);

}

/* END demo_RTIshare */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
