/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Version     : Driver 01.14
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-03-18, 16:33, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE ProcessorExpert */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "CDC_Bridge_J8_2_3.h"
#include "TWR_SER_J8_4_5.h"
#include "WDog1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

void main(void)
{
  /* Write your local variable definition here */

	// For this project, two serial ports are run at 38400 8N1.  Use TWR-SER card RS232 connection and OSJTAG/CDC connection to demonstrate
	//    loopback on two ports.  What ever is rx on SCI0 or SCI1 is tx on both sci0 and sci1 for demonstration.
	    
	    
	    unsigned char x;
	    unsigned char * px = &x;
	      /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
	      PE_low_level_init();
	      /*** End of Processor Expert internal initialization.                    ***/

	      /* Write your code here */
	        WDog1_Disable();
	      for(;;) {
	    	  
	    	 switch ( CDC_Bridge_J8_2_3_RecvChar(px))
	      {
	    	 case ERR_OK: 
	    		 CDC_Bridge_J8_2_3_SendChar(x); TWR_SER_J8_4_5_SendChar(x);break;
	    	 case ERR_SPEED:
	    		 asm{nop}; break;
	    	 case ERR_RXEMPTY:
	    		 asm{nop}; break;	 
	    		 case ERR_BREAK:
	    			 asm{nop}; break;
	    			 case ERR_COMMON:
	    		 asm{nop}; break;
	    	 default: ;
	    }  
	    	  
	    	 switch ( TWR_SER_J8_4_5_RecvChar(px))
	      {
	    	 case ERR_OK: 
	    		 TWR_SER_J8_4_5_SendChar(x); CDC_Bridge_J8_2_3_SendChar(x); break;
	    	 case ERR_SPEED:
	    		 asm{nop}; break;
	    	 case ERR_RXEMPTY:
	    		 asm{nop}; break;	 
	    		 case ERR_BREAK:
	    			 asm{nop}; break;
	    			 case ERR_COMMON:
	    		 asm{nop}; break;
	    	 default: ;
	    }  
	    	  
	      }
	    }

/* END ProcessorExpert */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
