/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : SPI1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : SWSPI
**     Version     : Component 01.019, Driver 01.17, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 12:29, # CodeGen: 7
**     Abstract    :
**          This component implements an external SPI communication interface specialy 
**          designed for SPI compatible components. The interface uses three general-purpose 
**          I/O pins, first for the Input line, second for the Output line, third for 
**          the Serial Clock line. Is supported only Master mode with MSB first 
**          communication. 
**     Contents    :
**         RecvChar     - byte SPI1_RecvChar(byte *Chr);
**         SendChar     - byte SPI1_SendChar(byte Chr);
**         CharsInRxBuf - byte SPI1_CharsInRxBuf(word *Chr);
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/


/* MODULE SPI1. */

#include "SPI1.h"


#define OVERRUN_ERR  0x01U             /* Overrun error flag bit   */
#define CHAR_IN_RX   0x08U             /* Char is in RX buffer     */

static byte CLKshift;
static byte CLKsampl;
static byte InputBuffer;
static byte SerFlag;                   /* Flags for serial communication */
                                       /* Bits: 0 - OverRun error */
                                       /*       1 - Unused */
                                       /*       2 - Unused */
                                       /*       3 - Char in RX buffer */
                                       /*       4 - Unused */
                                       /*       5 - Unused */
                                       /*       6 - Unused */
                                       /*       7 - Unused */

/*
** ===================================================================
**     Method      :  SPI1_RecvChar (component SWSPI)
**
**     Description :
**         If any data received, this method returns one character,
**         otherwise it returns an error code (it does not wait for
**         data).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - A pointer to the received character.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_RXEMPTY - No data in receiver
**                           ERR_OVERRUN - Overrun error is detected
** ===================================================================
*/
byte SPI1_RecvChar(byte *Chr)
{
  if(!(SerFlag & CHAR_IN_RX)) {        /* Is char. received */
    return ERR_RXEMPTY;
  }
  *Chr = InputBuffer;                  /* Store the character */
  if(SerFlag & OVERRUN_ERR) {          /* Is "overrun" occured? */
    SerFlag &= (byte)(~(byte)(OVERRUN_ERR|CHAR_IN_RX)); /* If yes, clear flags */
    return ERR_OVERRUN;                /* ... and return error */
  }
  else {
    SerFlag &= (byte)(~(byte)CHAR_IN_RX); /* If no, clear flag */
    return ERR_OK;                     /* ... and return */
  }
}

/*
** ===================================================================
**     Method      :  SPI1_SendChar (component SWSPI)
**
**     Description :
**         Sends one character to the channel.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Chr             - Character to send.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
** ===================================================================
*/
byte SPI1_SendChar(byte Chr)
{
  byte i;
  InputBuffer = 0x00U;
  for(i=0U; i<8U; i++) {
    Inhr3_PutVal(CLKshift);            /* Set CLK to shift value */
    Inhr2_PutVal((bool)(Chr & 1U));    /* Set value on MOSI */
    InputBuffer = (byte)((byte)InputBuffer >> 1);
    Inhr3_PutVal(CLKsampl);            /* Set CLK to sample value */
    InputBuffer += Inhr1_GetVal()?128U:0U; /* Read value from MISO */
    Chr = (byte)((byte)Chr >> 1);
  }
  Inhr2_PutVal(1U);                    /* Set value on MOSI */
  if(SerFlag & CHAR_IN_RX) {           /* Is char. received? */
    SerFlag |= OVERRUN_ERR;            /* If yes then set "overrun" flag */
  }
  else {
    SerFlag |= CHAR_IN_RX;             /* If no then set "char in Rx" flag */
  }
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  SPI1_CharsInRxBuf (component SWSPI)
**
**     Description :
**         Returns number of characters in the input buffer.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Chr             - A pointer to the number of characters in
**                           the input buffer.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
** ===================================================================
*/
byte SPI1_CharsInRxBuf(word *Chr)
{
  *Chr = (word)((SerFlag & CHAR_IN_RX)?1U:0U); /* Return number of chars in receive buffer */
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  SPI1_Init (component SWSPI)
**
**     Description :
**         Initializes the associated peripheral(s) and the components 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void SPI1_Init(void)
{
  CLKsampl = 0U;                       /* Set sample value to 0 */
  CLKshift = 1U;                       /* Set shift value to 1 */
  Inhr3_PutVal((bool)0);               /* Set CLK to idle value */
  Inhr2_PutVal((bool)1);               /* Set value on MOSI */
  SerFlag = 0U;                        /* Clear flags */
}


/* END SPI1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/

