/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : SWSPI
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 14:10, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_SWSPI */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "SPI1.h"
#include "Inhr1.h"
#include "Inhr2.h"
#include "Inhr3.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define BLOCKSIZE 17

byte DataOut[] = " Message: Master ";
byte DataIn[BLOCKSIZE];
byte i;
bool Error;

void main(void)
{
  test_sRec testRec;
  word NumOfChars;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "SWSPI test");
  TEST1_testComment(&testRec, "Please interconnect the pins GPIOC3_TA0_CMPA_O_RXD0 and GPIOC4_TA1_CMPB_O.");

  Error = FALSE;
  for (i = 0; i < BLOCKSIZE; i++) {
    /* SendChar */
    if (SPI1_SendChar(DataOut[i]) != ERR_OK) {
      Error = TRUE;
    }
    do {
      if (SPI1_CharsInRxBuf(&NumOfChars) != ERR_OK) {
        Error = TRUE;
      }
    }
    while (NumOfChars == 0);

    /* RecvChar */
    if (SPI1_RecvChar(&DataIn[i]) != ERR_OK) {
      Error = TRUE;
    }
    if (DataOut[i] != DataIn[i]) {
      Error = TRUE;
    }
  }
  if (!Error)
    TEST1_testComment(&testRec, "Transmitting and receiving characters test OK.");
  else  
    TEST1_testFailed(&testRec, "Transmitting and receiving failed.");
 
  TEST1_testEnd(&testRec);

}

/* END demo_SWSPI */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
