/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : Cpu.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : MC56F84789VLL
**     Version     : Component 01.066, Driver 01.00, CPU db: 3.50.001
**     Datasheet   : MC56F847XXRM Rev.0RC 10/201
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-07-05, 13:51, # CodeGen: 41
**     Abstract    :
**
**     Settings    :
**
**     Contents    :
**         EnableInt   - void Cpu_EnableInt(void);
**         DisableInt  - void Cpu_DisableInt(void);
**         SetWaitMode - void Cpu_SetWaitMode(void);
**         SetStopMode - void Cpu_SetStopMode(void);
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Cpu. */
#include "SS1.h"
#include "TEST1.h"
#include "SM1.h"
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Events.h"
#include "Cpu.h"


/* Global variables */
volatile word SR_lock = 0U;            /* Lock */
volatile word SR_reg;                  /* Current value of the SR register */
/*
** ===================================================================
**     Method      :  Cpu_Interrupt (component MC56F84789VLL)
**
**     Description :
**         The method services unhandled interrupt vectors.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp
void Cpu_Interrupt(void)
{
  asm(DEBUGHLT);                       /* Halt the core and placing it in the debug processing state */
}

/*
** ===================================================================
**     Method      :  Cpu_DisableInt (component MC56F84789VLL)
**
**     Description :
**         Disables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_DisableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_EnableInt (component MC56F84789VLL)
**
**     Description :
**         Enables all maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_EnableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_SetStopMode (component MC56F84789VLL)
**
**     Description :
**         Sets low power mode - Stop mode.
**         For more information about the stop mode see this CPU
**         documentation.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_SetStopMode(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_SetWaitMode (component MC56F84789VLL)
**
**     Description :
**         Sets low power mode - Wait mode.
**         For more information about the wait mode see this CPU
**         documentation.
**         Release from wait mode: Reset or interrupt
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_SetWaitMode(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  _EntryPoint (component MC56F84789VLL)
**
**     Description :
**         Initializes the whole system like timing and so on. At the end 
**         of this function, the C startup is invoked to initialize stack,
**         memory areas and so on.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
extern void init_56800_(void);         /* Forward declaration of external startup function declared in startup file */

/*** !!! Here you can place your own code using property "User data declarations" on the build options tab. !!! ***/

void _EntryPoint(void)
{
  #pragma constarray off

  /*** !!! Here you can place your own code before PE initialization using property "User code before PE initialization" on the build options tab. !!! ***/

  /*** ### MC56F84789VLL "Cpu" init code ... ***/

  /*** PE initialization code after reset ***/

  /* Disable watchdog after reset based on the setting of the "Watchdog" property in CPU component */
  /* COP_CTRL: ??=0,??=0,??=0,??=0,??=0,??=0,PSS=3,INTEN=0,CLKSEL=0,CLOREN=0,CSEN=0,CWEN=0,CEN=0,CWP=0 */
  setReg16(COP_CTRL, 768U);             

  /* System clock initialization */
  setRegBitGroup(OCCS_OSCTL1, FREQ_TRIM8M, ((*(word *)58412) & 1023U)); /* Trim the 8MHz internal relaxation oscillator, frequency trim value */
  clrReg16Bit(OCCS_OSCTL1, ROPD);      /* Enable internal 8MHz oscillator */
  setReg16Bit(OCCS_OSCTL1, CLK_MODE);  /* Select an external clock bypass mode */
  setRegBitGroup(OCCS_CTRL, PRECS, 0U); /* Select an internal 8MHz clock source for the CPU core */
  clrSetReg16Bits(OCCS_CTRL, OCCS_CTRL_PLLPD_MASK, OCCS_CTRL_LCKON_MASK); /* Enable PLL, LCKON and select clock source from prescaler */
  /* OCCS_DIVBY: LORTP=2,COD=0,??=0,??=0,PLLDB=49 */
  setReg16(OCCS_DIVBY, 8241U);         /* Set the clock prescalers */ 
  while(!getRegBit(OCCS_STAT, LCK0)){} /* Wait for PLL lock */
  setReg16Bits(OCCS_CTRL, OCCS_CTRL_ZSRC_MASK); /* Enable PLL, LCKON and select clock source from prescaler */
  /* OCCS_PROT: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,FRQEP=0,OSCEP=0,PLLEP=0 */
  setReg16(OCCS_PROT, 0U);             /* Set the OCCS protection register */ 
  /*** End of PE initialization code after reset ***/

  /*** !!! Here you can place your own code after PE initialization using property "User code after PE initialization" on the build options tab. !!! ***/

  asm(JMP init_56800_);                /* Jump to C startup code */
}

/*
** ===================================================================
**     Method      :  PE_low_level_init (component MC56F84789VLL)
**
**     Description :
**         Initializes beans and provides common register initialization. 
**         The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PE_low_level_init(void)
{
      /* Initialization of the SIM module */
  /* SIM_MISC0: PIT_MSTR=0 */
  clrReg16Bits(SIM_MISC0, 1U);          
  /* SIM_CTRL: RST_FILT=0,DMAEbl=3,OnceEbl=0,STOP_disable=0,WAIT_disable=0 */
  clrSetReg16Bits(SIM_CTRL, 1327U, 192U); 
  /* SIM_PWR: SR12STDBY=0,SR27PDN=0,SR27STDBY=0,LRSTDBY=0 */
  clrReg16Bits(SIM_PWR, 255U);          
  /* SIM_CLKOUT: CLKODIV=0,CLKDIS1=1,CLKOSEL1=0,CLKDIS0=1,CLKOSEL0=0 */
  clrSetReg16Bits(SIM_CLKOUT, 58247U, 4128U); 
  /* SIM_PCE0: TA0=0,TA1=0,TA2=0,TA3=0,TB0=0,TB1=0,TB2=0,TB3=0,GPIOA=0,GPIOB=1,GPIOC=0,GPIOD=0,GPIOE=0,GPIOF=1,GPIOG=1 */
  clrSetReg16Bits(SIM_PCE0, 65372U, 35U); 
  /* SIM_PCE1: DAC=0,SCI0=0,SCI1=0,SCI2=0,QSPI0=1,QSPI1=1,QSPI2=1,IIC0=0,IIC1=0,FLEXCAN=0 */
  clrSetReg16Bits(SIM_PCE1, 15457U, 896U); 
  /* SIM_PCE2: CMPA=0,CMPB=0,CMPC=0,CMPD=0,SARADC=0,CYCADC=0,CRC=0,QDC=0,PIT0=0,PIT1=0,PDB0=0,PDB1=0 */
  clrReg16Bits(SIM_PCE2, 8127U);        
  /* SIM_PCE3: PWMACH0=0,PWMACH1=0,PWMACH2=0,PWMACH3=0,PWMBCH0=0,PWMBCH1=0,PWMBCH2=0,PWMBCH3=0 */
  clrReg16Bits(SIM_PCE3, 255U);         
  /* SIM_SD0: TA0=0,TA1=0,TA2=0,TA3=0,TB0=0,TB1=0,TB2=0,TB3=0,GPIOA=0,GPIOB=0,GPIOC=0,GPIOD=0,GPIOE=0,GPIOF=0,GPIOG=0 */
  clrReg16Bits(SIM_SD0, 65407U);        
  /* SIM_SD1: DAC=0,SCI0=0,SCI1=0,SCI2=0,QSPI0=0,QSPI1=0,QSPI2=0,IIC0=0,IIC1=0,FLEXCAN=0 */
  clrReg16Bits(SIM_SD1, 16353U);        
  /* SIM_SD2: CMPA=0,CMPB=0,CMPC=0,CMPD=0,SARADC=0,CYCADC=0,CRC=0,QDC=0,PIT0=0,PIT1=0,PDB0=0,PDB1=0 */
  clrReg16Bits(SIM_SD2, 8127U);         
  /* SIM_SD3: PWMACH0=0,PWMACH1=0,PWMACH2=0,PWMACH3=0,PWMBCH0=0,PWMBCH1=0,PWMBCH2=0,PWMBCH3=0 */
  clrReg16Bits(SIM_SD3, 255U);          
  /* SIM_PROT: PMODE=0,GDP=0,PCEP=0,GIPSP=0 */
  clrReg16Bits(SIM_PROT, 255U);         
  /* SIM_PCR: ??=0,??=0,SCI0_CR=1,SCI1_CR=1,SCI2_CR=1,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg16(SIM_PCR, 14336U);           /* Set the QSCI0; QSCI1; QSCI2 module clock rates */ 
      /* Initialization of the MCM module */
  /* MCM_UPRAMBAR: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,RBA=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg32(MCM_UPRAMBAR, 0UL);          
  /* MCM_UFLASHBAR: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,FBA=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0 */
  setReg32(MCM_UFLASHBAR, 0UL);         
  /* MCM_CPCR: XBARARB=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,IBDIS=0,SRDIS=0,RCDIS=0,INSDIS=0,SOCCR=0 */
  setReg32(MCM_CPCR, 0UL);              
  /* MCM_RPCR: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,RL=0,RPE=0 */
  setReg32(MCM_RPCR, 0UL);              
      /* Initialization of the GPIOA module */
  /* GPIOA_DRIVE: DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOA_DRIVE, 4095U);     
  /* GPIOA_SRE: SRE11=1,SRE10=1,SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16Bits(GPIOA_SRE, 4095U);       
      /* Initialization of the GPIOB module */
  /* GPIOB_DRIVE: DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOB_DRIVE, 4095U);     
  /* GPIOB_SRE: SRE11=1,SRE10=1,SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16Bits(GPIOB_SRE, 4095U);       
      /* Initialization of the GPIOC module */
  /* GPIOC_DRIVE: DRIVE15=0,DRIVE14=0,DRIVE13=0,DRIVE12=0,DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIOC_DRIVE, 0U);            
  /* GPIOC_SRE: SRE15=1,SRE14=1,SRE13=1,SRE12=1,SRE11=1,SRE10=1,SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16(GPIOC_SRE, 65535U);          
      /* Initialization of the GPIOD module */
  /* GPIOD_DRIVE: DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOD_DRIVE, 255U);      
  /* GPIOD_SRE: SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16Bits(GPIOD_SRE, 255U);        
      /* Initialization of the GPIOE module */
  /* GPIOE_DRIVE: DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOE_DRIVE, 1023U);     
  /* GPIOE_SRE: SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16Bits(GPIOE_SRE, 1023U);       
      /* Initialization of the GPIOF module */
  /* GPIOF_DRIVE: DRIVE15=0,DRIVE14=0,DRIVE13=0,DRIVE12=0,DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  setReg16(GPIOF_DRIVE, 0U);            
  /* GPIOF_SRE: SRE15=1,SRE14=1,SRE13=1,SRE12=1,SRE11=1,SRE10=1,SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16(GPIOF_SRE, 65535U);          
      /* Initialization of the GPIOG module */
  /* GPIOG_DRIVE: DRIVE11=0,DRIVE10=0,DRIVE9=0,DRIVE8=0,DRIVE7=0,DRIVE6=0,DRIVE5=0,DRIVE4=0,DRIVE3=0,DRIVE2=0,DRIVE1=0,DRIVE0=0 */
  clrReg16Bits(GPIOG_DRIVE, 4095U);     
  /* GPIOG_SRE: SRE11=1,SRE10=1,SRE9=1,SRE8=1,SRE7=1,SRE6=1,SRE5=1,SRE4=1,SRE3=1,SRE2=1,SRE1=1,SRE0=1 */
  setReg16Bits(GPIOG_SRE, 4095U);       
/*lint -save  -e586 Disable MISRA rule (2.1) checking. Functionality is implemented using assembler. */
  /* Shadow registers initialization */
  asm {
    move.l #0, R0
    move.l #0, R1
    move.l #0, R2
    move.l #0, R3
    move.l #0, R4
    move.l #0, R5
    move.l #0, N
    moveu.w #65535, N3
    moveu.w #65535, M01
    nop
    nop
    swap shadows
    /* Reset the M01 register for linear addressing */
    moveu.w #65535,M01
  }
/*lint -restore Enable MISRA rule (2.1) checking. */
  /* Common initialization of the CPU registers */
  /* INTC_IPR5: QSPI2_RCV=2,QSPI2_XMIT=2 */
  clrSetReg16Bits(INTC_IPR5, 20480U, 40960U); 
  /* GPIOB_PER: PE11=1,PE10=1,PE9=1 */
  setReg16Bits(GPIOB_PER, 3584U);       
  /* SIM_GPSBH: B11=2,B10=2,B9=2 */
  clrSetReg16Bits(SIM_GPSBH, 84U, 168U); 
  /* GPIOG_PER: PE10=1 */
  setReg16Bits(GPIOG_PER, 1024U);       
  /* SIM_GPSGH: G10=3 */
  setReg16Bits(SIM_GPSGH, 48U);         
  /* INTC_IPR6: QSPI1_RCV=2,QSPI1_XMIT=2 */
  clrSetReg16Bits(INTC_IPR6, 5U, 10U);  
  /* GPIOF_PER: PE14=1,PE13=1,PE12=1,PE7=1 */
  setReg16Bits(GPIOF_PER, 28800U);      
  /* SIM_GPSFH: ??=0,F14=0,??=0,F13=0,??=0,F12=0 */
  clrReg16Bits(SIM_GPSFH, 16128U);      
  /* SIM_GPSFL: F7=2 */
  clrSetReg16Bits(SIM_GPSFL, 16384U, 32768U); 
  /* GPIOD_PER: PE4=1 */
  setReg16Bits(GPIOD_PER, 16U);         
  /* Initialization of the SIM module */
  /* SIM_PCE0: GPIOB=0,GPIOF=0,GPIOG=0 */
  clrReg16Bits(SIM_PCE0, 35U);          
  /* ### SynchroSlave "SS1" init code ... */
  SS1_Init();
  /* ### SynchroMaster "SM1" init code ... */
  SM1_Init();
  __EI(0);                             /* Enable interrupts of the selected priority level */
}

/* END Cpu. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
