/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : SynSlave
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 14:29, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_SynSlave */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "SS1.h"
#include "TEST1.h"
#include "SM1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define BLOCKSIZE 16

byte DataOut[] = "Message: Master";
byte DataIn[BLOCKSIZE];
byte i, err;
word sent, recv;
volatile byte OnTxCharNum = 0;
volatile byte OnRxCharNum = 0;
bool cmpFailed;

volatile bool TxComplete = FALSE;

void main(void)
{
	test_sRec testRec;
	/*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
	PE_low_level_init();
	/*** End of Processor Expert internal initialization.                    ***/
	
	TEST1_testStart(&testRec, "SynchroSlave test");
    TEST1_testComment(&testRec, "Please interconnect the following pins: " );
    TEST1_testComment(&testRec, "GPIOB10/ANC22/XB_IN8/MOSI2 and GPIOF13/MOSI1/PWMB_FAULT1" );		//Slave Input - Master Output
    TEST1_testComment(&testRec, "GPIOB9/ANC21/XB_IN9/MISO2 and GPIOF12/MISO1/PWMB_FAULT2." ); 	//Slave Output - Master Input
	TEST1_testComment(&testRec, "GPIOB11/ANC23/XB_IN7/SCK2 and GPIOF14/SCK1/PWMB_FAULT0" );			//Clock
	TEST1_testComment(&testRec, "GPIOG10/PWMB_2X/PWMA_2X/XB_IN8/SS2_B and GPIOF7/TB3/CMPC_O/SS1_B/XB_IN3" );		//Slave Select
    //
    for (i=0;i<BLOCKSIZE;i++) {
      DataIn[i] = 0;
    }
    //
    TEST1_testComment(&testRec, "Transferring one character ...");
    err = SS1_SendChar( DataOut[0] );
    if (err != ERR_OK)
    	TEST1_testFailed(&testRec, "Transmitting one character failed");
    else  
    	TEST1_testComment(&testRec, "Transmitting PASSED");
    
    SM1_SendChar( DataOut[0] );
    while( !TxComplete ){}
    TxComplete = FALSE;
    
    while( SS1_GetCharsInRxBuf() ==0 ) {}
    
    err = SS1_RecvChar(&DataIn[0]);
    if (err != ERR_OK)
      TEST1_testFailed(&testRec, "Receiving one character failed");
    else  
      TEST1_testComment(&testRec, "Receiving PASSED");
    
    TEST1_testComment(&testRec, "Comparing data master -> slave ...");
    if ( DataOut[ 0 ] != DataIn[ 0 ] ) {
      TEST1_testFailed(&testRec, "");
    } else {
      TEST1_testComment(&testRec, "PASSED");
    }
    
    SM1_SendChar( DataOut[0] );
    SS1_RecvChar( &DataIn[0] );
    DataIn[ 0 ] = 0;
    SM1_RecvChar( &DataIn[0] );
    SM1_RecvChar( &DataIn[0] );
    
    
    
    TEST1_testComment(&testRec, "Comparing data slave -> master ...");
    if ( DataOut[ 0 ] != DataIn[ 0 ] ) {
      TEST1_testFailed(&testRec, "");
    } else {
      TEST1_testComment(&testRec, "PASSED");
    }
    
    //
    
    TEST1_testComment(&testRec, "Transferring data blocks...");
    err = SS1_SendBlock( DataOut, BLOCKSIZE, &sent );
    if ((err == ERR_OK) && (sent == BLOCKSIZE))
      TEST1_testComment(&testRec, "Transmitting PASSED");
    else  
      TEST1_testFailed(&testRec, "Transmitting data block failed");
    
    SM1_SendBlock( DataOut , BLOCKSIZE , &sent );
    err = SS1_RecvBlock( DataIn, BLOCKSIZE, &recv);
    if (err != ERR_OK)
      TEST1_testFailed(&testRec, "Receiving data block failed");
    else  
      TEST1_testComment(&testRec, "Receiving PASSED");    
    
    TEST1_testComment(&testRec, "Comparing data master -> slave ...");
    cmpFailed = FALSE;
    for (i=0;i<BLOCKSIZE;i++) {
      if ( DataOut[i] !=  DataIn[i]) {
        cmpFailed = TRUE;
      } 
    }
    if (cmpFailed) {
      TEST1_testFailed(&testRec, "");
    } else {
      TEST1_testComment(&testRec, "PASSED");
    }
    
    for (i=0;i<BLOCKSIZE;i++) {
      DataIn[i] = 0;
    }
    
    //
    SM1_RecvChar( &DataIn[0] );
    SM1_RecvBlock( DataIn , BLOCKSIZE , &recv );

    //
    TEST1_testComment(&testRec, "Comparing data slave -> master ...");
    cmpFailed = FALSE;
    for (i=0;i<BLOCKSIZE;i++) {
      if ( DataOut[i] !=  DataIn[i]) {
        cmpFailed = TRUE;
      } 
    }

    if (cmpFailed) {
      TEST1_testFailed(&testRec, "");
    } else {
      TEST1_testComment(&testRec, "PASSED");
    }  
    //
    TEST1_testComment(&testRec, "Testing OnTxCharNum event ...");
    if (OnTxCharNum != BLOCKSIZE + 1) {
      TEST1_testFailed(&testRec, "Testing OnTxCharNum event failed");
    } else {
      TEST1_testComment(&testRec, "PASSED");
    }  
    TEST1_testComment(&testRec, "Testing OnRxCharNum event ...");
    if (OnRxCharNum != BLOCKSIZE + 2) {
      TEST1_testFailed(&testRec, "Testing OnRxCharNum event failed");
    } else {
      TEST1_testComment(&testRec, "PASSED");
    }  
    //
    TEST1_testEnd(&testRec);
    //
  

}

/* END demo_SynSlave */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
