/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : DFR1.c
**     Project     : ProcessorExpert
**     Processor   : MC56F84789VLL
**     Component   : DSP_Func_DFR
**     Version     : Component 01.032, Driver 01.12, CPU db: 3.50.001
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-04-06, 09:36, # CodeGen: 1
**     Abstract    :
**          The DSP568xx Digital Signal Processing Function Library provides many
**          different types of signal processing algorithms. Most of these signal
**          processing algorithms, such as FFT, FIR, IIR, and correlation,
**          are general purpose. These algorithms can be used for digital filters,
**          speech coders, vector and array processing, and motor control.
**     Settings    :
**          Bean Name                      : DFR1
**          Use Assembler Files            : yes
**     Contents    :
**         dfr16FIR        - void DFR1_dfr16FIR(dfr16_tFirStruct *pFIR, Frac16 *pX, Frac16 *pZ, UInt16 n);
**         dfr16FIRHistory - void DFR1_dfr16FIRHistory(dfr16_tFirStruct *pFIR, Frac16 *pX);
**         dfr16FIRInit    - void DFR1_dfr16FIRInit(dfr16_tFirStruct *pFIR, Frac16 *pC, UInt16 n);
**         dfr16FIRs       - Frac16 DFR1_dfr16FIRs(dfr16_tFirStruct *pFIR, Frac16 x);
**         dfr16FIRInt     - UInt16 DFR1_dfr16FIRInt(dfr16_tFirIntStruct *pFIRINT, Frac16 *pX, Frac16 *pZ,...
**         dfr16FIRIntInit - void DFR1_dfr16FIRIntInit(dfr16_tFirIntStruct *pFIRInt, Frac16 *pC, UInt16 n,...
**         dfr16FIRDec     - UInt16 DFR1_dfr16FIRDec(dfr16_tFirDecStruct *pFIRDEC, Frac16 *pX, Frac16 *pZ,...
**         dfr16FIRDecInit - void DFR1_dfr16FIRDecInit(dfr16_tFirDecStruct *pFIRDec, Frac16 *pC, UInt16 n,...
**         dfr16IIR        - Result DFR1_dfr16IIR(dfr16_tIirStruct *pIIR, Frac16 *pX, Frac16 *pZ, UInt16 n);
**         dfr16IIRInit    - void DFR1_dfr16IIRInit(dfr16_tIirStruct *pIIR, Frac16 *pC, UInt16 nbiq);
**         dfr16AutoCorr   - Result DFR1_dfr16AutoCorr(UInt16 options, Frac16 *pX, Frac16 *pZ, UInt16 nx,...
**         dfr16Corr       - Result DFR1_dfr16Corr(UInt16 options, Frac16 *pX, Frac16 *pY, Frac16 *pZ,...
**         dfr16CFFT       - Result DFR1_dfr16CFFT(dfr16_tCFFTStruct *pCFFT, CFrac16 *pX, CFrac16 *pZ);
**         dfr16CFFTInit   - void DFR1_dfr16CFFTInit(dfr16_tCFFTStruct *pCFFT, UInt16 n, UInt16 options);
**         dfr16CIFFT      - Result DFR1_dfr16CIFFT(dfr16_tCFFTStruct *pCIFFT, CFrac16 *pX, CFrac16 *pZ);
**         dfr16CIFFTInit  - void DFR1_dfr16CIFFTInit(dfr16_tCFFTStruct *pCIFFT, UInt16 n, UInt16 options);
**         dfr16RFFT       - Result DFR1_dfr16RFFT(dfr16_tRFFTStruct *pRFFT, Frac16 *pX,...
**         dfr16RFFTInit   - void DFR1_dfr16RFFTInit(dfr16_tRFFTStruct *pRFFT, UInt16 n, UInt16 options);
**         dfr16RIFFT      - Result DFR1_dfr16RIFFT(dfr16_tRFFTStruct *pRIFFT, dfr16_sInplaceCRFFT *pX,...
**         dfr16RIFFTInit  - void DFR1_dfr16RIFFTInit(dfr16_tRFFTStruct *pRIFFT, UInt16 n, UInt16 options);
**         dfr16Cbitrev    - Result DFR1_dfr16Cbitrev(CFrac16 *pX, CFrac16 *pZ, UInt16 n);
**
**     (c) Freescale Semiconductor
**     2004 All Rights Reserved
**
**     Copyright : 1997 - 2012 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE DFR1. */

#include "DFR1.h"

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIR (component DSP_Func_DFR)
**
**     Description :
**         The method computes a Finite Impulse Response, (FIR), filter
**         for a vector of fractional data values. 
**         Prior to any call to fir, the FIR filter data structure
**         referred to by the first parameter pFIR must be allocated
**         and initialized. This allocation and initialization can be
**         done either statically by declaring a dfr16_tFirStruct data
**         structure and then initializing it with a call to
**         dfr16FIRInit, or dynamically by calling dfr16FIRCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIR            - Pointer to a data structure containing
**                           private data for the fir filter.
**       * pX              - Pointer to the input vector of n data
**                           elements.
**       * pZ              - Pointer to the output vector of n data
**                           elements.
**         n               - Length of the input and output vectors.
**     Returns     : Nothing
** ===================================================================
*/
/*void dfr16FIR(dfr16_tFirStruct *pFIR,Frac16 *pX,Frac16 *pZ,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRInit (component DSP_Func_DFR)
**
**     Description :
**         The method initializes the fir filter function from a
**         previously allocated dfr16_tFirStruct data structure.
**         Typically, this dfr16_tFirStruct data structure is allocated
**         statically by the caller prior to the firInit call. However,
**         firCreate also uses firInit to initialize the
**         dfr16_tFirStruct that it dynamically allocates. This method
**         cannot be disabled if Memory management property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIR            - Pointer to a previously allocated
**                           dfr16_rFirStruct data structure.
**       * pC              - Pointer to a vector of FIR filter
**                           coefficients.
**         n               - Length of the vector of FIR filter
**                           coefficients pointed to by pC.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16FIRInit(dfr16_tFirStruct *pFIR,Frac16 *pC,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRHistory (component DSP_Func_DFR)
**
**     Description :
**         The method reinitializes the Finite Impulse Response, (FIR),
**         filter history buffer data values. Prior to any call to
**         firHistory, the FIR filter must be initialized via a call to
**         firCreate. The firHistory function uses the private data
**         structure established by firCreate to establish the past
**         history of data elements required by the FIR filter
**         computation. The argument pX must point to n fractional data
**         elements, where n is the number of coefficients used to
**         establish the FIR filter in the call to firCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIR            - Pointer to a data structure containing
**                           private data for the fir filter; created by
**                           a call to firCreate.
**       * pX              - Pointer to the input vector of n data
**                           elements.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16FIRHistory(dfr16_tFirStruct *pFIR,Frac16 *pX)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRs (component DSP_Func_DFR)
**
**     Description :
**         The method computes a Finite Impulse Response (FIR) filter
**         for a single fractional data value. 
**         Prior to any call to fir, the FIR filter data structure
**         referred to by the first parameter pFIR must be allocated
**         and initialized. This allocation and initialization can be
**         done either statically by declaring a dfr16_tFirStruct data
**         structure and then initializing it with a call to
**         dfr16FIRInit, or dynamically by calling dfr16FIRCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIR            - Pointer to a data structure containing
**                           private data for the fir filter.
**         x               - Input data value.
**     Returns     :
**         ---             - The FIR filter computation returns the
**                           single output value which results from the
**                           FIR calculation on the single input value.
** ===================================================================
*/
/*
Frac16 dfr16FIRs(dfr16_tFirStruct *pFIR,Frac16 x)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRInt (component DSP_Func_DFR)
**
**     Description :
**         The method computes an interpolating Finite Impulse Response,
**         (FIR), filter for a vector of fractional data values. 
**         Prior to any call to firint, the FIR filter data structure
**         referred to by the first parameter pFIRINT must be allocated
**         and initialized. This allocation and initialization can be
**         done either statically by declaring a dfr16_tFirIntStruct
**         data structure and then initializing it with a call to
**         dfr16FIRIntInit, or dynamically by calling dfr16FIRIntCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIRINT         - Pointer to a data structure
**                           containing private data for the firint
**                           filter.
**       * pX              - Pointer to a vector of interpolating FIR
**                           filter coefficients.
**       * pZ              - Pointer to length of the vector of
**                           interpolating FIR filter coefficients
**                           pointed to by pC.
**         n               - The interpolation factor; the firint filter
**                           will produce f outputs for every input.
**     Returns     :
**         ---             - The firint filter computation generates (n
**                           * f) output values, which are stored in the
**                           vector pointed to by pZ, where f is the
**                           interpolation factor established in the
**                           call to firintCreate.
** ===================================================================
*/
/*
UInt16 dfr16FIRInt(dfr16_tFirIntStruct *pFIRINT,Frac16 *pX,Frac16 *pZ,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRIntInit (component DSP_Func_DFR)
**
**     Description :
**         The method initializes the firint filter function from a
**         previously allocated dfr16_tFirIntStruct data structure.
**         Typically, this dfr16_tFirIntStruct data structure is
**         allocated statically by the caller prior to the firintInit
**         call. However, firintCreate also uses firintInit to
**         initialize the dfr16_tFirIntStruct that it dynamically
**         allocates. This method cannot be disabled if Memory
**         management property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIRInt         - Pointer to a previously allocated
**                           dfr16_rFirIntStruct data structure.
**       * pC              - Pointer to a vector of firint filter
**                           coefficients.
**         n               - Length of the vector of firint filter
**                           coefficients pointed to by pC.
**         f               - The interpolation factor; the firint filter
**                           will produce f outputs for every input.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16FIRIntInit(dfr16_tFirIntStruct *pFIRInt,Frac16 *pC,UInt16 n,UInt16 f)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRDec (component DSP_Func_DFR)
**
**     Description :
**         The method computes a decimating Finite Impulse Response,
**         (FIR), filter for a vector of fractional data values. 
**         Prior to any call to firdec, the FIR filter data structure
**         referred to by the first parameter pFIRDEC must be allocated
**         and initialized. This allocation and initialization can be
**         done either statically by declaring a dfr16_tFirDecStruct
**         data structure and then initializing it with a call to
**         dfr16FIRDecInit, or dynamically by calling dfr16FIRDecCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIRDEC         - Pointer to a data structure
**                           containing private data for the firdec
**                           filter.
**       * pX              - Pointer to the input vector of nx data
**                           elements.
**       * pZ              - Pointer to the output vector of *pNZ data
**                           elements.
**         nx              - Length of the input data vector pointed to
**                           by pX.
**     Returns     :
**         ---             - The firdec filter computation generates
**                           output values which are stored in the
**                           vector pointed to by pZ. The number of
**                           output values generated is returned by the
**                           firdec function. In general, the length of
**                           the output vector is equal to nx/f, where f
**                           is the decimation factor established in the
**                           call to firdecCreate. However, if nx is not
**                           an integral multiple of f, the length of
**                           the output vector may vary; see Special
**                           Issues in this section for more information
**                           on the length of the output vector.
** ===================================================================
*/
/*
UInt16 dfr16FIRDec(dfr16_tFirDecStruct *pFIRDEC,Frac16 *pX,Frac16 *pZ,UInt16 nx)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16FIRDecInit (component DSP_Func_DFR)
**
**     Description :
**         The method initializes the firdec filter function from a
**         previously allocated dfr16_tFirDecStruct data structure.
**         Typically, this dfr16_tFirDecStruct data structure is
**         allocated statically by the caller prior to the firdecInit
**         call. However, firdecCreate also uses firdecInit to
**         initialize the dfr16_tFirDecStruct that it dynamically
**         allocates. This method cannot be disabled if Memory
**         management property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pFIRDec         - Pointer to a previously allocated
**                           dfr16_rFirdecStruct data structure.
**       * pC              - Pointer to a vector of firdec filter
**                           coefficients.
**         n               - Length of the vector of firdec filter
**                           coefficients pointed to by pC.
**         f               - Factor
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16FIRDecInit(dfr16_tFirDecStruct *pFIRDec,Frac16 *pC,UInt16 n,UInt16 f)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16IIR (component DSP_Func_DFR)
**
**     Description :
**         The method computes an Infinite Impulse Response, (IIR),
**         filter for a vector of fractional data values using a
**         cascade filter of biquad coefficients. 
**         Prior to any call to iir, the IIR filter data structure
**         referred to by the first parameter pIIR must be allocated
**         and initialized. This allocation and initialization can be
**         done either statically by declaring a dfr16_tIirStruct data
**         structure and then initializing it with a call to
**         dfr16IIRInit, or dynamically by calling dfr16IIRCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pIIR            - Pointer to a data structure containing
**                           private data for the iir filter.
**       * pX              - Pointer to the input vector of n data
**                           elements.
**       * pZ              - Pointer to the output vector of n data
**                           elements.
**         n               - Length of the input and output vectors.
**     Returns     :
**         ---             - The function returns: FAIL (-1): if the
**                           length of the input and output vectors, n,
**                           is greater than 8192; PASS (0): otherwise
** ===================================================================
*/
/*
Result dfr16IIR(dfr16_tIirStruct *pIIR,Frac16 *pX,Frac16 *pZ,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16IIRInit (component DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for the cascade iir
**         filter function and initializes the function from a
**         previously-allocated dfr16_tIirStruct data structure.
**         Typically, the dfr16_tIirStruct data structure is allocated
**         statically by the caller prior to the iirInit call. The
**         iirCreate function also uses iirInit to initialize the
**         dfr16_tIirStruct that it dynamically allocates. This method
**         cannot be disabled if Memory management property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pIIR            - Pointer to a data structure allocated
**                           statically by the caller before iirInit is
**                           called.
**       * pC              - Pointer to a vector of cascaded IIR filter
**                           coefficients, organized as a linear vector
**                           of n biquads, 5 coefficients per biquad.
**         nbiq            - The number of biquads for the cascaded
**                           iir filter.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16IIRInit(dfr16_tIirStruct *pIir,Frac16 *pC,UInt16 nbiq)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16AutoCorr (component DSP_Func_DFR)
**
**     Description :
**         The method computes the first nz points of auto-correlation
**         of a vector of fractional data values.
**     Parameters  :
**         NAME            - DESCRIPTION
**         options         - Selects raw, biased, or unbiased
**                           auto correlation.
**       * pX              - Pointer to the input vector of nx data
**                           elements.
**       * pZ              - Pointer to the output vector of nz data
**                           elements.
**         nx              - Length of the input vector pointed to by pX.
**         nz              - Length of the output vector pointed to by
**                           pZ.
**     Returns     :
**         ---             - The function returns: FAIL (-1): if the
**                           length of the output vector, nz, is outside
**                           the range 0 <= nz <= min(2nx-1, 8192), or
**                           if the options parameter is invalid; PASS
**                           (0): otherwise
** ===================================================================
*/
/*
Result dfr16AutoCorr(UInt16 options,Frac16 *pX,Frac16 *pZ,UInt16 nx,UInt16 nz)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16Corr (component DSP_Func_DFR)
**
**     Description :
**         The method computes the full length correlation of two
**         vectors of fractional data values.
**     Parameters  :
**         NAME            - DESCRIPTION
**         options         - Selects between raw, biased, and
**                           unbiased correlation.
**       * pX              - Pointer to the first input vector of nx data
**                           elements.
**       * pY              - Pointer to the second input vector of ny
**                           data elements.
**       * pZ              - Pointer to the output vector of (nx + ny -1)
**                           data elements.
**         nx              - Length of the input vector pointed to by pX.
**         ny              - Length of the input vector pointed to by pY.
**     Returns     :
**         ---             - The corr computation generates (nx + ny -
**                           1) output values which are stored in the
**                           vector pointed to by pZ.
**                           The function corr returns:
**                           - FAIL (-1): if the length of the output
**                           vector, nx + ny - 1, exceeds 8192.
**                           - PASS (0): otherwise
** ===================================================================
*/
/*
Result dfr16Corr(UInt16 options,Frac16 *px,Frac16 *py,Frac16 *pz,UInt16 nx,UInt16 ny)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CFFT (component DSP_Func_DFR)
**
**     Description :
**         The method computes an in place, radix-2, complex,
**         decimation-in-time, (DIT), forward Fast Fourier Transform
**         function for a vector of complex fractional data values. 
**         Prior to any call to cfft, the CFFT data structure referred
**         to by the first parameter pCFFT must be allocated and
**         initialized. This allocation and initialization can be done
**         either statically by declaring a dfr16_tCFFTStruct data
**         structure and then initializing it with a call to
**         dfr16CFFTInit, or dynamically by calling dfr16CFFTCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pCFFT           - Pointer to a data structure containing
**                           private data for the cfft function.
**       * pX              - Pointer to the input vector of n complex
**                           fractional data.
**       * pZ              - Pointer to the output structure of complex
**                           values.
**     Returns     :
**         ---             - The function returns either FAIL or the
**                           amount of scaling done: Note: Scaling/Scale
**                           down implies Right Shift; Scale up implies
**                           Left Shift. -1: Indicates FAIL (0 to log(2)
**                           (n), both inclusive): Indicates that the
**                           result was scaled down by so many times.
** ===================================================================
*/
/*
Result dfr16CFFT(dfr16_tCFFTStruct *pCFFT,CFrac16 *pX,CFrac16 *pZ)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CFFTInit (component DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         radix-2, complex, decimation-in-time (DIT), forward Fast
**         Fourier Transform (FFT) function, cfft, using complex
**         fractional data values. Initializes the function from a
**         previously-allocated dfr16_tCFFTStruct data structure.
**         Typically, the dfr16_tCFFTStruct data structure is allocated
**         statically by the caller prior to the cfftInit call. The
**         cfftCreate function also uses cfftInit to initialize the
**         dfr16_tCFFTStruct that it dynamically allocates. This method
**         cannot be disabled if Memory management property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pCFFT           - Pointer to a data structure containing
**                           private data for the cfft function; this
**                           pointer is statically allocated by caller
**                           prior to the dfr16CFFTInit function.
**         n               - Length of the complex FFT input and output
**                           vectors: 8, 16, 32, 64, 128, 256, 512, 1024,
**                           2048.
**         options         - Option flags to control cfft
**                           algorithm operation.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16CFFTInit(dfr16_tCFFTStruct *pCFFT,UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CIFFT (component DSP_Func_DFR)
**
**     Description :
**         The method computes an in place, radix-2, complex,
**         decimation-in-time (DIT), inverse Fast Fourier Transform
**         function for a vector of complex fractional data values. 
**         Prior to any call to cifft, the CFFT data structure referred
**         to by the first parameter pCIFFT must be allocated and
**         initialized. This allocation and initialization can be done
**         either statically by declaring a dfr16_tCFFTStruct data
**         structure and then initializing it with a call to
**         dfr16CIFFTInit, or dynamically by calling dfr16CIFFTCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pCIFFT          - Pointer to a data structure
**                           containing private data for the cifft
**                           function.
**       * pX              - Pointer to the input structure of complex
**                           values.
**       * pZ              - Pointer to the output structure of complex
**                           values.
**     Returns     :
**         ---             - The function returns either FAIL or the
**                           amount of scaling done: -1: Indicates FAIL
**                           (0 to log(2)(n), both inclusive): Indicates
**                           that the result was scaled down by so many
**                           times
** ===================================================================
*/
/*
Result dfr16CIFFT(dfr16_tCFFTStruct *pCIFFT,CFrac16 *pX,CFrac16 *pZ)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16CIFFTInit (component DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         radix-2, complex, decimation-in-time (DIT), inverse Fast
**         Fourier Transform, (IFFT), using complex fractional data
**         values. Initializes the function from a previously-allocated
**         dfr16_tCFFTStruct data structure. Typically, the
**         dfr16_tCFFTStruct data structure is allocated statically by
**         the caller prior to the cifftInit call. The cifftCreate
**         function also uses cifftInit to initialize allocate the
**         dfr16_tCFFTStruct dynamically. This method cannot be
**         disabled if Memory management property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pCIFFT          - Pointer to a data structure
**                           containing private data for the cfft
**                           function; this pointer is statically
**                           allocated by caller prior to the
**                           dfr16CFFTInit function.
**         n               - Length of the complex FFT input and output
**                           vectors: 8, 16, 32, 64, 128, 256, 512, 1024,
**                           2048.
**         options         - Option flags to control cfft
**                           algorithm operation.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16CIFFTInit(dfr16_tCFFTStruct *pCIFFT,UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RFFT (component DSP_Func_DFR)
**
**     Description :
**         The method computes an in place, radix-2, real,
**         decimation-in-time (DIT) forward Fast Fourier Transform
**         function for a vector of fractional data values. 
**         Prior to any call to rfft, the RFFT data structure referred
**         to by the first parameter pRFFT must be allocated and
**         initialized. This allocation and initialization can be done
**         either statically by declaring a dfr16_tRFFTStruct data
**         structure and then initializing it with a call to
**         dfr16RFFTInit, or dynamically by calling dfr16RFFTCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pRFFT           - Pointer to a data structure containing
**                           private data for the rfft function.
**       * pX              - Pointer to the input vector of n fractional
**                           data elements,stored in normal, as opposed
**                           to bit-reversed, order.
**       * pZ              - Pointer to the output structure of complex
**                           values.
**     Returns     :
**         ---             - The function returns either FAIL, or the
**                           number of stages of FFT scaled. -1:
**                           Indicates FAIL (0 to log(2)(n), both
**                           inclusive): Indicates that the result was
**                           scaled down by so many times
** ===================================================================
*/
/*
Result dfr16RFFT(dfr16_tRFFTStruct *pRFFT,Frac16 *pX,dfr16_sInplaceCRFFT *pZ)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RFFTInit (component DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         radix-2, real, decimation-in-time (DIT), forward Fast
**         Fourier Transform (FFT) function, rfft, using complex
**         fractional data values. Initializes the function from a
**         previously allocated dfr16_tRFFTStruct data structure.
**         Typically, the dfr16_tRFFTStruct data structure is allocated
**         statically by the caller prior to the rfftInit call. The
**         rfftCreate function also uses rfftInit to initialize the
**         dfr16_tRFFTStruct that it dynamically allocates. This method
**         cannot be disabled if Memory management property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pRFFT           - Pointer to a data structure containing
**                           private data for the cfft function; this
**                           pointer is statically created by caller
**                           prior to the dfr16CFFTInit function.
**         n               - Length of the complex FFT input and output
**                           vectors: 8, 16, 32, 64, 128, 256, 512, 1024,
**                           2048.
**         options         - Option flags to control rfft
**                           algorithm operation.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16RFFTInit(dfr16_tRFFTStruct *pRFFT,UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RIFFT (component DSP_Func_DFR)
**
**     Description :
**         The method computes an in place, radix-2, decimation-in-time,
**         (DIT), inverse Fast Fourier Transform function for a
**         structure of complex data values. 
**         Prior to any call to rifft, the RFFT data structure referred
**         to by the first parameter pRIFFT must be allocated and
**         initialized. This allocation and initialization can be done
**         either statically by declaring a dfr16_tRFFTStruct data
**         structure and then initializing it with a call to
**         dfr16RIFFTInit, or dynamically by calling dfr16RIFFTCreate.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pRIFFT          - Pointer to a data structure
**                           containing private data for the rifft
**                           function.
**       * pX              - Pointer to the input structure of complex
**                           values stored in normal, rather than
**                           bit-reversed, order.
**       * pZ              - Pointer to the output vector of real values
**                           stored in normal order.
**     Returns     :
**         ---             - The function returns either FAIL or the
**                           number of stages of FFT scaled. -1:
**                           Indicates FAIL (0 to log(2)(n), both
**                           inclusive): Indicates that the result was
**                           scaled down by so many times.
** ===================================================================
*/
/*
Result dfr16RIFFT(dfr16_tRFFTStruct *pRIFFT,dfr16_sInplaceCRFFT *pX,Frac16 *pZ)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16RIFFTInit (component DSP_Func_DFR)
**
**     Description :
**         The method performs the initialization for an in place,
**         radix-2, real, decimation-in-time (DIT), forward Fast
**         Fourier Transform (FFT) function, rifft, using complex
**         fractional data values. Initializes the function from a
**         previously allocated dfr16_tRIFFTStruct data structure.
**         Typically, the dfr16_tRIFFTStruct data structure is
**         allocated statically by the caller prior to the rifftInit
**         call. The rifftCreate function also uses rifftInit to
**         initialize the dfr16_tRIFFTStruct that it dynamically
**         allocates. This method cannot be disabled if Memory
**         management property is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pRIFFT          - Pointer to a data structure created
**                           by the rifftCreate function.
**         n               - Length of the inverse real FFT output
**                           vector 8,16, 32, 64, 128, 256, 512, 1024,
**                           or 2048.
**         options         - Option flags to control rifft
**                           algorithm operation.
**     Returns     : Nothing
** ===================================================================
*/
/*
void dfr16RIFFTInit(dfr16_tRFFTStruct *pRIFFT,UInt16 n,UInt16 options)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16Cbitrev (component DSP_Func_DFR)
**
**     Description :
**         The method bit-reverses the position of n complex data
**         elements in the input vector, pointed to by pX. The cbitrev
**         function is used to convert normal, (linear), order complex
**         vectors to bit-reversed complex vectors, and vice-versa, for
**         use in Fast Fourier Transform functions.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pX              - Pointer to the input vector of n complex
**                           data elements.
**       * pZ              - Pointer to the output vector of n complex
**                           data elements.
**         n               - Length of the input and output vectors
**                           pointed to by pX and pZ.
**     Returns     :
**         ---             - The function returns: FAIL (-1): if the
**                           length of the input and output vectors, n,
**                           is outside the range 0 < n lt= 8192 PASS (0):
**                           otherwise.
** ===================================================================
*/
/*
Result dfr16Cbitrev_(CFrac16 *pX,CFrac16 *pZ,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/*
** ===================================================================
**     Method      :  DFR1_dfr16Cbitrev (component DSP_Func_DFR)
**
**     Description :
**         The method bit-reverses the position of n complex data
**         elements in the input vector, pointed to by pX. The cbitrev
**         function is used to convert normal, (linear), order complex
**         vectors to bit-reversed complex vectors, and vice-versa, for
**         use in Fast Fourier Transform functions.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * pX              - Pointer to the input vector of n complex
**                           data elements.
**       * pZ              - Pointer to the output vector of n complex
**                           data elements.
**         n               - Length of the input and output vectors
**                           pointed to by pX and pZ.
**     Returns     :
**         ---             - The function returns: FAIL (-1): if the
**                           length of the input and output vectors, n,
**                           is outside the range 0 < n lt= 8192 PASS (0):
**                           otherwise.
** ===================================================================
*/
/*
static Result dfr16CbitrevC(CFrac16 *pX,CFrac16 *pZ,UInt16 n)
{
**     This method is implemented as macro      **
}
*/

/* END DFR1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
