/** ###################################################################
**     Filename    : Events.c
**     Project     : TimeDate
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 15:11, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

byte Alarm=0;

DATEREC Date;


/*
** ===================================================================
**     Event       :  TmDt1_OnAlarm (module Events)
**
**     Component   :  TmDt1 [TimeDate]
**     Description :
**         This event is called whenever an actual time is equal to the
**         alarm time (set by <SetAlarm> method).
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void TmDt1_OnAlarm(void)
{
  (void)TmDt1_GetDate(&Date);
  Alarm = 1;
}

/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
