/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : XBarSwitch
**     Processor   : MC56F84789VLL
**     Component   : Events
**     Version     : Driver 01.03
**     Compiler    : Metrowerks DSP C Compiler
**     Date/Time   : 2012-02-28, 15:59, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE demo_XBarSwitch */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "XBAR1.h"
#include "Bit1.h"
#include "Bit2.h"
#include "TEST1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

void main(void)
{
  test_sRec testRec;
  bool Error = FALSE;

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  TEST1_testStart(&testRec, "CrossbarSwitch test"); 
  TEST1_testComment(&testRec, "Please interconnect pins GPIOC3_TA0_CMPA_O_RXD0 and GPIOC4_TA1_CMPB_O.");
  TEST1_testComment(&testRec, "Please interconnect pins GPIOF1_CLKO1_XB_IN7 and GPIOF2_SCL1_XB_OUT2.");

  if (Bit2_GetVal())
    Error = TRUE;

  Bit1_SetVal();
  Cpu_Delay100US(10);
  if (!Bit2_GetVal())
    Error = TRUE;
  
  if (!Error)
    TEST1_testComment(&testRec, "CrossbarSwitch test OK.");
  else  
    TEST1_testFailed(&testRec, "CrossbarSwitch.");

  //
  TEST1_testEnd(&testRec);
  //
}

/* END demo_XBarSwitch */
/*
** ###################################################################
**
**     This file was created by Processor Expert
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
