/*
 * MKW01_Communication.h
 *
 *  Created on: Sep 25, 2015
 *      Author: B50961
 */

#ifndef MKW01_COMMUNICATION_H_
#define MKW01_COMMUNICATION_H_

#include "Common.h"
#include "user_configuration.h"


typedef struct Current_State {
	void (*vfnExecuteAtLfWakeUp)(void);
	void (*vfnExecuteAtRfWakeUp)(void);
	void (*vfnExecuteAtPwuWakeUp)(void);
	void (*vfnExecuteBeforeSTOP)(void);
}t_Current_State;


#pragma DATA_SEG BATTERY_BACKED_RAM
extern t_Current_State current_state;


/*
 **************************************************************
 * Function Prototypes 
 * Public functions
 **************************************************************/
void vfnInitStateMachine(void);
void vfnUpdateStateMachine(void);
void DisRF_EnLF (void);

#endif /* MKW01_COMMUNICATION_H_ */
