/*
 * user_configuration.h
 *
 *  Created on: May 19, 2016
 *      Author: B50961
 */

#ifndef USER_CONFIGURATION_H_
#define USER_CONFIGURATION_H_


// No need to modify these defines
#define CHOSEN_BY_USER				1
#define UNIQUE_ID					2
#define LF_COMMUNICATION			3
#define NO_LF_FASTEST_TX_ONLY		4
#define NO_LF_PWU_TX				5
#define USE_LEDS					6
#define DO_NOT_USE_LEDS				7
#define FIXED_ID					8
#define CYCLING_ID					9


/*******************************************************************************
 * *****************************************************************************
 * 
 * 
 * Below are demo parameters configurable by the user
 *  
 * 
 * *****************************************************************************
 *******************************************************************************/


/*******************************************************************************
 *  - The defines below are to choose the operating mode
 *  
 *  - LF_COMMUNICATION : FXTH is waiting for LF commands in STOP1 with LF block enabled.
 *  					When a valid LF command is received it is decoded and executed
 *  					Refer to function vfnUpdateStateMachine() in MKW01_Communication.c
 *  					
 *  - NO_LF_FASTEST_TX_ONLY : this mode does not use the LF communication.
 *  						The module executes the following sequence continuously:
 *  						 initialization -> sensors acquisition -> RF frame transmission in STOP1 -> initialization ...
 *  						 In summary, a new sequence of sensor acquisition and RF transmission starts as soon as 
 *  						 the previous RF frame has been transmitted.
 *  						 
 *  - NO_LF_PWU_WAKEUP : this mode does not use the LF communication.
 *  						The modules executes the following sequence continuously:
 *  						initialization -> sensor acquisition -> RF frame transmission in STOP1
 *  						-> wait for PWU interrupt in STOP1 -> initialization ...
 *  						In summary, a new sequence of sensor acquisition and RF transmission starts at each PWU interrupt. 
 *  						PWU period is configurable.
 *
 */

#define MODE	LF_COMMUNICATION
//#define MODE	NO_LF_FASTEST_TX_ONLY
//#define MODE	NO_LF_PWU_TX	// Choose the PWU period just below


#if (MODE == NO_LF_PWU_TX)
// PWU period defined must be between 1 and 95 seconds
// In order to set a period between 504ms and 1 second, 
// configure it manually in the function vfnNoLfConfigureStartPeriodicTx in MKW01_communication.c

#define PWU_PERIOD		2	// in seconds

#else
// Initialize to remove errors even if we do not use
#define	PWU_PERIOD		1
#endif

/*******************************************************************************
 * LEDs (GPIOs) can be used in the project.
 * Choose below if you want to use them or not. For example, do not use them
 * if the GPIOs are physically connected to GND or VDD on your board.
 * If DO_NOT_USE_LEDS is selected, all instructions related to LEDs will be replaced
 * by __asm nop;
 * 
 * In this project:
 * LED1 : PTA0
 * LED2 : PTA1
 * LED3 : PTA2
 * LED4 : PTA3
 * LED5 : PTB0
 * LED6 : PTB1 
 */

#define LEDS	USE_LEDS
//#define LEDS	DO_NOT_USE_LEDS


/*********************************************************************************
 * 	Below is to configure the tire ID sent in the RF frame.
 * 	CHOSEN_BY_USER means that tire ID will be one of the ID pre-determined by the user,
 * 	and UNIQUE_ID means that it is the unique 32-bit ID of the product that will be used
 * 	as tire ID.
 * 	In case of configurable IDs (not unique IDs), FIXED means that the same ID will be used
 * 	for every transmission and CYCLING means that the ID will change at each transmission (this
 * 	is to simulate four wheels).
 */

 
//#define TIRE_ID_VALUE	CHOSEN_BY_USER	// One of the four IDs below
#define TIRE_ID_VALUE	UNIQUE_ID		// The unique ID of the product


#if (TIRE_ID_VALUE == CHOSEN_BY_USER)

#define ID1 0xAA01AA01
#define ID2 0xBB02BB02
#define ID3 0xCC03CC03
#define ID4 0xDD04DD04

#define METHOD	FIXED_ID		// Choose the ID nb in the function vfnUpdateTireID in main.c
//#define METHOD 	CYCLING_ID 		// ID changes each time a new frame is sent

#else
// To remove warnings, initialize even if not used
#define METHOD		0


#endif





/**********************************************************************************
 **********************************************************************************
 	 	 	 	 	 	 	 Compilation check - do not modify
 **********************************************************************************
 **********************************************************************************
 */

#ifndef MODE
// If this error is displayed it means that no operating mode has been selected at the beginning of this header file.
#error "An operating mode must be chosen in user_configuration.h"
#endif

#ifndef TIRE_ID_VALUE
// If this error is displayed it means that no value has been chosen for the tire ID. This is to be done in this file.
#error "No value has been selected for the tire ID. Refer to user_configuration.h"
#endif

#if ((MODE == NO_LF_PWU_TX) && ((PWU_PERIOD<1)||(PWU_PERIOD>95)) )
// If this error is displayed it means that the PWU period chosen is not correct. It must be between 1 and 95 seconds.
#error "PWU period selected in user_configuration.h is not between 1 and 95 seconds"
#endif

#endif /* USER_CONFIGURATION_H_ */
