/*
 * EMC_ExecuteAction.c
 *
 *  Created on: Dec 11, 2016
 *      Author: B50961
 */

#include "device.h"
#include "stdint.h"
#include "ExecuteAction.h"
#include "UART.h" // for UART0_RxBufferFull
#include "GPIO.h"
#include "TPM.h"
#include "LF.h"


#define CMD_LF_STOP1				0x5E3101
#define CMD_LF_ONE_FRAME			0x5E3102
#define CMD_LF_PERIODIC				0x5E3103
#define CMD_LF_PERIODIC_550ms		0x5E3104
#define CMD_LF_FAST					0x5E3105
#define CMD_LF_FAST_NEVER_ENDING	0x5E3106
#define CMD_LF_FLASH_LED1			0x5E310F

/* Below the commands for LED4 and LED5
 * LED ON : param = 01. Example: LED4 ON : cmd = 0xE00E0401
 * LED OFF: param = 10  Example: LED4 OFF: cmd = 0xE00E0410
 */
#define CMD_LED4					0xE00E04
#define CMD_LED5					0xE00E05


/******************************************/
#define LED4_ON		GPIO_OUTPUT_SET(A,4)
#define LED4_OFF	GPIO_OUTPUT_CLEAR(A,4)
#define LED5_ON		GPIO_OUTPUT_SET(E,0)
#define LED5_OFF	GPIO_OUTPUT_CLEAR(E,0)
#define LED10_ON	GPIO_OUTPUT_SET(E,1)
#define LED10_OFF	GPIO_OUTPUT_CLEAR(E,1)
#define LED15_ON	GPIO_OUTPUT_SET(E,16)
#define LED15_OFF	GPIO_OUTPUT_CLEAR(E,16)
/*******************************************/


void Init_LEDs (void)
{
	/* LED4 = PTA4 */
	Config_Pin_GPIO('A',4);
	CFG_GPIO_OUTPUT(A,4);
	LED4_OFF;

	/* LED5 = PTE0 */
	Config_Pin_GPIO('E',0);
	CFG_GPIO_OUTPUT(E,0);
	LED5_OFF;

	/* LED10 = PTE1 */
	/* LED10 will be ON while the LF frame is sent */
	Config_Pin_GPIO('E',1);
	CFG_GPIO_OUTPUT(E,1);
	LED10_OFF;

	/* LED15 = PTE16 */
	/* LED15 will flash when an unknown command is received */
	Config_Pin_GPIO('E',16);
	CFG_GPIO_OUTPUT(E,16);
	LED15_OFF;

	/* LED16 = PTC2 */
	/* LED16 will be ON while the RF frame is stored and displayed */
	Config_Pin_GPIO('C',2);
	CFG_GPIO_OUTPUT(C,2);
	LED16_OFF;

	return;
}

void ExecuteAction_TPMS (void)
{
	uint32_t command;
	uint8_t param;

	command = UART0_Rx_Buffer[0];
	command = (command << 8);
	command |= UART0_Rx_Buffer[1];
	command = (command << 8);
	command |= UART0_Rx_Buffer[2];

	param = UART0_Rx_Buffer[3];

	switch (command)
	{

	case (CMD_LF_STOP1):
		LED10_ON;

		Tx_Buffer[0] = (0x5E);
		Tx_Buffer[1] = (0x31);
		Tx_Buffer[2] = (0x01);
		Tx_Buffer[3] = (0xAA);
		Nb_Bytes_To_Transmit = 4;
		Init_Tx_LF_PREMO();
		Start_Tx();
		LF_WaitEndTx();

		LED10_OFF;
		break;

	case (CMD_LF_ONE_FRAME):
		LED10_ON;

		Tx_Buffer[0] = (0x5E);
		Tx_Buffer[1] = (0x31);
		Tx_Buffer[2] = (0x02);
		Tx_Buffer[3] = (0xAA);
		Nb_Bytes_To_Transmit = 4;
		Init_Tx_LF_PREMO();
		Start_Tx();
		LF_WaitEndTx();

		LED10_OFF;
		break;

	case (CMD_LF_PERIODIC):
		LED10_ON;

		Tx_Buffer[0] = (0x5E);
		Tx_Buffer[1] = (0x31);
		Tx_Buffer[2] = (0x03);
		Tx_Buffer[3] = param;
		Nb_Bytes_To_Transmit = 4;
		Init_Tx_LF_PREMO();
		Start_Tx();
		LF_WaitEndTx();

		LED10_OFF;
		break;

	case (CMD_LF_PERIODIC_550ms):
		LED10_ON;

		Tx_Buffer[0] = (0x5E);
		Tx_Buffer[1] = (0x31);
		Tx_Buffer[2] = (0x04);
		Tx_Buffer[3] = (0xAA);
		Nb_Bytes_To_Transmit = 4;
		Init_Tx_LF_PREMO();
		Start_Tx();
		LF_WaitEndTx();

		LED10_OFF;
		break;

	case (CMD_LF_FAST):
		LED10_ON;

		Tx_Buffer[0] = (0x5E);
		Tx_Buffer[1] = (0x31);
		Tx_Buffer[2] = (0x05);
		Tx_Buffer[3] = param;
		Nb_Bytes_To_Transmit = 4;
		Init_Tx_LF_PREMO();
		Start_Tx();
		LF_WaitEndTx();

		LED10_OFF;
		break;

	case (CMD_LF_FAST_NEVER_ENDING):
		LED10_ON;

		Tx_Buffer[0] = (0x5E);
		Tx_Buffer[1] = (0x31);
		Tx_Buffer[2] = (0x06);
		Tx_Buffer[3] = (0xAA);
		Nb_Bytes_To_Transmit = 4;
		Init_Tx_LF_PREMO();
		Start_Tx();
		LF_WaitEndTx();

		LED10_OFF;
		break;

	case (CMD_LF_FLASH_LED1):
		LED10_ON;

		Tx_Buffer[0] = (0x5E);
		Tx_Buffer[1] = (0x31);
		Tx_Buffer[2] = (0x0F);
		Tx_Buffer[3] = (0xAA);
		Nb_Bytes_To_Transmit = 4;
		Init_Tx_LF_PREMO();
		Start_Tx();
		LF_WaitEndTx();

		LED10_OFF;
		break;

	case (CMD_LED4):
		if (param == 0x01){
			LED4_ON;
		}
		else {
			LED4_OFF;
		}
		break;

	case (CMD_LED5):
		if (param == 0x01){
			LED5_ON;
		}
		else {
			LED5_OFF;
		}
		break;

	default: // we received an unknown command
		LED15_ON;
		Delay_TPM0_ms(200);
		LED15_OFF;
		break;
	}

	UART0_RxBufferFull = 0; // Clear this variable once we are done with the Rx data (and not before otherwise Rx buffer will be overwritten)
	return;
}


