/*
 * GPIO.c
 *
 *  Created on: Nov 23, 2016
 *      Author: B50961
 */

#include "device.h"
#include "GPIO.h"

#define ALT_GPIO		1
#define MUX_MASK		7
#define MUX_BIT_SHIFT	8

#define GPIO(x,y)	(PORT ## x ## _PCR ## y &= ~(MUX_MASK<<MUX_BIT_SHIFT)); (PORT ## x ## _PCR ## y |= (ALT_GPIO<<MUX_BIT_SHIFT))


/*
 * Functions of GPIO.c
 */


uint8_t Config_Pin_GPIO (char Port, uint8_t Pin)
{
	uint8_t error;
	error = 0;

	switch (Port) {
	case 'A' :
		switch (Pin) {
			case 0 : GPIO(A,0);
			break;
			case 1 : GPIO(A,1);
			break;
			case 2 : GPIO(A,2);
			break;
			case 3 : GPIO(A,3);
			break;
			case 4 : GPIO(A,4);
			break;
			case 18 : GPIO(A,18);
			break;
			case 19 : GPIO(A,19);
			break;
			case 20 : GPIO(A,20);
			break;
			default: error = 1;
			break;
		}
	break; // case 'A'

	case 'B' :
		switch (Pin) {
			case 0 : GPIO(B,0);
			break;
			case 1 : GPIO(B,1);
			break;
			case 2 : GPIO(B,2);
			break;
			case 17 : GPIO(B,17);
			break;
			default: error = 1;
			break;
		}
	break; // case 'B'

	case 'C' :
		switch (Pin) {
			case 1 : GPIO(C,1);
			break;
			case 2 : GPIO(C,2);
			break;
			case 3 : GPIO(C,3);
			break;
			case 4 : GPIO(C,4);
			break;
			case 5 : GPIO(C,5);
			break;
			case 6 : GPIO(C,6);
			break;
			case 7 : GPIO(C,7);
			break;
			default: error = 1;
			break;
		}
	break; // case 'C'

	case 'D' :
		switch (Pin) {
			case 0 : GPIO(D,0);
			break;
			case 4 : GPIO(D,4);
			break;
			case 5 : GPIO(D,5);
			break;
			case 6 : GPIO(D,6);
			break;
			case 7 : GPIO(D,7);
			break;
			default: error = 1;
			break;
		}
	break; // case 'D'

	case 'E' :
		switch (Pin) {
			case 0 : GPIO(E,0);
			break;
			case 1 : GPIO(E,1);
			break;
			case 2 : GPIO(E,2);
			break;
			case 3 : GPIO(E,3);
			break;
			case 16 : GPIO(E,16);
			break;
			case 17 : GPIO(E,17);
			break;
			case 18 : GPIO(E,18);
			break;
			case 19 : GPIO(E,19);
			break;
			case 30 : GPIO(E,30);
			break;
			default: error = 1;
			break;
		}
	break; // case 'E'

	default: error = 1;
	break;

	}

	return error;
}


