/*
 * GPIO.h
 *
 *  Created on: Nov 23, 2016
 *      Author: B50961
 */

#ifndef SOURCES_GPIO_H_
#define SOURCES_GPIO_H_

#include "util.h" // for BITx_MASK definition

#define CFG_GPIO_OUTPUT(port,pin)	(GPIO ## port ## _PDDR |= (1<<pin))

#define CFG_GPIO_INPUT(port,pin)	(GPIO ## port ## _PDDR &= ~(1<<pin))
#define GPIO_OUTPUT_SET(port,pin)	(GPIO ## port ## _PSOR |= (1<<pin))
#define GPIO_OUTPUT_CLEAR(port,pin)	(GPIO ## port ## _PCOR |= (1<<pin))

#define GPIO_READ_VALUE(port,pin)	(uint8_t)( ((GPIO ## port ## _PDIR)&(BIT ## pin ## _MASK))>>pin )

uint8_t Config_Pin_GPIO (char Port, uint8_t Pin);


#endif /* SOURCES_GPIO_H_ */
