/*
 * Interrupt.c
 *
 *  Created on: Nov 25, 2016
 *      Author: B50961
 */
#include "device.h"


/*
void Enable_NVIC_IT (void)
{
	__asm("CPSIE i");
}

void Disable_NVIC_IT (void)
{
	__asm ("CPSID i");
}
*/
void IntRestoreAll(uint32_t var)
{
    __asm(" MSR PRIMASK, %0" : : "r" (var));
    __asm(" CPSIE i");
}


/*
In core_cm0plus.h:
void NVIC_EnableIRQ(IRQn_Type IRQn)
void NVIC_DisableIRQ(IRQn_Type IRQn)
void NVIC_SetPriority(IRQn_Type IRQn, uint32_t priority)
... + others ...


 Device specific interrupts
  DMA0_IRQn                    = 0,                /**< DMA channel 0 transfer complete and error interrupt
  DMA1_IRQn                    = 1,                /**< DMA channel 1 transfer complete and error interrupt
  DMA2_IRQn                    = 2,                /**< DMA channel 2 transfer complete and error interrupt
  DMA3_IRQn                    = 3,                /**< DMA channel 3 transfer complete and error interrupt
  Reserved20_IRQn              = 4,                /**< Reserved interrupt
  FTFA_IRQn                    = 5,                /**< FTFA command complete and read collision
  LVD_LVW_IRQn                 = 6,                /**< Low-voltage detect, low-voltage warning
  LLWU_IRQn                    = 7,                /**< Low Leakage Wakeup
  I2C0_IRQn                    = 8,                /**< I2C0 interrupt
  I2C1_IRQn                    = 9,                /**< I2C1 interrupt
  SPI0_IRQn                    = 10,               /**< SPI0 single interrupt vector for all sources
  SPI1_IRQn                    = 11,               /**< SPI1 single interrupt vector for all sources
  UART0_IRQn                   = 12,               /**< UART0 status and error
  UART1_IRQn                   = 13,               /**< UART1 status and error
  UART2_IRQn                   = 14,               /**< UART2 status and error
  ADC0_IRQn                    = 15,               /**< ADC0 interrupt
  CMP0_IRQn                    = 16,               /**< CMP0 interrupt
  TPM0_IRQn                    = 17,               /**< TPM0 single interrupt vector for all sources
  TPM1_IRQn                    = 18,               /**< TPM1 single interrupt vector for all sources
  TPM2_IRQn                    = 19,               /**< TPM2 single interrupt vector for all sources
  RTC_IRQn                     = 20,               /**< RTC alarm interrupt
  RTC_Seconds_IRQn             = 21,               /**< RTC seconds interrupt
  PIT_IRQn                     = 22,               /**< PIT single interrupt vector for all channels
  Reserved39_IRQn              = 23,               /**< Reserved interrupt
  Reserved40_IRQn              = 24,               /**< Reserved interrupt
  DAC0_IRQn                    = 25,               /**< DAC0 interrupt
  TSI0_IRQn                    = 26,               /**< TSI0 interrupt
  MCG_IRQn                     = 27,               /**< MCG interrupt
  LPTMR0_IRQn                  = 28,               /**< LPTMR0 interrupt
  Reserved45_IRQn              = 29,               /**< Reserved interrupt
  PORTA_IRQn                   = 30,               /**< PORTA pin detect
  PORTC_PORTD_IRQn             = 31                /**< Single interrupt vector for PORTC and PORTD pin detect
} IRQn_Type;


 */
