/*
 * RF_Rx_Appli.c
 *
 *  Created on: Nov 29, 2016
 *      Author: B50961
 */

#include "RF_Rx_Appli.h"
#include "TransceiverDrv.h"
#include "TransceiverReg.h"
#include "GPIO.h"
#include "device.h" //debug
#include "TPM.h"
#include "Display.h"


#define IRQ1_MODE_READY_MASK		(0x80)
#define IRQ1_RX_READY_MASK			(0x40)
#define IRQ2_CRC_OK_MASK			(0x02)



/********************
 * Public variables
 ********************/

uint8_t RF_Rx_Buffer [RF_RX_BUFFER_SIZE];
uint8_t RF_CrcNotOk;
uint8_t RF_RSSI_value;

/********************
 * Public functions
 ********************/

void RF_InitRx (void)
{
	uint8_t silicon_version;

	/* Config DIO0/PTE2 and DIO1/PTE3 as input */
	Config_Pin_GPIO('E',2);
	CFG_GPIO_INPUT(E,2);
	Config_Pin_GPIO('E',3);
	CFG_GPIO_INPUT(E,3);

	/* Init SPI for radio driver */
	MKW01Drv_SpiInit();

	/* Radio reset - refer to datasheet */
	MKW01Drv_Reset();

	silicon_version = MKW01Drv_ReadRegister(0x10);

	Delay_TPM0_ms(200); // Do not remove this delay

	/* Configure RF module */
	MKW01Drv_RFdefaultInit();

	/* Choose below between one of the defined frequencies:
	 * FREQ_3135 (313.5MHz), FREQ_314 (314MHz), FREQ_3145, FREQ_315, FREQ_3155, FREQ_316, FREQ_3165,
	 * FREQ_4325, FREQ_433, FREQ_4335, FREQ_434, FREQ_4345, FREQ_435, FREQ_4355 */
	MKW01Drv_SetFrequency(FREQ_434);

	/* Choose between one of the defined baud rates:
	 * BR_4800, BR_9600, BR_10000, BR_19200, BR_20000, BR_40000, BR_50000, BR_100000, BR_150000, BR_200000 */
	MKW01Drv_SetBaudRate(BR_19200);

	/* Choose between one of the defined frequency deviations:
	 * FREQ_DEV_5000, FREQ_DEV_19000, FREQ_DEV_25000, FREQ_DEV_50000, FREQ_DEV_50049, FREQ_DEV_100000 */
	MKW01Drv_SetFreqDev(FREQ_DEV_50000);


	Delay_TPM0_ms(200); // Do not remove this delay

	return;
}

uint8_t RF_EnableRx (void)
{
	uint8_t i;
	uint8_t irqFlag1;
	uint8_t timeout;
	uint8_t timeout_max;
	timeout_max = 200;

	MKW01Drv_WriteRegister(MKW01_Reg_OpMode, (uint8_t)(OpMode_Receiver));

	timeout = 0;
	irqFlag1 = MKW01Drv_ReadRegister(MKW01_Reg_IrqFlags1);
	while (((irqFlag1&IRQ1_RX_READY_MASK) != IRQ1_RX_READY_MASK) || (timeout >= timeout_max))
	{
		Delay_TPM0_ms(1);
		timeout ++;
		irqFlag1 = MKW01Drv_ReadRegister(MKW01_Reg_IrqFlags1);
	}

	if (timeout >= timeout_max)
	{
		timeout = 1;
	} else {
		timeout = 0;
	}

	Delay_TPM0_ms(200); // Do not remove this delay

	MKW01Drv_WriteRegister(MKW01_Reg_RssiConfig, RssiStart);

	/* Clear user reception buffer */
	for (i=0;i<RF_RX_BUFFER_SIZE;i++)
	{
		RF_Rx_Buffer[i] = 0;
	}

	return timeout;
}

uint8_t RF_DisableRx (void)
{
	uint8_t irqFlag1;
	uint8_t timeout;
	uint8_t timeout_max;
	timeout_max = 200;

	MKW01Drv_WriteRegister(MKW01_Reg_OpMode, (uint8_t)(OpMode_StandBy));

	timeout = 0;
	irqFlag1 = MKW01Drv_ReadRegister(MKW01_Reg_IrqFlags1);
	while (((irqFlag1&IRQ1_MODE_READY_MASK) != IRQ1_MODE_READY_MASK) || (timeout >= timeout_max))
	{
		Delay_TPM0_ms(1);
		timeout ++;
		irqFlag1 = MKW01Drv_ReadRegister(MKW01_Reg_IrqFlags1);
	}

	if (timeout >= timeout_max)
	{
		timeout = 1;
	} else {
		timeout = 0;
	}

	Delay_TPM0_ms(200); // Do not remove this delay

	return timeout;
}

/*
 * Store the Rf frame received and enable RF reception again
 */
void RF_StoreDataReceived (void)
{
	uint8_t index;
	uint8_t irqFlag2;

	/* Store RSSI value */
	RF_RSSI_value = MKW01Drv_ReadRegister(MKW01_Reg_RssiValue);

	/* Check if CRC is ok */
	irqFlag2 = MKW01Drv_ReadRegister(MKW01_Reg_IrqFlags2);
	if ((irqFlag2 & IRQ2_CRC_OK_MASK) == IRQ2_CRC_OK_MASK)
	{
		RF_CrcNotOk = 0;
	} else {
		RF_CrcNotOk = 1;
	}

	/* Then change mode to standby to get the data */
	MKW01Drv_WriteRegister(MKW01_Reg_OpMode, (uint8_t)(OpMode_StandBy));

	index = 0;

	while (RF_RX_FIFO_NOT_EMPTY)
	{
		RF_Rx_Buffer[index++] = MKW01Drv_ReadRegister(MKW01_Reg_Fifo);
	}

	// Enable RF reception again
	MKW01Drv_WriteRegister(MKW01_Reg_OpMode, (uint8_t)(OpMode_Receiver));
	Delay_TPM0_ms(1); // 200ms is too long we would miss frames
	MKW01Drv_WriteRegister(MKW01_Reg_RssiConfig, RssiStart);

	return;
}

/*
 * Below not used at the moment
 */
void RF_Clear_FIFO (void)
{
	uint8_t dummy;

	MKW01Drv_WriteRegister(MKW01_Reg_OpMode, (uint8_t)(OpMode_StandBy));

	while (RF_RX_FIFO_NOT_EMPTY)
	{
		dummy = MKW01Drv_ReadRegister(MKW01_Reg_Fifo);
	}

	return;
}

void RF_EnableRx_Quick (void)
{
	// Enable RF reception again
	MKW01Drv_WriteRegister(MKW01_Reg_OpMode, (uint8_t)(OpMode_Receiver));
	Delay_TPM0_ms(1); // 200ms is too long, we would miss frames
	MKW01Drv_WriteRegister(MKW01_Reg_RssiConfig, RssiStart);

	return;
}
