/*
 * RF_Rx_Appli.h
 *
 *  Created on: Nov 29, 2016
 *      Author: B50961
 */

#include "TransceiverDrv.h" // For FIFO_SIZE

#ifndef SOURCES_RF_RX_APPLI_H_
#define SOURCES_RF_RX_APPLI_H_

#include "GPIO.h"

#define RECEIVE_DATA	1
#define DISCARD_DATA	2

/***************************************************************************************
 * 							User configuration
 *
 * Choose here what to do when the RF data received is corrupted (CRC not ok):
 * RECEIVE DATA: the corrupted frame is received and displayed and the variable
 * RF_CrcNotOk is updated to indicate a corrupted frame (this variable is displayed on GUI).
 * DISCARD_DATA: the corrupted frame is discarded (only correct data will be received and displayed)
 *
 ***************************************************************************************/
#define RF_DATA_CORRUPTED		RECEIVE_DATA
//#define RF_DATA_CORRUPTED		DISCARD_DATA

/****************************************************************************************/

#define RF_RX_BUFFER_SIZE	FIFO_SIZE // Payload length max is set to FIFO_SIZE which is 66bytes

#define RF_PAYLOAD_READY		GPIO_READ_VALUE(E,2)
#define RF_RX_FIFO_NOT_EMPTY	GPIO_READ_VALUE(E,3)


/********************
 * Public variables
 ********************/

extern uint8_t RF_Rx_Buffer [RF_RX_BUFFER_SIZE];
extern uint8_t RF_CrcNotOk;
extern uint8_t RF_RSSI_value;

/********************
 * Public functions
 ********************/

void RF_InitRx (void);
uint8_t RF_EnableRx (void);
uint8_t RF_DisableRx (void);
void RF_StoreDataReceived (void); // Stores the RF frame received but does not enable the RF Rx again
void RF_EnableRx_Quick (void);


#endif /* SOURCES_RF_RX_APPLI_H_ */
