/*
 * TransceiverDrv.h
 *
 *  Created on: Nov 25, 2016
 *      Author: B50961
 */

#ifndef SOURCES_TRANSCEIVERDRV_H_
#define SOURCES_TRANSCEIVERDRV_H_

#include "device.h"
#include "derivative.h"
#include "util.h"


#define STANDBY 	(1) //RF mode
#define RECEIVE 	(2) //RF mode

#define FIFO_SIZE	66 // FIFO size is 66 bytes

/*****************************************************************************
 *                             PRIVATE MACROS                                *
 *---------------------------------------------------------------------------*
 * Add to this section all the access macros, registers mappings, bit access *
 * macros, masks, flags etc ...
 *---------------------------------------------------------------------------*
 *****************************************************************************/

/* Transceiver HW port/pin mapping */

/****************************************************************************/
/* Transceiver SPI interface */
/****************************************************************************/

/*                                       .... ...------------------------------------ Reserved.  0000000 */
/*                                       |||| |||.----------------------------------- ISF.       0 - Configured interrupt has not been detected. */
/*                                       |||| |||| ....------------------------------ Reserved.  0000 */
/*                                       |||| |||| |||| ....------------------------- IRQC.      0000 - Interrupt/DMA Request disabled. */
/*                                       |||| |||| |||| |||| .----------------------- LK.        0 - Pin Control Register bits [15:0] are not locked. */
/*                                       |||| |||| |||| |||| |... .------------------ Reserved.  0000 */
/*                                       |||| |||| |||| |||| |||| |...--------------- MUX.       010 - 010 Alternative 2 (SPI2_PCS1). */
/*                                       |||| |||| |||| |||| |||| |||| .------------- Reserved.  0 */
/*                                       |||| |||| |||| |||| |||| |||| |.------------ DSE.       1 - High drive strength is configured on the corresponding pin, if pin is configured as a digital output.*/
/*                                       |||| |||| |||| |||| |||| |||| ||.----------- ODE.       0 - Open Drain output is disabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||.---------- PFE.       0 - Passive Input Filter is disabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||| .-------- Reserved.  0 */
/*                                       |||| |||| |||| |||| |||| |||| |||| |.------- SRE.       0 - Fast slew rate is configured on the corresponding pin, if pin is configured as a digital output. */
/*                                       |||| |||| |||| |||| |||| |||| |||| ||.------ PE.        0 - Internal pull-up or pull-down resistor is not enabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||| |||.----- PS.        0 - Internal pull-down resistor is enabled on the corresponding pin, if the corresponding Port Pull Enable Register bit is set. */
/*                                       |||| |||| |||| |||| |||| |||| |||| |||| */
/*                                     0b0000 0000 0000 0000 0000 0010 0100 0000 */
#define cSPI_SSEL_PCR_Config_c         (0x00000240UL)

/*                                       .... ...------------------------------------ Reserved.  0000000 */
/*                                       |||| |||.----------------------------------- ISF.       0 - Configured interrupt has not been detected. */
/*                                       |||| |||| ....------------------------------ Reserved.  0000 */
/*                                       |||| |||| |||| ....------------------------- IRQC.      0000 - Interrupt/DMA Request disabled. */
/*                                       |||| |||| |||| |||| .----------------------- LK.        0 - Pin Control Register bits [15:0] are not locked. */
/*                                       |||| |||| |||| |||| |... .------------------ Reserved.  0000 */
/*                                       |||| |||| |||| |||| |||| |...--------------- MUX.       010 - 010 Alternative 2 (SPI2_SCK). */
/*                                       |||| |||| |||| |||| |||| |||| .------------- Reserved.  0 */
/*                                       |||| |||| |||| |||| |||| |||| |.------------ DSE.       1 - High drive strength is configured on the corresponding pin, if pin is configured as a digital output.*/
/*                                       |||| |||| |||| |||| |||| |||| ||.----------- ODE.       0 - Open Drain output is disabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||.---------- PFE.       0 - Passive Input Filter is disabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||| .-------- Reserved.  0 */
/*                                       |||| |||| |||| |||| |||| |||| |||| |.------- SRE.       0 - Fast slew rate is configured on the corresponding pin, if pin is configured as a digital output. */
/*                                       |||| |||| |||| |||| |||| |||| |||| ||.------ PE.        0 - Internal pull-up or pull-down resistor is not enabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||| |||.----- PS.        0 - Internal pull-down resistor is enabled on the corresponding pin, if the corresponding Port Pull Enable Register bit is set. */
/*                                       |||| |||| |||| |||| |||| |||| |||| |||| */
/*                                     0b0000 0000 0000 0000 0000 0010 0100 0000 */
#define cSPI_SCLK_PCR_Config_c         (0x00000240UL)

/*                                       .... ...------------------------------------ Reserved.  0000000 */
/*                                       |||| |||.----------------------------------- ISF.       0 - Configured interrupt has not been detected. */
/*                                       |||| |||| ....------------------------------ Reserved.  0000 */
/*                                       |||| |||| |||| ....------------------------- IRQC.      0000 - Interrupt/DMA Request disabled. */
/*                                       |||| |||| |||| |||| .----------------------- LK.        0 - Pin Control Register bits [15:0] are not locked. */
/*                                       |||| |||| |||| |||| |... .------------------ Reserved.  0000 */
/*                                       |||| |||| |||| |||| |||| |...--------------- MUX.       010 - 010 Alternative 2 (SPI2_SOUT). */
/*                                       |||| |||| |||| |||| |||| |||| .------------- Reserved.  0 */
/*                                       |||| |||| |||| |||| |||| |||| |.------------ DSE.       1 - High drive strength is configured on the corresponding pin, if pin is configured as a digital output.*/
/*                                       |||| |||| |||| |||| |||| |||| ||.----------- ODE.       0 - Open Drain output is disabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||.---------- PFE.       0 - Passive Input Filter is disabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||| .-------- Reserved.  0 */
/*                                       |||| |||| |||| |||| |||| |||| |||| |.------- SRE.       0 - Fast slew rate is configured on the corresponding pin, if pin is configured as a digital output. */
/*                                       |||| |||| |||| |||| |||| |||| |||| ||.------ PE.        0 - Internal pull-up or pull-down resistor is not enabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||| |||.----- PS.        0 - Internal pull-down resistor is enabled on the corresponding pin, if the corresponding Port Pull Enable Register bit is set. */
/*                                       |||| |||| |||| |||| |||| |||| |||| |||| */
/*                                     0b0000 0000 0000 0000 0000 0010 0100 0000 */
#define cSPI_MOSI_PCR_Config_c         (0x00000240UL)

/*                                       .... ...------------------------------------ Reserved.  0000000 */
/*                                       |||| |||.----------------------------------- ISF.       0 - Configured interrupt has not been detected. */
/*                                       |||| |||| ....------------------------------ Reserved.  0000 */
/*                                       |||| |||| |||| ....------------------------- IRQC.      0000 - Interrupt/DMA Request disabled. */
/*                                       |||| |||| |||| |||| .----------------------- LK.        0 - Pin Control Register bits [15:0] are not locked. */
/*                                       |||| |||| |||| |||| |... .------------------ Reserved.  0000 */
/*                                       |||| |||| |||| |||| |||| |...--------------- MUX.       010 - 010 Alternative 2 (SPI2_SIN). */
/*                                       |||| |||| |||| |||| |||| |||| .------------- Reserved.  0 */
/*                                       |||| |||| |||| |||| |||| |||| |.------------ DSE.       1 - High drive strength is configured on the corresponding pin, if pin is configured as a digital output.*/
/*                                       |||| |||| |||| |||| |||| |||| ||.----------- ODE.       0 - Open Drain output is disabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||.---------- PFE.       0 - Passive Input Filter is disabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||| .-------- Reserved.  0 */
/*                                       |||| |||| |||| |||| |||| |||| |||| |.------- SRE.       0 - Fast slew rate is configured on the corresponding pin, if pin is configured as a digital output. */
/*                                       |||| |||| |||| |||| |||| |||| |||| ||.------ PE.        0 - Internal pull-up or pull-down resistor is not enabled on the corresponding pin. */
/*                                       |||| |||| |||| |||| |||| |||| |||| |||.----- PS.        0 - Internal pull-down resistor is enabled on the corresponding pin, if the corresponding Port Pull Enable Register bit is set. */
/*                                       |||| |||| |||| |||| |||| |||| |||| |||| */
/*                                     0b0000 0000 0000 0000 0000 0010 0100 0000 */
#define cSPI_MISO_PCR_Config_c         (0x00000240UL)

/* SPI PORT  Clock Gating Control Register */

#define MKW01x_SPI_PORT_SIM_SCG       SIM_SCGC5

#define cSPI_PORT_SIM_SCG_Config_c    (1<<11)         /*SPI Port Clock Gate Control enable*/

#define MKW01x_SPI_SIM_SCG            SIM_SCGC4

#define cSPI_SIM_SCG_Config_c         (1<<22)         /*SPI Clock Gate Control enable*/


/* SPI Module Clock Gating Control Register */



/* SPI Registers */

extern SPI_MemMapPtr  SpiRegs;


#define MKW01Drv_DeassertReset()     { gRadioReset_ClearPortOutReg_c |= gMKW01ResetMask_c; }
#define MKW01Drv_AssertReset()   { gRadioReset_DataAvailablePortDataOUTReg_c |= gMKW01ResetMask_c;}

#define SPID_DummyRead              {char dummy = SpiRegs->DL;}
#define SPIS_DummyRead              {char dummy = SpiRegs->S;}

#define AssertSS                    {GPIOD_PCOR = (uint8_t)(1<<0);}
#define DeAssertSS                  {GPIOD_PDOR |= (uint8_t)(1<<0);}

#define WaitSPITxBufferEmpty        {while(!(SpiRegs->S & SPI_S_SPTEF_MASK));}
#define WaitSPIRxBufferFull         {while(!(SpiRegs->S & SPI_S_SPRF_MASK));}
#define WaitSPITransmitterEmpty     {WaitSPITxBufferEmpty; Wait_6_BitClks();  }


/************************************************************************************
* MCU SPI module configuration constants
************************************************************************************/
// SPI Control Register 1
//                            .--------- SPIE     : SPI Interrupt (SPRF and MODF) disabled
//                            |.-------- SPE      : SPI System inactive
//                            ||.------- SPTIE    : SPI Transmit Interrupt disabled
//                            |||.------ MSTR     : Master/Slave Mode Select.
//                            ||||.----- CPOL     : Clock Polarity. Active High
//                            |||||.---- CPHA     : Clock Phase. First edge on SPSCK occurs at the middle of the first cycle of an 8-cycle data transfer
//                            ||||||.--- SSOE     : Slave Select Output Enable
//                            |||||||.-- LSBFE    : LSB First (Shifter Direction). SPI serial data transfers start with most significant bit
//                            ||||||||
#define cSPIC1_Init  0x00 //0b00010000
// SPI Control Register 2
//                            .--------- SPMIE       : SPI match interrupt enable
//                            |.-------- SPIMODE     : SPI 8-bit or 16-bit mode
//                            ||.------- TXDMAE      : Transmit DMA Enable
//                            |||.------ MODFEN      : Master Mode-Fault Function disabled.
//                            ||||.----- BIDIROE     : Bidirectional Mode Output Enable disabled
//                            |||||.---- RXDMAE      : Receive DMA enable
//                            ||||||.--- SPISWAI     : SPI Stop in Wait Mode. SPI clocks continue to operate in wait mode
//                            |||||||.-- SPC0        : SPI Pin Control 0. SPI uses separate pins for data input and data output.
//                            ||||||||
#define cSPIC2_Init  0x00 //0b00000000
// SPI Baud Rate Register. Master SPI CLOCK = BUS CLOCK / Prescaler Divisor / SPI Rate Divisor = BUS CLOCK / 2
//                            .--------- X        : Unimplemented or Reserved
//                            |...------ SPPR[2:0]: SPI Baud Rate Prescale Divisor. Prescaler Divisor = 1
//                            ||||....-- SPR[3:0] : SPI Baud Rate Divisor. SPI Rate Divisor = 2
//                            ||||||||
#define cSPIBR_Init   0x00   //0b001110010    /                                 /Original line, SPICLK=BUSCLK/2 (2: baud rate divisor)
//#define cSPIBR_Init   0x01                                                    //modif->  SPICLK=BUSCLK/4 (4: baud rate divisor)
//#define cSPIBR_Init   0x02                                                    //modif->  SPICLK=BUSCLK/8 (8: baud rate divisor)
//#define cSPIBR_Init   0x04                                                    //modif->  SPICLK=BUSCLK/32 (32: baud rate divisor)
//#define cSPIBR_Init   0x08                                                    //modif->  SPICLK=BUSCLK/512 (512: baud rate divisor)


/* SPI Status Register masks */



/************************************************************************************
* Driver prototype functions for init, reset and wakeup
************************************************************************************/

#define MKW01Drv_WriteRegisterFastMacro(addr, val)\
  SPIS_DummyRead;\
  AssertSS;\
  SpiRegs->DL = (unsigned char)(addr | 0x80);\
  WaitSPITxBufferEmpty;\
  SPID_DummyRead;\
  SpiRegs->DL = (unsigned char)(val);\
  WaitSPITxBufferEmpty;\
  SPID_DummyRead;\
  WaitSPIRxBufferFull;\
  DeAssertSS;\


#define MKW01Drv_ReadRegisterFastMacro(addr, val)\
  SPIS_DummyRead;\
  AssertSS;\
  SpiRegs->DL = (unsigned char)(addr);\
  WaitSPITxBufferEmpty;\
  SPID_DummyRead;\
  SpiRegs->DL = 0x00;\
  WaitSPITxBufferEmpty;\
  SPID_DummyRead;\
  WaitSPIRxBufferFull;\
  (val) = SpiRegs->DL;\
  DeAssertSS;\


/************************************************************************************
* Init Radio driver.
*
* During MCU platform initialization at power-up this primitive may be invoked by
* the platform to initialize the MCU SPI port, which is connected to the Radio.
*
*
* Interface assumptions:
*   None
*
* Return value:
*   None
*
************************************************************************************/
void MKW01Drv_SpiInit(void);

/************************************************************************************
* Reset Radio Transceiver through reset pin.
*
* During MCU platform initialization at power-up this primitive may be invoked by
* the platform to perform a hardware reset of the transceiver.
* This must be done by asserting an active low pulse onto the RST pin through an MCU GPIO.
*
* Interface assumptions:
*   None
*
* Return value:
*   None
*
************************************************************************************/
void MKW01Drv_Reset(void);

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/

uint8_t MKW01Drv_ReadRegister(uint8_t addr);
void MKW01Drv_WriteRegister(uint8_t addr, uint8_t val);
void MKW01Drv_RFdefaultInit(void);

void mkw01_drv_set_op_mode(uint8_t opMode);

void MKW01Drv_SetFrequency(uint8_t freq);
void MKW01Drv_SetBaudRate(uint8_t baudRate);
void MKW01Drv_SetFreqDev (uint8_t freqDev);


#endif /* SOURCES_TRANSCEIVERDRV_H_ */
