/*
 * Display.c
 *
 *  Created on: Nov 28, 2016
 *      Author: B50961
 */

#include "UART.h"
#include "RF_Rx_Appli.h"
#include "util.h"

/*
 * Send the content of the RF frame to the hyperterminal
 */
void Display_SendDataHypertem (void)
{
	unsigned char hex_word[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

	uint8_t Rf_payloadSize;
	uint8_t tmpbuf[RF_RX_BUFFER_SIZE << 1];
	uint8_t index;
	uint8_t i;
	uint8_t tmp2[2];
	Rf_payloadSize = RF_Rx_Buffer[0];
	index = 0;
	tmp2[0] = '\r';
	tmp2[1] = '\n';

	for (i=0;i<=Rf_payloadSize;i++)
	{
		index = i << 1;
		tmpbuf[index++] = hex_word[(RF_Rx_Buffer[i] >> 4) &0x0f];
		tmpbuf[index] = hex_word[(RF_Rx_Buffer[i] & 0x0f)];
	}

	UART0_TransmitBuffer(tmpbuf, ((Rf_payloadSize+1)<<1));
	UART0_TransmitBuffer(tmp2, 2);

	return;
}

/*
 * Sends the payload, MKW01 counter, CRC and RSSI to the GUI
 */
void Display_SendDataToLabview(void)
{

     /*
		RF_Rx_Buffer[0] = (UINT8) (Payload_Length); 		// Payload length
		RF_Rx_Buffer[1] = (UINT8) (0xF0); 					// MKW01 receiver address. Address check disabled on KW01 side.
		RF_Rx_Buffer[2] = (UINT8) (Tire_ID >> 24u); 		// Tire ID
		RF_Rx_Buffer[3] = (UINT8) (Tire_ID >> 16u); 		// Tire ID
		RF_Rx_Buffer[4] = (UINT8) (Tire_ID >> 8u); 		   	// Tire ID
		RF_Rx_Buffer[5] = (UINT8) (Tire_ID);       			// Tire ID
		RF_Rx_Buffer[6] = (UINT8) (Firmware_Version);       // Firmware version
		RF_Rx_Buffer[7] = (UINT8) (Derivative_Descriptor);  // Derivative descriptor
	    RF_Rx_Buffer[8] = (UINT8) (u16CompPressure >> 8u); 	// Pressure
		RF_Rx_Buffer[9] = (UINT8) (u16CompPressure);
		RF_Rx_Buffer[10] = (UINT8) (u16CompAccelZ >> 8u); 	// Z-axis acceleration
		RF_Rx_Buffer[11] = (UINT8) (u16CompAccelZ);
		RF_Rx_Buffer[12] = (UINT8) (u16CompAccelX >> 8u); 	// X-axis acceleration
		RF_Rx_Buffer[13] = (UINT8) (u16CompAccelX);
		RF_Rx_Buffer[14] = (UINT8) (gu8CompVolt); 			// Voltage
		RF_Rx_Buffer[15] = (UINT8) (gu8CompTemp); 			// Temperature
		RF_Rx_Buffer[16] = (UINT8) (u8StatusAcqRead); 		// Status Acquisition for READ functions
		RF_Rx_Buffer[17] = (UINT8) (u8StatusAcqComp); 		// Status Acquisition for COMP functions
		RF_Rx_Buffer[18] = (UINT8) (FrameID >> 8);			// Frame ID: keep alive counter
		RF_Rx_Buffer[19] = (UINT8) (FrameID);
		RF_Rx_Buffer[20] = (UINT8) (0xC0);					// Fixed data => can be modified by the user
		RF_Rx_Buffer[21] = (UINT8) (0xC1); 					// Fixed data => can be modified by the user
		RF_Rx_Buffer[22] = (UINT8) (0xC2); 					// Fixed data => can be modified by the user
   */

   unsigned char hex_word[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

   uint8_t tmpbuf[(RF_RX_BUFFER_SIZE << 1)+14+8]; // Max RF data size*2 + GUI format bytes + MKW01 data
   uint8_t index = 0;
   uint8_t i;
   static uint16_t counter = 0;
   static uint8_t payloadSize = 22; // At startup default value is 22 (decimal)
   static bool_t payloadSize_confirmed = FALSE; // At startup we are not sure the payload size is 22.

   /*
    * The payload length is not manually set to a given value in order to avoid having to update it when
    * the RF frame is modified.
    * In order to know the current payload length, we have to read RF_Rx_Buffer[0]. But the problem is that
    * RF_Rx_Buffer[0] can be corrupted and may contain a wrong value.
    * So if the RF frame is not corrupted (CRC OK), we can use the value given by RF_Rx_Buffer[0].
    * But if the RF frame is corrupted, we cannot use this value as it may be wrong so we use the default value
    * as long as we do not receive a correct frame.
    * We do not want to use a corrupted value of RF_Rx_Buffer[0] because it will shift the GUI frame and may lead
    * to memory corruption if the value is higher than the size of tmpbuf.
    */
   if (payloadSize_confirmed == FALSE)
   {
	   if (RF_CrcNotOk == 0)
	   {
		   // CRC is ok, payload length is not corrupted so we store the actual payload length
		   payloadSize = RF_Rx_Buffer[0];
		   payloadSize_confirmed = TRUE;
	   }
   }

   if (payloadSize < 3)
   {
	   payloadSize = 3; // We do not want a negative number below
   }

   tmpbuf[0]  = '[';
   tmpbuf[1]  = 'D';
   tmpbuf[2]  = 'A';
   tmpbuf[3]  = '0';
   tmpbuf[4]  = '8';
   tmpbuf[5]  = '0';
   tmpbuf[6]  = '0';
   tmpbuf[7]  = '0';
   tmpbuf[8]  = '1';
   tmpbuf[9]  = '1';
   tmpbuf[10] = '2';
   tmpbuf[11] = '3';
   tmpbuf[12] = '4';

   index = 13;
   for (i=2;i<=payloadSize-3;i++) // Do not display constant bytes at the end
	{
		tmpbuf[index++] = hex_word[(RF_Rx_Buffer[i] >> 4) &0x0f];
		tmpbuf[index++] = hex_word[(RF_Rx_Buffer[i] & 0x0f)];
	}


   tmpbuf[index++] = hex_word[((uint8_t)(counter>>8) >> 4)&0x0f]; // MKW01 RF counter
   tmpbuf[index++] = hex_word[((uint8_t)(counter>>8) & 0x0f)];
   tmpbuf[index++] = hex_word[((uint8_t)(counter&0x00FF) >> 4)&0x0f];
   tmpbuf[index++] = hex_word[((uint8_t)(counter&0x00FF) & 0x0f)];
   tmpbuf[index++] = hex_word[((uint8_t)(RF_CrcNotOk) >> 4)&0x0f]; // 0 if CRC OK, 1 if not OK
   tmpbuf[index++] = hex_word[((uint8_t)(RF_CrcNotOk) & 0x0f)];
   tmpbuf[index++] = hex_word[((uint8_t)(RF_RSSI_value) >> 4)&0x0f]; // RSSI value
   tmpbuf[index++] = hex_word[((uint8_t)(RF_RSSI_value) & 0x0f)];
   tmpbuf[index++] = ']';

   counter++;

   UART0_TransmitBuffer(tmpbuf, index);

   return;
}
