/*
 * UART.h
 *
 *  Created on: Dec 8, 2016
 *      Author: B50961
 */

#ifndef SOURCES_UART_UART_H_
#define SOURCES_UART_UART_H_

#include "device.h"

#define UART_BAUD_RATE_9600			(1)
#define UART_BAUD_RATE_19200		(2)
#define UART_BAUD_RATE_115200		(3)

#define UART_RE_SHIFT	2
#define UART_TE_SHIFT	3
#define UART0_DISABLE_RECEPTION		(UART0_C2 &= ~(1<<UART_RE_SHIFT))
#define UART0_ENABLE_RECEPTION		(UART0_C2 |= (1<<UART_RE_SHIFT))
#define UART0_DISABLE_TRANSMISSION	(UART0_C2 &= ~(1<<UART_TE_SHIFT))
#define UART0_ENABLE_TRANSMISSION	(UART0_C2 |= (1<<UART_TE_SHIFT))



#define UART_NB_BYTES_TO_RECEIVE	4

extern uint8_t UART0_Rx_Buffer[UART_NB_BYTES_TO_RECEIVE];
volatile extern uint8_t UART0_RxBufferFull;

void Init_UART0_General (void);
void UART0_SetBaudRate(uint8_t);
void UART0_TransmitBuffer(uint8_t *UART_Tx_Buffer , uint8_t buffer_size);


#endif /* SOURCES_UART_UART_H_ */
