/*****************************************************************************
 *   adc_main.c:  routine to test the stability of the circuit design
 *
 *   Copyright(C) 2010, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2010.12.28  ver 1.00    Preliminary version, first Release
 *
****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 ****************************************************************************/

#include "LPC13xx.h"                        /* LPC13xx definitions */
#include "adc.h"
#include "stdio.h"

/******************************************************************************
**   Main Function  main()
******************************************************************************/
int main (void)
{
	/* Basic chip initialization is taken care of in SystemInit() called
	 * from the startup code. SystemInit() and chip settings are defined
	 * in the CMSIS system_<part family>.c file.
	 */

	uint32_t cnt_adc_val[31];
	uint32_t j,temp_ADC7;
	uint32_t sum_avg=0;
	extern volatile uint32_t ADCIntDone;
	extern volatile uint32_t ADCValue[];

	/* Initialize ADC  */
	ADCInit( ADC_CLK );

while(1){
		// main part of routine

		// testing connections: ADC7 = PIO 1.11	... uart txd = PIO 1.7
		// step 1. Initialize
		// step 2. 1,000,000 measurements and calculate AVG
		// step 3. 1,000,000 measurements and put ADC-values into the histogram
		// step 4. send results via UART to PC

		printf("Starting the ADC\n");
		printf("Taking 1,000,000 ADC samples\n");

			// zero the array's => after startup all array's are 0
		  	for (j=0;j<=30;j++)
		  	{
		  		cnt_adc_val[j] = 0;
		  	}

			// avg calculation -> result: sum_avg
		  	sum_avg = 0;
			for (j=0;j<1000000;j++)
			{
			  		if (j%100000==0)
			  			printf(".");

					ADCRead( 7 );
			  		while ( !ADCIntDone ); 	// wait for ADC int = done
			  		ADCIntDone = 0;

					sum_avg = sum_avg + ADCValue[7];	// total result counter
			}

			sum_avg = (unsigned int)(sum_avg / 1000000);	// avg value over 1000000 measurements

  			printf("\nCalculated sample average: %d\n", sum_avg);

  			printf("Taking another 1,000,000 samples\n");

			// actual calculations -> result 30 counter-values
			for (j=0;j<1000000;j++)
			{
			  		ADCRead( 7 );					 	// ADC conversion
			  		while ( !ADCIntDone );			// wait till conversion is done
			  		ADCIntDone = 0;
					temp_ADC7 = ADCValue[7];   	// put ADC-value in temp-var
					// value should be > 0.048 V and < 3.248 V
					if ((temp_ADC7 > 15) && (temp_ADC7 < 1023 - 15))
					{
						if (j%100000==0)
				  			printf(".");

						if (temp_ADC7 < (sum_avg - 15)) 	cnt_adc_val[0]++;
						if (temp_ADC7 > (sum_avg + 15)) 	cnt_adc_val[30]++;
						if ((temp_ADC7 >= (sum_avg - 15)) && (temp_ADC7 <= (sum_avg + 15)))
				 		{
							cnt_adc_val[temp_ADC7 - sum_avg + 15]++;
						}
					}
			}
  			printf("\n");
  			printf("Printing histogram data...\n");
  			printf("Column 1: +/- from the AVG bin\n");
  			printf("Column 2: # of samples that match the bin\n");
  			printf("Note that each bin increment corresponds to a LSB of the ADC\n");
  			printf("(Hint: Copy & Paste into Excel)\n");

  			for (j=0;j<=30;j++)	{

  				printf("%d\t%u", j - 15, cnt_adc_val[j]);

  				if (j==15)		// place marker for center point
  					printf("\t<-- Bin that contains exactly the AVG (ADC = %d)\n", sum_avg);
  				else			// no marker
  					printf("\n");
  			}

			printf("END of Test\n");

			while(1); // eternal stop
	}
}

/******************************************************************************
**                            End Of File
******************************************************************************/

