
#include "timer.h"

void DelayMs(uint8_t timerno, uint32_t delaytime)
{
    switch (timerno)
    {
        case 0:
            LPC_TIMER0->TCR = 0x02;		/* reset timer */
            LPC_TIMER0->PR  = 0x00;		/* set prescaler to zero */
            LPC_TIMER0->MR[0] = CGU_GetPCLKFrequency(CGU_PERIPHERAL_M4CORE) / (1000/delaytime);  //enter delay time
            LPC_TIMER0->IR  = 0xff;		/* reset all interrrupts */
            LPC_TIMER0->MCR = 0x04;		/* stop timer on match */
            LPC_TIMER0->TCR = 0x01;		/* start timer */
            /* wait until delay time has elapsed */
            while (LPC_TIMER0->TCR & 0x01);
        break;

        case 1:
            LPC_TIMER1->TCR = 0x02;		/* reset timer */
            LPC_TIMER1->PR  = 0x00;		/* set prescaler to zero */
            LPC_TIMER1->MR[0] = CGU_GetPCLKFrequency(CGU_PERIPHERAL_M4CORE) / (1000/delaytime);  //enter delay time
            LPC_TIMER1->IR  = 0xff;		/* reset all interrrupts */
            LPC_TIMER1->MCR = 0x04;		/* stop timer on match */
            LPC_TIMER1->TCR = 0x01;		/* start timer */
            /* wait until delay time has elapsed */
            while (LPC_TIMER1->TCR & 0x01);
        break;
        case 2:
            LPC_TIMER2->TCR = 0x02;		/* reset timer */
            LPC_TIMER2->PR  = 0x00;		/* set prescaler to zero */
            LPC_TIMER2->MR[0] = CGU_GetPCLKFrequency(CGU_PERIPHERAL_M4CORE) / (1000/delaytime);  //enter delay time
            LPC_TIMER2->IR  = 0xff;		/* reset all interrrupts */
            LPC_TIMER2->MCR = 0x04;		/* stop timer on match */
            LPC_TIMER2->TCR = 0x01;		/* start timer */
            /* wait until delay time has elapsed */
            while (LPC_TIMER2->TCR & 0x01);
        break;
        case 3:
            LPC_TIMER3->TCR = 0x02;		/* reset timer */
            LPC_TIMER3->PR  = 0x00;		/* set prescaler to zero */
            LPC_TIMER3->MR[0] = CGU_GetPCLKFrequency(CGU_PERIPHERAL_M4CORE) / (1000/delaytime);  //enter delay time
            LPC_TIMER3->IR  = 0xff;		/* reset all interrrupts */
            LPC_TIMER3->MCR = 0x04;		/* stop timer on match */
            LPC_TIMER3->TCR = 0x01;		/* start timer */
            /* wait until delay time has elapsed */
            while (LPC_TIMER3->TCR & 0x01);
        break;

    }
}

void TimerInit(uint8_t timerno, uint32_t interval_time)
{
    switch (timerno)
    {
        case 0:
            LPC_TIMER0->IR = 0xFFFFFFFF;            //clear interrupts
            LPC_TIMER0->PR = 0x0;                   //prescale to 1
            LPC_TIMER0->MR[0] = interval_time;      //init MR[0] counter
            LPC_TIMER0->MCR = 0x3;                  //interrupt and reset when MR[0] is reached
        break;

        case 1:
            LPC_TIMER1->IR = 0xFFFFFFFF;            //clear interrupts
            LPC_TIMER1->PR = 0x0;                   //prescale to 1
            LPC_TIMER1->MR[0] = interval_time;      //init MR[0] counter
            LPC_TIMER1->MCR = 0x3;
        break;

        case 2:
            LPC_TIMER2->IR = 0xFFFFFFFF;            //clear interrupts
            LPC_TIMER2->PR = 0x0;                   //prescale to 1
            LPC_TIMER2->MR[0] = interval_time;      //init MR[0] counter
            LPC_TIMER2->MCR = 0x3;
        break;

        case 3:
            LPC_TIMER3->IR = 0xFFFFFFFF;            //clear interrupts
            LPC_TIMER3->PR = 0x0;                   //prescale to 1
            LPC_TIMER3->MR[0] = interval_time;      //init MR[0] counter
            LPC_TIMER3->MCR = 0x3;
        break;
    }
}

void TimerEnable(uint8_t timerno)
{
    switch (timerno)
    {
        case 0:
            LPC_TIMER0->TCR = 0x1;                  //enable timer
            NVIC_EnableIRQ(TIMER0_IRQn);
        break;
        case 1:
            LPC_TIMER1->TCR = 0x1;                  //enable timer
            NVIC_EnableIRQ(TIMER1_IRQn);
        break;
        case 2:
            LPC_TIMER2->TCR = 0x1;                  //enable timer
            NVIC_EnableIRQ(TIMER2_IRQn);
        break;
        case 3:
            LPC_TIMER3->TCR = 0x1;                  //enable timer
            NVIC_EnableIRQ(TIMER3_IRQn);
        break;

    }
}

void TimerDisable(uint8_t timerno)
{
    switch (timerno)
    {
        case 0:
            LPC_TIMER0->TCR = 0x2;                  //reset timer
            NVIC_DisableIRQ(TIMER0_IRQn);
            LPC_TIMER0->TCR = 0x0;                  //disable timer
        break;
        case 1:
            LPC_TIMER1->TCR = 0x2;                  //reset timer
            NVIC_DisableIRQ(TIMER1_IRQn);
            LPC_TIMER1->TCR = 0x0;                  //disable timer
        break;
        case 2:
            LPC_TIMER2->TCR = 0x2;                  //reset timer
            NVIC_DisableIRQ(TIMER2_IRQn);
            LPC_TIMER2->TCR = 0x0;                  //disable timer
        break;
        case 3:
            LPC_TIMER3->TCR = 0x2;                  //reset timer
            NVIC_DisableIRQ(TIMER3_IRQn);
            LPC_TIMER3->TCR = 0x0;                  //disable timer
        break;

    }
}

