/***********************************************************************
 * Code Red Technologies Flash driver                                  *
 *                                                                     */
/***********************************************************************/
/*                                                                     */
/*  FlashDev.C:  Device Description for SST39VF3201B (16-bit Bus)      */
/*               connected to CS0 of LPC1800 on the Hitex board v2     */
/*                                                                     */
/***********************************************************************/

#include "crt_flash_if.h"


struct FlashDevice const FlashDevice  =  {
   FLASH_DRV_VERS,             // Driver Version, do not modify!

   "S29GL064N Dual Flash (16MB) Keil_MCB1850_4350 " __DATE__" "__TIME__, // Device Name

   EXT32BIT,                   // Device Type
   0x1C000000,                 // Device Start Address
   0x01000000,                 // Device Size in Bytes (16MB)
   1024,                       // Programming Page Size
   0,                          // Reserved, must be 0
   0xFF,                       // Initial Content of Erased Memory

   100,                        // Program Page Timeout 100 mSec
   3000,                       // Erase Sector Timeout 1000 mSec

// Specify the sector sizes and the relative start address of the first sector

   {{0x002000, 0x000000},         // Sector Size 8kB (1024 Sectors)
   {SECTOR_END }}
};
