#ifndef lpc43xx_RITIMER_H_
#define lpc43xx_RITIMER_H_

/* Includes ------------------------------------------------------------------- */
#include "lpc43xx.h"
#include "lpc_types.h"

#ifdef __cplusplus
extern "C"
{
#endif

#define RITIMER_ENABLE				(LPC_RITIMER->CTRL |= (uint32_t)(1 << 3))
#define RITIMER_DISABLE				(LPC_RITIMER->CTRL &= ~(uint32_t)(1 << 3))
#define RITIMER_CLR_INT				(LPC_RITIMER->CTRL |= (uint32_t)(1 << 0))
#define RITIMER_AUTO_RESET_EN		(LPC_RITIMER->CTRL |= (uint32_t)(1 << 1))
#define RITIMER_AUTO_RESET_DIS		(LPC_RITIMER->CTRL &= ~(uint32_t)(1 << 1))
#define RITIMER_SET_COMPVAL(val)	(LPC_RITIMER->COMPVAL = (uint32_t)val)
#define RITIMER_SET_RI_MASK(val)	(LPC_RITIMER->MASK = (uint32_t)val)
#define RITIMER_SET_RI_COUNTER(val)	(LPC_RITIMER->COUNTER = (uint32_t)val)
#define RITIMER_CHECK_TIMEOUT		(LPC_RITIMER->CTRL & (0x1))

#define timer_wait_ms(regs, msec) rit_delay_ms(msec)


void RIT_IRQHandler(void);
void rit_init(uint32_t intv_ms);
uint32_t rit_get_counter(void);
void rit_delay_ms(uint32_t delay_ms);




#ifdef __cplusplus
}
#endif

#endif

