/***************************************************************************
* @brief oled.h
*	
* Description :  This file contains the  header definitons for OLED Display
*
* @note
* Copyright(C) NXP Semiconductors, 2014
* All rights reserved.
*
* Copyright(C) 2009, Embedded Artists AB
* All rights reserved.
*
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* LPC products.  This software is supplied "AS IS" without any warranties of
* any kind, and NXP Semiconductors and its licensor disclaim any and
* all warranties, express or implied, including all implied warranties of
* merchantability, fitness for a particular purpose and non-infringement of
* intellectual property rights.  NXP Semiconductors assumes no responsibility
* or liability for the use of the software, conveys no license or rights under any
* patent, copyright, mask work right, or any other intellectual property rights in
* or to any products. NXP Semiconductors reserves the right to make changes
* in the software without notification. NXP Semiconductors also makes no
* representation or warranty that such application will be suitable for the
* specified use without further testing or modification.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
**********************************************************************************/
#ifndef __OLED_H
#define __OLED_H

#define OLED_DISPLAY_WIDTH     96
#define OLED_DISPLAY_HEIGHT    64
#define OLED_I2C_ADDR          (0x3c << 1)

typedef enum
{
    OLED_COLOR_BLACK,
    OLED_COLOR_WHITE
} oled_color_t;

void    oled_init(void);
void    oled_putPixel(uint8_t x, uint8_t y, oled_color_t color);
void    oled_line(uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1, oled_color_t color);
void    oled_circle(uint8_t x0, uint8_t y0, uint8_t r, oled_color_t color);
void    oled_rect(uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1, oled_color_t color);
void    oled_fillRect(uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1, oled_color_t color);
void    oled_clearScreen(oled_color_t color);
void    oled_putString(uint8_t x, uint8_t y, char *pStr, oled_color_t fb, oled_color_t bg);
uint8_t oled_putChar(uint8_t x, uint8_t y, char ch, oled_color_t fb, oled_color_t bg);

#endif /* end __OLED_H */
