#include "LPC15xx.h"

typedef struct {
  __I  uint32_t RESERVED[4];
  __IO uint32_t CSR;          // (0x10)
  __IO uint32_t RVR;          // (0x14)
  __IO uint32_t CVR;          // (0x18)
  __IO uint32_t CALIB;        // (0x1C)
} LPC_SYSTICK_TypeDef;

#define LPC_SYSTICK_BASE       (0xE000E000UL)
#define LPC_SYSTICK            ((LPC_SYSTICK_TypeDef   *) LPC_SYSTICK_BASE  )

#define SETENA0                (*(volatile unsigned long *)(0xE000E100))     // ISER0
#define CLRENA0                (*(volatile unsigned long *)(0xE000E180))     // ICER0
#define CLRPEND0               (*(volatile unsigned long *)(0xE000E280))     // ICPR0
#define IP0                    (*(volatile unsigned long *)(0xE000E400))     // IPR0

#define NVIC_INTR              16
#define NVIC_WDT_IRQ           (NVIC_INTR+ 0) 	/* Windowed watchdog timer interrupt  */
#define NVIC_BOD_IRQ           (NVIC_INTR+ 1) 	/* BOD interrupt				              */
#define NVIC_DMA		       (NVIC_INTR+ 4) 	/* DMA interrupt                      */
#define NVIC_GINT0             (NVIC_INTR+ 5) 	/* GPIO group 0 interrupt             */
#define NVIC_GINT1             (NVIC_INTR+ 6) 	/* GPIO group 1 interrupt             */
#define NVIC_PININT0	       (NVIC_INTR+ 7) 	/* Pin interrupt 0                    */
#define NVIC_PININT1           (NVIC_INTR+ 8) 	/* Pin interrupt 1                    */
#define NVIC_PININT2           (NVIC_INTR+ 9) 	/* Pin interrupt 2                    */
#define NVIC_PININT3           (NVIC_INTR+10) 	/* Pin interrupt 3                    */
#define NVIC_PININT4           (NVIC_INTR+11) 	/* Pin interrupt 4                    */
#define NVIC_PININT5           (NVIC_INTR+12) 	/* Pin interrupt 5                    */
#define NVIC_PININT6           (NVIC_INTR+13) 	/* Pin interrupt 6                    */
#define NVIC_PININT7           (NVIC_INTR+14) 	/* Pin interrupt 7                    */
#define NVIC_SCT0          		(NVIC_INTR+16) 	/* State configurable timer interrupt */
#define NVIC_SCT1          		(NVIC_INTR+17) 	/* State configurable timer interrupt */
#define NVIC_SCT2          		(NVIC_INTR+18) 	/* State configurable timer interrupt */
#define NVIC_SCT3          		(NVIC_INTR+19) 	/* State configurable timer interrupt */
#define NVIC_MRT          		(NVIC_INTR+20) 	/* Multi-rate timer interrupt 				*/
#define NVIC_UART0         		(NVIC_INTR+21) 	/* USART0 interrupt 		 							*/
#define NVIC_UART1         		(NVIC_INTR+22) 	/* USART1 interrupt 		 							*/
#define NVIC_UART2         		(NVIC_INTR+23) 	/* USART2 interrupt 		 							*/
#define NVIC_I2C0         		(NVIC_INTR+24) 	/* I2C0 interrupt  			 							*/
#define NVIC_SPI0          		(NVIC_INTR+25) 	/* SPI0 interrupt 			 							*/
#define NVIC_SPI1          		(NVIC_INTR+26) 	/* SPI1 interrupt 			 							*/
#define NVIC_C_CAN0        		(NVIC_INTR+27) 	/* C_CAN0 interrupt 		 							*/
#define NVIC_USB_LP        		(NVIC_INTR+28) 	/* USB LP interrupt 		 							*/
#define NVIC_USB_HP        		(NVIC_INTR+29) 	/* USB HP interrupt 		 							*/
#define NVIC_USB_WAKE      		(NVIC_INTR+30) 	/* USB wake up interrupt 							*/
#define NVIC_ADC0_SEQA     		(NVIC_INTR+31) 	/* ADC0 sequence A completion 				*/
#define NVIC_ADC0_SEQB     		(NVIC_INTR+32) 	/* ADC0 sequence B completion 				*/
#define NVIC_ADC0_THCMP    		(NVIC_INTR+33) 	/* ADC0 threshold compare 			 			*/
#define NVIC_ADC0_OVR    		(NVIC_INTR+34) 	/* ADC0 overrun 								 			*/
#define NVIC_ADC1_SEQA    		(NVIC_INTR+35) 	/* ADC1 sequence A completion 	 			*/
#define NVIC_ADC1_SEQB    		(NVIC_INTR+36) 	/* ADC1 sequence B completion 	 			*/
#define NVIC_ADC1_THCMP    		(NVIC_INTR+37) 	/* ADC1 threshold compare 			 			*/
#define NVIC_ADC1_OVR    		(NVIC_INTR+38) 	/* ADC1 overrun	 								 			*/
#define NVIC_DAC    			(NVIC_INTR+39) 	/* DAC interrupt 								 			*/
#define NVIC_CMP0        		(NVIC_INTR+40) 	/* Analog comparator 0 interrupt 			*/
#define NVIC_CMP1		    	(NVIC_INTR+41) 	/* Analog comparator 1 interrupt 			*/
#define NVIC_CMP2		    	(NVIC_INTR+42) 	/* Analog comparator 2 interrupt 			*/
#define NVIC_CMP3		    	(NVIC_INTR+43) 	/* Analog comparator 3 interrupt 			*/
#define NVIC_QEI		    	(NVIC_INTR+44) 	/* QEI interrupt 											*/
#define NVIC_RTC_ALARM  		(NVIC_INTR+45) 	/* RTC alarm interrupt 								*/
#define NVIC_RTC_WAKE   		(NVIC_INTR+46) 	/* RTC wake-up interrut 							*/


#define GPIO_B3                LPC_GPIO->B0[3]             // P0.3 (green led)
#define GPIO_B25               LPC_GPIO->B0[25]            // P0.25 (red led)
#define GPIO_B27               LPC_GPIO->B0[27]            // P0.27 (current trip)
#define GPIO_DIR0              LPC_GPIO->DIR[0]            // ?
#define GPIO_DIR1              LPC_GPIO->DIR[1]            // ?
#define GPIO_DIR2              LPC_GPIO->DIR[2]            // ?
#define GPIO_NOT0              LPC_GPIO->NOT[0]            // ?
#define GPIO_PIN1              LPC_GPIO->PIN[1]            // ?
#define QEISTAT                LPC_QEI->STAT                // ?
#define QEIPOS                 LPC_QEI->POS                // ?
#define QEIMAXPSOS             LPC_QEI->MAXPOS                // ?
#define QEICONF                LPC_QEI->CONF                // ?
#define SYSAHBCLKCTRL0         LPC_SYSCON->SYSAHBCLKCTRL0
#define SYSAHBCLKCTRL1         LPC_SYSCON->SYSAHBCLKCTRL1
#define PDRUNCFG               LPC_SYSCON->PDRUNCFG
#define SYSTICKCLKDIV          LPC_SYSCON->SYSTICKCLKDIV
#define SYSAHBCLKDIV           LPC_SYSCON->SYSAHBCLKDIV
#define IOCONCLKDIV            LPC_SYSCON->IOCONCLKDIV
#define UARTCLKDIV             LPC_SYSCON->UARTCLKDIV
#define FRGCTRL                LPC_SYSCON->FRGCTRL
#define TRACECLKDIV            LPC_SYSCON->TRACECLKDIV
#define USBCLKDIV              LPC_SYSCON->USBCLKDIV
#define ADCASYNCCLKDIV         LPC_SYSCON->ADCASYNCCLKDIV
#define CLKOUTDIV              LPC_SYSCON->CLKOUTDIV
#define CLKOUTSELA             LPC_SYSCON->CLKOUTCLKSELA
#define CLKOUTSELB             LPC_SYSCON->CLKOUTCLKSELB
#define PINASSIGN0             LPC_SWM->PINASSIGN0
#define PINASSIGN1             LPC_SWM->PINASSIGN1
#define PINASSIGN2             LPC_SWM->PINASSIGN2
#define PINASSIGN3             LPC_SWM->PINASSIGN3
#define PINASSIGN4             LPC_SWM->PINASSIGN4
#define PINASSIGN5             LPC_SWM->PINASSIGN5
#define PINASSIGN6             LPC_SWM->PINASSIGN6
#define PINASSIGN7             LPC_SWM->PINASSIGN7
#define PINASSIGN8             LPC_SWM->PINASSIGN8
#define PINASSIGN9             LPC_SWM->PINASSIGN9
#define PINASSIGN10            LPC_SWM->PINASSIGN10
#define PINASSIGN11            LPC_SWM->PINASSIGN11
#define PINASSIGN12            LPC_SWM->PINASSIGN12
#define PINASSIGN13            LPC_SWM->PINASSIGN13
#define PINASSIGN14            LPC_SWM->PINASSIGN14
#define PINASSIGN15            LPC_SWM->PINASSIGN15
#define PINENABLE0             LPC_SWM->PINENABLE0
#define PINENABLE1             LPC_SWM->PINENABLE1
#define USART0_STAT            LPC_UART0->STAT
#define USART0_CFG             LPC_UART0->CFG
#define USART0_CTRL            LPC_UART0->CTRL
#define USART0_BRG             LPC_UART0->BRG
#define USART0_INTENSET        LPC_UART0->INTENSET
#define USART0_INTENCLR        LPC_UART0->INTENCLR
#define USART0_TXDATA          LPC_UART0->TXDATA
#define USART0_RXDATA          LPC_UART0->RXDATA
#define SCT0_CONFIG            LPC_SCT0->CONFIG
#define SCT0_CTRL              LPC_SCT0->CTRL_U
#define SCT0_STATE             LPC_SCT0->STATE_L
#define SCT0_MATCHREL0         LPC_SCT0->MATCHREL[0].U
#define SCT0_MATCHREL1         LPC_SCT0->MATCHREL[1].U
#define SCT0_MATCHREL2         LPC_SCT0->MATCHREL[2].U
#define SCT0_MATCHREL3         LPC_SCT0->MATCHREL[3].U
#define SCT0_MATCHREL4         LPC_SCT0->MATCHREL[4].U
#define SCT0_MATCH0            LPC_SCT0->MATCH[0].U
#define SCT0_MATCH1            LPC_SCT0->MATCH[1].U
#define SCT0_MATCH2            LPC_SCT0->MATCH[2].U
#define SCT0_MATCH3            LPC_SCT0->MATCH[3].U
#define SCT0_MATCH4            LPC_SCT0->MATCH[4].U
#define SCT0_EV0_STATE         LPC_SCT0->EVENT[0].STATE
#define SCT0_EV1_STATE         LPC_SCT0->EVENT[1].STATE
#define SCT0_EV2_STATE         LPC_SCT0->EVENT[2].STATE
#define SCT0_EV3_STATE         LPC_SCT0->EVENT[3].STATE
#define SCT0_EV4_STATE         LPC_SCT0->EVENT[4].STATE
#define SCT0_EV5_STATE         LPC_SCT0->EVENT[5].STATE
#define SCT0_EV6_STATE         LPC_SCT0->EVENT[6].STATE
#define SCT0_EV7_STATE         LPC_SCT0->EVENT[7].STATE
#define SCT0_EV0_CTRL          LPC_SCT0->EVENT[0].CTRL
#define SCT0_EV1_CTRL          LPC_SCT0->EVENT[1].CTRL
#define SCT0_EV2_CTRL          LPC_SCT0->EVENT[2].CTRL
#define SCT0_EV3_CTRL          LPC_SCT0->EVENT[3].CTRL
#define SCT0_EV4_CTRL          LPC_SCT0->EVENT[4].CTRL
#define SCT0_EV5_CTRL          LPC_SCT0->EVENT[5].CTRL
#define SCT0_EV6_CTRL          LPC_SCT0->EVENT[6].CTRL
#define SCT0_EV7_CTRL          LPC_SCT0->EVENT[7].CTRL
#define SCT0_OUT0_SET          LPC_SCT0->OUT[0].SET
#define SCT0_OUT1_SET          LPC_SCT0->OUT[1].SET
#define SCT0_OUT2_SET          LPC_SCT0->OUT[2].SET
#define SCT0_OUT3_SET          LPC_SCT0->OUT[3].SET
#define SCT0_OUT4_SET          LPC_SCT0->OUT[4].SET
#define SCT0_OUT5_SET          LPC_SCT0->OUT[5].SET
#define SCT0_OUT6_SET          LPC_SCT0->OUT[6].SET
#define SCT0_OUT7_SET          LPC_SCT0->OUT[7].SET
#define SCT0_OUT8_SET          LPC_SCT0->OUT[8].SET
#define SCT0_OUT0_CLR          LPC_SCT0->OUT[0].CLR
#define SCT0_OUT1_CLR          LPC_SCT0->OUT[1].CLR
#define SCT0_OUT2_CLR          LPC_SCT0->OUT[2].CLR
#define SCT0_OUT3_CLR          LPC_SCT0->OUT[3].CLR
#define SCT0_OUT4_CLR          LPC_SCT0->OUT[4].CLR
#define SCT0_OUT5_CLR          LPC_SCT0->OUT[5].CLR
#define SCT0_OUT6_CLR          LPC_SCT0->OUT[6].CLR
#define SCT0_OUT7_CLR          LPC_SCT0->OUT[7].CLR
#define SCT0_OUT8_CLR          LPC_SCT0->OUT[8].CLR
#define ADC0_CTRL              LPC_ADC0->CTRL
#define ADC0_INSEL             LPC_ADC0->INPUTSEL
#define ADC0_SEQA_CTRL         LPC_ADC0->SEQA_CTRL
#define ADC0_SEQB_CTRL         LPC_ADC0->SEQB_CTRL
#define ADC0_INTEN             LPC_ADC0->INTEN
#define ADC0_FLAGS             LPC_ADC0->FLAGS
#define ADC0_DAT0              LPC_ADC0->DAT0
#define ADC0_DAT1              LPC_ADC0->DAT1
#define ADC0_DAT2              LPC_ADC0->DAT2
#define ADC0_DAT3              LPC_ADC0->DAT3
#define ADC0_DAT4              LPC_ADC0->DAT4
#define ADC1_CTRL              LPC_ADC1->CTRL
#define ADC1_INSEL             LPC_ADC1->INPUTSEL
#define ADC1_SEQA_CTRL         LPC_ADC1->SEQA_CTRL
#define ADC1_SEQB_CTRL         LPC_ADC1->SEQB_CTRL
#define ADC1_INTEN             LPC_ADC1->INTEN
#define DAC_VAL                LPC_DAC->VAL
#define SYSTICKCSR             LPC_SYSTICK->CSR
#define SYSTICKRVR             LPC_SYSTICK->RVR

#define __disable_interrupt()  __disable_irq()
#define __enable_interrupt()   __enable_irq()
