/***************************************************************************
* @brief NXP LPC15xx Joystick control
*
*	Description :
*			This file contains the joystick control interrupt handlers for motor control.
*
* @note
* Copyright(C) NXP Semiconductors, 2014
* All rights reserved.
*
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* LPC products.  This software is supplied "AS IS" without any warranties of
* any kind, and NXP Semiconductors and its licensor disclaim any and
* all warranties, express or implied, including all implied warranties of
* merchantability, fitness for a particular purpose and non-infringement of
* intellectual property rights.  NXP Semiconductors assumes no responsibility
* or liability for the use of the software, conveys no license or rights under any
* patent, copyright, mask work right, or any other intellectual property rights in
* or to any products. NXP Semiconductors reserves the right to make changes
* in the software without notification. NXP Semiconductors also makes no
* representation or warranty that such application will be suitable for the
* specified use without further testing or modification.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
**********************************************************************************/

#include "global.h"
#define JOYSTICK_PORT1 1
#define JOY_R_PIN 6
#define JOY_L_PIN 4
#define JOY_U_PIN 7
#define JOY_D_PIN 8
#define JOY_C_PIN 5
extern volatile uint8_t state;
extern volatile int flag;
extern volatile uint8_t index;
extern volatile uint8_t f_100ms;
extern volatile uint8_t speed;
volatile int teu=0;
void joystick_init (void)
{
	
	/* set the GPIOs as inputs */
    GPIOSetDir( JOYSTICK_PORT1, JOY_C_PIN, 0 ); // JOY_CENTER
    GPIOSetDir( JOYSTICK_PORT1, JOY_U_PIN, 0 ); // JOY_UP
    GPIOSetDir( JOYSTICK_PORT1, JOY_D_PIN, 0 ); // JOY_DOWN
	
	GPIOPinIntClear(CHANNEL5);
	GPIOPinIntClear(CHANNEL6);
	GPIOPinIntClear(CHANNEL7);
	
	/* Setup the interrupt, seq: portNum, bitPosi, sense = edge, single = both, event*/
	GPIOSetPinInterrupt(CHANNEL5,JOYSTICK_PORT1, JOY_C_PIN ,0,0);
	GPIOSetPinInterrupt(CHANNEL6,JOYSTICK_PORT1, JOY_U_PIN ,0,0);
	GPIOSetPinInterrupt(CHANNEL7,JOYSTICK_PORT1, JOY_D_PIN ,0,0);


	/* Enable the interrupts */
	GPIOPinIntEnable(CHANNEL5, 0 );
	GPIOPinIntEnable(CHANNEL6, 0 );
	GPIOPinIntEnable(CHANNEL7, 0 );
	
}

void PININT5_IRQHandler(void)
{
	uint32_t regVal;
	regVal = GPIOPinIntStatus(CHANNEL5);	
	if(regVal)
	{  
		teu=0;
  speed = 0;
	}		
	
LPC_GPIO_PIN_INT->IST = 0xFFF;
}

void PININT6_IRQHandler(void)
{
	uint32_t regVal;
	regVal = GPIOPinIntStatus(CHANNEL6);
	if(regVal && (teu!=1))
	{ teu=1;
		state = ST_F_BOOST;
	}
	if(regVal && ( state == ST_F_BOOST))
	{
			flag=1;
      state = ST_FORWARD;                          // in forward direction
      LPC_SCT0->STATE_L = index;                   // set initial state
      LPC_SCT0->CTRL_U &= ~(1 << 2);               // unhalt SCT by clearing bit 2 of the CTRL register		
	}
	if(regVal && (state == ST_FORWARD))
	{
		if (f_100ms)                                 // every 100 mseconds
    {
      f_100ms = 0;
      if (speed < pwm_end)       
         {	
           speed ++;                            // increase motor speed
         }
		}
	}
		
LPC_GPIO_PIN_INT->IST = 0xFFF;

}

void PININT7_IRQHandler(void)
{
	uint32_t regVal;
	regVal = GPIOPinIntStatus(CHANNEL7);
	if(regVal&& (state == ST_FORWARD))
	{		
		if (f_100ms)                                 // every 100 mseconds
       {
         f_100ms = 0;
				 if ( speed > 0)            
            {
               speed --;                            // decrease motor speed
            }
			}
	}
	
	LPC_GPIO_PIN_INT->IST = 0xFFF;
}
