/*****************************************************************************
*  LPC15xx SCT0 BLDC motor demo
*
*  LPC154x  - SCT0/1 support: � 8 inputs
*                             � 10 outputs
*                             � 16 match/capture registers
*                             � 16 events
*                             � 16 states
*****************************************************************************/
/*
 * @brief LPC15xx Analog comparator driver
 *
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "global.h"

void SCT0_IRQHandler(void)
{                                                  // SCT2 Interrupt Handler (10 msec)
    LPC_SCT0->EVFLAG = 0x0000FFFF;                 // clear all event flags
}

void SCT0_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |=  (EN1_SCT0);             // enable the SCT0 clock

    LPC_SCT0->CONFIG           |= (1 << 0) | (1 << 17);    // unified timer and autolimit
    LPC_SCT0->CTRL_U           |= (sct_pre << 5);          // SCT0 clock input is = 1MHz (1usec)

    LPC_SCT0->MATCH[0].U        = pwm_end;                 // match 0 = end of pwm signal 
    LPC_SCT0->MATCHREL[0].U     = pwm_end;
    LPC_SCT0->MATCH[1].U        = pwm_end;                 // match 1 = duty cycle value
    LPC_SCT0->MATCHREL[1].U     = pwm_end;

    LPC_SCT0->EVENT[0].STATE  = 0xFFFFFFFF;                // event 0 (PWM_END) happens in all states
    LPC_SCT0->EVENT[0].CTRL   = (0 << 0)  |                // related to match 0 (pwm_end)
                                (1 << 12) |                // COMBMODE[13:12] = match condition only
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                (0 << 15);                 // STATEV[19:15] = 0 (no state change)

    LPC_SCT0->EVENT[1].STATE  = (1 << 4);                  // event 1 happens in state 4 (PHASE 2)
    LPC_SCT0->EVENT[1].CTRL   = (1 << 0)  |                // related to match 1 (pwm_duty)
                                (1 << 12) |                // COMBMODE[13:12] = match condition only
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                (0 << 15);                 // STATEV[19:15] = 0 (no state change)

    LPC_SCT0->EVENT[2].STATE  = (1 << 1);                  // event 2 happens in state 1 (PHASE 6)
    LPC_SCT0->EVENT[2].CTRL   = (1 << 0)  |                // related to match 1 (pwm_duty)
                                (1 << 12) |                // COMBMODE[13:12] = match condition only
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                (0 << 15);                 // STATEV[19:15] = 0 (no state change)

    LPC_SCT0->EVENT[3].STATE  = (1 << 5);                  // event 3 happens in state 5 (PHASE 1)
    LPC_SCT0->EVENT[3].CTRL   = (1 << 0)  |                // related to match 1 (pwm_duty)
                                (1 << 12) |                // COMBMODE[13:12] = match condition only
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                (0 << 15);                 // STATEV[19:15] = 0 (no state change)

    LPC_SCT0->EVENT[4].STATE  = (1 << 2);                  // event 4 happens in state 2 (PHASE 4)
    LPC_SCT0->EVENT[4].CTRL   = (1 << 0)  |                // related to match 1 (pwm_duty)
                                (1 << 12) |                // COMBMODE[13:12] = match condition only
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                (0 << 15);                 // STATEV[19:15] = 0 (no state change)

    LPC_SCT0->EVENT[5].STATE  = (1 << 6);                  // event 5 happens in state 6 (PHASE 3)
    LPC_SCT0->EVENT[5].CTRL   = (1 << 0)  |                // related to match 1 (pwm_duty)
                                (1 << 12) |                // COMBMODE[13:12] = match condition only
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                (0 << 15);                 // STATEV[19:15] = 0 (no state change)

    LPC_SCT0->EVENT[6].STATE  = (1 << 3);                  // event 6 happens in state 3 (PHASE 5)
    LPC_SCT0->EVENT[6].CTRL   = (1 << 0)  |                // related to match 1 (pwm_duty)
                                (1 << 12) |                // COMBMODE[13:12] = match condition only
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                (0 << 15);                 // STATEV[19:15] = 0 (no state change)

    LPC_SCT0->EVENT[7].STATE  = (1 << 1);                  // event 7 happens in state 1 (PHASE 6)
    LPC_SCT0->EVENT[7].CTRL   = (0 << 0)  |                // related to match 0 (pwm_end)
                                (0 << 5)  |                // OUTSEL[5]     = selects input
                                (0 << 6)  |                // IOSEL[9:6]    = 0 (select SCT0_IN0 = HAL_A)
                                (3 << 10) |                // IOCOND[11:10] = 3 (high level on HAL_A)
                                (3 << 12) |                // COMBMODE[13:12] = match AND IO condition
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                (4 << 15);                 // STATEV[19:15] = new state is 5 (PHASE 1)

    LPC_SCT0->EVENT[8].STATE  = (1 << 6);                  // event 8 happens in state 6 (PHASE 3)
    LPC_SCT0->EVENT[8].CTRL   = (0 << 0)  |                // related to match 0 (pwm_end)
                                (0 << 5)  |                // OUTSEL[5]     = selects input
                                (0 << 6)  |                // IOSEL[9:6]    = 0 (select SCT0_IN0 = HAL_A)
                                (0 << 10) |                // IOCOND[11:10] = 0 (low level on HAL_A)
                                (3 << 12) |                // COMBMODE[13:12] = match AND IO condition
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                ((32 - 4) << 15);          // STATEV[19:15] = new state is 2 (PHASE 4)

    LPC_SCT0->EVENT[9].STATE  = (1 << 4);                  // event 9 happens in state 4 (PHASE 2)
    LPC_SCT0->EVENT[9].CTRL   = (0 << 0)  |                // related to match 0 (pwm_end)
                                (0 << 5)  |                // OUTSEL[5]     = selects input
                                (1 << 6)  |                // IOSEL[9:6]    = 1 (select SCT0_IN1 = HAL_B)
                                (3 << 10) |                // IOCOND[11:10] = 3 (high level on HAL_B)
                                (3 << 12) |                // COMBMODE[13:12] = match AND IO condition
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                (2 << 15);                 // STATEV[19:15] = new state is 6 (PHASE 3)

    LPC_SCT0->EVENT[10].STATE = (1 << 3);                  // event 10 happens in state 3 (PHASE 5)
    LPC_SCT0->EVENT[10].CTRL  = (0 << 0)  |                // related to match 0 (pwm_end)
                                (0 << 5)  |                // OUTSEL[5]     = selects input
                                (1 << 6)  |                // IOSEL[9:6]    = 1 (select SCT0_IN1 = HAL_B)
                                (0 << 10) |                // IOCOND[11:10] = 0 (low level on HAL_B)
                                (3 << 12) |                // COMBMODE[13:12] = match AND IO condition
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                ((32 - 2) << 15);          // STATEV[19:15] = new state is 1 (PHASE 6)

    LPC_SCT0->EVENT[11].STATE = (1 << 2);                  // event 11 happens in state 2 (PHASE 4)
    LPC_SCT0->EVENT[11].CTRL  = (0 << 0)  |                // related to match 0 (pwm_end)
                                (0 << 5)  |                // OUTSEL[5]     = selects input
                                (2 << 6)  |                // IOSEL[9:6]    = 2 (select SCT0_IN2 = HAL_C)
                                (3 << 10) |                // IOCOND[11:10] = 3 (high level on HAL_C)
                                (3 << 12) |                // COMBMODE[13:12] = match AND IO condition
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                (1 << 15);                 // STATEV[19:15] = new state is 3 (PHASE 5)

    LPC_SCT0->EVENT[12].STATE = (1 << 5);                  // event 12 happens in state 5 (PHASE 1)
    LPC_SCT0->EVENT[12].CTRL  = (0 << 0)  |                // related to match 0 (pwm_end)
                                (0 << 5)  |                // OUTSEL[5]     = selects input
                                (2 << 6)  |                // IOSEL[9:6]    = 2 (select SCT0_IN2 = HAL_C)
                                (0 << 10) |                // IOCOND[11:10] = 0 (low level on HAL_C)
                                (3 << 12) |                // COMBMODE[13:12] = match AND IO condition
                                (0 << 14) |                // STATELD[14]   = STATEV is added to state
                                ((32 - 1) << 15);          // STATEV[19:15] = new state is 4 (PHASE 2)

    LPC_SCT0->EVENT[13].STATE = 0xFFFFFFFF;                // event 13 (ABORT) happens in all states
    LPC_SCT0->EVENT[13].CTRL  = (0 << 5)  |                // OUTSEL[5]     = selects input
                                (3 << 6)  |                // IOSEL[9:6]    = 3 (select SCT0_IN3 = ABORT)
                                (0 << 10) |                // IOCOND[11:10] = 0 (low level on INP3)
                                (2 << 12) |                // COMBMODE[13:12] = IO condition only
                                (1 << 14) |                // STATELD[14]   = STATEV is loaded into state
                                (0 << 15);                 // STATEV[19:15] = new state is 0 (ERROR)

    LPC_SCT0->OUT[0].SET      = (1 << 4) | (1 << 6);       // event 4 and 6 will set SCT0_OUT0 (SW2)
    LPC_SCT0->OUT[1].SET      = (1 << 1) | (1 << 3);       // event 1 and 3 will set SCT0_OUT1 (SW1)
    LPC_SCT0->OUT[2].SET      = (1 << 2) | (1 << 3);       // event 2 and 3 will set SCT0_OUT2 (SW4)
    LPC_SCT0->OUT[3].SET      = (1 << 4) | (1 << 5);       // event 4 and 5 will set SCT0_OUT3 (SW3)
    LPC_SCT0->OUT[4].SET      = (1 << 1) | (1 << 5);       // event 1 and 5 will set SCT0_OUT4 (SW6)
    LPC_SCT0->OUT[6].SET      = (1 << 2) | (1 << 6);       // event 2 and 6 will set SCT0_OUT6 (SW5)

    LPC_SCT0->OUT[0].CLR      = (1 << 0) | (1 << 13);      // event 0 and 13 will clear SCT0_OUT0 (SW2)
    LPC_SCT0->OUT[1].CLR      = (1 << 0) | (1 << 13);      // event 0 and 13 will clear SCT0_OUT1 (SW1)
    LPC_SCT0->OUT[2].CLR      = (1 << 0) | (1 << 13);      // event 0 and 13 will clear SCT0_OUT2 (SW4)
    LPC_SCT0->OUT[3].CLR      = (1 << 0) | (1 << 13);      // event 0 and 13 will clear SCT0_OUT3 (SW3)
    LPC_SCT0->OUT[4].CLR      = (1 << 0) | (1 << 13);      // event 0 and 13 will clear SCT0_OUT4 (SW6)
    LPC_SCT0->OUT[6].CLR      = (1 << 0) | (1 << 13);      // event 0 and 13 will clear SCT0_OUT6 (SW5)
}
