
#include <LPC13xx.H>                        /* LPC13xx definitions */

#include "type.h"

#include "timer.h"
#include "gpio.h"
#include "demo.h"

#include "usb.h"
#include "usbcfg_LPC13xx.h"
#include "usbreg_LPC13xx.h"
#include "usbhw_LPC13xx.h"
#include "usbcore.h"
#include "usbuser.h"

volatile uint32_t USB_Suspend = 0;

void Timer32B0_Init(void)
{
	LPC_SYSCON -> SYSAHBCLKCTRL |= (1 << 9);

	LPC_TMR32B0 -> MCR |= 0x07;
	LPC_TMR32B0 -> MR0 = (RC6_MAX * 12);

	NVIC_EnableIRQ(TIMER_32_0_IRQn);
}


void TIMER32_0_IRQHandler(void)
{
	if (LPC_TMR32B0->IR & 0x01)
	{
		LPC_TMR32B0->IR &= 0x01;
		
		if(IR_DataShift & 0x7FF00000) 
		{
			if(IR_Data == IR_DataShift)
			{
				IR_DataBufNum++;
				// avoid the mute toggle and the pause toggle
				if((((IR_DataShift & 0x7FFF) == BUTTEN_PAUSE) || ((IR_DataShift & 0x7FFF) == BUTTEN_MUTE))
					&& (IR_DataBufNum > 2))
					IR_DataBufNum--;
				
			}
			else
			{
				IR_DataBufNum = 1;
				IR_Data = IR_DataShift;
				Reset_IR();
			}
		}
		else
		{
			IR_Data = 0;
			IR_DataShift = 0;
			IR_DataBufNum = 0;
			Reset_IR();
		}

		if((IR_DataShift & 0x7FF00000) && ((IR_DataBufNum == 1) || (IR_DataBufNum > 3))) 
		{
			IR_Data = IR_DataShift;
			switch(IR_DataShift & 0x7FFF)
			{
				// navigation control buttons
				case BUTTEN_GREENSTART:
					INPORT[0] = 0x02;
					INPORT[1] = 0x0D;
					INPORT_NUM = 2;
					break;
				case BUTTEN_UP:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x52;
					INPORT_NUM = 3;
					break;
				case BUTTEN_DOWN:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x51;
					INPORT_NUM = 3;
					break;
				case BUTTEN_LEFT:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x50;
					INPORT_NUM = 3;
					break;
				case BUTTEN_RIGHT:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x4F;
					INPORT_NUM = 3;
					break;
				case BUTTEN_OK:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x28;
					INPORT_NUM = 3;
					break;
				case BUTTEN_BACK:
					INPORT[0] = 0x01;
					INPORT[1] = 0x24;
					INPORT[2] = 0x02;
					INPORT_NUM = 3;
					break;
				case BUTTEN_MORE:
					INPORT[0] = 0x01;
					INPORT[1] = 0x09;
					INPORT[2] = 0x02;
					INPORT_NUM = 3;
					break;
				// transport control buttons
				case BUTTEN_PLAY:
					INPORT[0] = 0x01;
					INPORT[1] = 0xB0;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_PAUSE:
					INPORT[0] = 0x01;
					INPORT[1] = 0xB1;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_STOP:
					INPORT[0] = 0x01;
					INPORT[1] = 0xB7;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_RECORD:
					INPORT[0] = 0x01;
					INPORT[1] = 0xB2;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_FASTFORWARD:
					INPORT[0] = 0x01;
					INPORT[1] = 0xB3;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_REWIND:
					INPORT[0] = 0x01;
					INPORT[1] = 0xB4;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_SKIPFORWARD:
					INPORT[0] = 0x01;
					INPORT[1] = 0xB5;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_SKIPBACKWARD:
					INPORT[0] = 0x01;
					INPORT[1] = 0xB6;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				// audio and video control buttons
				case BUTTEN_SLEEPTOGGLE:
					if(USB_Suspend > 2) 
					{
						USB_Suspend = 2;
						USB_WakeUp();
					}
					else
					{
						INPORT[0] = 0x03;
						INPORT[1] = 0x82;
						INPORT_NUM = 2;
					}
					break;
				case BUTTEN_VOLUMEUP:
					INPORT[0] = 0x01;
					INPORT[1] = 0xE9;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_VOLUMEDOWN:
					INPORT[0] = 0x01;
					INPORT[1] = 0xEA;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_CHANNELUP:
					INPORT[0] = 0x01;
					INPORT[1] = 0x9C;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_CHANNELDOWN:
					INPORT[0] = 0x01;
					INPORT[1] = 0x9D;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_MUTE:
					INPORT[0] = 0x01;
					INPORT[1] = 0xE2;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				// numeric buttons
				case BUTTEN_0:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x27;
					INPORT_NUM = 3;
					break;
				case BUTTEN_1:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x1E;
					INPORT_NUM = 3;
					break;
				case BUTTEN_2:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x1F;
					INPORT_NUM = 3;
					break;
				case BUTTEN_3:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x20;
					INPORT_NUM = 3;
					break;
				case BUTTEN_4:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x21;
					INPORT_NUM = 3;
					break;
				case BUTTEN_5:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x22;
					INPORT_NUM = 3;
					break;
				case BUTTEN_6:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x23;
					INPORT_NUM = 3;
					break;
				case BUTTEN_7:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x24;
					INPORT_NUM = 3;
					break;
				case BUTTEN_8:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x25;
					INPORT_NUM = 3;
					break;
				case BUTTEN_9:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x26;
					INPORT_NUM = 3;
					break;
				case BUTTEN_SHARP:
					INPORT[0] = 0x04;
					INPORT[1] = 0x20;
					INPORT[2] = 0x20;
					INPORT_NUM = 3;
					break;
				case BUTTEN_STAR:
					INPORT[0] = 0x04;
					INPORT[1] = 0x20;
					INPORT[2] = 0x25;
					INPORT_NUM = 3;
					break;
				case BUTTEN_CLEAR:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x2A;
					INPORT_NUM = 3;
					break;
				case BUTTEN_ENTER:
					INPORT[0] = 0x04;
					INPORT[1] = 0x00;
					INPORT[2] = 0x28;
					INPORT_NUM = 3;
					break;
				// shortcupt buttons
				case BUTTEN_GUIDE:
					INPORT[0] = 0x01;
					INPORT[1] = 0x8D;
					INPORT[2] = 0x00;
					INPORT_NUM = 3;
					break;
				case BUTTEN_LIVETV:
					INPORT[0] = 0x02;
					INPORT[1] = 0x25;
					INPORT_NUM = 2;
					break;
				case BUTTEN_RECORDEDTV:
					INPORT[0] = 0x02;
					INPORT[1] = 0x48;
					INPORT_NUM = 2;
					break;
				case BUTTEN_MUSIC:
					INPORT[0] = 0x02;
					INPORT[1] = 0x47;
					INPORT_NUM = 2;
					break;
				case BUTTEN_PICTURES:
					INPORT[0] = 0x02;
					INPORT[1] = 0x49;
					INPORT_NUM = 2;
					break;
				case BUTTEN_VIDEOS:
					INPORT[0] = 0x02;
					INPORT[1] = 0x4A;
					INPORT_NUM = 2;
					break;
				case BUTTEN_TV:
					break;
				// DVD buttons
				case BUTTEN_DVDMENU:
					INPORT[0] = 0x02;
					INPORT[1] = 0x24;
					INPORT_NUM = 2;
					break;
			}
			Reset_IR();
		}
		else
		{
			Reset_IR();
		}
		IR_DataShift = 0;
	}

}

void Enable_Timer32B0(void)
{
	LPC_TMR32B0->TCR = 1;
}

void Disable_Timer32B0(void)
{
	LPC_TMR32B0->TCR = 0;
}

void Reset_Timer32B0(void)
{
	uint32_t regVal;

	regVal = LPC_TMR32B0->TCR;
	regVal |= 0x02;
	LPC_TMR32B0->TCR = regVal;
}

uint32_t GetValue_Timer32B0(void)
{
	return LPC_TMR32B0->TC;
}

