/*----------------------------------------------------------------------------
 * U S B  -  K e r n e l
 *----------------------------------------------------------------------------
 * Name:    usbdesc.c
 * Purpose: USB Descriptors
 * Version: V1.20
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2009 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------
 * History:
 *          V1.20 Changed string descriptor handling
 *                Changed HID Report Descriptor
 *          V1.00 Initial Version
 *----------------------------------------------------------------------------*/

#include "type.h"

#include "usb.h"
#include "usbcfg_LPC13xx.h"
#include "usbdesc.h"

#include "hid.h"

/*------------------------------------------------------------------------------
  HID Report Descriptor
 *------------------------------------------------------------------------------*/

/*   Bit    Input       Output
      0     KBD          LED0
      1     ---          LED1
      2     ---          LED2
      3     ---          LED3
      4     ---          LED4
      5     ---          LED5
      6     ---          LED6
      7     ---          LED7
*/

#define HID_INPUT_REPORT_BYTES       1              /* size of report in Bytes */
#define HID_OUTPUT_REPORT_BYTES      1              /* size of report in Bytes */
#define HID_FEATURE_REPORT_BYTES     1              /* size of report in Bytes */


//const U8 HID_ReportDescriptor[] = {
//  HID_UsagePageVendor( 0x00                     ),
//  HID_Usage          ( 0x01                     ),
//  HID_Collection     ( HID_Application          ),
//    HID_LogicalMin   ( 0                        ),  /* value range: 0 - 0xFF */
//    HID_LogicalMaxS  ( 0xFF                     ),
//    HID_ReportSize   ( 8                        ),  /* 8 bits */
//    HID_ReportCount  ( HID_INPUT_REPORT_BYTES   ),
//    HID_Usage        ( 0x01                     ),
//    HID_Input        ( HID_Data | HID_Variable | HID_Absolute ),
//    HID_ReportCount  ( HID_OUTPUT_REPORT_BYTES  ),
//    HID_Usage        ( 0x01                     ),
//    HID_Output       ( HID_Data | HID_Variable | HID_Absolute ),
//    HID_ReportCount  ( HID_FEATURE_REPORT_BYTES ),
//    HID_Usage        ( 0x01                     ),
//    HID_Feature      ( HID_Data | HID_Variable | HID_Absolute ),
//  HID_EndCollection,
//};
const U8 HID_ReportDescriptor3[] = {
  HID_UsagePageVendor(0x00),
  HID_Usage(0x01),
  HID_Collection(HID_Application),
    HID_UsageMin(0), //1
    HID_UsageMax(1), //3
    HID_LogicalMin(0),
    HID_LogicalMax(1),
    HID_ReportCount(1),//3
    HID_ReportSize(1),
    HID_Input(HID_Data | HID_Variable | HID_Absolute),
    HID_ReportCount(1),
    HID_ReportSize(7), //5
    HID_Input(HID_Constant),
    HID_UsageMin(0), 
    HID_UsageMax(255), 
//    HID_LogicalMin(0),
//    HID_LogicalMax(1),
    HID_ReportCount(8),
    HID_ReportSize(1),
    HID_Output(HID_Data | HID_Variable | HID_Absolute),	
  HID_EndCollection,
};
const U8 HID_ReportDescriptor2[] = {
  HID_UsagePageVendor( 0x00                     ),
  HID_Usage          ( 0x01                     ),
  HID_Collection     ( HID_Application          ),
  //0x85, 0x00, // Report Id (1)
    HID_LogicalMin   ( 0                        ),  /* value range: 0 - 0xFF */
    HID_LogicalMaxS  ( 0xFF                     ),
    HID_ReportSize   ( 8                        ),  /* 8 bits */
    HID_ReportCount  ( HID_INPUT_REPORT_BYTES   ),
    HID_Usage        ( 0x01                     ),
    HID_Input        ( HID_Data | HID_Variable | HID_Absolute ),
    HID_ReportCount  ( HID_OUTPUT_REPORT_BYTES  ),
    HID_Usage        ( 0x01                     ),
    HID_Output       ( HID_Data | HID_Variable | HID_Absolute ),
    HID_ReportCount  ( HID_FEATURE_REPORT_BYTES ),
/*    HID_Usage        ( 0x01                     ),
    HID_Feature      ( HID_Data | HID_Variable | HID_Absolute ), */
  HID_EndCollection,
};


const U8 HID_ReportDescriptor[] = {	 
// Consumer Controls 
0x05, 0x0c, // Usage Page (Consumer Controls), 
0x09, 0x01, // Usage (Consumer Control), 
0xA1, 0x01, // Collection (Application), 
0x85, 0x01, // Report Id (1) 
0x19, 0x00, // Usage Minimum (0), 
0x2a, 0x3c, 0x02, // Usage Maximum (23c) 
0x15, 0x00, // Logical Minimum (0), 
0x26, 0x3c, 0x02, // Logical Maximum (23c) 
0x95, 0x01, // Report Count (1), 
0x75, 0x10, // Report Size (16), 
0x81, 0x00, // Input (Data, Array), 
0xC0, // End Collection 
// MS Vendor controls 
0x06, 0xbc, 0xff, // Usage Page (Vendor 0xffbc), 
0x09, 0x88, // Usage (88), 
0xa1, 0x01, // Collection (Application), 
0x85, 0x02, // Report Id (2) 
0x19, 0x01, // Usage Minimum (0x01), 
0x29, 0xff, // Usage Maximum (0xff), 
0x15, 0x00, // Logical Minimum (0), 
0x25, 0x01, // Logical Maximum(1),
0x95, 0x01, // Report Count (1), 
0x75, 0x08, // Report Size (8), 
0x81, 0x00, // Input (Data, Array), 
0xc0, // End Collection 

// Standby button 
0x05, 0x01, // Usage Page (Generic Desktop), 
0x09, 0x80, // Usage (System Control), 
0xa1, 0x01, // Collection (Application), 
0x85, 0x03, // Report Id (3) 
0x19, 0x81, // Usage Minimum (0x81), 
0x29, 0x83, // Usage Maximum (0x83), 
0x25, 0x01, // Logical Maximum(1), 
0x75, 0x01, // Report Size (1), 
0x95, 0x03, // Report Count (3), 
0x81, 0x02, // Input 
0x75, 0x01, // Report Size (1), 
0x95, 0x05, // Report Count (5), 
0x81, 0x01, // Input (Constant), 
0xC0, // End Collection 

// Keyboard 
0x05, 0x01, // Usage Page (Generic Desktop), 
0x09, 0x06, // Usage (Keyboard), 
0xA1, 0x01, // Collection (Application), 
0x85, 0x04, // Report Id (4) 
0x05, 0x07, // usage page key codes 
0x19, 0xe0, // usage min left control 
0x29, 0xe8, // usage max keyboard right gui 
0x75, 0x01, // report size 1 
0x95, 0x08, // report count 8 
0x81, 0x02, // input (Variable) 
0x19, 0x00, // usage min 0 
0x29, 0x90, // usage max 91 
0x26, 0xff, 0x00, // logical max 0xff 
0x75, 0x08, // report size 8 
0x95, 0x01, // report count 1 
0x81, 0x00, // Input (Data, Array), 
0xC0 // End Collection
};


const U16 HID_ReportDescSize = sizeof(HID_ReportDescriptor);


/* USB Standard Device Descriptor */
const U8 USB_DeviceDescriptor[] = {
  USB_DEVICE_DESC_SIZE,              /* bLength */
  USB_DEVICE_DESCRIPTOR_TYPE,        /* bDescriptorType */
  WBVAL(0x0200), /* 2.00 */          /* bcdUSB */
  0x00,                              /* bDeviceClass */
  0x00,                              /* bDeviceSubClass */
  0x00,                              /* bDeviceProtocol */
  USB_MAX_PACKET0,                   /* bMaxPacketSize0 */
  WBVAL(0xC251),                     /* idVendor */
  WBVAL(0x2501),                     /* idProduct */
  WBVAL(0x0100), /* 1.00 */          /* bcdDevice */
  0x01,                              /* iManufacturer */
  0x02,                              /* iProduct */
  0x03,                              /* iSerialNumber */
  0x01                               /* bNumConfigurations: one possible configuration*/
};

/* USB Configuration Descriptor */
/*   All Descriptors (Configuration, Interface, Endpoint, Class, Vendor) */
const U8 USB_ConfigDescriptor[] = {
/* Configuration 1 */
  USB_CONFIGUARTION_DESC_SIZE,       /* bLength */
  USB_CONFIGURATION_DESCRIPTOR_TYPE, /* bDescriptorType */
  WBVAL(                             /* wTotalLength */
    USB_CONFIGUARTION_DESC_SIZE +
    USB_INTERFACE_DESC_SIZE     +
    HID_DESC_SIZE               +
    USB_ENDPOINT_DESC_SIZE
  ),
  0x01,                              /* bNumInterfaces */
  0x01,                              /* bConfigurationValue: 0x01 is used to select this configuration */
  0x00,                              /* iConfiguration: no string to describe this configuration */
  /*USB_CONFIG_BUS_POWERED |*/       /* bmAttributes */
USB_CONFIG_REMOTE_WAKEUP,
  USB_CONFIG_POWER_MA(100),          /* bMaxPower, device power consumption is 100 mA */

/* Interface 0, Alternate Setting 0, HID Class */
  USB_INTERFACE_DESC_SIZE,           /* bLength */
  USB_INTERFACE_DESCRIPTOR_TYPE,     /* bDescriptorType */
  0x00,                              /* bInterfaceNumber */
  0x00,                              /* bAlternateSetting */
  0x01,                              /* bNumEndpoints */
  USB_DEVICE_CLASS_HUMAN_INTERFACE,  /* bInterfaceClass */
  HID_SUBCLASS_NONE,                 /* bInterfaceSubClass */
  HID_PROTOCOL_NONE,                 /* bInterfaceProtocol */
  0x04,                              /* iInterface */
/* HID Class Descriptor */
/* HID_DESC_OFFSET = 0x0012 */
  HID_DESC_SIZE,                     /* bLength */
  HID_HID_DESCRIPTOR_TYPE,           /* bDescriptorType */
  WBVAL(0x0100), /* 1.00 */          /* bcdHID */
  0x00,                              /* bCountryCode */
  0x01,                              /* bNumDescriptors */
  HID_REPORT_DESCRIPTOR_TYPE,        /* bDescriptorType */
  WBVAL(HID_REPORT_DESC_SIZE),       /* wDescriptorLength */
/* Endpoint, HID Interrupt In */
  USB_ENDPOINT_DESC_SIZE,            /* bLength */
  USB_ENDPOINT_DESCRIPTOR_TYPE,      /* bDescriptorType */
  USB_ENDPOINT_IN(1),                /* bEndpointAddress */
  USB_ENDPOINT_TYPE_INTERRUPT,       /* bmAttributes */
  WBVAL(0x0004),                     /* wMaxPacketSize */
  0x14,          /*  */          /* bInterval */
/* Terminator */
  0                                  /* bLength */
};


/* USB String Descriptor (optional) */
const U8 USB_StringDescriptor[] = {
/* Index 0x00: LANGID Codes */
  0x04,                              /* bLength */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  WBVAL(0x0409), /* US English */    /* wLANGID */
/* Index 0x01: Manufacturer */
  (13*2 + 2),                        /* bLength (13 Char + Type + lenght) */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  'N',0,
  'X',0,
  'P',0,
  ' ',0,
  'S',0,
  'e',0,
  'm',0,
  'i',0,
  'c',0,
  'o',0,
  'n',0,
  ' ',0,
  ' ',0,
/* Index 0x02: Product */
  (19*2 + 2),                        /* bLength (16 Char + Type + lenght) */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  'L',0,
  'P',0,
  'C',0,
  '1',0,
  '3',0,
  '4',0,
  'x',0,
  ' ',0,
  'U',0,
  'S',0,
  'B',0,
  '-',0,
  'I',0,
  'R',0,
  ' ',0,
  'D',0,
  'e',0,
  'm',0,
  'o',0,
/* Index 0x03: Serial Number */
  (12*2 + 2),                        /* bLength (12 Char + Type + lenght) */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  '0',0,                             /* allowed characters are       */
  '0',0,                             /*   0x0030 - 0x0039 ('0'..'9') */
  '0',0,                             /*   0x0041 - 0x0046 ('A'..'F') */
  '1',0,                             /*   length >= 26               */
  'A',0,
  '0',0,
  '0',0,
  '0',0,
  '0',0,
  '0',0,
  '0',0,
  '0',0,
/* Index 0x04: Interface 0, Alternate Setting 0 */
  ( 3*2 + 2),                        /* bLength (3 Char + Type + lenght) */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  'H',0,
  'I',0,
  'D',0,
};
