/****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#include "LPC8xx.h"			/* LPC8xx Peripheral Registers */
#include "type.h"
#include "lpc8xx_gpio.h"
#include "sct.h"

#define TEST_DIGITAL_FILTER			0
#define TEST_PATTERN_MATCH			1

volatile uint32_t TimeTick = 0;


/* SysTick interrupt happens every 10 ms */
void SysTick_Handler(void)
{
  TimeTick++;
}

/*****************************************************************************
**   Main Function  main()
******************************************************************************/
int main (void)
{
	volatile uint32_t regVal,i;
	
  SystemCoreClockUpdate();

	SysTick_Config(SystemCoreClock/100);
	NVIC_SetPriority(SysTick_IRQn, 2);

	// P0.9 is used to rescue SWD port
	if(!((LPC_GPIO -> PIN[0]) & (1<< 9 ))) while(1);

	
  GPIOInit();
	LPC_SWM->SWM_8BIT_PINASSIGN6 = 0x08FFFFFF;                          // SCT OUTP_0 at P0.8
	SCT_Init();
	
	while(1)
	{
		TimeTick = 0;
		while(TimeTick < 300); // 300ms
		SCB->SCR |= 0x01 << 2;
		LPC_PMU->PCON = 0x2;
		__WFI();
	}
}

/*********************************************************************************
**                            End Of File
*********************************************************************************/
