#include "LPC8xx.h"			/* LPC8xx Peripheral Registers */
#include "mrt.h"
#include "lpc8xx_gpio.h"
#include "type.h"


static volatile uint32_t IRQCount = 0;
static volatile uint32_t IRStatus = 0;

void Initial_MRT_IR(void)
{
	LPC_SYSCON->SYSAHBCLKCTRL |= (0x1<<10);
	LPC_SYSCON->PRESETCTRL  &= ~(0x1UL << 7);
	LPC_SYSCON->PRESETCTRL |= (0x1UL << 7);

  NVIC_DisableIRQ(MRT_IRQn);
	
	LPC_MRT->Channel[0].INTVAL = IR_INTERVAL;
  LPC_MRT->Channel[0].INTVAL |= 0x1UL<<31;
	
	LPC_MRT->Channel[0].CTRL = MRT_REPEATED_MODE|MRT_INT_ENA;
	
	NVIC_SetPriority(MRT_IRQn, 1);
  /* Enable the MRT Interrupt */
  NVIC_EnableIRQ(MRT_IRQn);
	
	LPC_SYSCON->SYSAHBCLKCTRL &= ~(0x1<<10);
}

void MRT_IRQHandler(void)
{ 
	static int32_t flag = 0;
	if ( LPC_MRT->Channel[0].STAT & MRT_STAT_IRQ_FLAG )
	{
		LPC_MRT->Channel[0].STAT = MRT_STAT_IRQ_FLAG;			/* clear interrupt flag */
		IRQCount--;
		if(IRQCount == 0) LPC_SYSCON->SYSAHBCLKCTRL &= ~(0x1<<10);
	}
}

void Start_MRT(uint32_t irqcount)
{
	IRQCount = irqcount;
	LPC_SYSCON->SYSAHBCLKCTRL |= (0x1<<10);
}

void Send_Bit_1_Data(void)
{
	Start_MRT(64); // 2t *16/t * 2 (t: RC-6 444.44us)
	while(IRQCount)
	{
		// 1t: '1'
		if((IRQCount > 33) && ((IRQCount%2) == 0))
		{
			LPC_GPIO->SET[PORT0] = 1 << IR_BIT;
		}
		// 1t: '0'
		else
		{
			LPC_GPIO->CLR[PORT0] = 1 << IR_BIT;
		}
	}
}

void Send_Bit_0_Data(void)
{
	Start_MRT(64); // 2t *16/t * 2 (t: RC-6 444.44us)
	while(IRQCount)
	{
		// 1t: '1'
		if((IRQCount < 33) && ((IRQCount%2) == 0))
		{
			LPC_GPIO->SET[PORT0] = 1 << IR_BIT;
		}
		// 1t: '0'
		else
		{
			LPC_GPIO->CLR[PORT0] = 1 << IR_BIT;
		}
	}
}

void Send_2Bytes_Data(uint16_t data)
{
	uint32_t i;
	for(i = 16; i > 0; i--)
	if(data & (0x01 << (i - 1)))
	{
		Send_Bit_1_Data();
	}
	else
	{
		Send_Bit_0_Data();
	}
}

void Send_Leader(void)
{
	Start_MRT(256); // 8t *16/t * 2 (t: RC-6 444.44us)
	while(IRQCount)
	{
		// 6t: '1'
		if((IRQCount > 63) && ((IRQCount%2) == 0))
		{
			LPC_GPIO->SET[PORT0] = 1 << IR_BIT;
		}
		// 2t: '0'
		else
		{
			LPC_GPIO->CLR[PORT0] = 1 << IR_BIT;
		}
	}
}

void Send_SB(void)
{
	Send_Bit_1_Data();
}

void Send_ModeBit(void)
{
	Send_Bit_1_Data();
	Send_Bit_1_Data();
	Send_Bit_0_Data();
}

void Send_TR(void)
{
	Start_MRT(128); // 4t *16/t * 2 (t: RC-6 444.44us)
	while(IRQCount)
	{
		// 2t: '1'
		if((IRQCount < 65) && ((IRQCount%2) == 0))
		{
			LPC_GPIO->SET[PORT0] = 1 << IR_BIT;
		}
		// 2t: '0'
		else
		{
			LPC_GPIO->CLR[PORT0] = 1 << IR_BIT;
		}
	}
}

// mode: 6A
void Send_Header(void)
{
	Send_Leader();
	Send_SB();
	Send_ModeBit();
	Send_TR();
}

// LCC: 0x000F
void Send_LCC(void)
{
	Send_2Bytes_Data(0x800F);
}

void Send_SignalFree(void)
{
	Start_MRT(292); // 6t *16/t * 2 (t: RC-6 444.44us)
	LPC_GPIO->CLR[PORT0] = 1 << IR_BIT;
	while(IRQCount);
}

void Send_Data(uint16_t data)
{
	static uint8_t flag = 0;
	Send_Header();
	Send_LCC();
	if(flag) Send_2Bytes_Data(data);
	else Send_2Bytes_Data(data & 0x7FFF);
	flag != flag;
	Send_SignalFree();
}



