/****************************************************************************
 *   $Id:: mrt.h 3635 2010-06-02 00:31:46Z usb00423                     $
 *   Project: NXP LPC8xx software example
 *
 *   Description:
 *     This file contains definition and prototype for multi-rate timer 
 *     configuration.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#ifndef __MRT_H 
#define __MRT_H

/* Control register bit definition. */
#define MRT_INT_ENA					(0x1<<0)
#define MRT_REPEATED_MODE		(0x00<<1)
#define MRT_ONE_SHOT_INT		(0x01<<1)
#define MRT_ONE_SHOT_STALL	(0x02<<1)

/* Status register bit definition */
#define MRT_STAT_IRQ_FLAG		(0x1<<0)
#define MRT_STAT_RUN				(0x1<<1)


/* cclk=12mhz. carrier frequency is 36khz. duty cycle 1/2. so interval time is 13.889us.
16*2*interval time = 1t(RC-6)=444.444us
this value should be 166 for 12mhz. 143 is only for the test chip */
#define IR_INTERVAL 166
#define IR_BIT 8

#define IR_IDLE			0
#define IR_HEADER		1

void delayMs(uint32_t delayInMs);
void MRT_IRQHandler(void);
void Initial_MRT_IR(void);
void Start_MRT(uint32_t irqcount);
void Send_Bit_0_Data(void);
void Send_Bit_1_Data(void);
void Send_2Bytes_Data(uint16_t data);
void Send_Leader(void);
void Send_SB(void);
void Send_ModeBit(void);
void Send_TR(void);
void Send_Header(void);
void Send_LCC(void);
void Send_SignalFree(void);
void Send_Data(uint16_t data);

#endif /* end __MRT_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
