/* INSERT HEADER */

/* INSERT INCLUDES */

ENTRY(${start_symbol})

SECTIONS
{
    /* INSERT TEXT_SECTION */

    /* MAIN TEXT SECTION */    
    .flash_resident : ALIGN(${text_align})
    {
        FILL(0xff)
        __vectors_start__ = ABSOLUTE(.) ;
        KEEP(*(.isr_vector))
        /* INSERT SECTION_TABLE */

         KEEP(*(.after_vectors*))

        /* INSERT CRP */
    } >${CODE}
    
     /* INSERT MAIN_TEXT_SECTION */   
    .text : ALIGN(${text_align})    
    {
		*(.text*)
        /* INSERT RODATA */
		*(.rodata)     
        /* INSERT CPP_INFO */
    } > ${RAM} AT>${CODE}

    /* INSERT EXDATA */
    
    _etext = .;
        
    /* INSERT DATA_SECTION */
    	
	.data_RAM2 : ALIGN(4)
	{
		FILL(0xff)  
		KEEP(*(.data_RAM2*))	   
		. = ALIGN(4) ;
	} >  ${RAM2} AT>${CODE}
	
    /* MAIN DATA SECTION */
	.data : ALIGN(4)
	{
	   FILL(0xff)
	   . = ALIGN(4) ;
	   KEEP(*(.data*))	   
	   . = ALIGN(4) ;
	} >  ${RAM2} AT>${CODE}
	
    /* INSERT MTB_DEFAULT_SECTION */

    .uninit_RESERVED : ALIGN(${data_align})
    {
        KEEP(*(.bss.$RESERVED*))
        . = ALIGN(4) ;
        _end_uninit_RESERVED = .;
    } > ${RAM2}

	/* INSERT MAIN_DATA_SECTION */

    /* INSERT BSS_SECTION */

    /* MAIN BSS SECTION */
    .bss : ALIGN(${bss_align})
    {
        _bss = .;
        *(.bss*)
        *(COMMON)
        . = ALIGN(${bss_align}) ;
        _ebss = .;
        PROVIDE(end = .);
    } > ${RAM2}
        
    /* INSERT NOINIT_SECTION */
    
    /* DEFAULT NOINIT SECTION */
    .noinit (NOLOAD): ALIGN(${bss_align})
    {
        _noinit = .;
        *(.noinit*) 
         . = ALIGN(${bss_align}) ;
        _end_noinit = .;
    } > ${RAM2}
    
    PROVIDE(${heap_symbol} = DEFINED(__user_heap_base) ? __user_heap_base : .);
    PROVIDE(_vStackTop = DEFINED(__user_stack_top) ? __user_stack_top : __top_${DATA} - ${STACK_OFFSET});
}
