/*
 * @brief Wakeup example
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */
#include "board.h"


/** @defgroup PERIPH_WAKEUP_5410X Wakeup example
 * @ingroup EXAMPLES_PERIPH_5410X
 * @include "periph\wakeup\readme.txt"
 */

/**
 * @}
 */

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/
/* Pin muxing table, only items that need changing from their default pin
   state are in this table. Not every pin is mapped. */
STATIC const PINMUX_GRP_T pinmuxing_lowpower[] = {
	
	
	/* UART */
	{0, 0,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* UART0 RX */
	{0, 1,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* UART0 TX */

	{0, 2,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 3,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	
	{0, 4,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 5,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 6,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 7,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	
	{0, 8,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 9,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 10,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 11,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 12,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 13,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 14,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 15,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	//{0, 16,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	//{0, 17,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 18,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 19,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 20,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 21,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 22,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 23,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 24,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 25,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 26,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 27,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{0, 28,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	
	{1, 9,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{1, 10,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{1, 11,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{1, 12,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{1, 13,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{1, 14,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{1, 15,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{1, 16,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */
	{1, 17,  (IOCON_FUNC0 | IOCON_MODE_INACT | IOCON_DIGITAL_EN)}, /* NC */

		
 

};


/*************************/
/* test configuration definition*/
/******************************/
#define SLEEP_MODE														0
#define DEEP_SLEEP_MODE												1
#define POWER_DOWN_8KB_SRAM0									2
#define POWER_DOWN_64KB_SRAM0									3
#define POWER_DOWN_96KB_SRAM0_SRAM1						4
#define POWER_DOWN_104KB_SRAM0_SRAM1_SRAM2		5
#define DEEP_POWER_DOWN_RTC_ON								6    //power consumption measure only in this project
#define DEEP_POWER_DOWN_RTC_OFF								7    //power consumption measure only in this project

/* Below mode only works with the iram target*/
#define SRAM_WAKEUP_TIME_MODE									8

#define SELECTED_MEASUREMENT				SLEEP_MODE
#define CURRENT_MEASUREMENT					0



/* GPIO pin for PININT input */
#if defined (BOARD_NXP_LPCXPRESSO_54102)
#define GPIO_PININT_PIN     24	/* GPIO pin number mapped to PININT */
#define GPIO_PININT_PORT    0	/* GPIO port number mapped to PININT */
#define GPIO_PININT_INDEX   PININTSELECT0	/* PININT index used for GPIO mapping */
#define PININT_IRQ_HANDLER  PIN_INT0_IRQHandler	/* GPIO interrupt IRQ function name */
#define PININT_NVIC_NAME    PIN_INT0_IRQn	/* GPIO interrupt NVIC interrupt name */
#define GPIO_GOSLEEP_PORT		0
#define GPIO_GOSLEEP_PIN		31

#define WAKEUP_Time_PORT 	0
#define WAKEUP_Time_PIN 	2
#else
#error "Board not supported - setup GPIO for pin interrupt"
#endif



/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/
/**
 * @brief	Handle interrupt from GPIO pin or GPIO pin mapped to PININT
 * @return	Nothing
 */
void PININT_IRQ_HANDLER(void)
{
		
	LPC_GPIO->B[WAKEUP_Time_PORT][WAKEUP_Time_PIN] = 1;
	
	Chip_PININT_ClearIntStatus(LPC_PININT, PININTCH(GPIO_PININT_INDEX));
}

void SetupUnusedPins(void)
{

	Chip_GPIO_SetPinDIRInput(LPC_GPIO, 0, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 1);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 1, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 2);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 2, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 3);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 3, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 4);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 4, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 5);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 5, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 6);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 6, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 7);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 7, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 8);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 8, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 9);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 9, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 10);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 10, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 11);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 11, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 12);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 12, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 13);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 13, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 14);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 14, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 15);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 15, 0);
 // Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 16);  // swd pin
 // Chip_GPIO_SetPinState(LPC_GPIO, 0, 16, 0);   // swd pin
 //	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 17);  // swd pin
 //	Chip_GPIO_SetPinState(LPC_GPIO, 0, 17, 0);   // swd pin
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 18);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 18, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 19);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 19, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 20);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 20, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 21);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 21, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 22);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 22, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 23);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 23, 0);
	Chip_GPIO_SetPinDIRInput(LPC_GPIO, 0, 24);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 25);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 25, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 0, 27);
	Chip_GPIO_SetPinState(LPC_GPIO, 0, 27, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 9);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 9, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 10);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 10, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 11);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 11, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 12);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 12, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 13);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 13, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 14);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 14, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 15);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 15, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 16);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 16, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO, 1, 17);
	Chip_GPIO_SetPinState(LPC_GPIO, 1, 17, 0);
	
	
	
}
void ConfigureUnusedPins(void)
{
	Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_IOCON);
	Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_GPIO0);
	Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_GPIO1);
	Chip_IOCON_SetPinMuxing(LPC_IOCON, pinmuxing_lowpower, sizeof(pinmuxing_lowpower) / sizeof(PINMUX_GRP_T));
	SetupUnusedPins();
	
}

/**
 * @brief	Main routine for wakeup example
 * @return	Function should not exit
 */
int main(void)
{

	CHIP_SYSCON_MAINCLKSRC_T saved_clksrc;

	/* Generic Initialization */
	SystemCoreClockUpdate();
	
	Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_INPUTMUX);
	Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_IOCON);
	Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_GPIO0);
	Chip_SYSCON_PeriphReset(RESET_GPIO0);


	/* Wakeup from deep powerdown? Then turn on LED1 */
	if ((Chip_PMU_GetDPDWUSource() & PMU_DPDWU_RESET)!= 0) {
		Board_LED_Set(1, true);
		Chip_PMU_ClearDPDWUSource(Chip_PMU_GetDPDWUSource());
	}
		
	/* Switch main system clock to IRC and power down PLL */
	saved_clksrc = Chip_Clock_GetMainClockSource();
	if (saved_clksrc == SYSCON_MAINCLKSRC_PLLOUT) {
		Chip_Clock_SetMainClockSource(SYSCON_MAINCLKSRC_IRC);
		Chip_SYSCON_PowerDown(SYSCON_PDRUNCFG_PD_SYS_PLL);
	}

	/**** Setup PININT ****/
	/* Wakeup pin is setup as a GPIO input */
	Chip_IOCON_PinMuxSet(LPC_IOCON, GPIO_PININT_PORT, GPIO_PININT_PIN,
						 (IOCON_FUNC0 | IOCON_DIGITAL_EN | IOCON_GPIO_MODE));
	
	Chip_GPIO_SetPinDIRInput(LPC_GPIO, GPIO_PININT_PORT, GPIO_PININT_PIN);

	/* Wait for pin to not be pressed */
	while (Chip_GPIO_ReadPortBit(LPC_GPIO, GPIO_PININT_PORT, GPIO_PININT_PIN) == 0);

	/* Configure pin interrupt selection for the GPIO pin in Input Mux Block */
	Chip_PININT_Init(LPC_PININT);
	Chip_INMUX_PinIntSel(GPIO_PININT_INDEX, GPIO_PININT_PORT, GPIO_PININT_PIN);

	/* Configure channel interrupt as edge sensitive and falling edge interrupt */
	
	Chip_PININT_SetPinModeEdge(LPC_PININT, PININTCH(GPIO_PININT_INDEX));
	Chip_PININT_EnableIntLow(LPC_PININT, PININTCH(GPIO_PININT_INDEX));
  Chip_PININT_ClearIntStatus(LPC_PININT, PININTCH(GPIO_PININT_INDEX));
	
	NVIC_EnableIRQ(PININT_NVIC_NAME);
	Chip_SYSCON_EnableWakeup(SYSCON_STARTER_PINT0);
	

		/* Disable PLL, if previously enabled, prior to sleep */
		if (saved_clksrc == SYSCON_MAINCLKSRC_PLLOUT) {
			Chip_Clock_SetMainClockSource(SYSCON_MAINCLKSRC_IRC);
			Chip_SYSCON_PowerDown(SYSCON_PDRUNCFG_PD_SYS_PLL);
		}
		Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_INPUTMUX);
		Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_IOCON);
		Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_GPIO0);
		Chip_GPIO_SetPinDIROutput(LPC_GPIO, WAKEUP_Time_PORT, WAKEUP_Time_PIN);
		Chip_GPIO_SetPinState(LPC_GPIO, WAKEUP_Time_PORT, WAKEUP_Time_PIN, 0);
          
		Chip_POWER_SetVoltage(POWER_LOW_POWER_MODE, Chip_Clock_GetMainClockRate());
		Chip_GPIO_SetPinDIRInput(LPC_GPIO, GPIO_GOSLEEP_PORT, GPIO_GOSLEEP_PIN);
		while (Chip_GPIO_GetPinState(LPC_GPIO, GPIO_GOSLEEP_PORT, GPIO_GOSLEEP_PIN));
		ConfigureUnusedPins();
		if (CURRENT_MEASUREMENT)
		{
			Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_GPIO0);
			Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_PINT);
			Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_GPIO1);
			Chip_Clock_DisablePeriphClock(SYSCON_CLOCK_INPUTMUX);
		}
		if (SELECTED_MEASUREMENT == SLEEP_MODE)
		 Chip_POWER_EnterPowerMode(POWER_SLEEP,0);
			
		if (SELECTED_MEASUREMENT == DEEP_SLEEP_MODE)
		 Chip_POWER_EnterPowerMode(POWER_DEEP_SLEEP,0);
	
		
		if (SELECTED_MEASUREMENT == POWER_DOWN_8KB_SRAM0)
			Chip_POWER_EnterPowerMode(POWER_POWER_DOWN,0);
		
		
		if (SELECTED_MEASUREMENT == POWER_DOWN_64KB_SRAM0)
		Chip_POWER_EnterPowerMode(POWER_POWER_DOWN,
			(SYSCON_PDRUNCFG_PD_SRAM0B));
		
		if (SELECTED_MEASUREMENT == POWER_DOWN_96KB_SRAM0_SRAM1)
		Chip_POWER_EnterPowerMode(POWER_POWER_DOWN,
			(SYSCON_PDRUNCFG_PD_SRAM0B | SYSCON_PDRUNCFG_PD_SRAM1 ));

		if (SELECTED_MEASUREMENT == POWER_DOWN_104KB_SRAM0_SRAM1_SRAM2)
		Chip_POWER_EnterPowerMode(POWER_POWER_DOWN,
			(SYSCON_PDRUNCFG_PD_SRAM0B | SYSCON_PDRUNCFG_PD_SRAM1 | SYSCON_PDRUNCFG_PD_SRAM2 ));
			
		if (SELECTED_MEASUREMENT == DEEP_POWER_DOWN_RTC_OFF)
		Chip_POWER_EnterPowerMode(POWER_DEEP_POWER_DOWN, 0);
			
		if (SELECTED_MEASUREMENT == DEEP_POWER_DOWN_RTC_ON)
		Chip_POWER_EnterPowerMode(POWER_DEEP_POWER_DOWN, SYSCON_PDRUNCFG_PD_32K_OSC);	
		
		if (SELECTED_MEASUREMENT == DEEP_POWER_DOWN_RTC_ON)
		Chip_POWER_EnterPowerMode(POWER_DEEP_POWER_DOWN, SYSCON_PDRUNCFG_PD_32K_OSC);	
		
		if (SELECTED_MEASUREMENT == SRAM_WAKEUP_TIME_MODE)
				Chip_POWER_EnterPowerModeIramOnly(0);
		
			/* On wakeup, restore PLL power if needed */
		if (saved_clksrc == SYSCON_MAINCLKSRC_PLLOUT) {
			Chip_SYSCON_PowerUp(SYSCON_PDRUNCFG_PD_SYS_PLL);

			/* Wait for PLL lock */
			while (!Chip_Clock_IsSystemPLLLocked());

			Chip_POWER_SetVoltage(POWER_LOW_POWER_MODE, Chip_Clock_GetSystemPLLOutClockRate(false));

			/* Use PLL for system clock */
			Chip_Clock_SetMainClockSource(SYSCON_MAINCLKSRC_PLLOUT);
		}
	

	return 0;
}

