/*
 * @brief Random Number Generator example
 * This example show how to use the the random number generator.
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2013
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "chip.h"
#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/
#if (defined(BOARD_HITEX_EVA_1850) || defined(BOARD_HITEX_EVA_4350))
#define UARTNum 0

#elif (defined(BOARD_KEIL_MCB_1857) || defined(BOARD_KEIL_MCB_4357))
#define UARTNum 3

#elif (defined(BOARD_NGX_XPLORER_1830) || defined (BOARD_NGX_XPLORER_4330))
#define UARTNum 0

#elif defined(BOARD_NXP_LPCLINK2_4370)
#define UARTNum 2

#elif defined(BOARD_NXP_LPCXPRESSO_4337)
#define UARTNum 0

#else
#error No UART selected for undefined board
#endif

#if (UARTNum == 0)
#define LPC_UART LPC_USART0
#define UARTx_IRQn  USART0_IRQn
#define UARTx_IRQHandler UART0_IRQHandler
#define _GPDMA_CONN_UART_Tx GPDMA_CONN_UART0_Tx
#define _GPDMA_CONN_UART_Rx GPDMA_CONN_UART0_Rx
#elif (UARTNum == 1)
#define LPC_UART LPC_UART1
#define UARTx_IRQn  UART1_IRQn
#define UARTx_IRQHandler UART1_IRQHandler
#define _GPDMA_CONN_UART_Tx GPDMA_CONN_UART1_Tx
#define _GPDMA_CONN_UART_Rx GPDMA_CONN_UART1_Rx
#elif (UARTNum == 2)
#define LPC_UART LPC_USART2
#define UARTx_IRQn  USART2_IRQn
#define UARTx_IRQHandler UART2_IRQHandler
#define _GPDMA_CONN_UART_Tx GPDMA_CONN_UART2_Tx
#define _GPDMA_CONN_UART_Rx GPDMA_CONN_UART2_Rx
#elif (UARTNum == 3)
#define LPC_UART LPC_USART3
#define UARTx_IRQn  USART3_IRQn
#define UARTx_IRQHandler UART3_IRQHandler
#define _GPDMA_CONN_UART_Tx GPDMA_CONN_UART3_Tx
#define _GPDMA_CONN_UART_Rx GPDMA_CONN_UART3_Rx
#endif

volatile uint32_t rval;
uint32_t rng_num1,rng_num2,rng_num3,rng_num4;

/* Memory location of the generated random numbers */
uint32_t *RANDOM_NUM0 = (uint32_t *) 0x40045050;
uint32_t *RANDOM_NUM1 = (uint32_t *) 0x40045054;
uint32_t *RANDOM_NUM2 = (uint32_t *) 0x40045058;
uint32_t *RANDOM_NUM3 = (uint32_t *) 0x4004505C;


/* Transmit and receive buffers */
uint8_t menu1[] = "\n\t\t************ RANDOM NUMBER GENERATOR ************* \n\n\n\r";
uint8_t menu2[] = "**********************LOGGING DATA ****************** \n\n\r";
uint8_t menu3[] = "\n\n\r *************COMPLETED ****************** \n\r";
uint8_t binout[16][5]= {"0000","0001","0010","0011","0100","0101","0110","0111","1000","1001","1010","1011","1100","1101","1110","1111"};
const char ascii[] = "0123456789ABCDEF";



/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

void display(char random_buffer[])
{
	int i=0;
	for (i=0;random_buffer[i]!='\0';i++)
	{
	switch(random_buffer[i])
	{
		case '0' : Chip_UART_SendBlocking(LPC_UART, binout[0], sizeof(binout[0]));break;
		case '1' : Chip_UART_SendBlocking(LPC_UART, binout[1], sizeof(binout[1]));break;
		case '2' : Chip_UART_SendBlocking(LPC_UART, binout[2], sizeof(binout[2]));break;
		case '3' : Chip_UART_SendBlocking(LPC_UART, binout[3], sizeof(binout[3]));break;
		case '4' : Chip_UART_SendBlocking(LPC_UART, binout[4], sizeof(binout[4]));break; 
		case '5' : Chip_UART_SendBlocking(LPC_UART, binout[5], sizeof(binout[5]));break;
		case '6' : Chip_UART_SendBlocking(LPC_UART, binout[6], sizeof(binout[6]));break;
    case '7' : Chip_UART_SendBlocking(LPC_UART, binout[7], sizeof(binout[7]));break;
 		case '8' : Chip_UART_SendBlocking(LPC_UART, binout[8], sizeof(binout[8]));break;
		case '9' : Chip_UART_SendBlocking(LPC_UART, binout[9], sizeof(binout[9]));break;
		case 'A' : Chip_UART_SendBlocking(LPC_UART, binout[10], sizeof(binout[10]));break;
		case 'B' : Chip_UART_SendBlocking(LPC_UART, binout[11], sizeof(binout[11]));break;
		case 'C' : Chip_UART_SendBlocking(LPC_UART, binout[12], sizeof(binout[12]));break;
    case 'D' : Chip_UART_SendBlocking(LPC_UART, binout[13], sizeof(binout[13]));break;
		case 'E' : Chip_UART_SendBlocking(LPC_UART, binout[14], sizeof(binout[14]));break;
		case 'F' : Chip_UART_SendBlocking(LPC_UART, binout[15], sizeof(binout[15]));break;
			
	}
	}
}

/*****************************************************************************
 * Public functions
 ****************************************************************************/


int main(void)
{
	int ret = 0;
	unsigned int k=0;
	char random_num_buff0[80],random_num_buff1[80],random_num_buff2[80],random_num_buff3[80];                 
	uint32_t err_cnt = 0;
	uint32_t rnum[4];
	
	
	SystemCoreClockUpdate();
	Board_Init();
	Board_UART_Init(LPC_UART);

	Chip_SCU_PinMuxSet(9, 1, (SCU_MODE_PULLUP | SCU_MODE_FUNC0)); // P9_1 used for LED  
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 4,13);         // GPIO0 4[13] set as output 
	Chip_GPIO_SetPinState(LPC_GPIO_PORT, 4, 13, false);     // GPIO0 4[13] set to low state
	
#if !((defined(CHIP_LPC43XX) && defined(BOARD_KEIL_MCB_18574357) && UARTNum==3) || ((!(defined(CHIP_LPC43XX) && defined(BOARD_KEIL_MCB_18574357))) && UARTNum==0))
	Chip_UART_Init(LPC_UART);
	Chip_UART_SetBaud(LPC_UART, 9600);
	Chip_UART_ConfigData(LPC_UART, UART_LCR_WLEN8 | UART_LCR_SBS_1BIT); /* Default 8-N-1 */

	/* Enable UART Transmit */
	Chip_UART_TXEnable(LPC_UART);
#endif

	/* Reset FIFOs, Enable FIFOs and DMA mode in UART */
	Chip_UART_SetupFIFOS(LPC_UART, (UART_FCR_FIFO_EN | UART_FCR_RX_RS |
							UART_FCR_TX_RS | UART_FCR_DMAMODE_SEL | UART_FCR_TRG_LEV0));

	/* Enable UART End of Auto baudrate & Auto baudrate timeout interrupts */
	Chip_UART_IntEnable(LPC_UART, (UART_IER_ABEOINT | UART_IER_ABTOINT));

	/* preemption = 1, sub-priority = 1 */
	NVIC_SetPriority(UARTx_IRQn, 1);
	/* Enable Interrupt for UART0 channel */
	NVIC_EnableIRQ(UARTx_IRQn);

	Chip_UART_SendBlocking(LPC_UART, menu1, sizeof(menu1));
	Chip_UART_SendBlocking(LPC_UART, menu2, sizeof(menu2));

	/* Initiliaze OTP function */
	rval = Chip_OTP_Init();

	if(rval !=0)
	{
		err_cnt++;
	}
        
	/* Generate 800,000 128-bit random numbers */	
	while(k<800000)
	{
		k=k+1;
		
		/* Generate Random Number using HW Random Number Generator */
		rval = Chip_OTP_GenRand();
		
		if(rval !=0)
		{
			err_cnt++;
		}
	
	rnum[0] = *RANDOM_NUM0;
	rnum[1] = *RANDOM_NUM1;
	rnum[2] = *RANDOM_NUM2;
	rnum[3] = *RANDOM_NUM3;
		
		sprintf(random_num_buff0, "\n\r%c%c%c%c%c%c%c%c\n\r\n", ascii[((uint8_t)(rnum[0]>>24))>>4],ascii[((uint8_t)(rnum[0]>>24))& 0x0F],
					ascii[((uint8_t)(rnum[0]>>16))>>4], ascii[((uint8_t)(rnum[0]>>16))& 0x0F],
					ascii[((uint8_t)(rnum[0]>>8))>>4], ascii[((uint8_t)(rnum[0]>>8))& 0x0F],
					ascii[((uint8_t)rnum[0]>>4)], ascii[((uint8_t)rnum[0]& 0x0F)]);

	sprintf(random_num_buff1, "\n\r%c%c%c%c%c%c%c%c\t\n", ascii[((uint8_t)(rnum[1]>>24))>>4],ascii[((uint8_t)(rnum[1]>>24))& 0x0F],
					ascii[((uint8_t)(rnum[1]>>16))>>4], ascii[((uint8_t)(rnum[1]>>16))& 0x0F],
					ascii[((uint8_t)(rnum[1]>>8))>>4], ascii[((uint8_t)(rnum[1]>>8))& 0x0F],
					ascii[((uint8_t)rnum[1]>>4)], ascii[((uint8_t)rnum[1]& 0x0F)]);
	
	sprintf(random_num_buff2, "\n\r%c%c%c%c%c%c%c%c\t\n", ascii[((uint8_t)(rnum[2]>>24))>>4],ascii[((uint8_t)(rnum[2]>>24))& 0x0F],
					ascii[((uint8_t)(rnum[2]>>16))>>4], ascii[((uint8_t)(rnum[2]>>16))& 0x0F],
					ascii[((uint8_t)(rnum[2]>>8))>>4], ascii[((uint8_t)(rnum[2]>>8))& 0x0F],
					ascii[((uint8_t)rnum[2]>>4)], ascii[((uint8_t)rnum[2]& 0x0F)]);
					
	sprintf(random_num_buff3, "\n\r%c%c%c%c%c%c%c%c\t\n", ascii[((uint8_t)(rnum[3]>>24))>>4],ascii[((uint8_t)(rnum[3]>>24))& 0x0F],
					ascii[((uint8_t)(rnum[3]>>16))>>4], ascii[((uint8_t)(rnum[3]>>16))& 0x0F],
					ascii[((uint8_t)(rnum[3]>>8))>>4], ascii[((uint8_t)(rnum[3]>>8))& 0x0F],
					ascii[((uint8_t)rnum[3]>>4)], ascii[((uint8_t)rnum[3]& 0x0F)]);
	
        /* Display the random numbers on the terminal*/					
	display(random_num_buff3);
	display(random_num_buff2);
	display(random_num_buff1);
	display(random_num_buff0);		
	}
	
        /* Check for completion*/
	if(k==800000)
	{
		Chip_UART_SendBlocking(LPC_UART, menu3, sizeof(menu3));
	}
	
	Chip_GPIO_SetPinState(LPC_GPIO_PORT, 4, 13, true);     // GPIO0 4[13] set to high state
	
	return ret;
}
