/***************************************************************************/
/*  This module consists a number of exported declarations of the I2C      */
/*  driver package. Include this module in your source file if you want    */
/*  to make use of one of the interface functions of the package.          */
/***************************************************************************/
#include "LPC82x.h"

typedef struct
{
    uint8_t  address;                      // slave address to sent/receive message
    uint8_t  nrBytes;                      // number of bytes in message buffer
    uint8_t  *buf;                         // pointer to I2C message buffer
    uint32_t  next;                        // address of next I2C message in chain
} I2C_MSG;

#define I2C_OK                   0         // transfer ended No Errors
#define I2C_BUSY                 1         // transfer busy
#define I2C_ERR                  2         // err: general error
#define I2C_NO_DATA              3         // err: No data in block
#define I2C_NACK_ON_DATA         4         // err: No ack on data
#define I2C_NACK_ON_ADDRESS      5         // err: No ack on address
#define I2C_ARBITRATION_LOST     6         // err: Arbitration lost
#define I2C_TIME_OUT             7         // err: Time out occurred
#define I2C_SLAVE_ERROR          8         // err: slave mode error
#define I2C_INIT_ERROR           9         // err: Initialization (not done)

extern uint8_t I2C_Transfer(I2C_MSG *p);
extern void    I2CMST_Init(void);
