/*****************************************************************************
 *
 * MODULE:             JN-AN-1200-ZigBee-RF4CE-Application-Template
 *
 * COMPONENT:          app_buttons.c
 *
 * DESCRIPTION:        Button Initialisation and Read functionality.
 *
 * $HeadURL: https://www.collabnet.nxp.com/svn/lprf_apps/Application_Notes/JN-AN-1206-ZRC2v0-Application-Template/Tags/Release_0v2-Alpha/Common/Source/app_buttons.c $
 *
 * $Revision: 14103 $
 *
 * $LastChangedBy: nxp46755 $
 *
 * $LastChangedDate: 2014-09-17 17:45:54 +0530 (Wed, 17 Sep 2014) $
 *
 * $Id: app_buttons.c 14103 2014-09-17 12:15:54Z nxp46755 $
 *
 ****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN516x, JN514x,
 * JN513x].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 *
 ***************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
#include <jendefs.h>
#include "AppHardwareApi.h"
#include "app_buttons.h"
#include "printf.h"
#include "dbg.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

#ifdef DEBUG_APP
    #define TRACE_APP   TRUE
#else
    #define TRACE_APP   FALSE
#endif
/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Function Prototypes                                     ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/
uint8 u8WakeUpButton = ERR;

/****************************************************************************/
/***        Local Variables                                               ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/
/****************************************************************************
 *
 * NAME: bAppButtonsInitialise
 *
 * DESCRIPTION:
 * Initialises buttons.
 *
 * RETURNS:
 * bool_t   Returns TRUE if APP_BUTTONS_DIO8 was pressed.
 *
 ****************************************************************************/
PUBLIC bool_t bAppButtonsInitialise(void)
{
    /* Set DIO lines to inputs with buttons connected */
    vAHI_DioSetDirection(APP_BUTTONS_DIO_MASK, 0);

    /* Turn on pull-ups for DIO lines with buttons connected */
    vAHI_DioSetPullup(APP_BUTTONS_DIO_MASK, 0);

    /* Set the edge detection for falling edges */
    vAHI_DioWakeEdge(0, APP_BUTTONS_DIO_MASK);

    /* Enable interrupts to occur on selected edge */
    vAHI_DioWakeEnable(APP_BUTTONS_DIO_MASK, 0);

    /* Remembering the wake up button */
    u8WakeUpButton = u8AppButtonsRead();

    if (u32AppButtonsReadMask() == APP_BUTTONS_DIO8_MASK)
    {
        return TRUE;
    }
    return FALSE;
}

/****************************************************************************
 *
 * NAME: u32AppButtonsReadMask
 *
 * DESCRIPTION:
 * Reads the button DIO mask on EK001 board.
 *
 * RETURNS:
 * uint32   Returns button DIO Mask.
 *
 ****************************************************************************/
PUBLIC uint32 u32AppButtonsReadMask(void)
{
    uint32 u32Buttons;
    u32Buttons = u32AHI_DioReadInput() & APP_BUTTONS_DIO_MASK;
    return (u32Buttons ^ APP_BUTTONS_DIO_MASK);
}


/****************************************************************************
 *
 * NAME: u8AppButtonsRead
 *
 * DESCRIPTION:
 * Reads the button DIO number on EK001 board.
 *
 * RETURNS:
 * uint8    Returns button DIO number if appropriate button press detected.
 *          Otherwise returns ERR.
 *
 ****************************************************************************/
PUBLIC uint8 u8AppButtonsRead(void)
{
    uint32 u32Buttons;
    u32Buttons = u32AHI_DioReadInput() & APP_BUTTONS_DIO_MASK;
    //DBG_vPrintf(TRACE_APP," Buttons %x\n", u32Buttons);
    switch(u32Buttons ^ APP_BUTTONS_DIO_MASK)
    {
        case APP_BUTTONS_SW1_MASK:
            return APP_BUTTONS_SW1;
            break;
        case APP_BUTTONS_SW2_MASK:
            return APP_BUTTONS_SW2;
            break;
        case APP_BUTTONS_SW3_MASK:
            return APP_BUTTONS_SW3;
            break;
        case APP_BUTTONS_SW4_MASK:
            return APP_BUTTONS_SW4;
            break;
        case APP_BUTTONS_DIO8_MASK:
            return APP_BUTTONS_DIO8;
            break;
        default:
            return ERR;
            break;
    }
}

/****************************************************************************/
/***        Local Functions                                               ***/
/****************************************************************************/

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
