/**************************************************************************
 * Copyright (C) 2015 Eff'Innov Technologies
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Developped by Eff'Innov Technologies : contact@effinnov.com
 *
 **************************************************************************/

#include "framework_Timer.h"
#include "framework_Interface.h"

#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/time.h>

struct framework_Timer
{
   framework_TimerCallBack *callback;
   void* pContext;
   int nIsStopped;
};

static struct framework_Timer timers = {NULL, NULL, 0};

static void framework_TimerExpired(int signum)
{
	if(signum != SIGVTALRM)
	{
		return;
	}

	if(timers.nIsStopped == 1)
	{
		timers.nIsStopped = 0;
		return;
	}

    if (timers.callback)
    {
    	timers.callback(timers.pContext);
	}
}

static void framework_TimerDummyCb(void *pContext) {}

void framework_TimerCreate(void** timer)
{
	if(timers.callback != NULL) {
	   *timer = NULL;
	   return;
	}

	timers.callback = framework_TimerDummyCb;
	*timer = &timers;
}

void framework_TimerDelete(void* timer)
{
	if(timers.callback == NULL)
		return;

	timers.callback = NULL;
	timers.pContext = NULL;
}

void framework_TimerStart(void* timer,uint32_t delay, framework_TimerCallBack *cb,void *usercontext)
{
    static struct sigaction sa;
	struct itimerval its;

	if((cb == NULL) || (timers.callback == NULL))
		return;

	timers.callback = cb;
	timers.pContext = usercontext;
	timers.nIsStopped = 0;

	its.it_interval.tv_sec  = 0;
	its.it_interval.tv_usec = 0;
	its.it_value.tv_sec     = delay / 1000;
	its.it_value.tv_usec    = 1000 * (delay % 1000);

	memset (&sa, 0, sizeof (sa));
	sa.sa_handler = framework_TimerExpired;
	sigaction (SIGVTALRM, &sa, NULL);

	setitimer(ITIMER_VIRTUAL, &its, NULL);
}


void framework_TimerStop(void* timer)
{
	struct itimerval its = {{0, 0}, {0, 0}};

	if((timers.callback == NULL) || (timers.nIsStopped != 0))
		return;

	timers.nIsStopped = 1;

	setitimer(ITIMER_VIRTUAL, &its, NULL);

	//while(timers.nIsStopped != 0);

}

