#include "memtools_register_info.h"

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ADC
#endif

// Bitfields in register ADC_HC0.
static const field_t hw_adc_hc0[] =
{
    {
        "ADCH",
        "This 5-bit field selects one of the input channels.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AIEN",
        "An interrupt is generated whenever ADC_HS[COCO0]=1 (conversion ADC_HC0"
        " completed), provided the corresponding interrupt is enabled.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_HC1.
static const field_t hw_adc_hc1[] =
{
    {
        "ADCH",
        "This 5-bit field selects one of the input channels.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AIEN",
        "An interrupt is generated whenever ADC_HS[COCO0]=1(conversion ADC_HC0 "
        "completed), provided the corresponding interrupt is enabled.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_HS.
static const field_t hw_adc_hs[] =
{
    {
        "COCO0",
        "The COCOn flag is a read-only bit that is set each time a conversion i"
        "s completed when the compare function is disabled (ADC_GC[ACFE]=0) and"
        " the hardware average function is disabled (ADC_GC[AVGE]=0).",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COCO1",
        "See description for COCO0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_R0.
static const field_t hw_adc_r0[] =
{
    {
        "CDATA",
        "",
        0, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_R1.
static const field_t hw_adc_r1[] =
{
    {
        "CDATA",
        "Data (result of an ADC conversion)",
        0, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_CFG.
static const field_t hw_adc_cfg[] =
{
    {
        "ADICLK",
        "Selects the input clock source to generate the internal clock ADCK.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MODE",
        "Used to set the ADC resolution mode.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADLSMP",
        "Selects between different sample times based on the ADC_CFG[ADSTS] fie"
        "ld.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADIV",
        "Selects the divide ratio used by the ADC to generate the internal cloc"
        "k ADCK.",
        5, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADLPC",
        "Puts the ADC hard block into low power mode and reduces the comparator"
        " enable period by controlling its timing in the SAR controller block t"
        "owards the anlong hard block.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADSTS",
        "Defines the sample time duration.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADHSC",
        "This bit configures the ADC for high speed operation.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFSEL",
        "Selects the voltage reference source used for conversions (see the chi"
        "p-specific SARADC information for details).",
        11, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADTRG",
        "Selects the type of trigger used for initiating a conversion.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGS",
        "Determines how many ADC conversions will be averaged to create the ADC"
        " average result.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OVWREN",
        "Controls the overwriting of the next converted Data onto the existing "
        "(previous) unread data into the Data result register.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_GC.
static const field_t hw_adc_gc[] =
{
    {
        "ADACKEN",
        "Enables the ADC's asynchronous clock source and the clock source outpu"
        "t regardless of the conversion and input clock select (ADC_CFG[ADICLK]"
        ") settings of the ADC.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMAEN",
        "Enables the DMA logic.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACREN",
        "Configures the compare function to check the conversion result of the "
        "input being monitored is either between or outside the range formed by"
        " the compare values in register (ADC_CV) determined by the value of AC"
        "FGT.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACFGT",
        "Configures the compare function to check the conversion result relativ"
        "e to the compare value register (ADC_CV) based upon the value of ACREN"
        " (bit 2 in ADC_GC register).",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACFE",
        "Enables the compare function.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AVGE",
        "Enables the hardware average function of the ADC.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADCO",
        "Enables continuous conversions.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAL",
        "CAL begins the calibration sequence when set.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_GS.
static const field_t hw_adc_gs[] =
{
    {
        "ADACT",
        "Indicates that a conversion or hardware averaging is in progress.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CALF",
        "Displays the result of the calibration sequence.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AWKST",
        "Holds the status of asynchronous interrupt status that occured during "
        "stop mode.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_CV.
static const field_t hw_adc_cv[] =
{
    {
        "CV1",
        "Contains a compare value used to compare with the conversion result wh"
        "en the compare function ais enabled (ADC_GC[ACFE]=1).",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CV2",
        "Contains a compare value used to compare with the conversion result wh"
        "en the compare function and compare range function are enabled (ADC_GC"
        "[ACFE]=1, ADC_GC[ACREN]=1).",
        16, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_OFS.
static const field_t hw_adc_ofs[] =
{
    {
        "OFS",
        "User configurable offset value.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIGN",
        "",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ADC_CAL.
static const field_t hw_adc_cal[] =
{
    {
        "CAL_CODE",
        "This value is automatically loaded and updated at the end of calibrati"
        "on.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ADC module.
static const reg_t hw_adc[] =
{
    {
        "HC0",
        "ADC_HC0 can be used for both software and hardware trigger mode.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_hc0
    },
    {
        "HC1",
        "ADC_HC1 are for use only in hardware trigger mode.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_hc1
    },
    {
        "HS",
        "Bit 0 is used for both software and hardware trigger modes of operatio"
        "n.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_adc_hs
    },
    {
        "R0",
        "Contains the result of an ADC conversion of the channel selected by th"
        "e respective hardware trigger and channel control register (ADC_HC0:AD"
        "C_HCn).",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_adc_r0
    },
    {
        "R1",
        "Contains the result of an ADC conversion of the channel selected by th"
        "e respective Hardware Trigger and channel control register (ADC_HC0:AD"
        "C_HCn).",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_adc_r1
    },
    {
        "CFG",
        "Selects the mode of operation, clock source, clock divide, configure f"
        "or low power, long sample time, high speed configuration and selects t"
        "he sample time duration.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_adc_cfg
    },
    {
        "GC",
        "Controls the calibration, continuous convert, hardware averaging funct"
        "ions, conversion active, hardware/software trigger select, compare fun"
        "ction and voltage reference select of the ADC module.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_adc_gc
    },
    {
        "GS",
        "Controls the calibration, continuous convert, hardware averaging funct"
        "ions, conversion active, hardware/software trigger select, compare fun"
        "ction and voltage reference select of the ADC module.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_adc_gs
    },
    {
        "CV",
        "Contains compare values used to compare with the conversion result whe"
        "n the compare function is enabled (ADC_GC[ACFE]=1).",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_cv
    },
    {
        "OFS",
        "Contains the user-defined offset error correction value.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_adc_ofs
    },
    {
        "CAL",
        "Contains calibration information that is generated by the calibration "
        "function.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_adc_cal
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark APBH
#endif

// Bitfields in register APBH_CTRL0.
static const field_t hw_apbh_ctrl0[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL0_SET.
static const field_t hw_apbh_ctrl0_set[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL0_CLR.
static const field_t hw_apbh_ctrl0_clr[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL0_TOG.
static const field_t hw_apbh_ctrl0_tog[] =
{
    {
        "CLKGATE_CHANNEL",
        "These bits must be set to zero for normal operation of each channel.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Reserved, always set to zero.",
        16, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "APB_BURST_EN",
        "Set this bit to one to enable apb master do a continous transfers when"
        " a device request a burst dma.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_BURST8_EN",
        "Set this bit to one (default) to enable AHB 8-beat burst.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to zero to enable normal APBH DMA operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1.
static const field_t hw_apbh_ctrl1[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1_SET.
static const field_t hw_apbh_ctrl1_set[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1_CLR.
static const field_t hw_apbh_ctrl1_clr[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL1_TOG.
static const field_t hw_apbh_ctrl1_tog[] =
{
    {
        "CH0_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ",
        "Interrupt request status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_CMDCMPLT_IRQ_EN",
        "Setting this bit enables the generation of an interrupt request for AP"
        "BH DMA channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2.
static const field_t hw_apbh_ctrl2[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2_SET.
static const field_t hw_apbh_ctrl2_set[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2_CLR.
static const field_t hw_apbh_ctrl2_clr[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CTRL2_TOG.
static const field_t hw_apbh_ctrl2_tog[] =
{
    {
        "CH0_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 1.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 2.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 3.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 4.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7_ERROR_IRQ",
        "Error interrupt status bit for APBX DMA Channel 7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 8.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 9.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH10_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 10.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH11_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 11.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH12_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 12.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH13_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 13.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH14_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 14.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH15_ERROR_IRQ",
        "Error interrupt status bit for APBH DMA Channel 15.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH0_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 0.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH1_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 1.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH2_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 2.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH3_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 3.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH4_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 4.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH5_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 5.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH6_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 6.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH7_ERROR_STATUS",
        "Error status bit for APBX DMA Channel 7.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH8_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 8.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH9_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 9.",
        25, // LSB
        25, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH10_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 10.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH11_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 11.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH12_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 12.",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH13_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 13.",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH14_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 14.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CH15_ERROR_STATUS",
        "Error status bit for APBH DMA Channel 15.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL.
static const field_t hw_apbh_channel_ctrl[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL_SET.
static const field_t hw_apbh_channel_ctrl_set[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL_CLR.
static const field_t hw_apbh_channel_ctrl_clr[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CHANNEL_CTRL_TOG.
static const field_t hw_apbh_channel_ctrl_tog[] =
{
    {
        "FREEZE_CHANNEL",
        "Setting a bit in this field will freeze the DMA channel associated wit"
        "h it.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET_CHANNEL",
        "Setting a bit in this field causes the DMA controller to take the corr"
        "esponding channel through its reset state.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_DEVSEL.
static const field_t hw_apbh_devsel[] =
{
    {
        "CH0",
        "Reserved.",
        0, // LSB
        1, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH1",
        "Reserved.",
        2, // LSB
        3, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH2",
        "Reserved.",
        4, // LSB
        5, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH3",
        "Reserved.",
        6, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH4",
        "Reserved.",
        8, // LSB
        9, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH5",
        "Reserved.",
        10, // LSB
        11, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH6",
        "Reserved.",
        12, // LSB
        13, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH7",
        "Reserved.",
        14, // LSB
        15, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH8",
        "Reserved.",
        16, // LSB
        17, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH9",
        "Reserved.",
        18, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH10",
        "Reserved.",
        20, // LSB
        21, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH11",
        "Reserved.",
        22, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH12",
        "Reserved.",
        24, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH13",
        "Reserved.",
        26, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH14",
        "Reserved.",
        28, // LSB
        29, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH15",
        "Reserved.",
        30, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_DMA_BURST_SIZE.
static const field_t hw_apbh_dma_burst_size[] =
{
    {
        "CH0",
        "DMA burst size for GPMI channel 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH1",
        "DMA burst size for GPMI channel 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH2",
        "DMA burst size for GPMI channel 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH3",
        "DMA burst size for GPMI channel 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH4",
        "DMA burst size for GPMI channel 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH5",
        "DMA burst size for GPMI channel 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH6",
        "DMA burst size for GPMI channel 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH7",
        "DMA burst size for GPMI channel 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH8",
        "DMA burst size for SSP.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CH9",
        "Reserved.",
        18, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH10",
        "Reserved.",
        20, // LSB
        21, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH11",
        "Reserved.",
        22, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH12",
        "Reserved.",
        24, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH13",
        "Reserved.",
        26, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH14",
        "Reserved.",
        28, // LSB
        29, // MSB
        false, // Readable
        false // Writable
    },
    {
        "CH15",
        "Reserved.",
        30, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_DEBUG.
static const field_t hw_apbh_debug[] =
{
    {
        "GPMI_ONE_FIFO",
        "Set to 0ne and the 8 GPMI channels will share the DMA FIFO, and when s"
        "et to zero, the 8 GPMI channels will use its own DMA FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_CURCMDAR.
static const field_t hw_apbh_ch0_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_NXTCMDAR.
static const field_t hw_apbh_ch0_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_CMD.
static const field_t hw_apbh_ch0_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_BAR.
static const field_t hw_apbh_ch0_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_SEMA.
static const field_t hw_apbh_ch0_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_DEBUG1.
static const field_t hw_apbh_ch0_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH0_DEBUG2.
static const field_t hw_apbh_ch0_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_CURCMDAR.
static const field_t hw_apbh_ch1_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_NXTCMDAR.
static const field_t hw_apbh_ch1_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_CMD.
static const field_t hw_apbh_ch1_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_BAR.
static const field_t hw_apbh_ch1_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_SEMA.
static const field_t hw_apbh_ch1_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_DEBUG1.
static const field_t hw_apbh_ch1_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH1_DEBUG2.
static const field_t hw_apbh_ch1_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_CURCMDAR.
static const field_t hw_apbh_ch2_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_NXTCMDAR.
static const field_t hw_apbh_ch2_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_CMD.
static const field_t hw_apbh_ch2_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_BAR.
static const field_t hw_apbh_ch2_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_SEMA.
static const field_t hw_apbh_ch2_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_DEBUG1.
static const field_t hw_apbh_ch2_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH2_DEBUG2.
static const field_t hw_apbh_ch2_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_CURCMDAR.
static const field_t hw_apbh_ch3_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_NXTCMDAR.
static const field_t hw_apbh_ch3_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_CMD.
static const field_t hw_apbh_ch3_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_BAR.
static const field_t hw_apbh_ch3_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_SEMA.
static const field_t hw_apbh_ch3_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_DEBUG1.
static const field_t hw_apbh_ch3_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH3_DEBUG2.
static const field_t hw_apbh_ch3_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_CURCMDAR.
static const field_t hw_apbh_ch4_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_NXTCMDAR.
static const field_t hw_apbh_ch4_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_CMD.
static const field_t hw_apbh_ch4_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_BAR.
static const field_t hw_apbh_ch4_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_SEMA.
static const field_t hw_apbh_ch4_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_DEBUG1.
static const field_t hw_apbh_ch4_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH4_DEBUG2.
static const field_t hw_apbh_ch4_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_CURCMDAR.
static const field_t hw_apbh_ch5_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_NXTCMDAR.
static const field_t hw_apbh_ch5_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_CMD.
static const field_t hw_apbh_ch5_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_BAR.
static const field_t hw_apbh_ch5_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_SEMA.
static const field_t hw_apbh_ch5_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_DEBUG1.
static const field_t hw_apbh_ch5_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH5_DEBUG2.
static const field_t hw_apbh_ch5_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_CURCMDAR.
static const field_t hw_apbh_ch6_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_NXTCMDAR.
static const field_t hw_apbh_ch6_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_CMD.
static const field_t hw_apbh_ch6_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_BAR.
static const field_t hw_apbh_ch6_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_SEMA.
static const field_t hw_apbh_ch6_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_DEBUG1.
static const field_t hw_apbh_ch6_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH6_DEBUG2.
static const field_t hw_apbh_ch6_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_CURCMDAR.
static const field_t hw_apbh_ch7_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_NXTCMDAR.
static const field_t hw_apbh_ch7_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_CMD.
static const field_t hw_apbh_ch7_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_BAR.
static const field_t hw_apbh_ch7_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_SEMA.
static const field_t hw_apbh_ch7_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_DEBUG1.
static const field_t hw_apbh_ch7_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH7_DEBUG2.
static const field_t hw_apbh_ch7_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_CURCMDAR.
static const field_t hw_apbh_ch8_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_NXTCMDAR.
static const field_t hw_apbh_ch8_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_CMD.
static const field_t hw_apbh_ch8_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_BAR.
static const field_t hw_apbh_ch8_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_SEMA.
static const field_t hw_apbh_ch8_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_DEBUG1.
static const field_t hw_apbh_ch8_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH8_DEBUG2.
static const field_t hw_apbh_ch8_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_CURCMDAR.
static const field_t hw_apbh_ch9_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_NXTCMDAR.
static const field_t hw_apbh_ch9_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_CMD.
static const field_t hw_apbh_ch9_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_BAR.
static const field_t hw_apbh_ch9_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_SEMA.
static const field_t hw_apbh_ch9_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_DEBUG1.
static const field_t hw_apbh_ch9_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH9_DEBUG2.
static const field_t hw_apbh_ch9_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_CURCMDAR.
static const field_t hw_apbh_ch10_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_NXTCMDAR.
static const field_t hw_apbh_ch10_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_CMD.
static const field_t hw_apbh_ch10_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_BAR.
static const field_t hw_apbh_ch10_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_SEMA.
static const field_t hw_apbh_ch10_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_DEBUG1.
static const field_t hw_apbh_ch10_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH10_DEBUG2.
static const field_t hw_apbh_ch10_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_CURCMDAR.
static const field_t hw_apbh_ch11_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_NXTCMDAR.
static const field_t hw_apbh_ch11_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_CMD.
static const field_t hw_apbh_ch11_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_BAR.
static const field_t hw_apbh_ch11_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_SEMA.
static const field_t hw_apbh_ch11_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_DEBUG1.
static const field_t hw_apbh_ch11_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH11_DEBUG2.
static const field_t hw_apbh_ch11_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_CURCMDAR.
static const field_t hw_apbh_ch12_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_NXTCMDAR.
static const field_t hw_apbh_ch12_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_CMD.
static const field_t hw_apbh_ch12_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_BAR.
static const field_t hw_apbh_ch12_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_SEMA.
static const field_t hw_apbh_ch12_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_DEBUG1.
static const field_t hw_apbh_ch12_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH12_DEBUG2.
static const field_t hw_apbh_ch12_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_CURCMDAR.
static const field_t hw_apbh_ch13_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_NXTCMDAR.
static const field_t hw_apbh_ch13_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_CMD.
static const field_t hw_apbh_ch13_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_BAR.
static const field_t hw_apbh_ch13_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_SEMA.
static const field_t hw_apbh_ch13_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_DEBUG1.
static const field_t hw_apbh_ch13_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH13_DEBUG2.
static const field_t hw_apbh_ch13_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_CURCMDAR.
static const field_t hw_apbh_ch14_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_NXTCMDAR.
static const field_t hw_apbh_ch14_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_CMD.
static const field_t hw_apbh_ch14_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_BAR.
static const field_t hw_apbh_ch14_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_SEMA.
static const field_t hw_apbh_ch14_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_DEBUG1.
static const field_t hw_apbh_ch14_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH14_DEBUG2.
static const field_t hw_apbh_ch14_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_CURCMDAR.
static const field_t hw_apbh_ch15_curcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to command structure currently being processed for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_NXTCMDAR.
static const field_t hw_apbh_ch15_nxtcmdar[] =
{
    {
        "CMD_ADDR",
        "Pointer to next command structure for channel n.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_CMD.
static const field_t hw_apbh_ch15_cmd[] =
{
    {
        "COMMAND",
        "This bitfield indicates the type of current command:",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CHAIN",
        "A value of one indicates that another command is chained onto the end "
        "of the current command structure.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IRQONCMPLT",
        "A value of one indicates that the channel will cause the interrupt sta"
        "tus bit to be set upon completion of the current command, i.e.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDLOCK",
        "A value of one indicates that the NAND DMA channel will remain \"locke"
        "d\" in the arbiter at the expense of other NAND DMA channels.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NANDWAIT4READY",
        "A value of one indicates that the NAND DMA channel will will wait unti"
        "l the NAND device reports \"ready\" before executing the command.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SEMAPHORE",
        "A value of one indicates that the channel will decrement its semaphore"
        " at the completion of the current command structure.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT4ENDCMD",
        "A value of one indicates that the channel will wait for the end of com"
        "mand signal to be sent from the APBH device to the DMA before starting"
        " the next DMA command.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALTONTERMINATE",
        "A value of one indicates that the channel will immeditately terminate "
        "the current descriptor and halt the DMA channel if a terminate signal "
        "is set.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CMDWORDS",
        "This field indicates the number of command words to send to the GPMI0,"
        " starting with the base PIO address of the GPMI0 control register and "
        "incrementing from there.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "XFER_COUNT",
        "This field indicates the number of bytes to transfer to or from the ap"
        "propriate PIO register in the GPMI0 device.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_BAR.
static const field_t hw_apbh_ch15_bar[] =
{
    {
        "ADDRESS",
        "Address of system memory buffer to be read or written over the AHB bus"
        ".",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_SEMA.
static const field_t hw_apbh_ch15_sema[] =
{
    {
        "INCREMENT_SEMA",
        "The value written to this field is added to the semaphore count in an "
        "atomic way such that simultaneous software adds and DMA hardware subst"
        "racts happening on the same clock are protected.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PHORE",
        "This read-only field shows the current (instantaneous) value of the se"
        "maphore counter.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_DEBUG1.
static const field_t hw_apbh_ch15_debug1[] =
{
    {
        "STATEMACHINE",
        "PIO Display of the DMA Channel n state machine state.",
        0, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        5, // LSB
        19, // MSB
        false, // Readable
        false // Writable
    },
    {
        "WR_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Write FIFO Fu"
        "ll signal.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WR_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Write FIFO Em"
        "pty signal.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_FULL",
        "This bit reflects the current state of the DMA Channel's Read FIFO Ful"
        "l signal.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RD_FIFO_EMPTY",
        "This bit reflects the current state of the DMA Channel's Read FIFO Emp"
        "ty signal.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "NEXTCMDADDRVALID",
        "This bit reflects the internal bit which indicates whether the channel"
        "'s next command address is valid.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LOCK",
        "This bit is reserved for this Channel and always reads 0.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "READY",
        "This bit is reserved for this DMA Channel and always reads 0.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SENSE",
        "This bit is reserved for this DMA Channel and always reads 0.",
        27, // LSB
        27, // MSB
        false, // Readable
        false // Writable
    },
    {
        "END",
        "This bit reflects the current state of the DMA End Command Signal sent"
        " from the APB Device",
        28, // LSB
        28, // MSB
        true, // Readable
        false // Writable
    },
    {
        "KICK",
        "This bit reflects the current state of the DMA Kick Signal sent to the"
        " APB Device",
        29, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BURST",
        "This bit reflects the current state of the DMA Burst Signal from the A"
        "PB device",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REQ",
        "This bit reflects the current state of the DMA Request Signal from the"
        " APB device",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_CH15_DEBUG2.
static const field_t hw_apbh_ch15_debug2[] =
{
    {
        "AHB_BYTES",
        "This value reflects the current number of AHB bytes remaining to be tr"
        "ansfered in the current transfer.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_BYTES",
        "This value reflects the current number of APB bytes remaining to be tr"
        "ansfered in the current transfer.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register APBH_VERSION.
static const field_t hw_apbh_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a APBH module.
static const reg_t hw_apbh[] =
{
    {
        "CTRL0",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0
    },
    {
        "CTRL0_SET",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0_set
    },
    {
        "CTRL0_CLR",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0_clr
    },
    {
        "CTRL0_TOG",
        "The APBH CTRL 0 provides overall control of the AHB to APBH bridge and"
        " DMA.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_apbh_ctrl0_tog
    },
    {
        "CTRL1",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1
    },
    {
        "CTRL1_SET",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1_set
    },
    {
        "CTRL1_CLR",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1_clr
    },
    {
        "CTRL1_TOG",
        "The APBH CTRL one provides overall control of the interrupts generated"
        " by the AHB to APBH DMA.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl1_tog
    },
    {
        "CTRL2",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2
    },
    {
        "CTRL2_SET",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2_set
    },
    {
        "CTRL2_CLR",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2_clr
    },
    {
        "CTRL2_TOG",
        "The APBH CTRL 2 provides channel error interrupts generated by the AHB"
        " to APBH DMA.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        32, // Number of bitfields
        hw_apbh_ctrl2_tog
    },
    {
        "CHANNEL_CTRL",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl
    },
    {
        "CHANNEL_CTRL_SET",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl_set
    },
    {
        "CHANNEL_CTRL_CLR",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl_clr
    },
    {
        "CHANNEL_CTRL_TOG",
        "The APBH CHANNEL CTRL provides reset/freeze control of each DMA channe"
        "l.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_channel_ctrl_tog
    },
    {
        "DEVSEL",
        "This register allows reassignment of the APBH device connected to the "
        "DMA Channels.",
        4, // Width in bytes
        0x00000040, // Base address offset
        false, // Readable
        false, // Writable
        16, // Number of bitfields
        hw_apbh_devsel
    },
    {
        "DMA_BURST_SIZE",
        "This register programs the apbh burst size of the APBH DMA devices whe"
        "n a DMA burst request is issued.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_apbh_dma_burst_size
    },
    {
        "DEBUG",
        "This register is for debug purpose.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_debug
    },
    {
        "CH0_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch0_curcmdar
    },
    {
        "CH0_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch0_nxtcmdar
    },
    {
        "CH0_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch0_cmd
    },
    {
        "CH0_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch0_bar
    },
    {
        "CH0_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch0_sema
    },
    {
        "CH0_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch0_debug1
    },
    {
        "CH0_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch0_debug2
    },
    {
        "CH1_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch1_curcmdar
    },
    {
        "CH1_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch1_nxtcmdar
    },
    {
        "CH1_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000190, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch1_cmd
    },
    {
        "CH1_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch1_bar
    },
    {
        "CH1_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000001b0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch1_sema
    },
    {
        "CH1_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch1_debug1
    },
    {
        "CH1_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000001d0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch1_debug2
    },
    {
        "CH2_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000001e0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch2_curcmdar
    },
    {
        "CH2_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000001f0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch2_nxtcmdar
    },
    {
        "CH2_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch2_cmd
    },
    {
        "CH2_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000210, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch2_bar
    },
    {
        "CH2_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000220, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch2_sema
    },
    {
        "CH2_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000230, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch2_debug1
    },
    {
        "CH2_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000240, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch2_debug2
    },
    {
        "CH3_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000250, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch3_curcmdar
    },
    {
        "CH3_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000260, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch3_nxtcmdar
    },
    {
        "CH3_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000270, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch3_cmd
    },
    {
        "CH3_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000280, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch3_bar
    },
    {
        "CH3_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000290, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch3_sema
    },
    {
        "CH3_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000002a0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch3_debug1
    },
    {
        "CH3_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000002b0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch3_debug2
    },
    {
        "CH4_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000002c0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch4_curcmdar
    },
    {
        "CH4_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000002d0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch4_nxtcmdar
    },
    {
        "CH4_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000002e0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch4_cmd
    },
    {
        "CH4_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000002f0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch4_bar
    },
    {
        "CH4_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000300, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch4_sema
    },
    {
        "CH4_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000310, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch4_debug1
    },
    {
        "CH4_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000320, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch4_debug2
    },
    {
        "CH5_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000330, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch5_curcmdar
    },
    {
        "CH5_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000340, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch5_nxtcmdar
    },
    {
        "CH5_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000350, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch5_cmd
    },
    {
        "CH5_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000360, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch5_bar
    },
    {
        "CH5_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000370, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch5_sema
    },
    {
        "CH5_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000380, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch5_debug1
    },
    {
        "CH5_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000390, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch5_debug2
    },
    {
        "CH6_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000003a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch6_curcmdar
    },
    {
        "CH6_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000003b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch6_nxtcmdar
    },
    {
        "CH6_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000003c0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch6_cmd
    },
    {
        "CH6_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000003d0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch6_bar
    },
    {
        "CH6_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000003e0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch6_sema
    },
    {
        "CH6_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000003f0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch6_debug1
    },
    {
        "CH6_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch6_debug2
    },
    {
        "CH7_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000410, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch7_curcmdar
    },
    {
        "CH7_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000420, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch7_nxtcmdar
    },
    {
        "CH7_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000430, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch7_cmd
    },
    {
        "CH7_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000440, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch7_bar
    },
    {
        "CH7_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000450, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch7_sema
    },
    {
        "CH7_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000460, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch7_debug1
    },
    {
        "CH7_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000470, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch7_debug2
    },
    {
        "CH8_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000480, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch8_curcmdar
    },
    {
        "CH8_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000490, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch8_nxtcmdar
    },
    {
        "CH8_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000004a0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch8_cmd
    },
    {
        "CH8_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000004b0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch8_bar
    },
    {
        "CH8_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000004c0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch8_sema
    },
    {
        "CH8_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000004d0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch8_debug1
    },
    {
        "CH8_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000004e0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch8_debug2
    },
    {
        "CH9_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000004f0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch9_curcmdar
    },
    {
        "CH9_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000500, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch9_nxtcmdar
    },
    {
        "CH9_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000510, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch9_cmd
    },
    {
        "CH9_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000520, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch9_bar
    },
    {
        "CH9_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000530, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch9_sema
    },
    {
        "CH9_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000540, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch9_debug1
    },
    {
        "CH9_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000550, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch9_debug2
    },
    {
        "CH10_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000560, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch10_curcmdar
    },
    {
        "CH10_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000570, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch10_nxtcmdar
    },
    {
        "CH10_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000580, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch10_cmd
    },
    {
        "CH10_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000590, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch10_bar
    },
    {
        "CH10_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000005a0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch10_sema
    },
    {
        "CH10_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000005b0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch10_debug1
    },
    {
        "CH10_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000005c0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch10_debug2
    },
    {
        "CH11_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000005d0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch11_curcmdar
    },
    {
        "CH11_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000005e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch11_nxtcmdar
    },
    {
        "CH11_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000005f0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch11_cmd
    },
    {
        "CH11_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000600, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch11_bar
    },
    {
        "CH11_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000610, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch11_sema
    },
    {
        "CH11_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000620, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch11_debug1
    },
    {
        "CH11_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000630, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch11_debug2
    },
    {
        "CH12_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000640, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch12_curcmdar
    },
    {
        "CH12_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000650, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch12_nxtcmdar
    },
    {
        "CH12_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000660, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch12_cmd
    },
    {
        "CH12_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000670, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch12_bar
    },
    {
        "CH12_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000680, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch12_sema
    },
    {
        "CH12_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000690, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch12_debug1
    },
    {
        "CH12_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000006a0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch12_debug2
    },
    {
        "CH13_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x000006b0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch13_curcmdar
    },
    {
        "CH13_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000006c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch13_nxtcmdar
    },
    {
        "CH13_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000006d0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch13_cmd
    },
    {
        "CH13_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000006e0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch13_bar
    },
    {
        "CH13_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000006f0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch13_sema
    },
    {
        "CH13_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000700, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch13_debug1
    },
    {
        "CH13_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000710, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch13_debug2
    },
    {
        "CH14_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000720, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch14_curcmdar
    },
    {
        "CH14_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x00000730, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch14_nxtcmdar
    },
    {
        "CH14_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x00000740, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch14_cmd
    },
    {
        "CH14_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x00000750, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch14_bar
    },
    {
        "CH14_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x00000760, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch14_sema
    },
    {
        "CH14_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x00000770, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch14_debug1
    },
    {
        "CH14_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x00000780, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch14_debug2
    },
    {
        "CH15_CURCMDAR",
        "The APBH DMA channel n current command address register points to the "
        "multiword command that is currently being executed.",
        4, // Width in bytes
        0x00000790, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch15_curcmdar
    },
    {
        "CH15_NXTCMDAR",
        "The APBH DMA Channel n Next Command Address register contains the addr"
        "ess of the next multiword command to be executed.",
        4, // Width in bytes
        0x000007a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_apbh_ch15_nxtcmdar
    },
    {
        "CH15_CMD",
        "The APBH DMA Channel n command register specifies the DMA transaction "
        "to perform for the current command chain item.",
        4, // Width in bytes
        0x000007b0, // Base address offset
        true, // Readable
        false, // Writable
        10, // Number of bitfields
        hw_apbh_ch15_cmd
    },
    {
        "CH15_BAR",
        "The APBH DMA Channel n buffer address register contains a pointer to t"
        "he data buffer for the transfer.",
        4, // Width in bytes
        0x000007c0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_apbh_ch15_bar
    },
    {
        "CH15_SEMA",
        "The APBH DMA Channel n semaphore register is used to synchronize the A"
        "RM platform instruction stream and the DMA chain processing state.",
        4, // Width in bytes
        0x000007d0, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_apbh_ch15_sema
    },
    {
        "CH15_DEBUG1",
        "This register gives debug visibility into the APBH DMA Channel n state"
        " machine and controls.",
        4, // Width in bytes
        0x000007e0, // Base address offset
        true, // Readable
        false, // Writable
        14, // Number of bitfields
        hw_apbh_ch15_debug1
    },
    {
        "CH15_DEBUG2",
        "This register gives debug visibility for the APB and AHB byte counts f"
        "or DMA Channel n.",
        4, // Width in bytes
        0x000007f0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_apbh_ch15_debug2
    },
    {
        "VERSION",
        "This register always returns a known read value for debug purposes it "
        "indicates the version of the block.",
        4, // Width in bytes
        0x00000800, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_apbh_version
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ASRC
#endif

// Bitfields in register ASRC_ASRCTR.
static const field_t hw_asrc_asrctr[] =
{
    {
        "ASRCEN",
        "ASRC Enable Enable the operation of ASRC.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREA",
        "ASRC Enable A Enable the operation of the conversion A of ASRC.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREB",
        "ASRC Enable B Enable the operation of the conversion B of ASRC.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ASREC",
        "ASRC Enable C Enable the operation of the conversion C of ASRC.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRST",
        "Software Reset This bit is self-clear bit.",
        4, // LSB
        4, // MSB
        false, // Readable
        false // Writable
    },
    {
        "IDRA",
        "Use Ideal Ratio for Pair A When USRA=0, this bit has no usage.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRA",
        "Use Ratio for Pair A Use ratio as the input to ASRC.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDRB",
        "Use Ideal Ratio for Pair B When USRB=0, this bit has no usage.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRB",
        "Use Ratio for Pair B Use ratio as the input to ASRC.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDRC",
        "Use Ideal Ratio for Pair C When USRC=0, this bit has no usage.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USRC",
        "Use Ratio for Pair C Use ratio as the input to ASRC.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSA",
        "ASRC Pair A Automatic Selection For Processing Options When this bit i"
        "s 1, pair A will automatic update its pre-processing and post-processi"
        "ng options (ASRCFG: PREMODA, ASRCFG:POSTMODA see ASRC Misc Control Reg"
        "ister 1 for Pair CASRC Filter Configuration Status Register ) based on"
        " the frequencies it detected.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSB",
        "ASRC Pair B Automatic Selection For Processing Options When this bit i"
        "s 1, pair B will automatic update its pre-processing and post-processi"
        "ng options (ASRCFG: PREMODB, ASRCFG:POSTMODB see ASRC Misc Control Reg"
        "ister 1 for Pair CASRC Filter Configuration Status Register ) based on"
        " the frequencies it detected.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATSC",
        "ASRC Pair C Automatic Selection For Processing Options When this bit i"
        "s 1, pair C will automatic update its pre-processing and post-processi"
        "ng options (ASRCFG: PREMODC, ASRCFG:POSTMODC see ASRC Misc Control Reg"
        "ister 1 for Pair CASRC Filter Configuration Status Register ) based on"
        " the frequencies it detected.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIER.
static const field_t hw_asrc_asrier[] =
{
    {
        "ADIEA",
        "Data Input A Interrupt Enable Enables the data input A Interrupt.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADIEB",
        "Data Input B Interrupt Enable Enables the data input B interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADIEC",
        "Data Input C Interrupt Enable Enables the data input C interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEA",
        "Data Output A Interrupt Enable Enables the data output A interrupt.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEB",
        "Data Output B Interrupt Enable Enables the data output B interrupt.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADOEC",
        "Data Output C Interrupt Enable Enables the data output C interrupt.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOLIE",
        "Overload Interrupt Enable Enables the overload interrupt.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AFPWE",
        "FP in Wait State Interrupt Enable Enables the FP in wait state interru"
        "pt.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCNCR.
static const field_t hw_asrc_asrcncr[] =
{
    {
        "ANCA",
        "Number of A Channels",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ANCB",
        "Number of B Channels",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ANCC",
        "Number of C ChannelsANCC+ANCB+ANCA<=10.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCFG.
static const field_t hw_asrc_asrcfg[] =
{
    {
        "PREMODA",
        "Pre-Processing Configuration for Conversion Pair A These bits will be "
        "read/write by user if ASRCTR:ATSA=0, and can also be automatically upd"
        "ated by the ASRC internal logic if ASRCTR:ATSA=1 (see ASRC Misc Contro"
        "l Register 1 for Pair CASRC Control Register ).",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODA",
        "Post-Processing Configuration for Conversion Pair A These bits will be"
        " read/write by user if ASRCTR:ATSA=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSA=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair CASRC Control Register ).",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREMODB",
        "Pre-Processing Configuration for Conversion Pair B These bits will be "
        "read/write by user if ASRCTR:ATSB=0, and can also be automatically upd"
        "ated by the ASRC internal logic if ASRCTR:ATSB=1 (see ASRC Misc Contro"
        "l Register 1 for Pair CASRC Control Register ).",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODB",
        "Post-Processing Configuration for Conversion Pair B These bits will be"
        " read/write by user if ASRCTR:ATSB=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSB=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair CASRC Control Register ).",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREMODC",
        "Pre-Processing Configuration for Conversion Pair C These bits will be "
        "read/write by user if ASRCTR:ATSC=0, and can also be automatically upd"
        "ated by the ASRC internal logic if ASRCTR:ATSC=1 (see ASRC Misc Contro"
        "l Register 1 for Pair CASRC Control Register ).",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTMODC",
        "Post-Processing Configuration for Conversion Pair C These bits will be"
        " read/write by user if ASRCTR:ATSC=0, and can also be automatically up"
        "dated by the ASRC internal logic if ASRCTR:ATSC=1 (see ASRC Misc Contr"
        "ol Register 1 for Pair CASRC Control Register ).",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRA",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir A",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRB",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir B",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NDPRC",
        "Not Use Default Parameters for RAM-stored Parameters For Conversion Pa"
        "ir C",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INIRQA",
        "Initialization for Conversion Pair A is served When this bit is 1, it "
        "means the initialization for conversion pair A is served.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INIRQB",
        "Initialization for Conversion Pair B is served When this bit is 1, it "
        "means the initialization for conversion pair B is served.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INIRQC",
        "Initialization for Conversion Pair C is served When this bit is 1, it "
        "means the initialization for conversion pair C is served.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCSR.
static const field_t hw_asrc_asrcsr[] =
{
    {
        "AICSA",
        "Input Clock Source A",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICSB",
        "Input Clock Source B",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICSC",
        "Input Clock Source C",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSA",
        "Output Clock Source A",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSB",
        "Output Clock Source B",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCSC",
        "Output Clock Source C",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCDR1.
static const field_t hw_asrc_asrcdr1[] =
{
    {
        "AICPA",
        "Input Clock Prescaler A Specify the prescaling factor of the input pre"
        "scaler A.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDA",
        "Input Clock Divider A Specify the divide ratio of the input clock divi"
        "der A.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICPB",
        "Input Clock Prescaler B Specify the prescaling factor of the input pre"
        "scaler B.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDB",
        "Input Clock Divider B Specify the divide ratio of the input clock divi"
        "der B.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPA",
        "Output Clock Prescaler A Specify the prescaling factor of the output p"
        "rescaler A.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDA",
        "Output Clock Divider A Specify the divide ratio of the output clock di"
        "vider A.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPB",
        "Output Clock Prescaler B Specify the prescaling factor of the output p"
        "rescaler B.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDB",
        "Output Clock Divider B Specify the divide ratio of the output clock di"
        "vider B.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCDR2.
static const field_t hw_asrc_asrcdr2[] =
{
    {
        "AICPC",
        "Input Clock Prescaler C Specify the prescaling factor of the input pre"
        "scaler C.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AICDC",
        "Input Clock Divider C Specify the divide ratio of the input clock divi"
        "der C.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCPC",
        "Output Clock Prescaler C Specify the prescaling factor of the output p"
        "rescaler C.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AOCDC",
        "Output Clock Divider C Specify the divide ratio of the output clock di"
        "vider C.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRSTR.
static const field_t hw_asrc_asrstr[] =
{
    {
        "AIDEA",
        "Number of data in Input Data Buffer A is less than threshold When set,"
        " this bit indicates that number of data still available in ASRDIRA is "
        "less than threshold and the processor can write data to ASRDIRA.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDEB",
        "Number of data in Input Data Buffer B is less than threshold When set,"
        " this bit indicates that number of data still available in ASRDIRB is "
        "less than threshold and the processor can write data to ASRDIRB.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDEC",
        "Number of data in Input Data Buffer C is less than threshold When set,"
        " this bit indicates that number of data still available in ASRDIRC is "
        "less than threshold and the processor can write data to ASRDIRC.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFA",
        "Number of data in Output Data Buffer A is greater than threshold When "
        "set, this bit indicates that number of data already existing in ASRDOR"
        "A is greater than threshold and the processor can read data from ASRDO"
        "RA.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFB",
        "Number of data in Output Data Buffer B is greater than threshold When "
        "set, this bit indicates that number of data already existing in ASRDOR"
        "B is greater than threshold and the processor can read data from ASRDO"
        "RB.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODFC",
        "Number of data in Output Data Buffer C is greater than threshold When "
        "set, this bit indicates that number of data already existing in ASRDOR"
        "C is greater than threshold and the processor can read data from ASRDO"
        "RC.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOLE",
        "Overload Error Flag When set, this bit indicates that the task rate is"
        " too high for the ASRC to handle.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FPWT",
        "FP is in wait states This bit is for debug only.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUA",
        "Input Data Buffer A has underflowed When set, this bit indicates that "
        "input data buffer A has underflowed.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUB",
        "Input Data Buffer B has underflowed When set, this bit indicates that "
        "input data buffer B has underflowed.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIDUC",
        "Input Data Buffer C has underflowed When set, this bit indicates that "
        "input data buffer C has underflowed.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOA",
        "Output Data Buffer A has overflowed When set, this bit indicates that "
        "output data buffer A has overflowed.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOB",
        "Output Data Buffer B has overflowed When set, this bit indicates that "
        "output data buffer B has overflowed.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AODOC",
        "Output Data Buffer C has overflowed When set, this bit indicates that "
        "output data buffer C has overflowed.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLA",
        "Pair A Input Task Overload When set, this bit indicates that pair A in"
        "put task is oveloaded.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLB",
        "Pair B Input Task Overload When set, this bit indicates that pair B in"
        "put task is oveloaded.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AIOLC",
        "Pair C Input Task Overload When set, this bit indicates that pair C in"
        "put task is oveloaded.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLA",
        "Pair A Output Task Overload When set, this bit indicates that pair A o"
        "utput task is oveloaded.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLB",
        "Pair B Output Task Overload When set, this bit indicates that pair B o"
        "utput task is oveloaded.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AOOLC",
        "Pair C Output Task Overload When set, this bit indicates that pair C o"
        "utput task is oveloaded.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ATQOL",
        "Task Queue FIFO overload When set, this bit indicates that task queue "
        "FIFO logic is oveloaded.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DSLCNT",
        "DSL Counter Input to FIFO ready When set, this bit indicates that new "
        "DSL counter information is stored in the internal ASRC FIFO.",
        21, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn1.
static const field_t hw_asrc_asrpmn1[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn2.
static const field_t hw_asrc_asrpmn2[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn3.
static const field_t hw_asrc_asrpmn3[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn4.
static const field_t hw_asrc_asrpmn4[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRPMn5.
static const field_t hw_asrc_asrpmn5[] =
{
    {
        "PARAMETER_VALUE",
        "See recommended values table.",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRTFR1.
static const field_t hw_asrc_asrtfr1[] =
{
    {
        "TF_BASE",
        "Base address for task queue FIFO.",
        6, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF_FILL",
        "Current number of entries in task queue FIFO.",
        13, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRCCR.
static const field_t hw_asrc_asrccr[] =
{
    {
        "ACIA",
        "The channel counter for Pair A's input FIFO These bits stand for the c"
        "urrent channel being accessed through shared peripheral bus for Pair A"
        "'s input FIFO's usage.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACIB",
        "The channel counter for Pair B's input FIFO These bits stand for the c"
        "urrent channel being accessed through shared peripheral bus for Pair B"
        "'s input FIFO's usage.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACIC",
        "The channel counter for Pair C's input FIFO These bits stand for the c"
        "urrent channel being accessed through shared peripheral bus for Pair C"
        "'s input FIFO's usage.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOA",
        "The channel counter for Pair A's output FIFO These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "A's output FIFO's usage.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOB",
        "The channel counter for Pair B's output FIFO These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "B's output FIFO's usage.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACOC",
        "The channel counter for Pair C's output FIFO These bits stand for the "
        "current channel being accessed through shared peripheral bus for Pair "
        "C's output FIFO's usage.",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIA.
static const field_t hw_asrc_asrdia[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOA.
static const field_t hw_asrc_asrdoa[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIB.
static const field_t hw_asrc_asrdib[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOB.
static const field_t hw_asrc_asrdob[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDIC.
static const field_t hw_asrc_asrdic[] =
{
    {
        "DATA",
        "Audio data input",
        0, // LSB
        23, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRDOC.
static const field_t hw_asrc_asrdoc[] =
{
    {
        "DATA",
        "Audio data output",
        0, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHA.
static const field_t hw_asrc_asridrha[] =
{
    {
        "IDRATIOA",
        "IDRATIOA[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLA.
static const field_t hw_asrc_asridrla[] =
{
    {
        "IDRATIOA",
        "IDRATIOA[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHB.
static const field_t hw_asrc_asridrhb[] =
{
    {
        "IDRATIOB",
        "IDRATIOB[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLB.
static const field_t hw_asrc_asridrlb[] =
{
    {
        "IDRATIOB",
        "IDRATIOB[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRHC.
static const field_t hw_asrc_asridrhc[] =
{
    {
        "IDRATIOC",
        "IDRATIOC[31:24].",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRIDRLC.
static const field_t hw_asrc_asridrlc[] =
{
    {
        "IDRATIOC",
        "IDRATIOC[23:0].",
        0, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASR76K.
static const field_t hw_asrc_asr76k[] =
{
    {
        "ASR76K",
        "Value for the period of the 76kHz sampling clock.",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASR56K.
static const field_t hw_asrc_asr56k[] =
{
    {
        "ASR56K",
        "Value for the period of the 56kHz sampling clock",
        0, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRA.
static const field_t hw_asrc_asrmcra[] =
{
    {
        "INFIFO_THRESHOLDA",
        "The threshold for Pair A's input FIFO per channel These bits stand for"
        " the threshold for Pair A's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFA",
        "Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOA=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFA",
        "Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIA=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDA",
        "The threshold for Pair A's output FIFO per channel These bits stand fo"
        "r the threshold for Pair A's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYA",
        "Bypass Polyphase Filtering for Pair A This bit will determine whether "
        "the polyphase filtering part of Pair A conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLA",
        "Stall Pair A conversion in case of Buffer Near Empty/Full Condition Th"
        "is bit will determine whether the near empty/full FIFO condition will "
        "stall the rate conversion for pair A.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHA",
        "Use external thresholds for FIFO control of Pair A This bit will deter"
        "mine whether the FIFO thresholds externally defined in this register i"
        "s used to control ASRC internal FIFO logic for pair A.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFA",
        "Initialize buf of Pair A when pair A is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTA.
static const field_t hw_asrc_asrfsta[] =
{
    {
        "INFIFO_FILLA",
        "The fillings for Pair A's input FIFO per channel These bits stand for "
        "the fillings for Pair A's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEA",
        "Input FIFO is near Empty for Pair A This bit is to indicate whether th"
        "e input FIFO of Pair A is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLA",
        "The fillings for Pair A's output FIFO per channel These bits stand for"
        " the fillings for Pair A's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFA",
        "Output FIFO is near Full for Pair A This bit is to indicate whether th"
        "e output FIFO of Pair A is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRB.
static const field_t hw_asrc_asrmcrb[] =
{
    {
        "INFIFO_THRESHOLDB",
        "The threshold for Pair B's input FIFO per channel These bits stand for"
        " the threshold for Pair B's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFB",
        "Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOB=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFB",
        "Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIB=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDB",
        "The threshold for Pair B's output FIFO per channel These bits stand fo"
        "r the threshold for Pair B's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYB",
        "Bypass Polyphase Filtering for Pair B This bit will determine whether "
        "the polyphase filtering part of Pair B conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLB",
        "Stall Pair B conversion in case of Buffer Near Empty/Full Condition Th"
        "is bit will determine whether the near empty/full FIFO condition will "
        "stall the rate conversion for pair B.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHB",
        "Use external thresholds for FIFO control of Pair B This bit will deter"
        "mine whether the FIFO thresholds externally defined in this register i"
        "s used to control ASRC internal FIFO logic for pair B.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFB",
        "Initialize buf of Pair B when pair B is enabled This bit is used to co"
        "ntrol whether the buffer is to be zeroized when pair B is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTB.
static const field_t hw_asrc_asrfstb[] =
{
    {
        "INFIFO_FILLB",
        "The fillings for Pair B's input FIFO per channel These bits stand for "
        "the fillings for Pair B's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEB",
        "Input FIFO is near Empty for Pair B This bit is to indicate whether th"
        "e input FIFO of Pair B is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLB",
        "The fillings for Pair B's output FIFO per channel These bits stand for"
        " the fillings for Pair B's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFB",
        "Output FIFO is near Full for Pair B This bit is to indicate whether th"
        "e output FIFO of Pair B is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCRC.
static const field_t hw_asrc_asrmcrc[] =
{
    {
        "INFIFO_THRESHOLDC",
        "The threshold for Pair C's input FIFO per channel These bits stand for"
        " the threshold for Pair C's input FIFO per channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNOFC",
        "Re-sync Output FIFO Channel Counter If bit set, force ASRCCR:ACOC=0.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSYNIFC",
        "Re-sync Input FIFO Channel Counter If bit set, force ASRCCR:ACIC=0.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OUTFIFO_THRESHOLDC",
        "The threshold for Pair C's output FIFO per channel These bits stand fo"
        "r the threshold for Pair C's output FIFO per channel.",
        12, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASSPOLYC",
        "Bypass Polyphase Filtering for Pair C This bit will determine whether "
        "the polyphase filtering part of Pair C conversion will be bypassed.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUFSTALLC",
        "Stall Pair C conversion in case of Buffer Near Empty/Full Condition Th"
        "is bit will determine whether the near empty/full FIFO condition will "
        "stall the rate conversion for pair C.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXTTHRSHC",
        "Use external thresholds for FIFO control of Pair C This bit will deter"
        "mine whether the FIFO thresholds externally defined in this register i"
        "s used to control ASRC internal FIFO logic for pair C.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZEROBUFC",
        "Initialize buf of Pair C when pair C is enabled This bit is used to co"
        "ntrol whether the buffer is to be zeroized when pair C is enabled.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRFSTC.
static const field_t hw_asrc_asrfstc[] =
{
    {
        "INFIFO_FILLC",
        "The fillings for Pair C's input FIFO per channel These bits stand for "
        "the fillings for Pair C's input FIFO per channel.",
        0, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAEC",
        "Input FIFO is near Empty for Pair C This bit is to indicate whether th"
        "e input FIFO of Pair C is near empty.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OUTFIFO_FILLC",
        "The fillings for Pair C's output FIFO per channel These bits stand for"
        " the fillings for Pair C's output FIFO per channel.",
        12, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OAFC",
        "Output FIFO is near Full for Pair C This bit is to indicate whether th"
        "e output FIFO of Pair C is near full.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1A.
static const field_t hw_asrc_asrmcr1a[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO This bit will determine the bit wi"
        "dth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO This bit will determine the s"
        "ign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO This bit will determine the data ali"
        "gnment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO This bit will determine the data alig"
        "nment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO These three bits will determine the bitwi"
        "dth for the audio data into ASRC All other settings not shown are rese"
        "rved.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1B.
static const field_t hw_asrc_asrmcr1b[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO This bit will determine the bit wi"
        "dth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO This bit will determine the s"
        "ign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO This bit will determine the data ali"
        "gnment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO This bit will determine the data alig"
        "nment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO These three bits will determine the bitwi"
        "dth for the audio data into ASRC All other settings not shown are rese"
        "rved.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ASRC_ASRMCR1C.
static const field_t hw_asrc_asrmcr1c[] =
{
    {
        "OW16",
        "Bit Width Option of the output FIFO This bit will determine the bit wi"
        "dth option of the output FIFO.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSGN",
        "Sign Extension Option of the output FIFO This bit will determine the s"
        "ign extension option of the output FIFO.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OMSB",
        "Data Alignment of the output FIFO This bit will determine the data ali"
        "gnment of the output FIFO.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMSB",
        "Data Alignment of the input FIFO This bit will determine the data alig"
        "nment of the input FIFO.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IWD",
        "Data Width of the input FIFO These three bits will determine the bitwi"
        "dth for the audio data into ASRC All other settings not shown are rese"
        "rved.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ASRC module.
static const reg_t hw_asrc[] =
{
    {
        "ASRCTR",
        "The ASRC control register (ASRCTR) is a 24-bit read/write register tha"
        "t controls the ASRC operations.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_asrc_asrctr
    },
    {
        "ASRIER",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrier
    },
    {
        "ASRCNCR",
        "The ASRC channel number configuration register (ASRCNCR) is a 24-bit r"
        "ead/write register that sets the number of channels used by each ASRC "
        "conversion pair.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_asrc_asrcncr
    },
    {
        "ASRCFG",
        "The ASRC configuration status register (ASRCFG) is a 24-bit read/write"
        " register that sets and/or automatically senses the ASRC operations.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_asrc_asrcfg
    },
    {
        "ASRCSR",
        "The ASRC clock source register (ASRCSR) is a 24-bit read/write registe"
        "r that controls the sources of the input and output clocks of the ASRC"
        ".",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_asrc_asrcsr
    },
    {
        "ASRCDR1",
        "The ASRC clock divider register (ASRCDR1) is a 24-bit read/write regis"
        "ter that controls the division factors of the ASRC input and output cl"
        "ock sources.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrcdr1
    },
    {
        "ASRCDR2",
        "The ASRC clock divider register (ASRCDR2) is a 24-bit read/write regis"
        "ter that controls the division factors of the ASRC input and output cl"
        "ock sources.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_asrc_asrcdr2
    },
    {
        "ASRSTR",
        "The ASRC status register (ASRSTR) is a 24-bit read-write register used"
        " by the processor core to examine the status of the ASRC block and cle"
        "ar the overload interrupt request and AOLE flag bit.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        22, // Number of bitfields
        hw_asrc_asrstr
    },
    {
        "ASRPMn1",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn1
    },
    {
        "ASRPMn2",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn2
    },
    {
        "ASRPMn3",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn3
    },
    {
        "ASRPMn4",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn4
    },
    {
        "ASRPMn5",
        "Parameter registers determine the performance of ASRC.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asrpmn5
    },
    {
        "ASRTFR1",
        "The register defines and shows the parameters for ASRC inner task queu"
        "e FIFOs.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_asrc_asrtfr1
    },
    {
        "ASRCCR",
        "The ASRC channel counter register (ASRCCR) is a 24-bit read/write regi"
        "ster that sets and reflects the current specific input/output FIFO bei"
        "ng accessed through shared peripheral bus for each ASRC conversion pai"
        "r.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_asrc_asrccr
    },
    {
        "ASRDIA",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000060, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdia
    },
    {
        "ASRDOA",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdoa
    },
    {
        "ASRDIB",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000068, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdib
    },
    {
        "ASRDOB",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdob
    },
    {
        "ASRDIC",
        "These registers are the interface registers for the audio data input o"
        "f pair A,B,C respectively.",
        4, // Width in bytes
        0x00000070, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdic
    },
    {
        "ASRDOC",
        "These registers are the interface registers for the audio data output "
        "of pair A,B,C respectively.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_asrc_asrdoc
    },
    {
        "ASRIDRHA",
        "The ideal ratio registers (ASRIDRHA, ASRIDRLA) hold the ratio value ID"
        "RATIOA.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrha
    },
    {
        "ASRIDRLA",
        "The ideal ratio registers (ASRIDRHA, ASRIDRLA) hold the ratio value ID"
        "RATIOA.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrla
    },
    {
        "ASRIDRHB",
        "The ideal ratio registers (ASRIDRHB, ASRIDRLB) hold the ratio value ID"
        "RATIOB.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrhb
    },
    {
        "ASRIDRLB",
        "The ideal ratio registers (ASRIDRHB, ASRIDRLB) hold the ratio value ID"
        "RATIOB.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrlb
    },
    {
        "ASRIDRHC",
        "The ideal ratio registers (ASRIDRHC, ASRIDRLC) hold the ratio value ID"
        "RATIOC.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrhc
    },
    {
        "ASRIDRLC",
        "The ideal ratio registers (ASRIDRHC, ASRIDRLC) hold the ratio value ID"
        "RATIOC.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asridrlc
    },
    {
        "ASR76K",
        "The register (ASR76K) holds the period of the 76kHz sampling clock in "
        "terms of the ASRC processing clock with frequency FsASRC.",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asr76k
    },
    {
        "ASR56K",
        "The register (ASR56K) holds the period of the 56kHz sampling clock in "
        "terms of the ASRC processing clock with frequency FsASRC.",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_asrc_asr56k
    },
    {
        "ASRMCRA",
        "The register (ASRMCRA) is used to control Pair A internal logic.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrmcra
    },
    {
        "ASRFSTA",
        "The register (ASRFSTA) is used to show Pair A internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_asrc_asrfsta
    },
    {
        "ASRMCRB",
        "The register (ASRMCRB) is used to control Pair B internal logic.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrmcrb
    },
    {
        "ASRFSTB",
        "The register (ASRFSTB) is used to show Pair B internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_asrc_asrfstb
    },
    {
        "ASRMCRC",
        "The register (ASRMCRC) is used to control Pair C internal logic.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_asrc_asrmcrc
    },
    {
        "ASRFSTC",
        "The register (ASRFSTC) is used to show Pair C internal FIFO conditions"
        ".",
        4, // Width in bytes
        0x000000b4, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_asrc_asrfstc
    },
    {
        "ASRMCR1A",
        "The register (ASRMCR1x) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_asrc_asrmcr1a
    },
    {
        "ASRMCR1B",
        "The register (ASRMCR1x) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_asrc_asrmcr1b
    },
    {
        "ASRMCR1C",
        "The register (ASRMCR1x) is used to control Pair x internal logic (for "
        "data alignment etc.).",
        4, // Width in bytes
        0x000000c8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_asrc_asrmcr1c
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark BCH
#endif

// Bitfields in register BCH_CTRL.
static const field_t hw_bch_ctrl[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_SET.
static const field_t hw_bch_ctrl_set[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_CLR.
static const field_t hw_bch_ctrl_clr[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_CTRL_TOG.
static const field_t hw_bch_ctrl_tog[] =
{
    {
        "COMPLETE_IRQ",
        "This bit indicates the state of the external interrupt line.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ",
        "DEBUG STALL Interrupt Status.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BM_ERROR_IRQ",
        "AHB Bus interface Error Interrupt Status.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        4, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETE_IRQ_EN",
        "1 = interrupt on completion of correction is enabled.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG_STALL_IRQ_EN",
        "1 = interrupt on debug stall mode is enabled.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD3",
        "This read-only field is reserved and always has the value 0",
        11, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "M2M_ENABLE",
        "NOTE! WRITING THIS BIT INITIATES A MEMORY-TO-MEMORY OPERATION.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_ENCODE",
        "Selects encode (parity generation) or decode (correction) mode for mem"
        "ory-to-memory operations.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "M2M_LAYOUT",
        "Selects the flash page format for memory-to-memory operations.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD4",
        "This read-only field is reserved and always has the value 0",
        20, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUGSYNDROME",
        "(For debug purposes only).",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD5",
        "This read-only field is reserved and always has the value 0.",
        23, // LSB
        29, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CLKGATE",
        "This bit must be set to 0 for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set this bit to 0 to enable normal BCH operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0.
static const field_t hw_bch_status0[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_SET.
static const field_t hw_bch_status0_set[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_CLR.
static const field_t hw_bch_status0_clr[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_STATUS0_TOG.
static const field_t hw_bch_status0_tog[] =
{
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UNCORRECTABLE",
        "1 = Uncorrectable error encountered during last processing cycle.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CORRECTED",
        "1 = At least one correctable error encountered during last processing "
        "cycle.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ALLONES",
        "1 = All data bits of this transaction are ONE.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STATUS_BLK0",
        "Count of symbols in error during processing of first block of flash (m"
        "etadata block).",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COMPLETED_CE",
        "This is the chip enable number corresponding to the NAND device from w"
        "hich this data came.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HANDLE",
        "Software supplies a 12 bit handle for this transfer as part of the GPM"
        "I DMA PIO operation that started the transaction.",
        20, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE.
static const field_t hw_bch_mode[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_SET.
static const field_t hw_bch_mode_set[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_CLR.
static const field_t hw_bch_mode_clr[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_MODE_TOG.
static const field_t hw_bch_mode_tog[] =
{
    {
        "ERASE_THRESHOLD",
        "This value indicates the maximum number of zero bits on a flash subpag"
        "e for it to be considered erased.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        8, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR.
static const field_t hw_bch_encodeptr[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_SET.
static const field_t hw_bch_encodeptr_set[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_CLR.
static const field_t hw_bch_encodeptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_ENCODEPTR_TOG.
static const field_t hw_bch_encodeptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to encode buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR.
static const field_t hw_bch_dataptr[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_SET.
static const field_t hw_bch_dataptr_set[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_CLR.
static const field_t hw_bch_dataptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DATAPTR_TOG.
static const field_t hw_bch_dataptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to data buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR.
static const field_t hw_bch_metaptr[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_SET.
static const field_t hw_bch_metaptr_set[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_CLR.
static const field_t hw_bch_metaptr_clr[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_METAPTR_TOG.
static const field_t hw_bch_metaptr_tog[] =
{
    {
        "ADDR",
        "Address pointer to metadata buffer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT.
static const field_t hw_bch_layoutselect[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_SET.
static const field_t hw_bch_layoutselect_set[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_CLR.
static const field_t hw_bch_layoutselect_clr[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_LAYOUTSELECT_TOG.
static const field_t hw_bch_layoutselect_tog[] =
{
    {
        "CS0_SELECT",
        "Selects which layout is used for chip select 0.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS1_SELECT",
        "Selects which layout is used for chip select 1.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS2_SELECT",
        "Selects which layout is used for chip select 2.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS3_SELECT",
        "Selects which layout is used for chip select 3.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS4_SELECT",
        "Selects which layout is used for chip select 4.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS5_SELECT",
        "Selects which layout is used for chip select 5.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS6_SELECT",
        "Selects which layout is used for chip select 6.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS7_SELECT",
        "Selects which layout is used for chip select 7.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS8_SELECT",
        "Selects which layout is used for chip select 8.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS9_SELECT",
        "Selects which layout is used for chip select 9.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS10_SELECT",
        "Selects which layout is used for chip select 10.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS11_SELECT",
        "Selects which layout is used for chip select 11.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS12_SELECT",
        "Selects which layout is used for chip select 12.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS13_SELECT",
        "Selects which layout is used for chip select 13.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS14_SELECT",
        "Selects which layout is used for chip select 14.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS15_SELECT",
        "Selects which layout is used for chip select 15.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0.
static const field_t hw_bch_flash0layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_SET.
static const field_t hw_bch_flash0layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_CLR.
static const field_t hw_bch_flash0layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT0_TOG.
static const field_t hw_bch_flash0layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1.
static const field_t hw_bch_flash0layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_SET.
static const field_t hw_bch_flash0layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_CLR.
static const field_t hw_bch_flash0layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH0LAYOUT1_TOG.
static const field_t hw_bch_flash0layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0.
static const field_t hw_bch_flash1layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_SET.
static const field_t hw_bch_flash1layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_CLR.
static const field_t hw_bch_flash1layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT0_TOG.
static const field_t hw_bch_flash1layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1.
static const field_t hw_bch_flash1layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_SET.
static const field_t hw_bch_flash1layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_CLR.
static const field_t hw_bch_flash1layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH1LAYOUT1_TOG.
static const field_t hw_bch_flash1layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0.
static const field_t hw_bch_flash2layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_SET.
static const field_t hw_bch_flash2layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_CLR.
static const field_t hw_bch_flash2layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT0_TOG.
static const field_t hw_bch_flash2layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1.
static const field_t hw_bch_flash2layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_SET.
static const field_t hw_bch_flash2layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_CLR.
static const field_t hw_bch_flash2layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH2LAYOUT1_TOG.
static const field_t hw_bch_flash2layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0.
static const field_t hw_bch_flash3layout0[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_SET.
static const field_t hw_bch_flash3layout0_set[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_CLR.
static const field_t hw_bch_flash3layout0_clr[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT0_TOG.
static const field_t hw_bch_flash3layout0_tog[] =
{
    {
        "DATA0_SIZE",
        "Indicates the size of the data 0 block (in DWORDS / four bytes) to be "
        "stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC0",
        "Indicates the ECC level for the first block on the flash page.",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "META_SIZE",
        "Indicates the size of the metadata (in bytes) to be stored on a flash "
        "page.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NBLOCKS",
        "Number of subsequent blocks on the flash page (excluding the data0 blo"
        "ck).",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1.
static const field_t hw_bch_flash3layout1[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_SET.
static const field_t hw_bch_flash3layout1_set[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_CLR.
static const field_t hw_bch_flash3layout1_clr[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_FLASH3LAYOUT1_TOG.
static const field_t hw_bch_flash3layout1_tog[] =
{
    {
        "DATAN_SIZE",
        "Indicates the size of the subsequent data blocks (in DWORDS / four byt"
        "es) to be stored on the flash page.",
        0, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GF13_0_GF14_1",
        "Select GF13 or GF14: 0-GF13; 1-GF14",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECCN",
        "Indicates the ECC level for the subsequent blocks on the flash page (b"
        "locks 1-n).",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAGE_SIZE",
        "Indicates the total size of the flash page (in bytes).",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0.
static const field_t hw_bch_debug0[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_SET.
static const field_t hw_bch_debug0_set[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_CLR.
static const field_t hw_bch_debug0_clr[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG0_TOG.
static const field_t hw_bch_debug0_tog[] =
{
    {
        "DEBUG_REG_SELECT",
        "The value loaded in this bit field is used to select the internal regi"
        "ster state view of KES engine or the Chien search engine.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "This read-only field is reserved and always has the value 0.",
        6, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BM_KES_TEST_BYPASS",
        "1 = Point all SYND_GEN writes to dummy area at the end of the AUXILLIA"
        "RY block so that diagnostics can preload all payload, parity bytes and"
        " computed syndrome bytes for test the KES engine.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STALL",
        "Set to one to cause KES FSM to stall after notifying Chien search engi"
        "ne to start processing its block but before notifying the bus master t"
        "hat the KES computation is complete.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_STEP",
        "Toggling this bit causes the KES FSM to skip passed the stall state if"
        " it is in DEBUG_STALL mode and completed processing a block.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_STANDALONE",
        "Set to one, cause the KES engine to suppress toggling the KES_BM_DONE "
        "signal to the bus master and suppress toggling the CF_BM_DONE signal b"
        "y the CF engine.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_KICK",
        "Toggling causes KES engine FSM to start as if kick by the Bus Master.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_MODE4K",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input mode (4K "
        "or 2K pages).",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_PAYLOAD_FLAG",
        "When running the stand alone debug mode on the error calculator, the s"
        "tate of this bit is presented to the KES engine as the input payload f"
        "lag.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SHIFT_SYND",
        "Toggling this bit causes the value in BCH_DEBUG0_KES_SYNDROME_SYMBOL t"
        "o be shift into the syndrome register array at the input to the KES en"
        "gine.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "KES_DEBUG_SYNDROME_SYMBOL",
        "The 9 bit value in this bit field shifts into the syndrome register ar"
        "ray at the input of the KES engine whenever BCH_DEBUG0_KES_DEBUG_SHIFT"
        "_SYND is toggled.",
        16, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "This read-only field is reserved and always has the value 0.",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD.
static const field_t hw_bch_dbgkesread[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_SET.
static const field_t hw_bch_dbgkesread_set[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_CLR.
static const field_t hw_bch_dbgkesread_clr[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGKESREAD_TOG.
static const field_t hw_bch_dbgkesread_tog[] =
{
    {
        "VALUES",
        "This register returns the ROM BIST CRC value after a BIST test.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD.
static const field_t hw_bch_dbgcsferead[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_SET.
static const field_t hw_bch_dbgcsferead_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_CLR.
static const field_t hw_bch_dbgcsferead_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGCSFEREAD_TOG.
static const field_t hw_bch_dbgcsferead_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD.
static const field_t hw_bch_dbgsyndgenread[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_SET.
static const field_t hw_bch_dbgsyndgenread_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_CLR.
static const field_t hw_bch_dbgsyndgenread_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGSYNDGENREAD_TOG.
static const field_t hw_bch_dbgsyndgenread_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD.
static const field_t hw_bch_dbgahbmread[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_SET.
static const field_t hw_bch_dbgahbmread_set[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_CLR.
static const field_t hw_bch_dbgahbmread_clr[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DBGAHBMREAD_TOG.
static const field_t hw_bch_dbgahbmread_tog[] =
{
    {
        "VALUES",
        "Reserved",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME.
static const field_t hw_bch_blockname[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_SET.
static const field_t hw_bch_blockname_set[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_CLR.
static const field_t hw_bch_blockname_clr[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_BLOCKNAME_TOG.
static const field_t hw_bch_blockname_tog[] =
{
    {
        "NAME",
        "The name is in the ASCII characters BCH (0x20, H, C, B).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION.
static const field_t hw_bch_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_SET.
static const field_t hw_bch_version_set[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_CLR.
static const field_t hw_bch_version_clr[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_VERSION_TOG.
static const field_t hw_bch_version_tog[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value indicates the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value indicates the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1.
static const field_t hw_bch_debug1[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1_SET.
static const field_t hw_bch_debug1_set[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1_CLR.
static const field_t hw_bch_debug1_clr[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register BCH_DEBUG1_TOG.
static const field_t hw_bch_debug1_tog[] =
{
    {
        "ERASED_ZERO_COUNT",
        "The zero counts on one page.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD",
        "This read-only field is reserved and always has the value 0.",
        9, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEBUG1_PREERASECHK",
        "Blank page enables pre-erase check.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a BCH module.
static const reg_t hw_bch[] =
{
    {
        "CTRL",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl
    },
    {
        "CTRL_SET",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_set
    },
    {
        "CTRL_CLR",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_clr
    },
    {
        "CTRL_TOG",
        "The BCH CTRL provides overall control of the hardware ECC accelerator",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_bch_ctrl_tog
    },
    {
        "STATUS0",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0
    },
    {
        "STATUS0_SET",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_set
    },
    {
        "STATUS0_CLR",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_clr
    },
    {
        "STATUS0_TOG",
        "The BCH STAT register provides visibility into the run-time status of "
        "the BCH and status information when processing is complete.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        8, // Number of bitfields
        hw_bch_status0_tog
    },
    {
        "MODE",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode
    },
    {
        "MODE_SET",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_set
    },
    {
        "MODE_CLR",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_clr
    },
    {
        "MODE_TOG",
        "The BCH MODE register provides additional mode controls.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_bch_mode_tog
    },
    {
        "ENCODEPTR",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr
    },
    {
        "ENCODEPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_set
    },
    {
        "ENCODEPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_clr
    },
    {
        "ENCODEPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the encode buffer.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_encodeptr_tog
    },
    {
        "DATAPTR",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr
    },
    {
        "DATAPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_set
    },
    {
        "DATAPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_clr
    },
    {
        "DATAPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the data buffer.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_dataptr_tog
    },
    {
        "METAPTR",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr
    },
    {
        "METAPTR_SET",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_set
    },
    {
        "METAPTR_CLR",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_clr
    },
    {
        "METAPTR_TOG",
        "When performing memory to memory operations, indicates the address of "
        "the metadata buffer.",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_bch_metaptr_tog
    },
    {
        "LAYOUTSELECT",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect
    },
    {
        "LAYOUTSELECT_SET",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_set
    },
    {
        "LAYOUTSELECT_CLR",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_clr
    },
    {
        "LAYOUTSELECT_TOG",
        "The BCH LAYOUTSELECT register provides a mapping of chip selects to la"
        "yout registers.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_bch_layoutselect_tog
    },
    {
        "FLASH0LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0
    },
    {
        "FLASH0LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_set
    },
    {
        "FLASH0LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_clr
    },
    {
        "FLASH0LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash0layout0_tog
    },
    {
        "FLASH0LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1
    },
    {
        "FLASH0LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_set
    },
    {
        "FLASH0LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x00000098, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_clr
    },
    {
        "FLASH0LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x0000009c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash0layout1_tog
    },
    {
        "FLASH1LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0
    },
    {
        "FLASH1LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_set
    },
    {
        "FLASH1LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_clr
    },
    {
        "FLASH1LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash1layout0_tog
    },
    {
        "FLASH1LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1
    },
    {
        "FLASH1LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_set
    },
    {
        "FLASH1LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000b8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_clr
    },
    {
        "FLASH1LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000bc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash1layout1_tog
    },
    {
        "FLASH2LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0
    },
    {
        "FLASH2LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_set
    },
    {
        "FLASH2LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000c8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_clr
    },
    {
        "FLASH2LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000cc, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash2layout0_tog
    },
    {
        "FLASH2LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1
    },
    {
        "FLASH2LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_set
    },
    {
        "FLASH2LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000d8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_clr
    },
    {
        "FLASH2LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000dc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash2layout1_tog
    },
    {
        "FLASH3LAYOUT0",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0
    },
    {
        "FLASH3LAYOUT0_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_set
    },
    {
        "FLASH3LAYOUT0_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_clr
    },
    {
        "FLASH3LAYOUT0_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_bch_flash3layout0_tog
    },
    {
        "FLASH3LAYOUT1",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1
    },
    {
        "FLASH3LAYOUT1_SET",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f4, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_set
    },
    {
        "FLASH3LAYOUT1_CLR",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000f8, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_clr
    },
    {
        "FLASH3LAYOUT1_TOG",
        "The flash format register contains a description of the logical layout"
        " of data on the flash device.",
        4, // Width in bytes
        0x000000fc, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_bch_flash3layout1_tog
    },
    {
        "DEBUG0",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0
    },
    {
        "DEBUG0_SET",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_set
    },
    {
        "DEBUG0_CLR",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_clr
    },
    {
        "DEBUG0_TOG",
        "The hardware BCH accelerator internal state machines and signals can b"
        "e seen in the ECC debug register.",
        4, // Width in bytes
        0x0000010c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_bch_debug0_tog
    },
    {
        "DBGKESREAD",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread
    },
    {
        "DBGKESREAD_SET",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000114, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_set
    },
    {
        "DBGKESREAD_CLR",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_clr
    },
    {
        "DBGKESREAD_TOG",
        "The hardware BCH ECC accelerator key equation solver internal state ma"
        "chines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgkesread_tog
    },
    {
        "DBGCSFEREAD",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead
    },
    {
        "DBGCSFEREAD_SET",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000124, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_set
    },
    {
        "DBGCSFEREAD_CLR",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000128, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_clr
    },
    {
        "DBGCSFEREAD_TOG",
        "The hardware BCH ECC accelerator Chien Search internal state machines "
        "and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000012c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgcsferead_tog
    },
    {
        "DBGSYNDGENREAD",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread
    },
    {
        "DBGSYNDGENREAD_SET",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000134, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_set
    },
    {
        "DBGSYNDGENREAD_CLR",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000138, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_clr
    },
    {
        "DBGSYNDGENREAD_TOG",
        "The hardware BCH ECC accelerator syndrome generator internal state mac"
        "hines and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000013c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgsyndgenread_tog
    },
    {
        "DBGAHBMREAD",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000140, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread
    },
    {
        "DBGAHBMREAD_SET",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000144, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_set
    },
    {
        "DBGAHBMREAD_CLR",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x00000148, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_clr
    },
    {
        "DBGAHBMREAD_TOG",
        "The hardware BCH ECC accelerator bus master, ECC controller internal s"
        "tate machines, and signals can be seen in the ECC debug registers.",
        4, // Width in bytes
        0x0000014c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_dbgahbmread_tog
    },
    {
        "BLOCKNAME",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname
    },
    {
        "BLOCKNAME_SET",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000154, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_set
    },
    {
        "BLOCKNAME_CLR",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x00000158, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_clr
    },
    {
        "BLOCKNAME_TOG",
        "Read only view of the block name string BCH.",
        4, // Width in bytes
        0x0000015c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_bch_blockname_tog
    },
    {
        "VERSION",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version
    },
    {
        "VERSION_SET",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000164, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_set
    },
    {
        "VERSION_CLR",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x00000168, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_clr
    },
    {
        "VERSION_TOG",
        "This register always returns a known read value for debug purposes and"
        " indicates the version of the block and RTL version in use.",
        4, // Width in bytes
        0x0000016c, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_bch_version_tog
    },
    {
        "DEBUG1",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1
    },
    {
        "DEBUG1_SET",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x00000174, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1_set
    },
    {
        "DEBUG1_CLR",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x00000178, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1_clr
    },
    {
        "DEBUG1_TOG",
        "The BCH_DEBUG1 register provides erased zero count information and pre"
        "-erase check.",
        4, // Width in bytes
        0x0000017c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_bch_debug1_tog
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CCM
#endif

// Bitfields in register CCM_CCR.
static const field_t hw_ccm_ccr[] =
{
    {
        "OSCNT",
        "Oscillator ready counter value.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_EN",
        "On chip oscillator enable bit - this bit value is reflected on the out"
        "put cosc_en.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG_BYPASS_COUNT",
        "Counter for analog_reg_bypass signal assertion after standby voltage r"
        "equest by PMIC_STBY_REQ.",
        21, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBC_EN",
        "Enable for REG_BYPASS_COUNTER.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCDR.
static const field_t hw_ccm_ccdr[] =
{
    {
        "MMDC_MASK",
        "During divider ratio mmdc_axi_podf change or sync mux periph2_clk_sel "
        "change (but not jtag) or SRC request during warm reset, mask handshake"
        " with mmdc module.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSR.
static const field_t hw_ccm_csr[] =
{
    {
        "REF_EN_B",
        "Status of the value of CCM_REF_EN_B output of ccm",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "COSC_READY",
        "Status indication of on board oscillator.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCSR.
static const field_t hw_ccm_ccsr[] =
{
    {
        "PLL3_SW_CLK_SEL",
        "Selects source to generate pll3_sw_clk.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL1_SW_CLK_SEL",
        "Selects source to generate pll1_sw_clk.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SECONDARY_CLK_SEL",
        "Select source to generate secondary_clk",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STEP_SEL",
        "Selects the option to be chosen for the step frequency when shifting A"
        "RM frequency.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CACRR.
static const field_t hw_ccm_cacrr[] =
{
    {
        "ARM_PODF",
        "Divider for ARM clock root.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CBCDR.
static const field_t hw_ccm_cbcdr[] =
{
    {
        "PERIPH2_CLK2_PODF",
        "Divider for periph2_clk2 podf.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FABRIC_MMDC_PODF",
        "Post divider for fabric / mmdc clock.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_CLK_SEL",
        "AXI clock source select",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_ALT_CLK_SEL",
        "AXI alternative clock select",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPG_PODF",
        "Divider for ipg podf.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_PODF",
        "Divider for AHB PODF.",
        10, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_PODF",
        "Post divider for axi clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK_SEL",
        "Selector for peripheral main clock (source of MMDC_CLK_ROOT).",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK_SEL",
        "Selector for peripheral2 main clock (source of mmdc_clk_root ).",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK2_PODF",
        "Divider for periph2 clock podf.",
        27, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CBCMR.
static const field_t hw_ccm_cbcmr[] =
{
    {
        "PERIPH_CLK2_SEL",
        "Selector for peripheral clk2 clock multiplexer",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_PERIPH_CLK_SEL",
        "Selector for pre_periph clock multiplexer",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK2_SEL",
        "Selector for periph2_clk2 clock multiplexer",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_PERIPH2_CLK_SEL",
        "Selector for pre_periph2 clock multiplexer",
        21, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_PODF",
        "Post-divider for lcdif1 clock.",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCMR1.
static const field_t hw_ccm_cscmr1[] =
{
    {
        "PERCLK_PODF",
        "Divider for perclk podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERCLK_CLK_SEL",
        "Selector for the perclk clock multiplexor",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "QSPI1_CLK_SEL",
        "QSPI1 clock select",
        7, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI1_CLK_SEL",
        "Selector for sai1 clock multiplexer",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI2_CLK_SEL",
        "Selector for sai2 clock multiplexer",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI3_CLK_SEL",
        "Selector for sai3 clock multiplexer",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC1_CLK_SEL",
        "Selector for usdhc1 clock multiplexer",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC2_CLK_SEL",
        "Selector for usdhc2 clock multiplexer",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCH_CLK_SEL",
        "Selector for bch clock multiplexer",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPMI_CLK_SEL",
        "Selector for gpmi clock multiplexer",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EIM_SLOW_PODF",
        "Divider for aclk_eim_slow clock root.",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "QSPI1_PODF",
        "Divider for QSPI1 clock root",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ACLK_EIM_SLOW_SEL",
        "Selector for aclk_eim_slow root clock multiplexer",
        29, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCMR2.
static const field_t hw_ccm_cscmr2[] =
{
    {
        "CAN_CLK_PODF",
        "Divider for can clock podf.",
        2, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAN_CLK_SEL",
        "Selector for FlexCAN clock multiplexer",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI0_DIV",
        "Control for divider of ldb clock for di0",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI1_DIV",
        "Control for divider of ldb clock for di1",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_CLK_SEL",
        "Selector for vid clock multiplexer",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_CLK_PRE_PODF",
        "Post-divider for vid clock root",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_CLK_PODF",
        "Post-divider for vid clock root",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR1.
static const field_t hw_ccm_cscdr1[] =
{
    {
        "UART_CLK_PODF",
        "Divider for uart clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UART_CLK_SEL",
        "Selector for the UART clock multiplexor",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC1_PODF",
        "Divider for usdhc1 clock podf.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "USDHC2_PODF",
        "Divider for usdhc2 clock.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCH_PODF",
        "Divider for bch clock podf.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPMI_PODF",
        "Divider for gpmi clock pred.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CS1CDR.
static const field_t hw_ccm_cs1cdr[] =
{
    {
        "SAI1_CLK_PODF",
        "Divider for sai1 clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI1_CLK_PRED",
        "Divider for sai1 clock pred.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI3_CLK_PODF",
        "Divider for sai3 clock podf.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI3_CLK_PRED",
        "Divider for sai3 clock pred.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CS2CDR.
static const field_t hw_ccm_cs2cdr[] =
{
    {
        "SAI2_CLK_PODF",
        "Divider for sai2 clock podf.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SAI2_CLK_PRED",
        "Divider for sai2 clock pred.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LDB_DI0_CLK_SEL",
        "Selector for ldb_di0 clock multiplexerMultiplexor should be updated wh"
        "en both input and output clocks are gated.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENFC_CLK_SEL",
        "Selector for enfc clock multiplexer Multiplexor should be updated when"
        " output clock is gated.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENFC_CLK_PRED",
        "Divider for enfc clock pred divider.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENFC_CLK_PODF",
        "Divider for enfc clock divider.",
        21, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CDCDR.
static const field_t hw_ccm_cdcdr[] =
{
    {
        "SPDIF0_CLK_SEL",
        "Selector for spdif0 clock multiplexer",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_PODF",
        "Divider for spdif0 clock podf.",
        22, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF0_CLK_PRED",
        "Divider for spdif0 clock pred.",
        25, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CHSCCDR.
static const field_t hw_ccm_chsccdr[] =
{
    {
        "SIM_CLK_SEL",
        "Selector for SIM root clock multiplexer",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIM_PODF",
        "Divider for SIM clock divider.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SIM_PRE_CLK_SEL",
        "Selector for SIM root clock pre-multiplexer",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR2.
static const field_t hw_ccm_cscdr2[] =
{
    {
        "LCDIF1_CLK_SEL",
        "Selector for lcdif1 root clock multiplexer",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_PRED",
        "Pre-divider for lcdif1 clock.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LCDIF1_PRE_CLK_SEL",
        "Selector for lcdif1 root clock pre-multiplexer",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECSPI_CLK_SEL",
        "Selector for the ECSPI clock multiplexor",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECSPI_CLK_PODF",
        "Divider for ecspi clock podf.",
        19, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CSCDR3.
static const field_t hw_ccm_cscdr3[] =
{
    {
        "CSI_CLK_SEL",
        "Selector for csi clock multiplexer",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_PODF",
        "Post divider for csi_core clock.",
        11, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CWDR.
static const field_t hw_ccm_cwdr[] =
{
    { 0 } // Terminator
};

// Bitfields in register CCM_CDHIPR.
static const field_t hw_ccm_cdhipr[] =
{
    {
        "AXI_PODF_BUSY",
        "Busy indicator for axi_podf.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AHB_PODF_BUSY",
        "Busy indicator for ahb_podf.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MMDC_PODF_BUSY",
        "Busy indicator for mmdc_axi_podf.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH2_CLK_SEL_BUSY",
        "Busy indicator for periph2_clk_sel mux control.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PERIPH_CLK_SEL_BUSY",
        "Busy indicator for periph_clk_sel mux control.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ARM_PODF_BUSY",
        "Busy indicator for arm_podf.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CLPCR.
static const field_t hw_ccm_clpcr[] =
{
    {
        "LPM",
        "Setting the low power mode that system will enter on next assertion of"
        " dsm_request signal.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_CLK_DIS_ON_LPM",
        "Define if ARM clocks (arm_clk, soc_mxclk, soc_pclk, soc_dbg_pclk, vl_w"
        "rck) will be disabled on wait mode.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SBYOS",
        "Standby clock oscillator bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIS_REF_OSC",
        "dis_ref_osc - in run mode, software can manually control closing of ex"
        "ternal reference oscillator clock, i.e.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSTBY",
        "Voltage standby request bit.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STBY_COUNT",
        "Standby counter definition.",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_PWRDOWN",
        "In run mode, software can manually control powering down of on chip os"
        "cillator, i.e.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_MMDC_LPM_HS",
        "Bypass handshake with mmdc on next entrance to low power mode (STOP or"
        " WAIT).",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_CORE0_WFI",
        "Mask WFI of core0 for entering low power mode Assertion of all bits[27"
        ":22] will generate low power mode request",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_SCU_IDLE",
        "Mask SCU IDLE for entering low power mode Assertion of all bits[27:22]"
        " will generate low power mode request",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_L2CC_IDLE",
        "Mask L2CC IDLE for entering low power mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CISR.
static const field_t hw_ccm_cisr[] =
{
    {
        "LRF_PLL",
        "CCM interrupt request 2 generated due to lock of all enabled and not b"
        "ypaseed PLLs",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COSC_READY",
        "CCM interrupt request 2 generated due to on board oscillator ready, i."
        "e.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AXI_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of axi_podf",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH2_CLK_SEL_LOADED",
        "CCM interrupt request 1 generated due to frequency change of periph2_c"
        "lk_sel",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of ahb_podf",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of mmdc_podf"
        "_ loaded",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PERIPH_CLK_SEL_LOADED",
        "CCM interrupt request 1 generated due to update of periph_clk_sel.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_PODF_LOADED",
        "CCM interrupt request 1 generated due to frequency change of arm_podf.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CIMR.
static const field_t hw_ccm_cimr[] =
{
    {
        "MASK_LRF_PLL",
        "mask interrupt generation due to lrf of PLLs",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_COSC_READY",
        "mask interrupt generation due to on board oscillator ready",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_AXI_PODF_LOADED",
        "mask interrupt generation due to frequency change of axi_podf",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_PERIPH2_CLK_SEL_LOADED",
        "mask interrupt generation due to update of periph2_clk_sel.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_AHB_PODF_LOADED",
        "mask interrupt generation due to frequency change of ahb_podf",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_MMDC_PODF_LOADED",
        "mask interrupt generation due to update of mask_mmdc_podf",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_PERIPH_CLK_SEL_LOADED",
        "mask interrupt generation due to update of periph_clk_sel.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ARM_PODF_LOADED",
        "mask interrupt generation due to frequency change of arm_podf",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCOSR.
static const field_t hw_ccm_ccosr[] =
{
    {
        "CLKO_SEL",
        "Selection of the clock to be generated on CCM_CLKO1",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_DIV",
        "Setting the divider of CCM_CLKO1",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO1_EN",
        "Enable of CCM_CLKO1 clock",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLK_OUT_SEL",
        "CCM_CLKO1 output to reflect CCM_CLKO1 or CCM_CLKO2 clocks",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_SEL",
        "Selection of the clock to be generated on CCM_CLKO2",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_DIV",
        "Setting the divider of CCM_CLKO2",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKO2_EN",
        "Enable of CCM_CLKO2 clock",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CGPR.
static const field_t hw_ccm_cgpr[] =
{
    {
        "PMIC_DELAY_SCALER",
        "Defines clock dividion of clock for stby_count (pmic delay counter)",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MMDC_EXT_CLK_DIS",
        "Disable external clock driver of MMDC during STOP mode",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EFUSE_PROG_SUPPLY_GATE",
        "Defines the value of the output signal cgpr_dout[4].",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYS_MEM_DS_CTRL",
        "System memory DS control",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FPL",
        "",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INT_MEM_CLK_LPM",
        "Control for the Deep Sleep signal to the ARM Platform memories with ad"
        "ditional control logic based on the ARM WFI signal.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR0.
static const field_t hw_ccm_ccgr0[] =
{
    {
        "CG0",
        "aips_tz1 clocks (aips_tz1_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "aips_tz2 clocks (aips_tz2_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "apbhdma hclk clock (apbhdma_hclk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "asrc clock (asrc_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "caam_secure_mem clock (caam_secure_mem_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "caam_wrapper_aclk clock (caam_wrapper_aclk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "caam_wrapper_ipg clock (caam_wrapper_ipg_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "can1 clock (can1_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "can1_serial clock (can1_serial_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "can2 clock (can2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "can2_serial clock (can2_serial_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "CPU debug clocks (arm_dbg_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "dcic1 clocks (dcic1_clk_enable) gpt2 bus clocks (gpt2_bus_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "gpt2 serial clocks (gpt2_serial_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "uart2 clock (uart2_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "gpio2_clocks (gpio2_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR1.
static const field_t hw_ccm_ccgr1[] =
{
    {
        "CG0",
        "ecspi1 clocks (ecspi1_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "ecspi2 clocks (ecspi2_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "ecspi3 clocks (ecspi3_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "ecspi4 clocks (ecspi4_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "adc2 clock (adc2_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "uart3 clock (uart3_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "epit1 clocks (epit1_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "epit2 clocks (epit2_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "adc1 clock (adc1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "sim_s clock (sim_s_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "gpt bus clock (gpt_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "gpt serial clock (gpt_serial_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "uart4 clock (uart4_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "gpio1 clock (gpio1_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "csu clock (csu_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "gpio5 clock (gpio5_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR2.
static const field_t hw_ccm_ccgr2[] =
{
    {
        "CG0",
        "Reserved",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "csi clock (csi_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "Reserved",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "i2c1_serial clock (i2c1_serial_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "i2c2_serial clock (i2c2_serial_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "i2c3_serial clock (i2c3_serial_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "OCOTP_CTRL clock (iim_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "iomux_ipt_clk_io clock (iomux_ipt_clk_io_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "ipmux1 clock (ipmux1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "ipmux2 clock (ipmux2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "ipmux3 clock (ipmux3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "ipsync_ip2apb_tzasc1_ipg clocks (ipsync_ip2apb_tzasc1_ipg_master_clk_e"
        "nable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "Reserved",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "gpio3 clock (gpio3_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "lcd clocks (lcd_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "pxp clocks (pxp_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR3.
static const field_t hw_ccm_ccgr3[] =
{
    {
        "CG0",
        "Reserved",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "uart5 clock (uart5_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "enet clock (enet_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "uart6 clock (uart6_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "CA7 CCM DAP clock (ccm_dap_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "lcdif1 pix clock (lcdif1_pix_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "gpio4 clock (gpio4_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "qspi1 clock (qspi1_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "wdog1 clock (wdog1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "a7 clkdiv patch clock (a7_clkdiv_patch_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "mmdc_core_aclk_fast_core_p0 clock (mmdc_core_aclk_fast_core_p0_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "Reserved",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "mmdc_core_ipg_clk_p0 clock (mmdc_core_ipg_clk_p0_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "mmdc_core_ipg_clk_p1 clock (mmdc_core_ipg_clk_p1_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "axi clock (axi_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "Reserved",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR4.
static const field_t hw_ccm_ccgr4[] =
{
    {
        "CG0",
        "pcie clock (pcie_root_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "iomuxc clock (iomuxc_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "iomuxc gpr clock (iomuxc_gpr_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "sim_cpu clock (sim_cpu_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "cxapbsyncbridge slave clock (cxapbsyncbridge_slave_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "tsc_dig clock (tsc_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "pl301_mx6qper1_bch clocks (pl301_mx6qper1_bchclk_enable) This gates bc"
        "h_clk_root to sim_m fabric.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "pl301_mx6qper2_mainclk_enable (pl301_mx6qper2_mainclk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "pwm1 clocks (pwm1_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "pwm2 clocks (pwm2_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "pwm3 clocks (pwm3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "pwm4 clocks (pwm4_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "rawnand_u_bch_input_apb clock (rawnand_u_bch_input_apb_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "rawnand_u_gpmi_bch_input_bch clock (rawnand_u_gpmi_bch_input_bch_clk_e"
        "nable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "rawnand_u_gpmi_bch_input_gpmi_io clock (rawnand_u_gpmi_bch_input_gpmi_"
        "io_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "rawnand_u_gpmi_input_apb clock (rawnand_u_gpmi_input_apb_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR5.
static const field_t hw_ccm_ccgr5[] =
{
    {
        "CG0",
        "rom clock (rom_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "stcr clock (stcr_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "snvs dryice clock (snvs_dryice_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "sdma clock (sdma_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "kpp clock (kpp_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "wdog2 clock (wdog2_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "spba clock (spba_clk_enable)",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "spdif / audio clock (spdif_clk_enable, audio_clk_root)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "sim_main clock (sim_main_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "snvs_hp clock (snvs_hp_clk_enable)",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "snvs_lp clock (snvs_lp_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "sai3 clock (sai3_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "uart1 clock (uart1_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "uart7 clock (uart7_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "sai1 clock (sai1_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "sai2 clock (sai2_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CCGR6.
static const field_t hw_ccm_ccgr6[] =
{
    {
        "CG0",
        "usboh3 clock (usboh3_clk_enable)",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG1",
        "usdhc1 clocks (usdhc1_clk_enable)",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG2",
        "usdhc2 clocks (usdhc2_clk_enable)",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG3",
        "sim1_clock (sim1_clk_enable)",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG4",
        "sim2_clock (sim2_clk_enable)",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG5",
        "eim_slow clocks (eim_slow_clk_enable)",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG6",
        "Reserved",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG7",
        "uart8 clocks (uart8_clk_enable)",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG8",
        "pwm8 clocks (pwm8_clk_enable)",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG9",
        "Reserved",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG10",
        "wdog3 clock (wdog3_clk_enable)",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG11",
        "anadig clocks (anadig_clk_enable)",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG12",
        "i2c4 serial clock (i2c4_serial_clk_enable)",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG13",
        "pwm5 clocks (pwm5_clk_enable)",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG14",
        "pwm6 clocks (pwm6_clk_enable)",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CG15",
        "pwm7 clocks (pwm7_clk_enable)",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_CMEOR.
static const field_t hw_ccm_cmeor[] =
{
    {
        "MOD_EN_OV_GPT",
        "Overide clock enable signal from GPT - clock will not be gated based o"
        "n GPT's signal 'ipg_enable_clk' .",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_EPIT",
        "Overide clock enable signal from EPIT - clock will not be gated based "
        "on EPIT's signal 'ipg_enable_clk' .",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_USDHC",
        "overide clock enable signal from USDHC.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_CAN2_CPI",
        "Overide clock enable signal from CAN2 - clock will not be gated based "
        "on CAN's signal 'enable_clk_cpi'.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MOD_EN_OV_CAN1_CPI",
        "Overide clock enable signal from CAN1 - clock will not be gated based "
        "on CAN's signal 'enable_clk_cpi'.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CCM module.
static const reg_t hw_ccm[] =
{
    {
        "CCR",
        "The figure below represents the CCM Control Register (CCR), which cont"
        "ains bits to control general operation of CCM.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_ccr
    },
    {
        "CCDR",
        "The figure below represents the CCM Control Divider Register (CCDR), w"
        "hich contains bits that control the loading of the dividers that need "
        "handshake with the modules they affect.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_ccdr
    },
    {
        "CSR",
        "The figure below represents the CCM status Register (CSR).",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_ccm_csr
    },
    {
        "CCSR",
        "The figure below represents the CCM Clock Switcher register (CCSR).",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_ccsr
    },
    {
        "CACRR",
        "The figure below represents the CCM Arm Clock Root register (CACRR).",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_cacrr
    },
    {
        "CBCDR",
        "The figure below represents the CCM Bus Clock Divider Register (CBCDR)"
        ".",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ccm_cbcdr
    },
    {
        "CBCMR",
        "The figure below represents the CCM Bus Clock Multiplexer Register (CB"
        "CMR).",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_ccm_cbcmr
    },
    {
        "CSCMR1",
        "The figure below represents the CCM Serial Clock Multiplexer Register "
        "1 (CSCMR1).",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_ccm_cscmr1
    },
    {
        "CSCMR2",
        "The figure below represents the CCM Serial Clock Multiplexer Register "
        "2 (CSCMR2).",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_cscmr2
    },
    {
        "CSCDR1",
        "The figure below represents the CCM Serial Clock Divider Register 1 (C"
        "SCDR1).",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cscdr1
    },
    {
        "CS1CDR",
        "The figure below represents the CCM SAI1, and SAI3 Clock Divider Regis"
        "ter (CS1CDR).",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_ccm_cs1cdr
    },
    {
        "CS2CDR",
        "The figure below represents the CCM SAI2, LDB Clock Divider Register ("
        "CS2CDR).",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cs2cdr
    },
    {
        "CDCDR",
        "The figure below represents the CCM DI Clock Divider Register (CDCDR).",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ccm_cdcdr
    },
    {
        "CHSCCDR",
        "The figure below represents the CCM HSC Clock Divider Register (CHSCCD"
        "R).",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ccm_chsccdr
    },
    {
        "CSCDR2",
        "The figure below represents the CCM Serial Clock Divider Register 2(CS"
        "CDR2).",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_ccm_cscdr2
    },
    {
        "CSCDR3",
        "The figure below represents the CCM Serial Clock Divider Register 3(CS"
        "CDR3).",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_ccm_cscdr3
    },
    {
        "CWDR",
        "The figure below represents the CCM Wakeup Detector Register (CWDR).",
        4, // Width in bytes
        0x00000044, // Base address offset
        false, // Readable
        false, // Writable
        0, // Number of bitfields
        hw_ccm_cwdr
    },
    {
        "CDHIPR",
        "The figure below represents the CCM Divider Handshake In-Process Regis"
        "ter (CDHIPR).",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_ccm_cdhipr
    },
    {
        "CLPCR",
        "The figure below represents the CCM Low Power Control Register (CLPCR)"
        ".",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_clpcr
    },
    {
        "CISR",
        "The figure below represents the CCM Interrupt Status Register (CISR).",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_cisr
    },
    {
        "CIMR",
        "The figure below represents the CCM Interrupt Mask Register (CIMR).",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_cimr
    },
    {
        "CCOSR",
        "The figure below represents the CCM Clock Output Source Register (CCOS"
        "R).",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_ccosr
    },
    {
        "CGPR",
        "Fast PLL enable.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ccm_cgpr
    },
    {
        "CCGR0",
        "CG(i) bits CCGR 0-6 These bits are used to turn on/off the clock to ea"
        "ch module independently.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr0
    },
    {
        "CCGR1",
        "The figure below represents the CCM Clock Gating Register 1(CCM_CCGR1)"
        ".",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr1
    },
    {
        "CCGR2",
        "The figure below represents the CCM Clock Gating Register 2 (CCM_CCGR2"
        ").",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr2
    },
    {
        "CCGR3",
        "The figure below represents the CCM Clock Gating Register 3 (CCM_CCGR3"
        ").",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr3
    },
    {
        "CCGR4",
        "The figure below represents the CCM Clock Gating Register 4 (CCM_CCGR4"
        ").",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr4
    },
    {
        "CCGR5",
        "The figure below represents the CCM Clock Gating Register 5 (CCM_CCGR5"
        ").",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr5
    },
    {
        "CCGR6",
        "The figure below represents the CCM Clock Gating Register 6 (CCM_CCGR6"
        ").",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_ccm_ccgr6
    },
    {
        "CMEOR",
        "The follow figure represents the CCM Module Enable Override Register ("
        "CMEOR).",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_ccm_cmeor
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CCM_ANALOG
#endif

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM.
static const field_t hw_ccm_analog_analog_pll_arm[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM_SET.
static const field_t hw_ccm_analog_analog_pll_arm_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM_CLR.
static const field_t hw_ccm_analog_analog_pll_arm_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ARM_TOG.
static const field_t hw_ccm_analog_analog_pll_arm_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL_SEL",
        "Reserved",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1.
static const field_t hw_ccm_analog_analog_pll_usb1[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1_SET.
static const field_t hw_ccm_analog_analog_pll_usb1_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1_CLR.
static const field_t hw_ccm_analog_analog_pll_usb1_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB1_TOG.
static const field_t hw_ccm_analog_analog_pll_usb1_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "Powers the 9-phase PLL outputs for USBPHYn.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2.
static const field_t hw_ccm_analog_analog_pll_usb2[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2_SET.
static const field_t hw_ccm_analog_analog_pll_usb2_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2_CLR.
static const field_t hw_ccm_analog_analog_pll_usb2_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_USB2_TOG.
static const field_t hw_ccm_analog_analog_pll_usb2_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_USB_CLKS",
        "0: 8-phase PLL outputs for USBPHY1 are powered down.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWER",
        "Powers up the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable the PLL clock output.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS.
static const field_t hw_ccm_analog_analog_pll_sys[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_SET.
static const field_t hw_ccm_analog_analog_pll_sys_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_CLR.
static const field_t hw_ccm_analog_analog_pll_sys_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_TOG.
static const field_t hw_ccm_analog_analog_pll_sys_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_SS.
static const field_t hw_ccm_analog_analog_pll_sys_ss[] =
{
    {
        "STEP",
        "Frequency change step = step/CCM_ANALOG_PLL_SYS_DENOM[B]*24MHz.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP",
        "Frequency change = stop/CCM_ANALOG_PLL_SYS_DENOM[B]*24MHz.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_NUM.
static const field_t hw_ccm_analog_analog_pll_sys_num[] =
{
    {
        "A",
        "30 bit numerator (A) of fractional loop divider (signed integer).",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_SYS_DENOM.
static const field_t hw_ccm_analog_analog_pll_sys_denom[] =
{
    {
        "B",
        "30 bit Denominator (B) of fractional loop divider (unsigned integer).",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO.
static const field_t hw_ccm_analog_analog_pll_audio[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_SET.
static const field_t hw_ccm_analog_analog_pll_audio_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_CLR.
static const field_t hw_ccm_analog_analog_pll_audio_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_TOG.
static const field_t hw_ccm_analog_analog_pll_audio_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enable PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_NUM.
static const field_t hw_ccm_analog_analog_pll_audio_num[] =
{
    {
        "A",
        "30 bit numerator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_AUDIO_DENOM.
static const field_t hw_ccm_analog_analog_pll_audio_denom[] =
{
    {
        "B",
        "30 bit Denominator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO.
static const field_t hw_ccm_analog_analog_pll_video[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_SET.
static const field_t hw_ccm_analog_analog_pll_video_set[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_CLR.
static const field_t hw_ccm_analog_analog_pll_video_clr[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_TOG.
static const field_t hw_ccm_analog_analog_pll_video_tog[] =
{
    {
        "DIV_SELECT",
        "This field controls the PLL loop divider.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE",
        "Enalbe PLL output",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIV_SELECT",
        "These bits implement a divider after the PLL, but before the enable an"
        "d bypass mux.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_NUM.
static const field_t hw_ccm_analog_analog_pll_video_num[] =
{
    {
        "A",
        "30 bit numerator of fractional loop divider(Signed number), absolute v"
        "alue should be less than denominator",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_VIDEO_DENOM.
static const field_t hw_ccm_analog_analog_pll_video_denom[] =
{
    {
        "B",
        "30 bit Denominator of fractional loop divider.",
        0, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET.
static const field_t hw_ccm_analog_analog_pll_enet[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET_SET.
static const field_t hw_ccm_analog_analog_pll_enet_set[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET_CLR.
static const field_t hw_ccm_analog_analog_pll_enet_clr[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PLL_ENET_TOG.
static const field_t hw_ccm_analog_analog_pll_enet_tog[] =
{
    {
        "ENET0_DIV_SELECT",
        "Controls the frequency of the ethernet0 reference clock.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_DIV_SELECT",
        "Controls the frequency of the ethernet1 reference clock.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POWERDOWN",
        "Powers down the PLL.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET1_125M_EN",
        "Enable the PLL providing the ENET1 125 MHz reference clock.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS_CLK_SRC",
        "Determines the bypass source.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BYPASS",
        "Bypass the PLL.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_OFFSET_EN",
        "Enables an offset in the phase frequency detector.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_125M",
        "Enables an offset in the phase frequency detector.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET2_125M_EN",
        "Enable the PLL providing the ENET2 125 MHz reference clock",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENET_25M_REF_EN",
        "Enable the PLL providing ENET 25 MHz reference clock",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK",
        "1 - PLL is currently locked; 0 - PLL is not currently locked.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480.
static const field_t hw_ccm_analog_analog_pfd_480[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480_SET.
static const field_t hw_ccm_analog_analog_pfd_480_set[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480_CLR.
static const field_t hw_ccm_analog_analog_pfd_480_clr[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_480_TOG.
static const field_t hw_ccm_analog_analog_pfd_480_tog[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528.
static const field_t hw_ccm_analog_analog_pfd_528[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528_SET.
static const field_t hw_ccm_analog_analog_pfd_528_set[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528_CLR.
static const field_t hw_ccm_analog_analog_pfd_528_clr[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_PFD_528_TOG.
static const field_t hw_ccm_analog_analog_pfd_528_tog[] =
{
    {
        "PFD0_FRAC",
        "This field controls the fractional divide value.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD0_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD0_CLKGATE",
        "If set to 1, the IO fractional divider clock (reference ref_pfd0) is o"
        "ff (power savings).",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_FRAC",
        "This field controls the fractional divide value.",
        8, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD1_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD1_CLKGATE",
        "IO Clock Gate.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_FRAC",
        "This field controls the fractional divide value.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD2_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD2_CLKGATE",
        "IO Clock Gate.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_FRAC",
        "This field controls the fractional divide value.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD3_STABLE",
        "This read-only bitfield is for DIAGNOSTIC PURPOSES ONLY since the frac"
        "tional divider should become stable quickly enough that this field wil"
        "l never need to be used by either device driver or application code.",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PFD3_CLKGATE",
        "IO Clock Gate.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0.
static const field_t hw_ccm_analog_analog_misc0[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISCON_HIGH_SNVS",
        "This bit controls a switch from VDD_HIGH_IN to VDD_SNVS_IN.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0_SET.
static const field_t hw_ccm_analog_analog_misc0_set[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISCON_HIGH_SNVS",
        "This bit controls a switch from VDD_HIGH_IN to VDD_SNVS_IN.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0_CLR.
static const field_t hw_ccm_analog_analog_misc0_clr[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISCON_HIGH_SNVS",
        "This bit controls a switch from VDD_HIGH_IN to VDD_SNVS_IN.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC0_TOG.
static const field_t hw_ccm_analog_analog_misc0_tog[] =
{
    {
        "REFTOP_PWD",
        "Control bit to power-down the analog bandgap reference circuitry.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_SELFBIASOFF",
        "Control bit to disable the self-bias circuit in the analog bandgap.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGADJ",
        "Not related to CCM.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFTOP_VBGUP",
        "Status bit that signals the analog bandgap voltage is up and stable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_MODE_CONFIG",
        "Configure the analog behavior in stop mode.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISCON_HIGH_SNVS",
        "This bit controls a switch from VDD_HIGH_IN to VDD_SNVS_IN.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_I",
        "This field determines the bias current in the 24MHz oscillator.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OSC_XTALOK",
        "Status bit that signals that the output of the 24-MHz crystal oscillat"
        "or is stable.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "OSC_XTALOK_EN",
        "This bit enables the detector that signals when the 24MHz crystal osci"
        "llator is stable.Not related to CCM.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_CTRL",
        "This bit allows disabling the clock gate (always ungated) for the xtal"
        " 24MHz clock that clocks the digital logic in the analog block.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE_DELAY",
        "This field specifies the delay between powering up the XTAL 24MHz cloc"
        "k and releasing the clock to the digital logic inside the analog block"
        ".",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTC_XTAL_SOURCE",
        "This field indicates which chip source is being used for the rtc clock"
        ".Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XTAL_24M_PWD",
        "This field powers down the 24M crystal oscillator if set true.Not rela"
        "ted to CCM.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VID_PLL_PREDIV",
        "Predivider for the source clock of the PLL's.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1.
static const field_t hw_ccm_analog_analog_misc1[] =
{
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1_SET.
static const field_t hw_ccm_analog_analog_misc1_set[] =
{
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1_CLR.
static const field_t hw_ccm_analog_analog_misc1_clr[] =
{
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC1_TOG.
static const field_t hw_ccm_analog_analog_misc1_tog[] =
{
    {
        "PFD_480_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_480 clocks an"
        "ytime the USB1_PLL_480 is unlocked or powered off.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PFD_528_AUTOGATE_EN",
        "This enables a feature that will clkgate (reset) all PFD_528 clocks an"
        "ytime the PLL_528 is unlocked or powered off.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPPANIC",
        "This status bit is set to one when the temperature sensor panic interr"
        "upt asserts for a panic high temperature.Not related to CCM.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPLOW",
        "This status bit is set to one when the temperature sensor low interrup"
        "t asserts for low temperature.Not related to CCM.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_TEMPHIGH",
        "This status bit is set to one when the temperature sensor high interru"
        "pt asserts for high temperature.Not related to CCM.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_ANA_BO",
        "This status bit is set to one when when any of the analog regulator br"
        "ownout interrupts assert.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRQ_DIG_BO",
        "This status bit is set to one when when any of the digital regulator b"
        "rownout interrupts assert.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2.
static const field_t hw_ccm_analog_analog_misc2[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2_SET.
static const field_t hw_ccm_analog_analog_misc2_set[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2_CLR.
static const field_t hw_ccm_analog_analog_misc2_clr[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CCM_ANALOG_ANALOG_MISC2_TOG.
static const field_t hw_ccm_analog_analog_misc2_tog[] =
{
    {
        "REG0_BO_OFFSET",
        "This field defines the brown out voltage offset for the CORE power dom"
        "ain.",
        0, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_BO_STATUS",
        "Reg0 brownout status bit.Not related to CCM.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG0_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLL3_DISABLE",
        "When USB is in low power suspend mode this Control bit is used to indi"
        "cate if other system peripherals require the USB PLL3 clock when the S"
        "oC is not in low power mode.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        8, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_BO_STATUS",
        "Reg1 brownout status bit.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG1_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUDIO_DIV_LSB",
        "LSB of Post-divider for Audio PLL.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_BO_OFFSET",
        "This field defines the brown out voltage offset for the xPU power doma"
        "in.",
        16, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_BO_STATUS",
        "Reg2 brownout status bit.Not related to CCM.",
        19, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REG2_ENABLE_BO",
        "Enables the brownout detection.Not related to CCM.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_OK",
        "Signals that the voltage is above the brownout level for the SOC suppl"
        "y.",
        22, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "AUDIO_DIV_MSB",
        "MSB of Post-divider for Audio PLL.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG0_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG1_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REG2_STEP_TIME",
        "Number of clock periods (24MHz clock).Not related to CCM.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_DIV",
        "Post-divider for video.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CCM_ANALOG module.
static const reg_t hw_ccm_analog[] =
{
    {
        "ANALOG_PLL_ARM",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_arm
    },
    {
        "ANALOG_PLL_ARM_SET",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_arm_set
    },
    {
        "ANALOG_PLL_ARM_CLR",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_arm_clr
    },
    {
        "ANALOG_PLL_ARM_TOG",
        "The control register provides control for the system PLL.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_arm_tog
    },
    {
        "ANALOG_PLL_USB1",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1
    },
    {
        "ANALOG_PLL_USB1_SET",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1_set
    },
    {
        "ANALOG_PLL_USB1_CLR",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1_clr
    },
    {
        "ANALOG_PLL_USB1_TOG",
        "The control register provides control for USBPHY0 480MHz PLL.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb1_tog
    },
    {
        "ANALOG_PLL_USB2",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2
    },
    {
        "ANALOG_PLL_USB2_SET",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2_set
    },
    {
        "ANALOG_PLL_USB2_CLR",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2_clr
    },
    {
        "ANALOG_PLL_USB2_TOG",
        "The control register provides control for USBPHY1 480MHz PLL.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_usb2_tog
    },
    {
        "ANALOG_PLL_SYS",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys
    },
    {
        "ANALOG_PLL_SYS_SET",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_set
    },
    {
        "ANALOG_PLL_SYS_CLR",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_clr
    },
    {
        "ANALOG_PLL_SYS_TOG",
        "The control register provides control for the 528MHz PLL.",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_tog
    },
    {
        "ANALOG_PLL_SYS_SS",
        "This register contains the 528 PLL spread spectrum controls.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_ss
    },
    {
        "ANALOG_PLL_SYS_NUM",
        "This register contains the numerator of 528MHz PLL fractional loop div"
        "ider (signed number).",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_num
    },
    {
        "ANALOG_PLL_SYS_DENOM",
        "This register contains the Denominator of 528MHz PLL fractional loop d"
        "ivider.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_sys_denom
    },
    {
        "ANALOG_PLL_AUDIO",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio
    },
    {
        "ANALOG_PLL_AUDIO_SET",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_set
    },
    {
        "ANALOG_PLL_AUDIO_CLR",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_clr
    },
    {
        "ANALOG_PLL_AUDIO_TOG",
        "The control register provides control for the audio PLL.",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_tog
    },
    {
        "ANALOG_PLL_AUDIO_NUM",
        "This register contains the numerator (A) of Audio PLL fractional loop "
        "divider.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_num
    },
    {
        "ANALOG_PLL_AUDIO_DENOM",
        "This register contains the Denominator (B) of Audio PLL fractional loo"
        "p divider.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_audio_denom
    },
    {
        "ANALOG_PLL_VIDEO",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video
    },
    {
        "ANALOG_PLL_VIDEO_SET",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000a4, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video_set
    },
    {
        "ANALOG_PLL_VIDEO_CLR",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000a8, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video_clr
    },
    {
        "ANALOG_PLL_VIDEO_TOG",
        "The control register provides control for the Video PLL.",
        4, // Width in bytes
        0x000000ac, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ccm_analog_analog_pll_video_tog
    },
    {
        "ANALOG_PLL_VIDEO_NUM",
        "This register contains the numerator (A) of Video PLL fractional loop "
        "divider.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_video_num
    },
    {
        "ANALOG_PLL_VIDEO_DENOM",
        "This register contains the Denominator (B) of Video PLL fractional loo"
        "p divider.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_ccm_analog_analog_pll_video_denom
    },
    {
        "ANALOG_PLL_ENET",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet
    },
    {
        "ANALOG_PLL_ENET_SET",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet_set
    },
    {
        "ANALOG_PLL_ENET_CLR",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet_clr
    },
    {
        "ANALOG_PLL_ENET_TOG",
        "The control register provides control for the ENET PLL.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_ccm_analog_analog_pll_enet_tog
    },
    {
        "ANALOG_PFD_480",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480
    },
    {
        "ANALOG_PFD_480_SET",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000f4, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480_set
    },
    {
        "ANALOG_PFD_480_CLR",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000f8, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480_clr
    },
    {
        "ANALOG_PFD_480_TOG",
        "The PFD_480 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x000000fc, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_480_tog
    },
    {
        "ANALOG_PFD_528",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528
    },
    {
        "ANALOG_PFD_528_SET",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x00000104, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528_set
    },
    {
        "ANALOG_PFD_528_CLR",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x00000108, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528_clr
    },
    {
        "ANALOG_PFD_528_TOG",
        "The PFD_528 control register provides control for PFD clock generation"
        ".",
        4, // Width in bytes
        0x0000010c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_ccm_analog_analog_pfd_528_tog
    },
    {
        "ANALOG_MISC0",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000150, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0
    },
    {
        "ANALOG_MISC0_SET",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000154, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0_set
    },
    {
        "ANALOG_MISC0_CLR",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000158, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0_clr
    },
    {
        "ANALOG_MISC0_TOG",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x0000015c, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_ccm_analog_analog_misc0_tog
    },
    {
        "ANALOG_MISC1",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000160, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_misc1
    },
    {
        "ANALOG_MISC1_SET",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000164, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_misc1_set
    },
    {
        "ANALOG_MISC1_CLR",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x00000168, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_misc1_clr
    },
    {
        "ANALOG_MISC1_TOG",
        "This register defines the control and status bits for miscellaneous an"
        "alog blocks.",
        4, // Width in bytes
        0x0000016c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ccm_analog_analog_misc1_tog
    },
    {
        "ANALOG_MISC2",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x00000170, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2
    },
    {
        "ANALOG_MISC2_SET",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x00000174, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2_set
    },
    {
        "ANALOG_MISC2_CLR",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x00000178, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2_clr
    },
    {
        "ANALOG_MISC2_TOG",
        "This register defines the control for miscellaneous analog blocks.",
        4, // Width in bytes
        0x0000017c, // Base address offset
        true, // Readable
        true, // Writable
        17, // Number of bitfields
        hw_ccm_analog_analog_misc2_tog
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark CSI
#endif

// Bitfields in register CSI_CSICR1.
static const field_t hw_csi_csicr1[] =
{
    {
        "PIXEL_BIT",
        "Pixel Bit.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REDGE",
        "Valid Pixel Clock Edge Select.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INV_PCLK",
        "Invert Pixel Clock Input.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INV_DATA",
        "Invert Data Input.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GCLK_MODE",
        "Gated Clock Mode Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_RXFIFO",
        "Asynchronous RXFIFO Clear.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLR_STATFIFO",
        "Asynchronous STATFIFO Clear.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PACK_DIR",
        "Data Packing Direction.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCC",
        "FIFO Clear Control.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CCIR_EN",
        "CCIR656 Interface Enable.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HSYNC_POL",
        "HSYNC Polarity Select.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_INTEN",
        "Start Of Frame (SOF) Interrupt Enable.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_POL",
        "SOF Interrupt Polarity.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_INTEN",
        "RxFIFO Full Interrupt Enable.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB1_DMA_DONE_INTEN",
        "Frame Buffer1 DMA Transfer Done Interrupt Enable.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FB2_DMA_DONE_INTEN",
        "Frame Buffer2 DMA Transfer Done Interrupt Enable.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_INTEN",
        "STATFIFO Full Interrupt Enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFF_DMA_DONE_INTEN",
        "STATFIFO DMA Transfer Done Interrupt Enable.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RF_OR_INTEN",
        "RxFIFO Overrun Interrupt Enable.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SF_OR_INTEN",
        "STAT FIFO Overrun Interrupt Enable.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COF_INT_EN",
        "Change Of Image Field (COF) Interrupt Enable.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VIDEO_MODE",
        "Video mode select.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRP_IF_EN",
        "CSI-PrP Interface Enable.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOF_INT_EN",
        "End-of-Frame Interrupt Enable.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EXT_VSYNC",
        "External VSYNC Enable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWAP16_EN",
        "SWAP 16-Bit Enable.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR2.
static const field_t hw_csi_csicr2[] =
{
    {
        "HSC",
        "Horizontal Skip Count.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VSC",
        "Vertical Skip Count.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LVRM",
        "Live View Resolution Mode.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BTS",
        "Bayer Tile Start.",
        19, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCE",
        "Skip Count Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AFS",
        "Auto Focus Spread.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRM",
        "Double Resolution Mode.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_BURST_TYPE_SFF",
        "Burst Type of DMA Transfer from STATFIFO.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_BURST_TYPE_RFF",
        "Burst Type of DMA Transfer from RxFIFO.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR3.
static const field_t hw_csi_csicr3[] =
{
    {
        "ECC_AUTO_EN",
        "Automatic Error Correction Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_INT_EN",
        "Error Detection Interrupt Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ZERO_PACK_EN",
        "Dummy Zero Packing Enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWO_8BIT_SENSOR",
        "Two 8-bit Sensor Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_LEVEL",
        "RxFIFO Full Level.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HRESP_ERR_EN",
        "Hresponse Error Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_LEVEL",
        "STATFIFO Full Level.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REQ_EN_SFF",
        "DMA Request Enable for STATFIFO.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REQ_EN_RFF",
        "DMA Request Enable for RxFIFO.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REFLASH_SFF",
        "Reflash DMA Controller for STATFIFO.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_REFLASH_RFF",
        "Reflash DMA Controller for RxFIFO.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRMCNT_RST",
        "Frame Count Reset.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRMCNT",
        "Frame Counter.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSISTATFIFO.
static const field_t hw_csi_csistatfifo[] =
{
    {
        "STAT",
        "Static data from sensor",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIRFIFO.
static const field_t hw_csi_csirfifo[] =
{
    {
        "IMAGE",
        "Received image data",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIRXCNT.
static const field_t hw_csi_csirxcnt[] =
{
    {
        "RXCNT",
        "RxFIFO Count.",
        0, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSISR.
static const field_t hw_csi_csisr[] =
{
    {
        "DRDY",
        "RXFIFO Data Ready.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_INT",
        "CCIR Error Interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HRESP_ERR_INT",
        "Hresponse Error Interrupt Status.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COF_INT",
        "Change Of Field Interrupt Status.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "F1_INT",
        "CCIR Field 1 Interrupt Status.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "F2_INT",
        "CCIR Field 2 Interrupt Status.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SOF_INT",
        "Start of Frame Interrupt Status.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EOF_INT",
        "End of Frame (EOF) Interrupt Status.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXFF_INT",
        "RXFIFO Full Interrupt Status.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_FB1",
        "DMA Transfer Done in Frame Buffer1.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_FB2",
        "DMA Transfer Done in Frame Buffer2.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STATFF_INT",
        "STATFIFO Full Interrupt Status.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_TSF_DONE_SFF",
        "DMA Transfer Done from StatFIFO.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RF_OR_INT",
        "RxFIFO Overrun Interrupt Status.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SF_OR_INT",
        "STATFIFO Overrun Interrupt Status.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_FIELD1_DONE",
        "When DMA field 0 is complete, this bit will be set to 1(clear by writi"
        "ng 1).",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_FIELD0_DONE",
        "When DMA field 0 is complete, this bit will be set to 1(clear by writi"
        "ng 1).",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_CHHANGE_ERROR",
        "When using base address switching enable, this bit will be 1 when swit"
        "ching occur before DMA complete.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_STATFIFO.
static const field_t hw_csi_csidmasa_statfifo[] =
{
    {
        "DMA_START_ADDR_SFF",
        "DMA Start Address for STATFIFO.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMATS_STATFIFO.
static const field_t hw_csi_csidmats_statfifo[] =
{
    {
        "DMA_TSF_SIZE_SFF",
        "DMA Transfer Size for STATFIFO.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_FB1.
static const field_t hw_csi_csidmasa_fb1[] =
{
    {
        "DMA_START_ADDR_FB1",
        "DMA Start Address in Frame Buffer1.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIDMASA_FB2.
static const field_t hw_csi_csidmasa_fb2[] =
{
    {
        "DMA_START_ADDR_FB2",
        "DMA Start Address in Frame Buffer2.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIFBUF_PARA.
static const field_t hw_csi_csifbuf_para[] =
{
    {
        "FBUF_STRIDE",
        "Frame Buffer Parameter.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEINTERLACE_STRIDE",
        "DEINTERLACE_STRIDE is only used in the deinterlace mode.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSIIMAG_PARA.
static const field_t hw_csi_csiimag_para[] =
{
    {
        "IMAGE_HEIGHT",
        "Image Height.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IMAGE_WIDTH",
        "Image Width.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register CSI_CSICR18.
static const field_t hw_csi_csicr18[] =
{
    {
        "NTSC_EN",
        "This bit is used to select NTSC/PAL mode When input is TVDECODER or st"
        "andard CCIR656 video.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEINTERLACE_EN",
        "This bit is used to select the output method When input is standard CC"
        "IR656 video.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PARALLEL24_EN",
        "When input is parallel rgb888/yuv444 24bit, this bit can be enabled.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_SWITCH_EN",
        "When this bit is enabled, CSI DMA will switch the base address accordi"
        "ng to BASEADDR_SWITCH_SEL rather than atomically by DMA completed.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_SWITCH_SEL",
        "CSI 2 base addresses switching method.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FIELD0_DONE_IE",
        "In interlace mode, fileld 0 means interrupt enabled.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA_FIELD1_DONE_IE",
        "When in interlace mode, field 1 done interrupt enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LAST_DMA_REQ_SEL",
        "Choosing the last DMA request condition.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BASEADDR_CHANGE_ERROR_IE",
        "Base address change error interrupt enable signal.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RGB888A_FORMAT_SEL",
        "Output is 32-bit format.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AHB_HPROT",
        "Hprot value in AHB bus protocol.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_LCDIF_BUFFER_LINES",
        "The number of lines are used in handshake mode with LCDIF.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK_OPTION",
        "These bits used to choose the method to mask the CSI input.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSI_ENABLE",
        "CSI global enable signal.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a CSI module.
static const reg_t hw_csi[] =
{
    {
        "CSICR1",
        "This register controls the sensor interface timing and interrupt gener"
        "ation.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        26, // Number of bitfields
        hw_csi_csicr1
    },
    {
        "CSICR2",
        "This register provides the statistic block with data about which live "
        "view resolution is being used, and the starting sensor pixel of the Ba"
        "yer pattern.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_csi_csicr2
    },
    {
        "CSICR3",
        "This read/write register acts as an extension of the functionality of "
        "the CSI Control register 1, adding additional control and features.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_csi_csicr3
    },
    {
        "CSISTATFIFO",
        "The StatFIFO is a read-only register containing statistic data from th"
        "e sensor.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_csi_csistatfifo
    },
    {
        "CSIRFIFO",
        "This read-only register contains received image data.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_csi_csirfifo
    },
    {
        "CSIRXCNT",
        "This register works for EOF interrupt generation.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csirxcnt
    },
    {
        "CSISR",
        "This read/write register shows sensor interface status, and which kind"
        " of interrupt is being generated.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_csi_csisr
    },
    {
        "CSIDMASA_STATFIFO",
        "This register provides the start address for the embedded DMA controll"
        "er of STATFIFO.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_statfifo
    },
    {
        "CSIDMATS_STATFIFO",
        "This register provides the total transfer size for the embedded DMA co"
        "ntroller of STATFIFO.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmats_statfifo
    },
    {
        "CSIDMASA_FB1",
        "This register provides the start address in the frame buffer1 for the "
        "embedded DMA controller of RxFIFO.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_fb1
    },
    {
        "CSIDMASA_FB2",
        "This register provides the start address in the frame buffer2 for the "
        "embedded DMA controller of RxFIFO.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_csi_csidmasa_fb2
    },
    {
        "CSIFBUF_PARA",
        "This register provides the stride of the frame buffer to show how many"
        " words to skip before starting to write the next row of the image.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_csi_csifbuf_para
    },
    {
        "CSIIMAG_PARA",
        "This register provides the width and the height of the image from the "
        "sensor.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_csi_csiimag_para
    },
    {
        "CSICR18",
        "This read/write register acts as an extension of the functionality of "
        "the CSI Control register 1",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        14, // Number of bitfields
        hw_csi_csicr18
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ECSPI
#endif

// Bitfields in register ECSPI_RXDATA.
static const field_t hw_ecspi_rxdata[] =
{
    {
        "ECSPI_RXDATA",
        "Receive Data.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_TXDATA.
static const field_t hw_ecspi_txdata[] =
{
    {
        "ECSPI_TXDATA",
        "Transmit Data.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_CONREG.
static const field_t hw_ecspi_conreg[] =
{
    {
        "EN",
        "SPI Block Enable Control.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HT",
        "Hardware Trigger Enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XCH",
        "SPI Exchange Bit.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMC",
        "Start Mode Control.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHANNEL_MODE",
        "SPI CHANNEL MODE selects the mode for each SPI channel.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POST_DIVIDER",
        "SPI Post Divider.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRE_DIVIDER",
        "SPI Pre Divider.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRCTL",
        "SPI Data Ready Control.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CHANNEL_SELECT",
        "SPI CHANNEL SELECT bits.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BURST_LENGTH",
        "Burst Length.",
        20, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_CONFIGREG.
static const field_t hw_ecspi_configreg[] =
{
    {
        "SCLK_PHA",
        "SPI Clock/Data Phase Control.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCLK_POL",
        "SPI Clock Polarity Control.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SS_CTL",
        "SPI SS Wave Form Select.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SS_POL",
        "SPI SS Polarity Select.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_CTL",
        "DATA CTL.",
        16, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCLK_CTL",
        "SCLK CTL.",
        20, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HT_LENGTH",
        "HT LENGTH.",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_INTREG.
static const field_t hw_ecspi_intreg[] =
{
    {
        "TEEN",
        "TXFIFO Empty Interrupt enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDREN",
        "TXFIFO Data Request Interrupt enable.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFEN",
        "TXFIFO Full Interrupt enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RREN",
        "RXFIFO Ready Interrupt enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDREN",
        "RXFIFO Data Request Interrupt enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFEN",
        "RXFIFO Full Interrupt enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROEN",
        "RXFIFO Overflow Interrupt enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCEN",
        "Transfer Completed Interrupt enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_DMAREG.
static const field_t hw_ecspi_dmareg[] =
{
    {
        "TX_THRESHOLD",
        "TX THRESHOLD.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEDEN",
        "TXFIFO Empty DMA Request Enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_THRESHOLD",
        "RX THRESHOLD.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXDEN",
        "RXFIFO DMA Request Enable.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_DMA_LENGTH",
        "RX DMA LENGTH.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXTDEN",
        "RXFIFO TAIL DMA Request Enable.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_STATREG.
static const field_t hw_ecspi_statreg[] =
{
    {
        "TE",
        "TXFIFO Empty.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TDR",
        "TXFIFO Data Request.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TF",
        "TXFIFO Full.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RR",
        "RXFIFO Ready.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RDR",
        "RXFIFO Data Request.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RF",
        "RXFIFO Full.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RO",
        "RXFIFO Overflow.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TC",
        "Transfer Completed Status bit.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_PERIODREG.
static const field_t hw_ecspi_periodreg[] =
{
    {
        "SAMPLE_PERIOD",
        "Sample Period Control.",
        0, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSRC",
        "Clock Source Control.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSD_CTL",
        "Chip Select Delay Control bits.",
        16, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_TESTREG.
static const field_t hw_ecspi_testreg[] =
{
    {
        "TXCNT",
        "TXFIFO Counter.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXCNT",
        "RXFIFO Counter.",
        8, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBC",
        "Loop Back Control.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ECSPI_MSGDATA.
static const field_t hw_ecspi_msgdata[] =
{
    {
        "ECSPI_MSGDATA",
        "ECSPI_MSGDATA holds the top word of MSG Data FIFO.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a ECSPI module.
static const reg_t hw_ecspi[] =
{
    {
        "RXDATA",
        "The Receive Data register (ECSPI_RXDATA) is a read-only register that "
        "forms the top word of the 64 x 32 receive FIFO.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ecspi_rxdata
    },
    {
        "TXDATA",
        "The Transmit Data (ECSPI_TXDATA) register is a write-only data registe"
        "r that forms the bottom word of the 64 x 32 TXFIFO.",
        4, // Width in bytes
        0x00000004, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ecspi_txdata
    },
    {
        "CONREG",
        "The Control Register (ECSPI_CONREG) allows software to enable the ECSP"
        "I , configure its operating modes, specify the divider value, and SPI_"
        "RDY control signal, and define the transfer length.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_ecspi_conreg
    },
    {
        "CONFIGREG",
        "The Config Register (ECSPI_CONFIGREG) allows software to configure eac"
        "h SPI channel, configure its operating modes, specify the phase and po"
        "larity of the clock, configure the Chip Select (SS), and define the HT"
        " transfer length.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_ecspi_configreg
    },
    {
        "INTREG",
        "The Interrupt Control Register (ECSPI_INTREG) enables the generation o"
        "f interrupts to the host processor.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ecspi_intreg
    },
    {
        "DMAREG",
        "The Direct Memory Access Control Register (ECSPI_DMAREG) provides soft"
        "ware a way to use an on-chip DMA controller for ECSPI data.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_ecspi_dmareg
    },
    {
        "STATREG",
        "The ECSPI Status Register (ECSPI_STATREG) reflects the status of the E"
        "CSPI's operating condition.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_ecspi_statreg
    },
    {
        "PERIODREG",
        "The Sample Period Control Register (ECSPI_PERIODREG) provides software"
        " a way to insert delays (wait states) between consecutive SPI transfer"
        "s.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ecspi_periodreg
    },
    {
        "TESTREG",
        "The Test Control Register (ECSPI_TESTREG) provides software a mechanis"
        "m to internally connect the receive and transmit devices of the ECSPI "
        ", and monitor the contents of the receive and transmit FIFOs.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_ecspi_testreg
    },
    {
        "MSGDATA",
        "The Message Data Register (ECSPI_MSGDATA) forms the top word of the 16"
        " x 32 MSG Data FIFO.",
        4, // Width in bytes
        0x00000040, // Base address offset
        false, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_ecspi_msgdata
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EIM
#endif

// Bitfields in register EIM_CS0GCR1.
static const field_t hw_eim_cs0gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0GCR2.
static const field_t hw_eim_cs0gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0RCR1.
static const field_t hw_eim_cs0rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0RCR2.
static const field_t hw_eim_cs0rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0WCR1.
static const field_t hw_eim_cs0wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS0WCR2.
static const field_t hw_eim_cs0wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1GCR1.
static const field_t hw_eim_cs1gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1GCR2.
static const field_t hw_eim_cs1gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1RCR1.
static const field_t hw_eim_cs1rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1RCR2.
static const field_t hw_eim_cs1rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1WCR1.
static const field_t hw_eim_cs1wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS1WCR2.
static const field_t hw_eim_cs1wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2GCR1.
static const field_t hw_eim_cs2gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2GCR2.
static const field_t hw_eim_cs2gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2RCR1.
static const field_t hw_eim_cs2rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2RCR2.
static const field_t hw_eim_cs2rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2WCR1.
static const field_t hw_eim_cs2wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS2WCR2.
static const field_t hw_eim_cs2wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3GCR1.
static const field_t hw_eim_cs3gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3GCR2.
static const field_t hw_eim_cs3gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3RCR1.
static const field_t hw_eim_cs3rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3RCR2.
static const field_t hw_eim_cs3rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3WCR1.
static const field_t hw_eim_cs3wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS3WCR2.
static const field_t hw_eim_cs3wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4GCR1.
static const field_t hw_eim_cs4gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4GCR2.
static const field_t hw_eim_cs4gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4RCR1.
static const field_t hw_eim_cs4rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4RCR2.
static const field_t hw_eim_cs4rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4WCR1.
static const field_t hw_eim_cs4wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS4WCR2.
static const field_t hw_eim_cs4wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5GCR1.
static const field_t hw_eim_cs5gcr1[] =
{
    {
        "CSEN",
        "CS Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Synchronous Write Data.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRD",
        "Synchronous Read Data.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUM",
        "Multiplexed Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WFL",
        "Write Fix Latency.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFL",
        "Read Fix Latency.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRE",
        "Configuration Register Enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CREP",
        "Configuration Register Enable Polarity.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BL",
        "Burst Length.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WC",
        "Write Continuous.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Burst Clock Divisor.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "Burst Clock Start.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DSZ",
        "Data Port Size.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SP",
        "Supervisor Protect.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CSREC",
        "CS Recovery.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AUS",
        "Address UnShifted.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBC",
        "Gap Between Chip Selects.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WP",
        "Write Protect.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSZ",
        "Page Size.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5GCR2.
static const field_t hw_eim_cs5gcr2[] =
{
    {
        "ADH",
        "Address hold time - This bit field determine the address hold time aft"
        "er ADV negation when mum = 1 (muxed mode).",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAPS",
        "Data Acknowledge Poling Start.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAE",
        "Data Acknowledge Enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DAP",
        "Data Acknowledge Polarity.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MUX16_BYP_GRANT",
        "Muxed 16 bypass grant.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5RCR1.
static const field_t hw_eim_cs5rcr1[] =
{
    {
        "RCSN",
        "Read CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCSA",
        "Read CS Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEN",
        "OE Negation.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OEA",
        "OE Assertion.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVN",
        "ADV Negation.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RAL",
        "Read ADV Low.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RADVA",
        "ADV Assertion.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWSC",
        "Read Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5RCR2.
static const field_t hw_eim_cs5rcr2[] =
{
    {
        "RBEN",
        "Read BE Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBE",
        "Read BE enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RBEA",
        "Read BE Assertion.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Read Latency.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAT",
        "Page Access Time.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "APR",
        "Asynchronous Page Read.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5WCR1.
static const field_t hw_eim_cs5wcr1[] =
{
    {
        "WCSN",
        "Write CS Negation.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WCSA",
        "Write CS Assertion.",
        3, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEN",
        "WE Negation.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WEA",
        "WE Assertion.",
        9, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEN",
        "BE[3:0] Negation.",
        12, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBEA",
        "BE Assertion.",
        15, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVN",
        "ADV Negation.",
        18, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WADVA",
        "ADV Assertion.",
        21, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WWSC",
        "Write Wait State Control.",
        24, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WBED",
        "Write Byte Enable Disable.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAL",
        "Write ADV Low.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_CS5WCR2.
static const field_t hw_eim_cs5wcr2[] =
{
    {
        "WBCDD",
        "Write Burst Clock Divisor Decrement.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EIM_WCR.
static const field_t hw_eim_wcr[] =
{
    {
        "BCM",
        "Burst Clock Mode.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GBCD",
        "General Burst Clock Divisor.",
        1, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CONT_BCLK_SEL",
        "When this bit is set BCLK pin output continuous clock.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTEN",
        "Interrupt Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INTPOL",
        "Interrupt Polarity.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WDOG_EN",
        "Memory WDOG enable.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WDOG_LIMIT",
        "Memory Watchdog (WDOG) cycle limit.",
        9, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRUN_ACLK_EN",
        "",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a EIM module.
static const reg_t hw_eim[] =
{
    {
        "CS0GCR1",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs0gcr1
    },
    {
        "CS0GCR2",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs0gcr2
    },
    {
        "CS0RCR1",
        "",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs0rcr1
    },
    {
        "CS0RCR2",
        "",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs0rcr2
    },
    {
        "CS0WCR1",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs0wcr1
    },
    {
        "CS0WCR2",
        "",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs0wcr2
    },
    {
        "CS1GCR1",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs1gcr1
    },
    {
        "CS1GCR2",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs1gcr2
    },
    {
        "CS1RCR1",
        "",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs1rcr1
    },
    {
        "CS1RCR2",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs1rcr2
    },
    {
        "CS1WCR1",
        "",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs1wcr1
    },
    {
        "CS1WCR2",
        "",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs1wcr2
    },
    {
        "CS2GCR1",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs2gcr1
    },
    {
        "CS2GCR2",
        "",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs2gcr2
    },
    {
        "CS2RCR1",
        "",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs2rcr1
    },
    {
        "CS2RCR2",
        "",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs2rcr2
    },
    {
        "CS2WCR1",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs2wcr1
    },
    {
        "CS2WCR2",
        "",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs2wcr2
    },
    {
        "CS3GCR1",
        "",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs3gcr1
    },
    {
        "CS3GCR2",
        "",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs3gcr2
    },
    {
        "CS3RCR1",
        "",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs3rcr1
    },
    {
        "CS3RCR2",
        "",
        4, // Width in bytes
        0x00000054, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs3rcr2
    },
    {
        "CS3WCR1",
        "",
        4, // Width in bytes
        0x00000058, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs3wcr1
    },
    {
        "CS3WCR2",
        "",
        4, // Width in bytes
        0x0000005c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs3wcr2
    },
    {
        "CS4GCR1",
        "",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs4gcr1
    },
    {
        "CS4GCR2",
        "",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs4gcr2
    },
    {
        "CS4RCR1",
        "",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs4rcr1
    },
    {
        "CS4RCR2",
        "",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs4rcr2
    },
    {
        "CS4WCR1",
        "",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs4wcr1
    },
    {
        "CS4WCR2",
        "",
        4, // Width in bytes
        0x00000074, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs4wcr2
    },
    {
        "CS5GCR1",
        "",
        4, // Width in bytes
        0x00000078, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_eim_cs5gcr1
    },
    {
        "CS5GCR2",
        "",
        4, // Width in bytes
        0x0000007c, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_eim_cs5gcr2
    },
    {
        "CS5RCR1",
        "",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_cs5rcr1
    },
    {
        "CS5RCR2",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_eim_cs5rcr2
    },
    {
        "CS5WCR1",
        "",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_eim_cs5wcr1
    },
    {
        "CS5WCR2",
        "",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_eim_cs5wcr2
    },
    {
        "WCR",
        "",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_eim_wcr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EMVSIM
#endif

// Bitfields in register EMVSIM_VER_ID.
static const field_t hw_emvsim_ver_id[] =
{
    {
        "VER",
        "EMV SIM Version Number used on the chip 31:16 - Major Version (example"
        ": 01.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_PARAM.
static const field_t hw_emvsim_param[] =
{
    {
        "RX_FIFO_DEPTH",
        "Value of parameter for Receive FIFO Depth (in Bytes)",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TX_FIFO_DEPTH",
        "Value of parameter for Transmit FIFO Depth (in Bytes)",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_CLKCFG.
static const field_t hw_emvsim_clkcfg[] =
{
    {
        "CLK_PRSC",
        "The value written to this register will determine the desired card clo"
        "ck frequency.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPCNT1_CLK_SEL",
        "Selects which clock source is used by EMV SIM Module general purpose c"
        "ounter 1.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPCNT0_CLK_SEL",
        "Selects which clock source is used by EMV SIM Module general purpose c"
        "ounter 0.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_DIVISOR.
static const field_t hw_emvsim_divisor[] =
{
    {
        "DIVISOR_VALUE",
        "The value written to this register will be used to generate the ETU bi"
        "t period that will be used by the transmitter and receiver.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_CTRL.
static const field_t hw_emvsim_ctrl[] =
{
    {
        "IC",
        "Used to configure the EMV SIM to use either inverse convention or dire"
        "ct convention for its data format.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICM",
        "Enables initial character mode.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ANACK",
        "Enables NACK generation for parity errors in receieved messages or whe"
        "n invalid initial characters are received in ICM mode.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ONACK",
        "Enables NACK generation when Rx FIFO is full and another message is re"
        "ady for writing into the FIFO.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FLSH_RX",
        "This bit operates as an EMV SIM receiver reset.",
        8, // LSB
        8, // MSB
        false, // Readable
        false // Writable
    },
    {
        "FLSH_TX",
        "This bit operates as an EMV SIM transmitter reset.",
        9, // LSB
        9, // MSB
        false, // Readable
        false // Writable
    },
    {
        "SW_RST",
        "Used to reset the entire EMV SIM module.",
        10, // LSB
        10, // MSB
        false, // Readable
        false // Writable
    },
    {
        "KILL_CLOCKS",
        "Used to enable/disable the clock input to the EMV SIM module.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOZE_EN",
        "Used to configure the operation of the EMV SIM module when a processor"
        " DOZE instruction is executed.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOP_EN",
        "Used to configure the operation of the EMV SIM module when a processor"
        " STOP instruction is executed.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCV_EN",
        "Used to enable/disable the EMV SIM receiver block.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XMT_EN",
        "Used to enable/disable the EMV SIM transmitter block.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCVR_11",
        "Used to configure the EMV SIM module receiver for 11 ETU operation (th"
        "at is, 1 Stop bit).",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_DMA_EN",
        "Enables assertion of DMA read request when Receive FIFO reaches the pr"
        "ogrammed data threshold value.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TX_DMA_EN",
        "Enables assertion of DMA write request when Transmit FIFO is empty.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INV_CRC_VAL",
        "This bit control whether the bits within the CRC Output value will be "
        "inverted (1's complement) or not.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRC_OUT_FLIP",
        "This bit control whether the bits in the CRC output bytes will be reve"
        "rsed or not.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRC_IN_FLIP",
        "This bit control whether the bits in the CRC input byte will be revers"
        "ed before CRC calculation or not.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CWT_EN",
        "Enables the character wait time counter.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LRC_EN",
        "This bit enables the calculation of the 8-bit LRC value for both recei"
        "ver and transmitter.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRC_EN",
        "This bit enables the calculation of the 16-bit CRC value for both rece"
        "iver and transmitter.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "XMT_CRC_LRC",
        "This bit specifies whether or not to transmit the redundancy checking "
        "data (LRC or CRC) at the end of a transmission (that is, when the FIFO"
        " becomes empty).",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWT_EN",
        "Writing a '1' to this bit will enable the BWT and BGT functions.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_INT_MASK.
static const field_t hw_emvsim_int_mask[] =
{
    {
        "RDT_IM",
        "Used to enable/disable the ability of the RDTF flag in the RX_STATUS r"
        "egister to generate EMV SIM interrupts.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TC_IM",
        "Used to enable/disable the ability of the TCF flag in the TX_STATUS re"
        "gister to generate EMV SIM interrupts.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFO_IM",
        "Used to enable/disable the ability of the RFO flag in the RX_STATUS re"
        "gister to generate EMV SIM interrupts.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ETC_IM",
        "Used to enable/disable the ability of the ETC flag in the TX_STATUS re"
        "gister to generate EMV SIM interrupts.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFE_IM",
        "Used to enable/disable the ability of the TFE flag in the TX_STATUS re"
        "gister to generate EMV SIM interrupts.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TNACK_IM",
        "Used to enable/disable the ability of the TNTE flag in the TX_STATUS r"
        "egister to generate EMV SIM interrupts.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFF_IM",
        "Used to enable/disable the ability of the TFF flag in the TX_STATUS re"
        "gister to generate EMV SIM interrupts.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDT_IM",
        "Used to enable/disable the ability of the TDTF flag in the TX_STATUS r"
        "egister to generate EMV SIM interrupts.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPCNT0_IM",
        "Used to enable/disable the ability of the GPCNT0_TO flag in the TX_STA"
        "TUS register to generate EMV SIM interrupts.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CWT_ERR_IM",
        "Used to enable/disable the ability of the CWT_ERR flag in the RX_STATU"
        "S register to generate EMV SIM interrupts.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RNACK_IM",
        "Used to enable/disable the ability of the RTE flag in the RX_STATUS re"
        "gister to generate EMV SIM interrupts.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWT_ERR_IM",
        "Used to enable/disable the ability of the BWT_ERR flag in the RX_STATU"
        "S register to generate EMV SIM interrupts.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BGT_ERR_IM",
        "Used to enable/disable the ability of the BGT_ERR flag in the RX_STATU"
        "S register to generate EMV SIM interrupts.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPCNT1_IM",
        "Used to enable/disable the ability of the GPCNT1_TO flag in the TX_STA"
        "TUS register to generate EMV SIM interrupts.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_DATA_IM",
        "Used to enable/disable the ability of the RX_DATA flag in the RX_STATU"
        "S register to generate EMV SIM interrupts.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PEF_IM",
        "Used to enable/disable the ability of the PEF flag in the RX_STATUS re"
        "gister to generate EMV SIM interrupts.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_RX_THD.
static const field_t hw_emvsim_rx_thd[] =
{
    {
        "RDT",
        "Determines the number of bytes that must exist in the Receive FIFO to "
        "trigger the receive data threshold interrupt flag (RDTF).",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RNCK_THD",
        "Used to specify the number of consecutive NACK's transmitted by the EM"
        "V SIM module, for a given character, before the receive threshold erro"
        "r (RTE) flag is triggered.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_TX_THD.
static const field_t hw_emvsim_tx_thd[] =
{
    {
        "TDT",
        "Used to set the threshold value for the Transmit FIFO at which the TDT"
        "F bit in the TX_STATUS register will be set.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TNCK_THD",
        "Used to set the NACK threshold for the transmitter.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_RX_STATUS.
static const field_t hw_emvsim_rx_status[] =
{
    {
        "RFO",
        "Used to indicate that the EMV SIM was unable to store received data du"
        "e to already unread bytes in the FIFO (FIFO full or almost full).",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_DATA",
        "Interrupt asserted when a new data byte is received and entered into t"
        "he Receive FIFO.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDTF",
        "Interrupt flag asserted when total bytes in the Receive FIFO equal or "
        "is greater than the programmed receive threshold RDT[3:0].",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LRC_OK",
        "Used to indicate when the calculated 8-bit LRC value is correct for th"
        "e current input data stream.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CRC_OK",
        "Used to indicate when the calculated 16-bit CRC value matches the expe"
        "cted value for the current input data stream.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CWT_ERR",
        "Used to indicate when the time between received characters is equal to"
        " or greater than the value programmed in the CHAR_WAIT register.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RTE",
        "Used to indicate whether the number of consecutive NACK's generated by"
        " the EMV SIM module in response to receive parity errors, for the byte"
        " being received, equals the value programmed in the RTH[3:0] in the RX"
        "_THRESHOLD register.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BWT_ERR",
        "Used to indicate if the block wait time has been exceeded.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BGT_ERR",
        "Used to indicate if the block guard time was too small.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PEF",
        "Used to indicate if a received byte had a parity error or not.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FEF",
        "Used to indicate if the current received byte did not have proper STOP"
        " bits.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_WPTR",
        "Value of write pointer of Receive FIFO",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_CNT",
        "These bits indicate the number of bytes stored in the receive FIFO.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_TX_STATUS.
static const field_t hw_emvsim_tx_status[] =
{
    {
        "TNTE",
        "Used to indicate the transmit NACK threshold has been reached.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFE",
        "Used to indicate that the EMV SIM transmit FIFO has been emptied.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ETCF",
        "Used to indicate that the EMV SIM transmitter has finished sending the"
        " last byte in transmit FIFO (if XMT_CRC_LRC = 0) or finished sending t"
        "he LRC or CRC byte (if XMT_CRC_LRC = 1).",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCF",
        "Used to indicate whether the EMV SIM transmitter is ready for a new tr"
        "ansmission.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFF",
        "Used to indicate when the Transmit FIFO has been written with maximum "
        "number of bytes that it can store.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TDTF",
        "Interrupt flag asserted when total bytes in the Transmit FIFO is less "
        "than or equal to the programmed transmit data threshold TDT[3:0].",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "GPCNT0_TO",
        "Used to indicate when the General Purpose Counter 0 has reached the GP"
        "CNT0_VAL value in the GPCNT_VAL register.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPCNT1_TO",
        "Used to indicate when the General Purpose Counter 1 has reached the GP"
        "CNT1_VAL value in the GPCNT_VAL register.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TX_RPTR",
        "Value of the read pointer of transmit FIFO.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TX_CNT",
        "These bits indicate the number of bytes stored in the transmit FIFO.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_PCSR.
static const field_t hw_emvsim_pcsr[] =
{
    {
        "SAPD",
        "Used to enable/disable the auto power down feature.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SVCC_EN",
        "Used to control the state of the SVEN pin on Smart Card port.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VCCENP",
        "Used to control the polarity of the SVEN output pad via the SVCC_EN bi"
        "t.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRST",
        "Used to control state of reset line to the Smart Card.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCEN",
        "Used to enable/disable the clock to the Smart Card.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SCSP",
        "Used to control the polarity of the idle EMV SIM clock when the clock "
        "is disabled by SCEN.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPD",
        "Writing a '1' to this location will start the autopower down sequence "
        "provided the auto power down feature is enabled by writing '1' to SAPD"
        " bit of this register.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIM",
        "Interrupt mask for the presence detect interrupt flag (SPDIF).",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDIF",
        "Status flag to indicate that an insertion or removal of a Smart Card h"
        "as been detected on port.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SPDP",
        "This bit reflects the state of the Smart Card Presence Detect pin.",
        26, // LSB
        26, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SPDES",
        "Controls which edge of the Smart Card Presence Detect pin is used to d"
        "etect the presence of the Smart Card.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_RX_BUF.
static const field_t hw_emvsim_rx_buf[] =
{
    {
        "RX_BYTE",
        "Provides the byte value from the top of the receive FIFO.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_TX_BUF.
static const field_t hw_emvsim_tx_buf[] =
{
    {
        "TX_BYTE",
        "Write to this register to fill the transmit FIFO with the bytes to be "
        "transmitted.",
        0, // LSB
        7, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_TX_GETU.
static const field_t hw_emvsim_tx_getu[] =
{
    {
        "GETU",
        "Used to control the number of additional Elementary Time Units (ETUs) "
        "inserted between bytes transmitted by the EMV SIM transmitter.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_CWT_VAL.
static const field_t hw_emvsim_cwt_val[] =
{
    {
        "CWT",
        "The value written to this register will specify the number of ETU time"
        "s allowed between characters.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_BWT_VAL.
static const field_t hw_emvsim_bwt_val[] =
{
    {
        "BWT",
        "The time from START bit of last byte sent from the EMV SIM module to t"
        "he START bit of the first byte sent from the Smart Card must be less t"
        "han the value in this register.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_BGT_VAL.
static const field_t hw_emvsim_bgt_val[] =
{
    {
        "BGT",
        "The value in this register is the block guard time.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_GPCNT0_VAL.
static const field_t hw_emvsim_gpcnt0_val[] =
{
    {
        "GPCNT0",
        "The value written to this register will be used to compare to the gene"
        "ral purpose counter 0 in the EMV SIM module.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EMVSIM_GPCNT1_VAL.
static const field_t hw_emvsim_gpcnt1_val[] =
{
    {
        "GPCNT1",
        "The value written to this register will be used to compare to the gene"
        "ral purpose counter in the EMV SIM module.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a EMVSIM module.
static const reg_t hw_emvsim[] =
{
    {
        "VER_ID",
        "Version ID for the IP.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_emvsim_ver_id
    },
    {
        "PARAM",
        "This register provides details on the parameter settings that were use"
        "d while including this module in the chip.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_emvsim_param
    },
    {
        "CLKCFG",
        "This register provides configuration details to enable the right clock"
        " frequency of clocks used by EMV SIM module.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_emvsim_clkcfg
    },
    {
        "DIVISOR",
        "This regiter configures the divisor value to generate the baud clock w"
        "hich will drive the card clock and also generate the transmit and rece"
        "ive clocks and respective ETUs.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_emvsim_divisor
    },
    {
        "CTRL",
        "",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        23, // Number of bitfields
        hw_emvsim_ctrl
    },
    {
        "INT_MASK",
        "",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_emvsim_int_mask
    },
    {
        "RX_THD",
        "",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_emvsim_rx_thd
    },
    {
        "TX_THD",
        "",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_emvsim_tx_thd
    },
    {
        "RX_STATUS",
        "",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_emvsim_rx_status
    },
    {
        "TX_STATUS",
        "",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        10, // Number of bitfields
        hw_emvsim_tx_status
    },
    {
        "PCSR",
        "",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_emvsim_pcsr
    },
    {
        "RX_BUF",
        "",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_emvsim_rx_buf
    },
    {
        "TX_BUF",
        "",
        4, // Width in bytes
        0x00000030, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_emvsim_tx_buf
    },
    {
        "TX_GETU",
        "",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_emvsim_tx_getu
    },
    {
        "CWT_VAL",
        "",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_emvsim_cwt_val
    },
    {
        "BWT_VAL",
        "",
        4, // Width in bytes
        0x0000003c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_emvsim_bwt_val
    },
    {
        "BGT_VAL",
        "",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_emvsim_bgt_val
    },
    {
        "GPCNT0_VAL",
        "",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_emvsim_gpcnt0_val
    },
    {
        "GPCNT1_VAL",
        "",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_emvsim_gpcnt1_val
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark ENET
#endif

// Bitfields in register ENET_EIR.
static const field_t hw_enet_eir[] =
{
    {
        "TS_TIMER",
        "The adjustable timer reached the period event.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TS_AVAIL",
        "Indicates that the timestamp of the last transmitted timing frame is a"
        "vailable in the ATSTMP register.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP",
        "Read-only status bit to indicate that a magic packet has been detected"
        ".",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLR",
        "Indicates a frame was received with a payload length error.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UN",
        "Indicates the transmit FIFO became empty before the complete frame was"
        " transmitted.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Indicates a collision occurred on each of 16 successive attempts to tr"
        "ansmit the frame.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LC",
        "Indicates a collision occurred beyond the collision window (slot time)"
        " in half-duplex mode.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EBERR",
        "Indicates a system bus error occurred when a uDMA transaction is under"
        "way.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII",
        "Indicates that the MII has completed the data transfer requested.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB",
        "Indicates a receive buffer descriptor is not the last in the frame has"
        " been updated.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF",
        "Indicates a frame has been received and the last corresponding buffer "
        "descriptor has been updated.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB",
        "Indicates a transmit buffer descriptor has been updated.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF",
        "Indicates a frame has been transmitted and the last corresponding buff"
        "er descriptor has been updated.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRA",
        "This interrupt is asserted after the transmitter is put into a pause s"
        "tate after completion of the frame currently being transmitted.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABT",
        "Indicates the transmitted frame length exceeds RCR[MAX_FL] bytes.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABR",
        "Indicates a frame was received with length in excess of RCR[MAX_FL] by"
        "tes.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_EIMR.
static const field_t hw_enet_eimr[] =
{
    {
        "TS_TIMER",
        "Corresponds to interrupt source EIR[TS_TIMER] register and determines "
        "whether an interrupt condition can generate an interrupt.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TS_AVAIL",
        "Corresponds to interrupt source EIR[TS_AVAIL] register and determines "
        "whether an interrupt condition can generate an interrupt.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAKEUP",
        "Corresponds to interrupt source EIR[WAKEUP] register and determines wh"
        "ether an interrupt condition can generate an interrupt.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PLR",
        "Corresponds to interrupt source EIR[PLR] and determines whether an int"
        "errupt condition can generate an interrupt.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UN",
        "Corresponds to interrupt source EIR[UN] and determines whether an inte"
        "rrupt condition can generate an interrupt.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RL",
        "Corresponds to interrupt source EIR[RL] and determines whether an inte"
        "rrupt condition can generate an interrupt.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LC",
        "Corresponds to interrupt source EIR[LC] and determines whether an inte"
        "rrupt condition can generate an interrupt.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EBERR",
        "Corresponds to interrupt source EIR[EBERR] and determines whether an i"
        "nterrupt condition can generate an interrupt.",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII",
        "Corresponds to interrupt source EIR[MII] and determines whether an int"
        "errupt condition can generate an interrupt.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXB",
        "Corresponds to interrupt source EIR[RXB] and determines whether an int"
        "errupt condition can generate an interrupt.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RXF",
        "Corresponds to interrupt source EIR[RXF] and determines whether an int"
        "errupt condition can generate an interrupt.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXB",
        "Corresponds to interrupt source EIR[TXB] and determines whether an int"
        "errupt condition can generate an interrupt.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TXF",
        "Corresponds to interrupt source EIR[TXF] and determines whether an int"
        "errupt condition can generate an interrupt.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRA",
        "Corresponds to interrupt source EIR[GRA] and determines whether an int"
        "errupt condition can generate an interrupt.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABT",
        "Corresponds to interrupt source EIR[BABT] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BABR",
        "Corresponds to interrupt source EIR[BABR] and determines whether an in"
        "terrupt condition can generate an interrupt.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDAR.
static const field_t hw_enet_rdar[] =
{
    {
        "RDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDAR.
static const field_t hw_enet_tdar[] =
{
    {
        "TDAR",
        "Always set to 1 when this register is written, regardless of the value"
        " written.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ECR.
static const field_t hw_enet_ecr[] =
{
    {
        "RESET",
        "When this field is set, it clears the ETHEREN field.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ETHEREN",
        "Enables/disables the Ethernet MAC.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAGICEN",
        "Enables/disables magic packet detection.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLEEP",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN1588",
        "Enables enhanced functionality of the MAC.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGEN",
        "Enables the MAC to enter hardware freeze mode when the device enters d"
        "ebug mode.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBSWP",
        "Swaps the byte locations of the buffer descriptors.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MMFR.
static const field_t hw_enet_mmfr[] =
{
    {
        "DATA",
        "This is the field for data to be written to or read from the PHY regis"
        "ter.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TA",
        "This field must be programmed to 10 to generate a valid MII management"
        " frame.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RA",
        "See (Clause 22) or (Clause 45) for correct value.",
        18, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PA",
        "See (Clause 22) or (Clause 45) for correct value.",
        23, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OP",
        "See (Clause 22) or (Clause 45) for correct value.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ST",
        "See (Clause 22) or (Clause 45) for correct value.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MSCR.
static const field_t hw_enet_mscr[] =
{
    {
        "MII_SPEED",
        "Controls the frequency of the MII management interface clock (MDC) rel"
        "ative to the internal module clock.",
        1, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DIS_PRE",
        "Enables/disables prepending a preamble to the MII management frame.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HOLDTIME",
        "IEEE802.3 clause 22 defines a minimum of 10 ns for the hold time on th"
        "e MDIO output.",
        8, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MIBC.
static const field_t hw_enet_mibc[] =
{
    {
        "MIB_CLEAR",
        "This field is not self-clearing.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MIB_IDLE",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MIB_DIS",
        "If this control field is set,",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RCR.
static const field_t hw_enet_rcr[] =
{
    {
        "LOOP",
        "This is an MII internal loopback, therefore MII_MODE must be written t"
        "o 1 and RMII_MODE must be written to 0.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DRT",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MII_MODE",
        "This field must always be set.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PROM",
        "All frames are accepted regardless of address matching.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BC_REJ",
        "If set, frames with destination address (DA) equal to 0xFFFF_FFFF_FFFF"
        " are rejected unless the PROM field is set.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FCE",
        "If set, the receiver detects PAUSE frames.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RMII_MODE",
        "Specifies whether the MAC is configured for MII mode or RMII operation"
        " .",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RMII_10T",
        "Enables 10-Mbit/s mode of the RMII .",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PADEN",
        "Specifies whether the MAC removes padding from received frames.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PAUFWD",
        "Specifies whether pause frames are terminated or forwarded.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRCFWD",
        "Specifies whether the CRC field of received frames is transmitted or s"
        "tripped.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CFEN",
        "Enables/disables the MAC control frame.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MAX_FL",
        "Resets to decimal 1518.",
        16, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NLC",
        "Enables/disables a payload length check.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GRS",
        "Read-only status indicating that the MAC receive datapath is stopped.",
        31, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCR.
static const field_t hw_enet_tcr[] =
{
    {
        "GTS",
        "When this field is set, MAC stops transmission after any frame current"
        "ly transmitted is complete and EIR[GRA] is set.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FDEN",
        "If this field is set, frames transmit independent of carrier sense and"
        " collision inputs.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TFC_PAUSE",
        "Pauses frame transmission.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFC_PAUSE",
        "This status field is set when a full-duplex flow control pause frame i"
        "s received and the transmitter pauses for the duration defined in this"
        " pause frame.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ADDSEL",
        "If ADDINS is set, indicates the MAC address that overwrites the source"
        " MAC address.",
        5, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDINS",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CRCFWD",
        "",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_PALR.
static const field_t hw_enet_palr[] =
{
    {
        "PADDR1",
        "Bytes 0 (bits 31:24), 1 (bits 23:16), 2 (bits 15:8), and 3 (bits 7:0) "
        "of the 6-byte individual address are used for exact match and the sour"
        "ce address field in PAUSE frames.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_PAUR.
static const field_t hw_enet_paur[] =
{
    {
        "TYPE",
        "These fields have a constant value of 0x8808.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PADDR2",
        "Bytes 4 (bits 31:24) and 5 (bits 23:16) of the 6-byte individual addre"
        "ss used for exact match, and the source address field in PAUSE frames.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_OPD.
static const field_t hw_enet_opd[] =
{
    {
        "PAUSE_DUR",
        "Pause duration field used in PAUSE frames.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OPCODE",
        "These fields have a constant value of 0x0001.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TXIC.
static const field_t hw_enet_txic[] =
{
    {
        "ICTT",
        "Interrupt coalescing timer threshold in units of 64 clock periods.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICFT",
        "This value determines the number of frames needed to be transmitted fo"
        "r raising an interrupt.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICCS",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICEN",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RXIC.
static const field_t hw_enet_rxic[] =
{
    {
        "ICTT",
        "Interrupt coalescing timer threshold in units of 64 clock periods.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICFT",
        "This value determines the number of frames needed to be received for r"
        "aising an interrupt.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICCS",
        "",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICEN",
        "",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IAUR.
static const field_t hw_enet_iaur[] =
{
    {
        "IADDR1",
        "Contains the upper 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a unicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IALR.
static const field_t hw_enet_ialr[] =
{
    {
        "IADDR2",
        "Contains the lower 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a unicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_GAUR.
static const field_t hw_enet_gaur[] =
{
    {
        "GADDR1",
        "Contains the upper 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a multicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_GALR.
static const field_t hw_enet_galr[] =
{
    {
        "GADDR2",
        "Contains the lower 32 bits of the 64-bit hash table used in the addres"
        "s recognition process for receive frames with a multicast address.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TFWR.
static const field_t hw_enet_tfwr[] =
{
    {
        "TFWR",
        "If TFWR[STRFWD] is cleared, this field indicates the number of bytes, "
        "in steps of 64 bytes, written to the transmit FIFO before transmission"
        " of a frame begins.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STRFWD",
        "",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RDSR.
static const field_t hw_enet_rdsr[] =
{
    {
        "R_DES_START",
        "Pointer to the beginning of the receive buffer descriptor queue.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TDSR.
static const field_t hw_enet_tdsr[] =
{
    {
        "X_DES_START",
        "Pointer to the beginning of the transmit buffer descriptor queue.",
        3, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_MRBR.
static const field_t hw_enet_mrbr[] =
{
    {
        "R_BUF_SIZE",
        "Receive buffer size in bytes.",
        4, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RSFL.
static const field_t hw_enet_rsfl[] =
{
    {
        "RX_SECTION_FULL",
        "Value, in 64-bit words, of the receive FIFO section full threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RSEM.
static const field_t hw_enet_rsem[] =
{
    {
        "RX_SECTION_EMPTY",
        "Value, in 64-bit words, of the receive FIFO section empty threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STAT_SECTION_EMPTY",
        "Defines number of frames in the receive FIFO, independent of its size,"
        " that can be accepted.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RAEM.
static const field_t hw_enet_raem[] =
{
    {
        "RX_ALMOST_EMPTY",
        "Value, in 64-bit words, of the receive FIFO almost empty threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RAFL.
static const field_t hw_enet_rafl[] =
{
    {
        "RX_ALMOST_FULL",
        "Value, in 64-bit words, of the receive FIFO almost full threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TSEM.
static const field_t hw_enet_tsem[] =
{
    {
        "TX_SECTION_EMPTY",
        "Value, in 64-bit words, of the transmit FIFO section empty threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TAEM.
static const field_t hw_enet_taem[] =
{
    {
        "TX_ALMOST_EMPTY",
        "Value, in 64-bit words, of the transmit FIFO almost empty threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TAFL.
static const field_t hw_enet_tafl[] =
{
    {
        "TX_ALMOST_FULL",
        "Value, in 64-bit words, of the transmit FIFO almost full threshold.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TIPG.
static const field_t hw_enet_tipg[] =
{
    {
        "IPG",
        "Indicates the IPG, in bytes, between transmitted frames.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_FTRL.
static const field_t hw_enet_ftrl[] =
{
    {
        "TRUNC_FL",
        "Indicates the value a receive frame is truncated, if it is greater tha"
        "n this value.",
        0, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TACC.
static const field_t hw_enet_tacc[] =
{
    {
        "SHIFT16",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPCHK",
        "Enables insertion of IP header checksum.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PROCHK",
        "Enables insertion of protocol checksum.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RACC.
static const field_t hw_enet_racc[] =
{
    {
        "PADREM",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IPDIS",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRODIS",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LINEDIS",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SHIFT16",
        "When this field is set, the actual frame data starts at bit 16 of the "
        "first word read from the RX FIFO aligning the Ethernet payload on a 32"
        "-bit boundary.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_DROP.
static const field_t hw_enet_rmon_t_drop[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_PACKETS.
static const field_t hw_enet_rmon_t_packets[] =
{
    {
        "TXPKTS",
        "Transmit packet count",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_BC_PKT.
static const field_t hw_enet_rmon_t_bc_pkt[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_MC_PKT.
static const field_t hw_enet_rmon_t_mc_pkt[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_CRC_ALIGN.
static const field_t hw_enet_rmon_t_crc_align[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_UNDERSIZE.
static const field_t hw_enet_rmon_t_undersize[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_OVERSIZE.
static const field_t hw_enet_rmon_t_oversize[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_FRAG.
static const field_t hw_enet_rmon_t_frag[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_JAB.
static const field_t hw_enet_rmon_t_jab[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_COL.
static const field_t hw_enet_rmon_t_col[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P64.
static const field_t hw_enet_rmon_t_p64[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P65TO127.
static const field_t hw_enet_rmon_t_p65to127[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P128TO255.
static const field_t hw_enet_rmon_t_p128to255[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P256TO511.
static const field_t hw_enet_rmon_t_p256to511[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P512TO1023.
static const field_t hw_enet_rmon_t_p512to1023[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P1024TO2047.
static const field_t hw_enet_rmon_t_p1024to2047[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_P_GTE2048.
static const field_t hw_enet_rmon_t_p_gte2048[] =
{
    {
        "TXPKTS",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_T_OCTETS.
static const field_t hw_enet_rmon_t_octets[] =
{
    {
        "TXOCTS",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_DROP.
static const field_t hw_enet_ieee_t_drop[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_FRAME_OK.
static const field_t hw_enet_ieee_t_frame_ok[] =
{
    {
        "COUNT",
        "Does not increment for the broadcast frames when broadcast reject is e"
        "nabled and promiscuous mode is disabled within the receive control reg"
        "ister (RCR).",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_1COL.
static const field_t hw_enet_ieee_t_1col[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_MCOL.
static const field_t hw_enet_ieee_t_mcol[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_DEF.
static const field_t hw_enet_ieee_t_def[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_LCOL.
static const field_t hw_enet_ieee_t_lcol[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_EXCOL.
static const field_t hw_enet_ieee_t_excol[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_MACERR.
static const field_t hw_enet_ieee_t_macerr[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_CSERR.
static const field_t hw_enet_ieee_t_cserr[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_SQE.
static const field_t hw_enet_ieee_t_sqe[] =
{
    {
        "COUNT",
        "Counter not implemented (always reads zero) as no SQE information is a"
        "vailable.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_FDXFC.
static const field_t hw_enet_ieee_t_fdxfc[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_T_OCTETS_OK.
static const field_t hw_enet_ieee_t_octets_ok[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_PACKETS.
static const field_t hw_enet_rmon_r_packets[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_BC_PKT.
static const field_t hw_enet_rmon_r_bc_pkt[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_MC_PKT.
static const field_t hw_enet_rmon_r_mc_pkt[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_CRC_ALIGN.
static const field_t hw_enet_rmon_r_crc_align[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_UNDERSIZE.
static const field_t hw_enet_rmon_r_undersize[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_OVERSIZE.
static const field_t hw_enet_rmon_r_oversize[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_FRAG.
static const field_t hw_enet_rmon_r_frag[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_JAB.
static const field_t hw_enet_rmon_r_jab[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_RESVD_0.
static const field_t hw_enet_rmon_r_resvd_0[] =
{
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P64.
static const field_t hw_enet_rmon_r_p64[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P65TO127.
static const field_t hw_enet_rmon_r_p65to127[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P128TO255.
static const field_t hw_enet_rmon_r_p128to255[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P256TO511.
static const field_t hw_enet_rmon_r_p256to511[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P512TO1023.
static const field_t hw_enet_rmon_r_p512to1023[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P1024TO2047.
static const field_t hw_enet_rmon_r_p1024to2047[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_P_GTE2048.
static const field_t hw_enet_rmon_r_p_gte2048[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_RMON_R_OCTETS.
static const field_t hw_enet_rmon_r_octets[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_DROP.
static const field_t hw_enet_ieee_r_drop[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_FRAME_OK.
static const field_t hw_enet_ieee_r_frame_ok[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_CRC.
static const field_t hw_enet_ieee_r_crc[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_ALIGN.
static const field_t hw_enet_ieee_r_align[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_MACERR.
static const field_t hw_enet_ieee_r_macerr[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_FDXFC.
static const field_t hw_enet_ieee_r_fdxfc[] =
{
    {
        "COUNT",
        "",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_IEEE_R_OCTETS_OK.
static const field_t hw_enet_ieee_r_octets_ok[] =
{
    {
        "COUNT",
        "Counts total octets (includes header and FCS fields).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATCR.
static const field_t hw_enet_atcr[] =
{
    {
        "EN",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFEN",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OFFRST",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PEREN",
        "",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PINPER",
        "Enables event signal output assertion on period event.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESTART",
        "Resets the timer to zero.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAPTURE",
        "When this field is set, all other fields are ignored during a write.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLAVE",
        "",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATVR.
static const field_t hw_enet_atvr[] =
{
    {
        "ATIME",
        "A write sets the timer.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATOFF.
static const field_t hw_enet_atoff[] =
{
    {
        "OFFSET",
        "Offset value for one-shot event generation.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATPER.
static const field_t hw_enet_atper[] =
{
    {
        "PERIOD",
        "Value for generating periodic events.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATCOR.
static const field_t hw_enet_atcor[] =
{
    {
        "COR",
        "Defines after how many timer clock cycles (ts_clk) the correction coun"
        "ter should be reset and trigger a correction increment on the timer.",
        0, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATINC.
static const field_t hw_enet_atinc[] =
{
    {
        "INC",
        "The timer increments by this amount each clock cycle.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "INC_CORR",
        "This value is added every time the correction timer expires (every clo"
        "ck cycle given in ATCOR).",
        8, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_ATSTMP.
static const field_t hw_enet_atstmp[] =
{
    {
        "TIMESTAMP",
        "Timestamp of the last frame transmitted by the core that had TxBD[TS] "
        "set .",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TGSR.
static const field_t hw_enet_tgsr[] =
{
    {
        "TF0",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF1",
        "",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF2",
        "",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF3",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR0.
static const field_t hw_enet_tcsr0[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPWC",
        "Specifies the pulse width associated with TMODE values of 1110 or 11X1"
        ".",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR0.
static const field_t hw_enet_tccr0[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR1.
static const field_t hw_enet_tcsr1[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPWC",
        "Specifies the pulse width associated with TMODE values of 1110 or 11X1"
        ".",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR1.
static const field_t hw_enet_tccr1[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR2.
static const field_t hw_enet_tcsr2[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPWC",
        "Specifies the pulse width associated with TMODE values of 1110 or 11X1"
        ".",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR2.
static const field_t hw_enet_tccr2[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCSR3.
static const field_t hw_enet_tcsr3[] =
{
    {
        "TDRE",
        "",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TMODE",
        "Updating the Timer Mode field takes a few cycles to register because i"
        "t is synchronized to the 1588 clock.",
        2, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIE",
        "",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TF",
        "Sets when input capture or output compare occurs.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TPWC",
        "Specifies the pulse width associated with TMODE values of 1110 or 11X1"
        ".",
        11, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register ENET_TCCR3.
static const field_t hw_enet_tccr3[] =
{
    {
        "TCC",
        "This register is double buffered between the module clock and 1588 clo"
        "ck domains.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a ENET module.
static const reg_t hw_enet[] =
{
    {
        "EIR",
        "When an event occurs that sets a bit in EIR, an interrupt occurs if th"
        "e corresponding bit in the interrupt mask register (EIMR) is also set.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_enet_eir
    },
    {
        "EIMR",
        "EIMR controls which interrupt events are allowed to generate actual in"
        "terrupts.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_enet_eimr
    },
    {
        "RDAR",
        "RDAR is a command register, written by the user, to indicate that the "
        "receive descriptor ring has been updated, that is, that the driver pro"
        "duced empty receive buffers with the empty bit set.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdar
    },
    {
        "TDAR",
        "The TDAR is a command register that the user writes to indicate that t"
        "he transmit descriptor ring has been updated, that is, that transmit b"
        "uffers have been produced by the driver with the ready bit set in the "
        "buffer descriptor.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdar
    },
    {
        "ECR",
        "ECR is a read/write user register, though hardware may also alter fiel"
        "ds in this register.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_enet_ecr
    },
    {
        "MMFR",
        "Writing to MMFR triggers a management frame transaction to the PHY dev"
        "ice unless MSCR is programmed to zero.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_enet_mmfr
    },
    {
        "MSCR",
        "MSCR provides control of the MII clock (MDC pin) frequency and allows "
        "a preamble drop on the MII management frame.",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_mscr
    },
    {
        "MIBC",
        "MIBC is a read/write register controlling and observing the state of t"
        "he MIB block.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_mibc
    },
    {
        "RCR",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_enet_rcr
    },
    {
        "TCR",
        "TCR is read/write and configures the transmit block.",
        4, // Width in bytes
        0x000000c4, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_enet_tcr
    },
    {
        "PALR",
        "PALR contains the lower 32 bits (bytes 0, 1, 2, 3) of the 48-bit addre"
        "ss used in the address recognition process to compare with the destina"
        "tion address (DA) field of receive frames with an individual DA.",
        4, // Width in bytes
        0x000000e4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_palr
    },
    {
        "PAUR",
        "PAUR contains the upper 16 bits (bytes 4 and 5) of the 48-bit address "
        "used in the address recognition process to compare with the destinatio"
        "n address (DA) field of receive frames with an individual DA.",
        4, // Width in bytes
        0x000000e8, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_paur
    },
    {
        "OPD",
        "OPD is read/write accessible.",
        4, // Width in bytes
        0x000000ec, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_opd
    },
    {
        "TXIC",
        "See Interrupt coalescence for more information.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_txic
    },
    {
        "RXIC",
        "See Interrupt coalescence for more information.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_rxic
    },
    {
        "IAUR",
        "IAUR contains the upper 32 bits of the 64-bit individual address hash "
        "table.",
        4, // Width in bytes
        0x00000118, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_iaur
    },
    {
        "IALR",
        "IALR contains the lower 32 bits of the 64-bit individual address hash "
        "table.",
        4, // Width in bytes
        0x0000011c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_ialr
    },
    {
        "GAUR",
        "GAUR contains the upper 32 bits of the 64-bit hash table used in the a"
        "ddress recognition process for receive frames with a multicast address"
        ".",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_gaur
    },
    {
        "GALR",
        "GALR contains the lower 32 bits of the 64-bit hash table used in the a"
        "ddress recognition process for receive frames with a multicast address"
        ".",
        4, // Width in bytes
        0x00000124, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_galr
    },
    {
        "TFWR",
        "If TFWR[STRFWD] is cleared, TFWR[TFWR] controls the amount of data req"
        "uired in the transmit FIFO before transmission of a frame can begin.",
        4, // Width in bytes
        0x00000144, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_tfwr
    },
    {
        "RDSR",
        "RDSR points to the beginning of the circular receive buffer descriptor"
        " queue in external memory.",
        4, // Width in bytes
        0x00000180, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rdsr
    },
    {
        "TDSR",
        "TDSR provides a pointer to the beginning of the circular transmit buff"
        "er descriptor queue in external memory.",
        4, // Width in bytes
        0x00000184, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tdsr
    },
    {
        "MRBR",
        "The MRBR is a user-programmable register that dictates the maximum siz"
        "e of all receive buffers.",
        4, // Width in bytes
        0x00000188, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_mrbr
    },
    {
        "RSFL",
        "",
        4, // Width in bytes
        0x00000190, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rsfl
    },
    {
        "RSEM",
        "",
        4, // Width in bytes
        0x00000194, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_rsem
    },
    {
        "RAEM",
        "",
        4, // Width in bytes
        0x00000198, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_raem
    },
    {
        "RAFL",
        "",
        4, // Width in bytes
        0x0000019c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_rafl
    },
    {
        "TSEM",
        "",
        4, // Width in bytes
        0x000001a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tsem
    },
    {
        "TAEM",
        "",
        4, // Width in bytes
        0x000001a4, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_taem
    },
    {
        "TAFL",
        "",
        4, // Width in bytes
        0x000001a8, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tafl
    },
    {
        "TIPG",
        "",
        4, // Width in bytes
        0x000001ac, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tipg
    },
    {
        "FTRL",
        "",
        4, // Width in bytes
        0x000001b0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_ftrl
    },
    {
        "TACC",
        "TACC controls accelerator actions when sending frames.",
        4, // Width in bytes
        0x000001c0, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_enet_tacc
    },
    {
        "RACC",
        "",
        4, // Width in bytes
        0x000001c4, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_racc
    },
    {
        "RMON_T_DROP",
        "",
        4, // Width in bytes
        0x00000200, // Base address offset
        true, // Readable
        false, // Writable
        0, // Number of bitfields
        hw_enet_rmon_t_drop
    },
    {
        "RMON_T_PACKETS",
        "",
        4, // Width in bytes
        0x00000204, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_packets
    },
    {
        "RMON_T_BC_PKT",
        "RMON Tx Broadcast Packets",
        4, // Width in bytes
        0x00000208, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_bc_pkt
    },
    {
        "RMON_T_MC_PKT",
        "",
        4, // Width in bytes
        0x0000020c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_mc_pkt
    },
    {
        "RMON_T_CRC_ALIGN",
        "",
        4, // Width in bytes
        0x00000210, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_crc_align
    },
    {
        "RMON_T_UNDERSIZE",
        "",
        4, // Width in bytes
        0x00000214, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_undersize
    },
    {
        "RMON_T_OVERSIZE",
        "",
        4, // Width in bytes
        0x00000218, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_oversize
    },
    {
        "RMON_T_FRAG",
        ".",
        4, // Width in bytes
        0x0000021c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_frag
    },
    {
        "RMON_T_JAB",
        "",
        4, // Width in bytes
        0x00000220, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_jab
    },
    {
        "RMON_T_COL",
        "",
        4, // Width in bytes
        0x00000224, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_col
    },
    {
        "RMON_T_P64",
        ".",
        4, // Width in bytes
        0x00000228, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p64
    },
    {
        "RMON_T_P65TO127",
        "",
        4, // Width in bytes
        0x0000022c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p65to127
    },
    {
        "RMON_T_P128TO255",
        "",
        4, // Width in bytes
        0x00000230, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p128to255
    },
    {
        "RMON_T_P256TO511",
        "",
        4, // Width in bytes
        0x00000234, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p256to511
    },
    {
        "RMON_T_P512TO1023",
        ".",
        4, // Width in bytes
        0x00000238, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p512to1023
    },
    {
        "RMON_T_P1024TO2047",
        "",
        4, // Width in bytes
        0x0000023c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p1024to2047
    },
    {
        "RMON_T_P_GTE2048",
        "",
        4, // Width in bytes
        0x00000240, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_p_gte2048
    },
    {
        "RMON_T_OCTETS",
        "",
        4, // Width in bytes
        0x00000244, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_t_octets
    },
    {
        "IEEE_T_DROP",
        "",
        4, // Width in bytes
        0x00000248, // Base address offset
        true, // Readable
        false, // Writable
        0, // Number of bitfields
        hw_enet_ieee_t_drop
    },
    {
        "IEEE_T_FRAME_OK",
        "",
        4, // Width in bytes
        0x0000024c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_frame_ok
    },
    {
        "IEEE_T_1COL",
        "",
        4, // Width in bytes
        0x00000250, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_1col
    },
    {
        "IEEE_T_MCOL",
        "",
        4, // Width in bytes
        0x00000254, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_mcol
    },
    {
        "IEEE_T_DEF",
        "",
        4, // Width in bytes
        0x00000258, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_def
    },
    {
        "IEEE_T_LCOL",
        "",
        4, // Width in bytes
        0x0000025c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_lcol
    },
    {
        "IEEE_T_EXCOL",
        "",
        4, // Width in bytes
        0x00000260, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_excol
    },
    {
        "IEEE_T_MACERR",
        "",
        4, // Width in bytes
        0x00000264, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_macerr
    },
    {
        "IEEE_T_CSERR",
        "",
        4, // Width in bytes
        0x00000268, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_cserr
    },
    {
        "IEEE_T_SQE",
        "",
        4, // Width in bytes
        0x0000026c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_sqe
    },
    {
        "IEEE_T_FDXFC",
        "",
        4, // Width in bytes
        0x00000270, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_fdxfc
    },
    {
        "IEEE_T_OCTETS_OK",
        "",
        4, // Width in bytes
        0x00000274, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_t_octets_ok
    },
    {
        "RMON_R_PACKETS",
        "",
        4, // Width in bytes
        0x00000284, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_packets
    },
    {
        "RMON_R_BC_PKT",
        "",
        4, // Width in bytes
        0x00000288, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_bc_pkt
    },
    {
        "RMON_R_MC_PKT",
        "",
        4, // Width in bytes
        0x0000028c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_mc_pkt
    },
    {
        "RMON_R_CRC_ALIGN",
        "",
        4, // Width in bytes
        0x00000290, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_crc_align
    },
    {
        "RMON_R_UNDERSIZE",
        "",
        4, // Width in bytes
        0x00000294, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_undersize
    },
    {
        "RMON_R_OVERSIZE",
        "",
        4, // Width in bytes
        0x00000298, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_oversize
    },
    {
        "RMON_R_FRAG",
        "",
        4, // Width in bytes
        0x0000029c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_frag
    },
    {
        "RMON_R_JAB",
        "",
        4, // Width in bytes
        0x000002a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_jab
    },
    {
        "RMON_R_RESVD_0",
        "",
        4, // Width in bytes
        0x000002a4, // Base address offset
        false, // Readable
        false, // Writable
        0, // Number of bitfields
        hw_enet_rmon_r_resvd_0
    },
    {
        "RMON_R_P64",
        "",
        4, // Width in bytes
        0x000002a8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p64
    },
    {
        "RMON_R_P65TO127",
        "",
        4, // Width in bytes
        0x000002ac, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p65to127
    },
    {
        "RMON_R_P128TO255",
        "",
        4, // Width in bytes
        0x000002b0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p128to255
    },
    {
        "RMON_R_P256TO511",
        "",
        4, // Width in bytes
        0x000002b4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p256to511
    },
    {
        "RMON_R_P512TO1023",
        "",
        4, // Width in bytes
        0x000002b8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p512to1023
    },
    {
        "RMON_R_P1024TO2047",
        "",
        4, // Width in bytes
        0x000002bc, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p1024to2047
    },
    {
        "RMON_R_P_GTE2048",
        "",
        4, // Width in bytes
        0x000002c0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_p_gte2048
    },
    {
        "RMON_R_OCTETS",
        "",
        4, // Width in bytes
        0x000002c4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_rmon_r_octets
    },
    {
        "IEEE_R_DROP",
        "Counter increments if a frame with invalid or missing SFD character is"
        " detected and has been dropped.",
        4, // Width in bytes
        0x000002c8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_drop
    },
    {
        "IEEE_R_FRAME_OK",
        "",
        4, // Width in bytes
        0x000002cc, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_frame_ok
    },
    {
        "IEEE_R_CRC",
        "",
        4, // Width in bytes
        0x000002d0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_crc
    },
    {
        "IEEE_R_ALIGN",
        "",
        4, // Width in bytes
        0x000002d4, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_align
    },
    {
        "IEEE_R_MACERR",
        "",
        4, // Width in bytes
        0x000002d8, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_macerr
    },
    {
        "IEEE_R_FDXFC",
        "",
        4, // Width in bytes
        0x000002dc, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_fdxfc
    },
    {
        "IEEE_R_OCTETS_OK",
        "",
        4, // Width in bytes
        0x000002e0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_ieee_r_octets_ok
    },
    {
        "ATCR",
        "ATCR command fields can trigger the corresponding events directly.",
        4, // Width in bytes
        0x00000400, // Base address offset
        true, // Readable
        true, // Writable
        8, // Number of bitfields
        hw_enet_atcr
    },
    {
        "ATVR",
        "",
        4, // Width in bytes
        0x00000404, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atvr
    },
    {
        "ATOFF",
        "",
        4, // Width in bytes
        0x00000408, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atoff
    },
    {
        "ATPER",
        "",
        4, // Width in bytes
        0x0000040c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atper
    },
    {
        "ATCOR",
        "",
        4, // Width in bytes
        0x00000410, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_atcor
    },
    {
        "ATINC",
        "",
        4, // Width in bytes
        0x00000414, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_enet_atinc
    },
    {
        "ATSTMP",
        "",
        4, // Width in bytes
        0x00000418, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_enet_atstmp
    },
    {
        "TGSR",
        "",
        4, // Width in bytes
        0x00000604, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_enet_tgsr
    },
    {
        "TCSR0",
        "",
        4, // Width in bytes
        0x00000608, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_tcsr0
    },
    {
        "TCCR0",
        "",
        4, // Width in bytes
        0x0000060c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr0
    },
    {
        "TCSR1",
        "",
        4, // Width in bytes
        0x00000610, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_tcsr1
    },
    {
        "TCCR1",
        "",
        4, // Width in bytes
        0x00000614, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr1
    },
    {
        "TCSR2",
        "",
        4, // Width in bytes
        0x00000618, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_tcsr2
    },
    {
        "TCCR2",
        "",
        4, // Width in bytes
        0x0000061c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr2
    },
    {
        "TCSR3",
        "",
        4, // Width in bytes
        0x00000620, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_enet_tcsr3
    },
    {
        "TCCR3",
        "",
        4, // Width in bytes
        0x00000624, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_enet_tccr3
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark EPIT
#endif

// Bitfields in register EPIT_CR.
static const field_t hw_epit_cr[] =
{
    {
        "EN",
        "This bit enables the EPIT.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENMOD",
        "EPIT enable mode.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OCIEN",
        "Output compare interrupt enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RLD",
        "Counter reload control.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESCALAR",
        "Counter clock prescaler value.",
        4, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Software reset.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IOVW",
        "EPIT counter overwrite enable.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGEN",
        "This bit is used to keep the EPIT functional in debug mode.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAITEN",
        "This read/write control bit enables the operation of the EPIT during w"
        "ait mode.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPEN",
        "EPIT stop mode enable.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM",
        "EPIT output mode.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKSRC",
        "Select clock source These bits determine which clock input is to be se"
        "lected for running the counter.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_SR.
static const field_t hw_epit_sr[] =
{
    {
        "OCIF",
        "Output compare interrupt flag.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_LR.
static const field_t hw_epit_lr[] =
{
    {
        "LOAD",
        "Load value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_CMPR.
static const field_t hw_epit_cmpr[] =
{
    {
        "COMPARE",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register EPIT_CNR.
static const field_t hw_epit_cnr[] =
{
    {
        "COUNT",
        "Counter value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a EPIT module.
static const reg_t hw_epit[] =
{
    {
        "CR",
        "The EPIT control register (EPIT_CR) is used to configure the operating"
        " settings of the EPIT.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_epit_cr
    },
    {
        "SR",
        "The EPIT status register (EPIT_SR) has a single status bit for the out"
        "put compare event.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_sr
    },
    {
        "LR",
        "The EPIT load register (EPIT_LR) contains the value that is to be load"
        "ed into the counter when EPIT counter reaches zero if the RLD bit in E"
        "PIT_CR is set.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_lr
    },
    {
        "CMPR",
        "The EPIT compare register (EPIT_CMPR) holds the value that determines "
        "when a compare event is generated.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_epit_cmpr
    },
    {
        "CNR",
        "The EPIT counter register (EPIT_CNR) contains the current count value "
        "and can be read at any time without disturbing the counter.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_epit_cnr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark FLEXCAN
#endif

// Bitfields in register FLEXCAN_MCR.
static const field_t hw_flexcan_mcr[] =
{
    {
        "MAXMB",
        "This 7-bit field defines the number of the last Message Buffers that w"
        "ill take part in the matching and arbitration processes.",
        0, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IDAM",
        "This 2-bit field identifies the format of the elements of the Rx FIFO "
        "filter table, as shown below.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "AEN",
        "This bit is supplied for backwards compatibility reasons.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LPRIO_EN",
        "This bit is provided for backwards compatibility reasons.",
        13, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IRMQ",
        "This bit indicates whether Rx matching process will be based either on"
        " individual masking and queue or on masking scheme with RXMGMASK, RX14"
        "MASK and RX15MASK, RXFGMASK.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRX_DIS",
        "This bit defines whether FlexCAN is allowed to receive frames transmit"
        "ted by itself.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAK_SRC",
        "This bit defines whether the integrated low-pass filter is applied to "
        "protect the FLEXCAN_RX input from spurious wake up.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LPM_ACK",
        "This read-only bit indicates that FLEXCAN is either in Disable Mode or"
        " Stop Mode.",
        20, // LSB
        20, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WRN_EN",
        "When asserted, this bit enables the generation of the TWRN_INT and RWR"
        "N_INT flags in the Error and Status Register.",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLF_WAK",
        "This bit enables the Self Wake Up feature when FLEXCAN is in Stop Mode"
        ".",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SUPV",
        "This bit configures some of the FLEXCAN registers to be either in Supe"
        "rvisor or User Mode.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRZ_ACK",
        "This read-only bit indicates that FLEXCAN is in Freeze Mode and its pr"
        "escaler is stopped.",
        24, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SOFT_RST",
        "When this bit is asserted, FlexCAN resets its internal state machines "
        "and some of the memory mapped registers.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAK_MSK",
        "This bit enables the Wake Up Interrupt generation.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "NOT_RDY",
        "This read-only bit indicates that FLEXCAN is either in Disable Mode, S"
        "top Mode or Freeze Mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "HALT",
        "Assertion of this bit puts the FLEXCAN module into Freeze Mode.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFEN",
        "This bit controls whether the Rx FIFO feature is enabled or not.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRZ",
        "The FRZ bit specifies the FLEXCAN behavior when the HALT bit in the MC"
        "R Register is set or when Debug Mode is requested at ARM level.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MDIS",
        "This bit controls whether FLEXCAN is enabled or not.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_CTRL1.
static const field_t hw_flexcan_ctrl1[] =
{
    {
        "PROP_SEG",
        "This 3-bit field defines the length of the Propagation Segment in the "
        "bit time.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOM",
        "This bit configures FLEXCAN to operate in Listen Only Mode.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LBUF",
        "This bit defines the ordering mechanism for Message Buffer transmissio"
        "n.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TSYN",
        "This bit enables a mechanism that resets the free-running timer each t"
        "ime a message is received in Message Buffer 0.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BOFF_REC",
        "This bit defines how FLEXCAN recovers from Bus Off state.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SMP",
        "This bit defines the sampling mode of CAN bits at the FLEXCAN_RX.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RWRN_MSK",
        "This bit provides a mask for the Rx Warning Interrupt associated with "
        "the RWRN_INT flag in the Error and Status Register.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWRN_MSK",
        "This bit provides a mask for the Tx Warning Interrupt associated with "
        "the TWRN_INT flag in the Error and Status Register.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LPB",
        "This bit configures FlexCAN to operate in Loop-Back Mode.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR_MSK",
        "This bit provides a mask for the Error Interrupt.",
        14, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BOFF_MSK",
        "This bit provides a mask for the Bus Off Interrupt.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSEG2",
        "This 3-bit field defines the length of Phase Buffer Segment 2 in the b"
        "it time.",
        16, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PSEG1",
        "This 3-bit field defines the length of Phase Buffer Segment 1 in the b"
        "it time.",
        19, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RJW",
        "This 2-bit field defines the maximum number of time quanta One time qu"
        "antum is equal to the Sclock period.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESDIV",
        "This 8-bit field defines the ratio between the PE clock frequency and "
        "the Serial Clock (Sclock) frequency.",
        24, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_TIMER.
static const field_t hw_flexcan_timer[] =
{
    {
        "TIMER",
        "TIMER",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RXMGMASK.
static const field_t hw_flexcan_rxmgmask[] =
{
    {
        "MG31_MG0",
        "These bits mask the Mailbox filter bits as shown in the figure above.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RX14MASK.
static const field_t hw_flexcan_rx14mask[] =
{
    {
        "RX14M31_RX14M0",
        "These bits mask Mailbox 14 filter bits in the same fashion as RXMGMASK"
        " masks other Mailboxes filters (see RXMGMASKRx Mailboxes Global Mask R"
        "egister )",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RX15MASK.
static const field_t hw_flexcan_rx15mask[] =
{
    {
        "RX15M31_RX15M0",
        "These bits mask Mailbox 15 filter bits in the same fashion as RXMGMASK"
        " masks other Mailboxes filters (see RXMGMASKRx Mailboxes Global Mask R"
        "egister ).",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_ECR.
static const field_t hw_flexcan_ecr[] =
{
    {
        "TX_ERR_COUNTER",
        "Tx_Err_Counter",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX_ERR_COUNTER",
        "Rx_Err_Counter",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_ESR1.
static const field_t hw_flexcan_esr1[] =
{
    {
        "WAK_INT",
        "When FLEXCAN is Stop Mode and a recessive to dominant transition is de"
        "tected on the CAN bus and if the WAK_MSK bit in the MCR Register is se"
        "t, an interrupt is generated to the ARM.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ERR_INT",
        "This bit indicates that at least one of the Error Bits (bits 15-10) is"
        " set.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BOFF_INT",
        "This bit is set when FLEXCAN enters 'Bus Off' state.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RX",
        "This bit indicates if FlexCAN is receiving a message.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FLT_CONF",
        "If the LOM bit in the Control Register is asserted, after some delay t"
        "hat depends on the CAN bit timing the FLT_CONF field will indicate \"E"
        "rror Passive\".",
        4, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TX",
        "This bit indicates if FLEXCAN is transmitting a message.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IDLE",
        "This bit indicates when CAN bus is in IDLE state.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RX_WRN",
        "This bit indicates when repetitive errors are occurring during message"
        " reception.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "TX_WRN",
        "This bit indicates when repetitive errors are occurring during message"
        " transmission.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "STF_ERR",
        "This bit indicates that a Stuffing Error has been detected.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FRM_ERR",
        "This bit indicates that a Form Error has been detected by the receiver"
        " node, i.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "CRC_ERR",
        "This bit indicates that a CRC Error has been detected by the receiver "
        "node, i.",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ACK_ERR",
        "This bit indicates that an Acknowledge Error has been detected by the "
        "transmitter node, i.",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BIT0_ERR",
        "This bit indicates when an inconsistency occurs between the transmitte"
        "d and the received bit in a message.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BIT1_ERR",
        "This bit indicates when an inconsistency occurs between the transmitte"
        "d and the received bit in a message.",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RWRN_INT",
        "If the WRN_EN bit in MCR is asserted, the RWRN_INT bit is set when the"
        " RX_WRN flag transition from '0' to '1', meaning that the Rx error cou"
        "nters reached 96.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TWRN_INT",
        "If the WRN_EN bit in MCR is asserted, the TWRN_INT bit is set when the"
        " TX_WRN flag transition from '0' to '1', meaning that the Tx error cou"
        "nter reached 96.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYNCH",
        "This read-only flag indicates whether the FlexCAN is synchronized to t"
        "he CAN bus and able to participate in the communication process.",
        18, // LSB
        18, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IMASK2.
static const field_t hw_flexcan_imask2[] =
{
    {
        "BUF63M_BUF32M",
        "Each bit enables or disables the respective FLEXCAN Message Buffer (MB"
        "32 to MB63) Interrupt.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IMASK1.
static const field_t hw_flexcan_imask1[] =
{
    {
        "BUF31M_BUF0M",
        "Each bit enables or disables the respective FLEXCAN Message Buffer (MB"
        "0 to MB31) Interrupt.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IFLAG2.
static const field_t hw_flexcan_iflag2[] =
{
    {
        "BUF63I_BUF32I",
        "Each bit flags the respective FLEXCAN Message Buffer (MB32 to MB63) in"
        "terrupt.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_IFLAG1.
static const field_t hw_flexcan_iflag1[] =
{
    {
        "BUF4I_BUF0I",
        "If the Rx FIFO is not enabled, these bits flag the interrupts for MB0 "
        "to MB4.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF5I",
        "If the Rx FIFO is not enabled, this bit flags the interrupt for MB5.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF6I",
        "If the Rx FIFO is not enabled, this bit flags the interrupt for MB6.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF7I",
        "If the Rx FIFO is not enabled, this bit flags the interrupt for MB7.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BUF31I_BUF8I",
        "Each bit flags the respective FLEXCAN Message Buffer (MB8 to MB31) int"
        "errupt.",
        8, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_CTRL2.
static const field_t hw_flexcan_ctrl2[] =
{
    {
        "EACEN",
        "This bit controls the comparison of IDE and RTR bits within Rx Mailbox"
        "es filters with their corresponding bits in the incoming frame by the "
        "matching process.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RRS",
        "If this bit is asserted Remote Request Frame is submitted to a matchin"
        "g process and stored in the corresponding Message Buffer in the same f"
        "ashion of a Data Frame.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MRP",
        "If this bit is set the matching process starts from the Mailboxes and "
        "if no match occurs the matching continues on the Rx FIFO.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TASD",
        "This 5-bit field indicates how many CAN bits the Tx arbitration proces"
        "s start point can be delayed from the first bit of CRC field on CAN bu"
        "s.",
        19, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RFFN",
        "This 4-bit field defines the number of Rx FIFO filters according to .",
        24, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRMFRZ",
        "Enable unrestricted write access to FlexCAN memory in Freeze mode.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_ESR2.
static const field_t hw_flexcan_esr2[] =
{
    {
        "IMB",
        "If ESR2[VPS] is asserted, this bit indicates whether there is any inac"
        "tive Mailbox (CODE field is either 0b1000 or 0b0000).",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VPS",
        "This bit indicates whether IMB and LPTM contents are currently valid o"
        "r not.",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "LPTM",
        "If ESR2[VPS] is asserted, his 7-bit field indicates the lowest number "
        "inactive Mailbox (refer to IMB bit description).",
        16, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_CRCR.
static const field_t hw_flexcan_crcr[] =
{
    {
        "TXCRC",
        "This field indicates the CRC value of the last message transmitted.",
        0, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MBCRC",
        "This field indicates the number of the Mailbox corresponding to the va"
        "lue in TXCRC field.",
        16, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RXFGMASK.
static const field_t hw_flexcan_rxfgmask[] =
{
    {
        "FGM31_FGM0",
        "These bits mask the ID Filter Table elements bits in a perfect alignme"
        "nt.RXFGMASKRx FIFO Global Mask Register shows in detail which FGM bits"
        " mask each IDAF field.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RXFIR.
static const field_t hw_flexcan_rxfir[] =
{
    {
        "IDHIT",
        "This 9-bit field indicates which Identifier Acceptance Filter (see Rx "
        "FIFO StructureWhen the MCR[RFEN] bit is set, the memory area from $80 "
        "to $DC (which is normally occupied by MBs 0 to 5) is used by the recep"
        "tion FIFO engine.",
        0, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_RXIMR0_RXIMR63.
static const field_t hw_flexcan_rximr0_rximr63[] =
{
    {
        "MI31_MI0",
        "These bits mask both Mailbox filter and Rx FIFO ID Filter Table elemen"
        "t in distinct ways.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register FLEXCAN_GFWR.
static const field_t hw_flexcan_gfwr[] =
{
    {
        "GFWR",
        "It determines the Glitch Filter Width.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a FLEXCAN module.
static const reg_t hw_flexcan[] =
{
    {
        "MCR",
        "This register defines global system configurations, such as the module"
        " operation mode (e.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        19, // Number of bitfields
        hw_flexcan_mcr
    },
    {
        "CTRL1",
        "This register is defined for specific FLEXCAN control features related"
        " to the CAN bus, such as bit-rate, programmable sampling point within "
        "an Rx bit, Loop Back Mode, Listen Only Mode, Bus Off recovery behavior"
        " and interrupt enabling (Bus-Off, Error, Warning).",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        15, // Number of bitfields
        hw_flexcan_ctrl1
    },
    {
        "TIMER",
        "This register represents a 16-bit free running counter that can be rea"
        "d and written by the ARM.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_timer
    },
    {
        "RXMGMASK",
        "RXMGMASK is provided for legacy support.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rxmgmask
    },
    {
        "RX14MASK",
        "RX14MASK is provided for legacy support, asserting the MCR[IRMQ] bit c"
        "auses the RX14MASK to have no effect on the module operation.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rx14mask
    },
    {
        "RX15MASK",
        "RX15MASK is provided for legacy support, asserting the MCR[IRMQ] bit c"
        "auses the RX15MASK Register to have no effect on the module operation.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rx15mask
    },
    {
        "ECR",
        "This register has 2 8-bit fields reflecting the value of two FLEXCAN e"
        "rror counters: Transmit Error Counter (Tx_Err_Counter field) and Recei"
        "ve Error Counter (Rx_Err_Counter field).",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_flexcan_ecr
    },
    {
        "ESR1",
        "This register reflects various error conditions, some general status o"
        "f the device and it is the source of four interrupts to the ARM.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_flexcan_esr1
    },
    {
        "IMASK2",
        "This register allows any number of a range of 32 Message Buffer Interr"
        "upts to be enabled or disabled.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_imask2
    },
    {
        "IMASK1",
        "This register allows to enable or disable any number of a range of 32 "
        "Message Buffer Interrupts.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_imask1
    },
    {
        "IFLAG2",
        "This register defines the flags for 32 Message Buffer interrupts.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_iflag2
    },
    {
        "IFLAG1",
        "This register defines the flags for 32 Message Buffer interrupts and F"
        "IFO interrupts.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        5, // Number of bitfields
        hw_flexcan_iflag1
    },
    {
        "CTRL2",
        "This register contains control bits for CAN errors, FIFO features and "
        "mode selection.",
        4, // Width in bytes
        0x00000034, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_flexcan_ctrl2
    },
    {
        "ESR2",
        "This register reflects various interrupt flags and some general status"
        ".",
        4, // Width in bytes
        0x00000038, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_flexcan_esr2
    },
    {
        "CRCR",
        "This register provides information about the CRC of transmitted messag"
        "es",
        4, // Width in bytes
        0x00000044, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_flexcan_crcr
    },
    {
        "RXFGMASK",
        "If Rx FIFO is enabled RXFGMASK is used to mask the Rx FIFO ID Filter T"
        "able elements that do not have a corresponding RXIMR according to CTRL"
        "2[RFFN] field setting.",
        4, // Width in bytes
        0x00000048, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rxfgmask
    },
    {
        "RXFIR",
        "RXFIR provides information on Rx FIFO.",
        4, // Width in bytes
        0x0000004c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_flexcan_rxfir
    },
    {
        "RXIMR0_RXIMR63",
        "RXIMR are used as acceptance masks for ID filtering in Rx MBs and the "
        "Rx FIFO.",
        4, // Width in bytes
        0x00000880, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_rximr0_rximr63
    },
    {
        "GFWR",
        "The Glitch Filter just takes effects when FLEXCAN enters the STOP mode"
        ".",
        4, // Width in bytes
        0x000009e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_flexcan_gfwr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPC
#endif

// Bitfields in register GPC_CNTR.
static const field_t hw_gpc_cntr[] =
{
    {
        "GPU_VPU_PDN_REQ",
        "GPU Power Down request.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPU_VPU_PUP_REQ",
        "GPU Power Up request.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MEGA_PDN_REQ",
        "MEGA domain power down request.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MEGA_PUP_REQ",
        "MEGA domain power up request.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISPLAY_PDN_REQ",
        "Display Power Down request.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DISPLAY_PUP_REQ",
        "Display Power Up request.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCIE_PHY_PDN_REQ",
        "PCIE PHY power down request.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PCIE_PHY_PUP_REQ",
        "PCIE PHY power up request.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DVFS0CR",
        "DVFS0 (ARM) Change request (bit is read-only)",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VADC_ANALOG_OFF",
        "Indication to VADC whether the analog power to VADC is available or no"
        "t",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "VADC_EXT_PWD_N",
        "VADC power down bit",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPCIRQM",
        "GPC interrupt/event masking",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "L2_PGE",
        "L2 Cache Power Gate Enable",
        22, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_PGR.
static const field_t hw_gpc_pgr[] =
{
    {
        "DRCIC",
        "Debug ref cir in mux control",
        29, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR1.
static const field_t hw_gpc_imr1[] =
{
    {
        "IMR1",
        "IRQ[63:32] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR2.
static const field_t hw_gpc_imr2[] =
{
    {
        "IMR2",
        "IRQ[95:64] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR3.
static const field_t hw_gpc_imr3[] =
{
    {
        "IMR3",
        "IRQ[127:96] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_IMR4.
static const field_t hw_gpc_imr4[] =
{
    {
        "IMR4",
        "IRQ[159:128] masking bits: 1-irq masked, 0-irq is not masked",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR1.
static const field_t hw_gpc_isr1[] =
{
    {
        "ISR1",
        "IRQ[63:32] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR2.
static const field_t hw_gpc_isr2[] =
{
    {
        "ISR2",
        "IRQ[95:64] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR3.
static const field_t hw_gpc_isr3[] =
{
    {
        "ISR3",
        "IRQ[127:96] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPC_ISR4.
static const field_t hw_gpc_isr4[] =
{
    {
        "ISR4",
        "IRQ[159:128] status, read only",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPC module.
static const reg_t hw_gpc[] =
{
    {
        "CNTR",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_gpc_cntr
    },
    {
        "PGR",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_pgr
    },
    {
        "IMR1",
        "IMR1 Register - masking of irq[63:32].",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr1
    },
    {
        "IMR2",
        "IMR2 Register - masking of irq[95:64].",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr2
    },
    {
        "IMR3",
        "IMR3 Register - masking of irq[127:96].",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr3
    },
    {
        "IMR4",
        "IMR4 Register - masking of irq[159:128].",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpc_imr4
    },
    {
        "ISR1",
        "ISR1 Register - status of irq [63:32].",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr1
    },
    {
        "ISR2",
        "ISR2 Register - status of irq [95:64].",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr2
    },
    {
        "ISR3",
        "ISR3 Register - status of irq [127:96].",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr3
    },
    {
        "ISR4",
        "ISR4 Register - status of irq [159:128].",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpc_isr4
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPIO
#endif

// Bitfields in register GPIO_DR.
static const field_t hw_gpio_dr[] =
{
    {
        "DR",
        "Data bits.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_GDIR.
static const field_t hw_gpio_gdir[] =
{
    {
        "GDIR",
        "GPIO direction bits.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_PSR.
static const field_t hw_gpio_psr[] =
{
    {
        "PSR",
        "GPIO pad status bits (status bits).",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_ICR1.
static const field_t hw_gpio_icr1[] =
{
    {
        "ICR0",
        "Interrupt configuration 1 fields.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR1",
        "Interrupt configuration 1 fields.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR2",
        "Interrupt configuration 1 fields.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR3",
        "Interrupt configuration 1 fields.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR4",
        "Interrupt configuration 1 fields.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR5",
        "Interrupt configuration 1 fields.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR6",
        "Interrupt configuration 1 fields.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR7",
        "Interrupt configuration 1 fields.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR8",
        "Interrupt configuration 1 fields.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR9",
        "Interrupt configuration 1 fields.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR10",
        "Interrupt configuration 1 fields.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR11",
        "Interrupt configuration 1 fields.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR12",
        "Interrupt configuration 1 fields.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR13",
        "Interrupt configuration 1 fields.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR14",
        "Interrupt configuration 1 fields.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR15",
        "Interrupt configuration 1 fields.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_ICR2.
static const field_t hw_gpio_icr2[] =
{
    {
        "ICR16",
        "Interrupt configuration 2 fields.",
        0, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR17",
        "Interrupt configuration 2 fields.",
        2, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR18",
        "Interrupt configuration 2 fields.",
        4, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR19",
        "Interrupt configuration 2 fields.",
        6, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR20",
        "Interrupt configuration 2 fields.",
        8, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR21",
        "Interrupt configuration 2 fields.",
        10, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR22",
        "Interrupt configuration 2 fields.",
        12, // LSB
        13, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR23",
        "Interrupt configuration 2 fields.",
        14, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR24",
        "Interrupt configuration 2 fields.",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR25",
        "Interrupt configuration 2 fields.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR26",
        "Interrupt configuration 2 fields.",
        20, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR27",
        "Interrupt configuration 2 fields.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR28",
        "Interrupt configuration 2 fields.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR29",
        "Interrupt configuration 2 fields.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR30",
        "Interrupt configuration 2 fields.",
        28, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ICR31",
        "Interrupt configuration 2 fields.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_IMR.
static const field_t hw_gpio_imr[] =
{
    {
        "IMR",
        "Interrupt Mask bits.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_ISR.
static const field_t hw_gpio_isr[] =
{
    {
        "ISR",
        "Interrupt status bits - Bit n of this register is asserted (active hig"
        "h) when the active condition (as determined by the corresponding ICR b"
        "it) is detected on the GPIO input and is waiting for service.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPIO_EDGE_SEL.
static const field_t hw_gpio_edge_sel[] =
{
    {
        "GPIO_EDGE_SEL",
        "Edge select.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPIO module.
static const reg_t hw_gpio[] =
{
    {
        "DR",
        "The 32-bit GPIO_DR register stores data that is ready to be driven to "
        "the output lines.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_dr
    },
    {
        "GDIR",
        "GPIO_GDIR functions as direction control when the IOMUXC is in GPIO mo"
        "de.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_gdir
    },
    {
        "PSR",
        "GPIO_PSR is a read-only register.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpio_psr
    },
    {
        "ICR1",
        "GPIO_ICR1 contains 16 two-bit fields, where each field specifies the i"
        "nterrupt configuration for a different input signal.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_gpio_icr1
    },
    {
        "ICR2",
        "GPIO_ICR2 contains 16 two-bit fields, where each field specifies the i"
        "nterrupt configuration for a different input signal.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        16, // Number of bitfields
        hw_gpio_icr2
    },
    {
        "IMR",
        "GPIO_IMR contains masking bits for each interrupt line.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_imr
    },
    {
        "ISR",
        "The GPIO_ISR functions as an interrupt status indicator.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_isr
    },
    {
        "EDGE_SEL",
        "GPIO_EDGE_SEL may be used to override the ICR registers' configuration"
        ".",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpio_edge_sel
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPMI
#endif

// Bitfields in register GPMI_CTRL0.
static const field_t hw_gpmi_ctrl0[] =
{
    {
        "XFER_COUNT",
        "Number of bytes to transfer for this command.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRESS_INCREMENT",
        "In ATA mode, the address will increment with each cycle.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRESS",
        "Specifies the three address lines for ATA mode.",
        17, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS",
        "Selects which chip select is active for this command.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WORD_LENGTH",
        "This bit should only be changed when RUN==0.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COMMAND_MODE",
        "WRITE = 0x0 Write mode.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UDMA",
        "DISABLED = 0x0 Use ATA-PIO mode on the external bus.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_CS",
        "For ATA/NAND mode: 0= Deassert chip select (CS) after RUN is complete.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_IRQ_EN",
        "When set to '1' and ATA_IRQ pin is asserted, the GPMI_IRQ output will "
        "assert.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RUN",
        "The GPMI is busy running a command whenever this bit is set to '1'.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "Set this bit zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set to zero for normal operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_CTRL0_SET.
static const field_t hw_gpmi_ctrl0_set[] =
{
    {
        "XFER_COUNT",
        "Number of bytes to transfer for this command.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRESS_INCREMENT",
        "In ATA mode, the address will increment with each cycle.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRESS",
        "Specifies the three address lines for ATA mode.",
        17, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS",
        "Selects which chip select is active for this command.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WORD_LENGTH",
        "This bit should only be changed when RUN==0.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COMMAND_MODE",
        "WRITE = 0x0 Write mode.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UDMA",
        "DISABLED = 0x0 Use ATA-PIO mode on the external bus.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_CS",
        "For ATA/NAND mode: 0= Deassert chip select (CS) after RUN is complete.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_IRQ_EN",
        "When set to '1' and ATA_IRQ pin is asserted, the GPMI_IRQ output will "
        "assert.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RUN",
        "The GPMI is busy running a command whenever this bit is set to '1'.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "Set this bit zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set to zero for normal operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_CTRL0_CLR.
static const field_t hw_gpmi_ctrl0_clr[] =
{
    {
        "XFER_COUNT",
        "Number of bytes to transfer for this command.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRESS_INCREMENT",
        "In ATA mode, the address will increment with each cycle.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRESS",
        "Specifies the three address lines for ATA mode.",
        17, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS",
        "Selects which chip select is active for this command.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WORD_LENGTH",
        "This bit should only be changed when RUN==0.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COMMAND_MODE",
        "WRITE = 0x0 Write mode.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UDMA",
        "DISABLED = 0x0 Use ATA-PIO mode on the external bus.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_CS",
        "For ATA/NAND mode: 0= Deassert chip select (CS) after RUN is complete.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_IRQ_EN",
        "When set to '1' and ATA_IRQ pin is asserted, the GPMI_IRQ output will "
        "assert.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RUN",
        "The GPMI is busy running a command whenever this bit is set to '1'.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "Set this bit zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set to zero for normal operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_CTRL0_TOG.
static const field_t hw_gpmi_ctrl0_tog[] =
{
    {
        "XFER_COUNT",
        "Number of bytes to transfer for this command.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRESS_INCREMENT",
        "In ATA mode, the address will increment with each cycle.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRESS",
        "Specifies the three address lines for ATA mode.",
        17, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CS",
        "Selects which chip select is active for this command.",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WORD_LENGTH",
        "This bit should only be changed when RUN==0.",
        23, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "COMMAND_MODE",
        "WRITE = 0x0 Write mode.",
        24, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UDMA",
        "DISABLED = 0x0 Use ATA-PIO mode on the external bus.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "LOCK_CS",
        "For ATA/NAND mode: 0= Deassert chip select (CS) after RUN is complete.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_IRQ_EN",
        "When set to '1' and ATA_IRQ pin is asserted, the GPMI_IRQ output will "
        "assert.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RUN",
        "The GPMI is busy running a command whenever this bit is set to '1'.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKGATE",
        "Set this bit zero for normal operation.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SFTRST",
        "Set to zero for normal operation.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_COMPARE.
static const field_t hw_gpmi_compare[] =
{
    {
        "REFERENCE",
        "16-bit value which is XORed with data read from the NAND device.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MASK",
        "16-bit mask which is applied after the read data is XORed with the REF"
        "ERENCE bit field.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_ECCCTRL.
static const field_t hw_gpmi_eccctrl[] =
{
    {
        "BUFFER_MASK",
        "ECC buffer information.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RANDOMIZER_ENABLE",
        "Enable randomizer function.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_ECC",
        "Enable ECC processing of GPMI transfers.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_CMD",
        "ECC Command information.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "Always write zeroes to this bit field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HANDLE",
        "This is a register available to software to attach an identifier to a "
        "transaction in progress.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_ECCCTRL_SET.
static const field_t hw_gpmi_eccctrl_set[] =
{
    {
        "BUFFER_MASK",
        "ECC buffer information.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RANDOMIZER_ENABLE",
        "Enable randomizer function.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_ECC",
        "Enable ECC processing of GPMI transfers.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_CMD",
        "ECC Command information.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "Always write zeroes to this bit field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HANDLE",
        "This is a register available to software to attach an identifier to a "
        "transaction in progress.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_ECCCTRL_CLR.
static const field_t hw_gpmi_eccctrl_clr[] =
{
    {
        "BUFFER_MASK",
        "ECC buffer information.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RANDOMIZER_ENABLE",
        "Enable randomizer function.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_ECC",
        "Enable ECC processing of GPMI transfers.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_CMD",
        "ECC Command information.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "Always write zeroes to this bit field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HANDLE",
        "This is a register available to software to attach an identifier to a "
        "transaction in progress.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_ECCCTRL_TOG.
static const field_t hw_gpmi_eccctrl_tog[] =
{
    {
        "BUFFER_MASK",
        "ECC buffer information.",
        0, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RANDOMIZER_ENABLE",
        "Enable randomizer function.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENABLE_ECC",
        "Enable ECC processing of GPMI transfers.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ECC_CMD",
        "ECC Command information.",
        13, // LSB
        14, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD2",
        "Always write zeroes to this bit field.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HANDLE",
        "This is a register available to software to attach an identifier to a "
        "transaction in progress.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_ECCCOUNT.
static const field_t hw_gpmi_ecccount[] =
{
    {
        "COUNT",
        "Number of bytes to pass through ECC.",
        0, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RANDOMIZER_PAGE",
        "Set NAND page number needed to be randomized.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_PAYLOAD.
static const field_t hw_gpmi_payload[] =
{
    {
        "RSVD0",
        "Always write zeroes to this bit field.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ADDRESS",
        "Pointer to an array of one or more 512 byte payload buffers.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_AUXILIARY.
static const field_t hw_gpmi_auxiliary[] =
{
    {
        "RSVD0",
        "Always write zeroes to this bit field.",
        0, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ADDRESS",
        "Pointer to ECC control structure and meta-data storage.",
        2, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_CTRL1.
static const field_t hw_gpmi_ctrl1[] =
{
    {
        "GPMI_MODE",
        "ATA mode is only supported on channel zero.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAMERA_MODE",
        "When set to 1 and ATA UDMA is enabled the UDMA interface becomes a cam"
        "era interface.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATA_IRQRDY_POLARITY",
        "For ATA MODE: Note NAND_RDY_BUSY[3:2] are not affected by this bit.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_RESET",
        "ENABLED = 0x0 NANDF_WP_B(WPN) pin is held low (asserted).",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABORT_WAIT_FOR_READY_CHANNEL",
        "Abort a wait for ready command on selected channel.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABORT_WAIT_REQUEST",
        "Request to abort \"wait for ready\" command on channel indicated by AB"
        "ORT_WAIT_FOR_READY_CHANNEL.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BURST_EN",
        "When set to 1 each DMA request will generate a 4-transfer burst on the"
        " APB bus.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMEOUT_IRQ",
        "This bit is set when a timeout occurs using the Device_Busy_Timeout va"
        "lue.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_IRQ",
        "This bit is set when an Interrupt is received from the ATA device.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA2ECC_MODE",
        "This is mainly for testing HWECC without involving the Nand device.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDN_DELAY",
        "This variable is a factor in the calculated delay to apply to the inte"
        "rnal read strobe for correct read data sampling.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_PERIOD",
        "Set this bit to 1 if the GPMI clock period is greater than 16ns for pr"
        "oper DLL operation.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_ENABLE",
        "Set this bit to 1 to enable the GPMI DLL.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCH_MODE",
        "This bit selects which error correction unit will access GPMI.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GANGED_RDYBUSY",
        "Set this bit to 1 will force all Nand RDY_BUSY inputs to be sourced fr"
        "om (tied to) RDY_BUSY0.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMEOUT_IRQ_EN",
        "Setting this bit to '1' will enable timeout IRQ for transfers in ATA m"
        "ode only, and for WAIT_FOR_READY commands in both ATA and Nand mode.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEST_TRIGGER",
        "Test Trigger Enable",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRN_DLY_SEL",
        "Since the GPMI write strobe (WRN) is a fast clock pin, the delay on th"
        "is signal can be programmed to match the load on this pin.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DECOUPLE_CS",
        "Decouple Chip Select from DMA Channel.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSYNCMODE",
        "source synchronouse mode 1 or asynchrous mode 0.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPDATE_CS",
        "force the CS value is be updated to external chip select pin, even GPM"
        "I is idle.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPMI_CLK_DIV2_EN",
        "This bit should be reset to 0 in asynchronous mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TOGGLE_MODE",
        "enable samsung toggle mode.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRITE_CLK_STOP",
        "In onfi source synchronous mode, host may save power during the data w"
        "rite cycles by holding the CLK signal high (i.e.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSYNC_CLK_STOP",
        "set this bit to 1 will stop the source synchronous mode clk.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_CLK_STOP",
        "set this bit to 1 will stop gpmi io working clk.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_CTRL1_SET.
static const field_t hw_gpmi_ctrl1_set[] =
{
    {
        "GPMI_MODE",
        "ATA mode is only supported on channel zero.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAMERA_MODE",
        "When set to 1 and ATA UDMA is enabled the UDMA interface becomes a cam"
        "era interface.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATA_IRQRDY_POLARITY",
        "For ATA MODE: Note NAND_RDY_BUSY[3:2] are not affected by this bit.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_RESET",
        "ENABLED = 0x0 NANDF_WP_B(WPN) pin is held low (asserted).",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABORT_WAIT_FOR_READY_CHANNEL",
        "Abort a wait for ready command on selected channel.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABORT_WAIT_REQUEST",
        "Request to abort \"wait for ready\" command on channel indicated by AB"
        "ORT_WAIT_FOR_READY_CHANNEL.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BURST_EN",
        "When set to 1 each DMA request will generate a 4-transfer burst on the"
        " APB bus.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMEOUT_IRQ",
        "This bit is set when a timeout occurs using the Device_Busy_Timeout va"
        "lue.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_IRQ",
        "This bit is set when an Interrupt is received from the ATA device.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA2ECC_MODE",
        "This is mainly for testing HWECC without involving the Nand device.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDN_DELAY",
        "This variable is a factor in the calculated delay to apply to the inte"
        "rnal read strobe for correct read data sampling.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_PERIOD",
        "Set this bit to 1 if the GPMI clock period is greater than 16ns for pr"
        "oper DLL operation.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_ENABLE",
        "Set this bit to 1 to enable the GPMI DLL.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCH_MODE",
        "This bit selects which error correction unit will access GPMI.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GANGED_RDYBUSY",
        "Set this bit to 1 will force all Nand RDY_BUSY inputs to be sourced fr"
        "om (tied to) RDY_BUSY0.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMEOUT_IRQ_EN",
        "Setting this bit to '1' will enable timeout IRQ for transfers in ATA m"
        "ode only, and for WAIT_FOR_READY commands in both ATA and Nand mode.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEST_TRIGGER",
        "Test Trigger Enable",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRN_DLY_SEL",
        "Since the GPMI write strobe (WRN) is a fast clock pin, the delay on th"
        "is signal can be programmed to match the load on this pin.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DECOUPLE_CS",
        "Decouple Chip Select from DMA Channel.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSYNCMODE",
        "source synchronouse mode 1 or asynchrous mode 0.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPDATE_CS",
        "force the CS value is be updated to external chip select pin, even GPM"
        "I is idle.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPMI_CLK_DIV2_EN",
        "This bit should be reset to 0 in asynchronous mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TOGGLE_MODE",
        "enable samsung toggle mode.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRITE_CLK_STOP",
        "In onfi source synchronous mode, host may save power during the data w"
        "rite cycles by holding the CLK signal high (i.e.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSYNC_CLK_STOP",
        "set this bit to 1 will stop the source synchronous mode clk.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_CLK_STOP",
        "set this bit to 1 will stop gpmi io working clk.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_CTRL1_CLR.
static const field_t hw_gpmi_ctrl1_clr[] =
{
    {
        "GPMI_MODE",
        "ATA mode is only supported on channel zero.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAMERA_MODE",
        "When set to 1 and ATA UDMA is enabled the UDMA interface becomes a cam"
        "era interface.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATA_IRQRDY_POLARITY",
        "For ATA MODE: Note NAND_RDY_BUSY[3:2] are not affected by this bit.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_RESET",
        "ENABLED = 0x0 NANDF_WP_B(WPN) pin is held low (asserted).",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABORT_WAIT_FOR_READY_CHANNEL",
        "Abort a wait for ready command on selected channel.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABORT_WAIT_REQUEST",
        "Request to abort \"wait for ready\" command on channel indicated by AB"
        "ORT_WAIT_FOR_READY_CHANNEL.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BURST_EN",
        "When set to 1 each DMA request will generate a 4-transfer burst on the"
        " APB bus.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMEOUT_IRQ",
        "This bit is set when a timeout occurs using the Device_Busy_Timeout va"
        "lue.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_IRQ",
        "This bit is set when an Interrupt is received from the ATA device.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA2ECC_MODE",
        "This is mainly for testing HWECC without involving the Nand device.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDN_DELAY",
        "This variable is a factor in the calculated delay to apply to the inte"
        "rnal read strobe for correct read data sampling.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_PERIOD",
        "Set this bit to 1 if the GPMI clock period is greater than 16ns for pr"
        "oper DLL operation.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_ENABLE",
        "Set this bit to 1 to enable the GPMI DLL.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCH_MODE",
        "This bit selects which error correction unit will access GPMI.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GANGED_RDYBUSY",
        "Set this bit to 1 will force all Nand RDY_BUSY inputs to be sourced fr"
        "om (tied to) RDY_BUSY0.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMEOUT_IRQ_EN",
        "Setting this bit to '1' will enable timeout IRQ for transfers in ATA m"
        "ode only, and for WAIT_FOR_READY commands in both ATA and Nand mode.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEST_TRIGGER",
        "Test Trigger Enable",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRN_DLY_SEL",
        "Since the GPMI write strobe (WRN) is a fast clock pin, the delay on th"
        "is signal can be programmed to match the load on this pin.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DECOUPLE_CS",
        "Decouple Chip Select from DMA Channel.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSYNCMODE",
        "source synchronouse mode 1 or asynchrous mode 0.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPDATE_CS",
        "force the CS value is be updated to external chip select pin, even GPM"
        "I is idle.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPMI_CLK_DIV2_EN",
        "This bit should be reset to 0 in asynchronous mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TOGGLE_MODE",
        "enable samsung toggle mode.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRITE_CLK_STOP",
        "In onfi source synchronous mode, host may save power during the data w"
        "rite cycles by holding the CLK signal high (i.e.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSYNC_CLK_STOP",
        "set this bit to 1 will stop the source synchronous mode clk.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_CLK_STOP",
        "set this bit to 1 will stop gpmi io working clk.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_CTRL1_TOG.
static const field_t hw_gpmi_ctrl1_tog[] =
{
    {
        "GPMI_MODE",
        "ATA mode is only supported on channel zero.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CAMERA_MODE",
        "When set to 1 and ATA UDMA is enabled the UDMA interface becomes a cam"
        "era interface.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ATA_IRQRDY_POLARITY",
        "For ATA MODE: Note NAND_RDY_BUSY[3:2] are not affected by this bit.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_RESET",
        "ENABLED = 0x0 NANDF_WP_B(WPN) pin is held low (asserted).",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABORT_WAIT_FOR_READY_CHANNEL",
        "Abort a wait for ready command on selected channel.",
        4, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ABORT_WAIT_REQUEST",
        "Request to abort \"wait for ready\" command on channel indicated by AB"
        "ORT_WAIT_FOR_READY_CHANNEL.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BURST_EN",
        "When set to 1 each DMA request will generate a 4-transfer burst on the"
        " APB bus.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMEOUT_IRQ",
        "This bit is set when a timeout occurs using the Device_Busy_Timeout va"
        "lue.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_IRQ",
        "This bit is set when an Interrupt is received from the ATA device.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DMA2ECC_MODE",
        "This is mainly for testing HWECC without involving the Nand device.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RDN_DELAY",
        "This variable is a factor in the calculated delay to apply to the inte"
        "rnal read strobe for correct read data sampling.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "HALF_PERIOD",
        "Set this bit to 1 if the GPMI clock period is greater than 16ns for pr"
        "oper DLL operation.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DLL_ENABLE",
        "Set this bit to 1 to enable the GPMI DLL.",
        17, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCH_MODE",
        "This bit selects which error correction unit will access GPMI.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GANGED_RDYBUSY",
        "Set this bit to 1 will force all Nand RDY_BUSY inputs to be sourced fr"
        "om (tied to) RDY_BUSY0.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TIMEOUT_IRQ_EN",
        "Setting this bit to '1' will enable timeout IRQ for transfers in ATA m"
        "ode only, and for WAIT_FOR_READY commands in both ATA and Nand mode.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TEST_TRIGGER",
        "Test Trigger Enable",
        21, // LSB
        21, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRN_DLY_SEL",
        "Since the GPMI write strobe (WRN) is a fast clock pin, the delay on th"
        "is signal can be programmed to match the load on this pin.",
        22, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DECOUPLE_CS",
        "Decouple Chip Select from DMA Channel.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSYNCMODE",
        "source synchronouse mode 1 or asynchrous mode 0.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "UPDATE_CS",
        "force the CS value is be updated to external chip select pin, even GPM"
        "I is idle.",
        26, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GPMI_CLK_DIV2_EN",
        "This bit should be reset to 0 in asynchronous mode.",
        27, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TOGGLE_MODE",
        "enable samsung toggle mode.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WRITE_CLK_STOP",
        "In onfi source synchronous mode, host may save power during the data w"
        "rite cycles by holding the CLK signal high (i.e.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SSYNC_CLK_STOP",
        "set this bit to 1 will stop the source synchronous mode clk.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DEV_CLK_STOP",
        "set this bit to 1 will stop gpmi io working clk.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_TIMING0.
static const field_t hw_gpmi_timing0[] =
{
    {
        "DATA_SETUP",
        "Data bus setup time in GPMICLK cycles.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DATA_HOLD",
        "Data bus hold time in GPMICLK cycles.",
        8, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ADDRESS_SETUP",
        "Number of GPMICLK cycles that the CE/ADDR signals are active before a "
        "strobe is asserted.",
        16, // LSB
        23, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "Always write zeroes to this bit field.",
        24, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_TIMING1.
static const field_t hw_gpmi_timing1[] =
{
    {
        "RSVD1",
        "Always write zeroes to this bit field.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEVICE_BUSY_TIMEOUT",
        "Timeout waiting for NAND Ready/Busy or ATA IRQ.",
        16, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_TIMING2.
static const field_t hw_gpmi_timing2[] =
{
    {
        "DATA_PAUSE",
        "GPMI delay time from data pause to data resume in GPMICLK cycles.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CMDADD_PAUSE",
        "GPMI delay time from command or addres pause to command or address res"
        "ume in GPMICLK cycles.",
        4, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "POSTAMBLE_DELAY",
        "GPMI post-amble delay in GPMICLK cycles.",
        8, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PREAMBLE_DELAY",
        "GPMI pre-amble delay in GPMICLK cycles.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CE_DELAY",
        "GPMI dealy from CEn assert to W/Rn changing edge.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD0",
        "Always write zeroes to this bit field.",
        21, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "READ_LATENCY",
        "This field is for double data rate read latency configuration.",
        24, // LSB
        26, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCR",
        "Only for Toggle NAND timing control delay (TCR+1) GPMICLK cycles for C"
        "En_B low to RE_B low, 0 is less than or equal to TCR, which is less th"
        "an the PREAMBLE_DELAY",
        27, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TRPSTH",
        "Only for Toggle NAND timing control delay TRPSTH GPMICLK cycles for CE"
        "n_B high to RE_B high, A value of zero is interpreted as 8",
        29, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_DATA.
static const field_t hw_gpmi_data[] =
{
    {
        "DATA",
        "In 8-bit mode, one, two, three or four bytes can can be accessed to se"
        "nd the same number of bus cycles.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_STAT.
static const field_t hw_gpmi_stat[] =
{
    {
        "PRESENT",
        "UNAVAILABLE = 0x0 GPMI is not present in this product.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FIFO_FULL",
        "NOT_FULL = 0x0 FIFO is not full.",
        1, // LSB
        1, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FIFO_EMPTY",
        "NOT_EMPTY = 0x0 FIFO is not empty.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "INVALID_BUFFER_MASK",
        "Buffer Mask Validity bit.",
        3, // LSB
        3, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ATA_IRQ",
        "Status of the ATA_IRQ input pin.",
        4, // LSB
        4, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Always write zeroes to this bit field.",
        5, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEV0_ERROR",
        "DMA channel 0 (Timeout or compare failure, depending on COMMAND_MODE).",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEV1_ERROR",
        "DMA channel 1 (Timeout or compare failure, depending on COMMAND_MODE).",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEV2_ERROR",
        "DMA channel 2 (Timeout or compare failure, depending on COMMAND_MODE).",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEV3_ERROR",
        "DMA channel 3 (Timeout or compare failure, depending on COMMAND_MODE).",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEV4_ERROR",
        "DMA channel 4 (Timeout or compare failure, depending on COMMAND_MODE).",
        12, // LSB
        12, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEV5_ERROR",
        "DMA channel 5 (Timeout or compare failure, depending on COMMAND_MODE).",
        13, // LSB
        13, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEV6_ERROR",
        "DMA channel 6 (Timeout or compare failure, depending on COMMAND_MODE).",
        14, // LSB
        14, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DEV7_ERROR",
        "DMA channel 7 (Timeout or compare failure, depending on COMMAND_MODE).",
        15, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RDY_TIMEOUT",
        "State of the RDY/BUSY Timeout Flags.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "READY_BUSY",
        "Read-only view of NAND Ready_Busy Input pins.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_DEBUG.
static const field_t hw_gpmi_debug[] =
{
    {
        "CMD_END",
        "Read Only view of the Command End toggle signals to DMA.",
        0, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DMAREQ",
        "Read-only view of DMA request line for 8 DMA channels.",
        8, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "DMA_SENSE",
        "Read-only view of sense state of the 8 DMA channels.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WAIT_FOR_READY_END",
        "Read Only view of the Wait_For_Ready End toggle signals to DMA.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_VERSION.
static const field_t hw_gpmi_version[] =
{
    {
        "STEP",
        "Fixed read-only value reflecting the stepping of the RTL version.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MINOR",
        "Fixed read-only value reflecting the MINOR field of the RTL version.",
        16, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAJOR",
        "Fixed read-only value reflecting the MAJOR field of the RTL version.",
        24, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_DEBUG2.
static const field_t hw_gpmi_debug2[] =
{
    {
        "RDN_TAP",
        "This is the DLL tap calculated by the DLL controller.",
        0, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UPDATE_WINDOW",
        "A 1 indicates that the DLL is busy generating the required delay.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "VIEW_DELAYED_RDN",
        "Set to a 1 to select the delayed feedback RE_B to drive the GPMI_ADDR["
        "0] (Nand CLE) pin.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYND2GPMI_READY",
        "Data handshake Input from BCH.",
        8, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SYND2GPMI_VALID",
        "Data handshake Input from BCH.",
        9, // LSB
        9, // MSB
        true, // Readable
        false // Writable
    },
    {
        "GPMI2SYND_READY",
        "Data handshake output to BCH.",
        10, // LSB
        10, // MSB
        true, // Readable
        false // Writable
    },
    {
        "GPMI2SYND_VALID",
        "Data handshake output to BCH.",
        11, // LSB
        11, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SYND2GPMI_BE",
        "Data byte enable Input from BCH.",
        12, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "MAIN_STATE",
        "parameter MSM_IDLE = 4'h0, MSM_BYTCNT = 4'h1, MSM_WAITFE = 4'h2, MSM_W"
        "AITFR = 4'h3, MSM_DMAREQ = 4'h4, MSM_DMAACK = 4'h5, MSM_WAITFF = 4'h6,"
        " MSM_LDFIFO = 4'h7, MSM_LDDMAR = 4'h8, MSM_RDCMP = 4'h9, MSM_DONE = 4'"
        "hA.",
        16, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "PIN_STATE",
        "parameter PSM_IDLE = 3'h0, PSM_BYTCNT = 3'h1, PSM_ADDR = 3'h2, PSM_STA"
        "LL = 3'h3, PSM_STROBE = 3'h4, PSM_ATARDY = 3'h5, PSM_DHOLD = 3'h6, PSM"
        "_DONE = 3'h7.",
        20, // LSB
        22, // MSB
        true, // Readable
        false // Writable
    },
    {
        "BUSY",
        "When asserted the GPMI is busy.",
        23, // LSB
        23, // MSB
        true, // Readable
        false // Writable
    },
    {
        "UDMA_STATE",
        "USM_IDLE = 4'h0, idle USM_DMARQ = 4'h1, DMA req USM_ACK = 4'h2, DMA AC"
        "K USM_FIFO_E = 4'h3, Fifo empty USM_WPAUSE = 4'h4, WR DMA Paused by de"
        "vice USM_TSTRB = 4'h5, Toggle HSTROBE USM_CAPTUR = 4'h6, Capture Stage"
        ", (data sampled with DSTROBE is valid) USM_DATOUT = 4'h7, Change Burst"
        " DATAOUT USM_CRC = 4'h8, Source CRC to Device USM_WAIT_R = 4'h9, Waiti"
        "ng for DDMARDY- USM_END = 4'ha; Negate DMAACK (end of DMA) USM_WAIT_S "
        "= 4'hb, Waiting for DSTROBE USM_RPAUSE = 4'hc, Rd DMA Paused by Host U"
        "SM_RSTOP = 4'hd, Rd DMA Stopped by Host USM_WTERM = 4'he, Wr DMA Termi"
        "nation State USM_RTERM = 4'hf, Rd DMA Termination state",
        24, // LSB
        27, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Always write zeroes to this bit field.",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_DEBUG3.
static const field_t hw_gpmi_debug3[] =
{
    {
        "DEV_WORD_CNTR",
        "Reflects the number of bytes remains to be transferred on the ATA/Nand"
        " bus.",
        0, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "APB_WORD_CNTR",
        "Reflects the number of bytes remains to be transferred on the APB bus.",
        16, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_READ_DDR_DLL_CTRL.
static const field_t hw_gpmi_read_ddr_dll_ctrl[] =
{
    {
        "ENABLE",
        "Set this bit to 1 to enable the DLL and delay chain; otherwise; set to"
        " 0 to bypasses DLL.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET",
        "Setting this bit to 1 force a reset on DLL.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLV_FORCE_UPD",
        "Setting this bit to 1, forces the slave delay line to update to the DL"
        "L calibrated value immediately.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLV_DLY_TARGET",
        "The delay target for the read clock is can be programmed in 1/16th inc"
        "rements of an GPMICLK half-period.",
        3, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GATE_UPDATE",
        "Setting this bit to 1, forces the slave delay line not update",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFCLK_ON",
        "set this bit to 1 will turn on the reference clock",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLV_OVERRIDE",
        "Set this bit to 1 to Enable manual override for slave delay chain usin"
        "g SLV_OVERRIDE_VAL; to set 0 to disable manual override.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLV_OVERRIDE_VAL",
        "When SLV_OVERRIDE=1 This field is used to select 1 of 256 physical tap"
        "s manually.",
        10, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "Reserved",
        18, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SLV_UPDATE_INT",
        "Setting a value greater than 0 in this field, shall over-ride the defa"
        "ult slave delay-line update interval of 256 GPMICLK cycles.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REF_UPDATE_INT",
        "This field allows the user to add additional delay cycles to the DLL c"
        "ontrol loop (reference delay line control).",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_WRITE_DDR_DLL_CTRL.
static const field_t hw_gpmi_write_ddr_dll_ctrl[] =
{
    {
        "ENABLE",
        "Set this bit to 1 to enable the DLL and delay chain; otherwise; set to"
        " 0 to bypasses DLL.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RESET",
        "Setting this bit to 1 force a reset on DLL.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLV_FORCE_UPD",
        "Setting this bit to 1, forces the slave delay line to update to the DL"
        "L calibrated value immediately.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLV_DLY_TARGET",
        "The delay target for the read clock can be programmed in 1/16th increm"
        "ents of an GPMICLK half-period.",
        3, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "GATE_UPDATE",
        "Setting this bit to 1, forces the slave delay line not update",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REFCLK_ON",
        "set this bit to 1 will turn on the reference clock",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLV_OVERRIDE",
        "Set this bit to 1 to Enable manual override for slave delay chain usin"
        "g SLV_OVERRIDE_VAL; to set 0 to disable manual override.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SLV_OVERRIDE_VAL",
        "When SLV_OVERRIDE=1 This field is used to select 1 of 256 physical tap"
        "s manually.",
        10, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RSVD1",
        "Reserved",
        18, // LSB
        19, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SLV_UPDATE_INT",
        "Setting a value greater than 0 in this field, shall over-ride the defa"
        "ult slave delay-line update interval of 256 GPMICLK cycles.",
        20, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "REF_UPDATE_INT",
        "This field allows the user to add additional delay cycles to the DLL c"
        "ontrol loop (reference delay line control).",
        28, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_READ_DDR_DLL_STS.
static const field_t hw_gpmi_read_ddr_dll_sts[] =
{
    {
        "SLV_LOCK",
        "Slave delay-line lock status.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SLV_SEL",
        "Slave delay line select status",
        1, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD0",
        "Reserved",
        9, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REF_LOCK",
        "Reference DLL lock status.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REF_SEL",
        "Reference delay line select status.",
        17, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPMI_WRITE_DDR_DLL_STS.
static const field_t hw_gpmi_write_ddr_dll_sts[] =
{
    {
        "SLV_LOCK",
        "Slave delay-line lock status.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "SLV_SEL",
        "Slave delay line select status",
        1, // LSB
        8, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD0",
        "Reserved",
        9, // LSB
        15, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REF_LOCK",
        "Reference DLL lock status.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "REF_SEL",
        "Reference delay line select status.",
        17, // LSB
        24, // MSB
        true, // Readable
        false // Writable
    },
    {
        "RSVD1",
        "Reserved",
        25, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPMI module.
static const reg_t hw_gpmi[] =
{
    {
        "CTRL0",
        "The GPMI control register 0 specifies the GPMI transaction to perform "
        "for the current command chain item.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gpmi_ctrl0
    },
    {
        "CTRL0_SET",
        "The GPMI control register 0 specifies the GPMI transaction to perform "
        "for the current command chain item.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gpmi_ctrl0_set
    },
    {
        "CTRL0_CLR",
        "The GPMI control register 0 specifies the GPMI transaction to perform "
        "for the current command chain item.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gpmi_ctrl0_clr
    },
    {
        "CTRL0_TOG",
        "The GPMI control register 0 specifies the GPMI transaction to perform "
        "for the current command chain item.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        12, // Number of bitfields
        hw_gpmi_ctrl0_tog
    },
    {
        "COMPARE",
        "The GPMI compare register specifies the expect data and the xor mask f"
        "or comparing to the status values read from the device.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_gpmi_compare
    },
    {
        "ECCCTRL",
        "The GPMI ECC control register handles configuration of the integrated "
        "ECC / Randomizer accelerator.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gpmi_eccctrl
    },
    {
        "ECCCTRL_SET",
        "The GPMI ECC control register handles configuration of the integrated "
        "ECC / Randomizer accelerator.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gpmi_eccctrl_set
    },
    {
        "ECCCTRL_CLR",
        "The GPMI ECC control register handles configuration of the integrated "
        "ECC / Randomizer accelerator.",
        4, // Width in bytes
        0x00000028, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gpmi_eccctrl_clr
    },
    {
        "ECCCTRL_TOG",
        "The GPMI ECC control register handles configuration of the integrated "
        "ECC / Randomizer accelerator.",
        4, // Width in bytes
        0x0000002c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gpmi_eccctrl_tog
    },
    {
        "ECCCOUNT",
        "The GPMI ECC Transfer Count Register contains the count of bytes that "
        "flow through the ECC / Randomizer sub­system.",
        4, // Width in bytes
        0x00000030, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_gpmi_ecccount
    },
    {
        "PAYLOAD",
        "The GPMI payload address register specifies the location of the data b"
        "uffers in system memory.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_gpmi_payload
    },
    {
        "AUXILIARY",
        "The GPMI auxiliary address register specifies the location of the auxi"
        "liary buffers in system memory.",
        4, // Width in bytes
        0x00000050, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_gpmi_auxiliary
    },
    {
        "CTRL1",
        "The GPMI control register 1 specifies additional control fields that a"
        "re not used on a per-transaction basis.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        26, // Number of bitfields
        hw_gpmi_ctrl1
    },
    {
        "CTRL1_SET",
        "The GPMI control register 1 specifies additional control fields that a"
        "re not used on a per-transaction basis.",
        4, // Width in bytes
        0x00000064, // Base address offset
        true, // Readable
        true, // Writable
        26, // Number of bitfields
        hw_gpmi_ctrl1_set
    },
    {
        "CTRL1_CLR",
        "The GPMI control register 1 specifies additional control fields that a"
        "re not used on a per-transaction basis.",
        4, // Width in bytes
        0x00000068, // Base address offset
        true, // Readable
        true, // Writable
        26, // Number of bitfields
        hw_gpmi_ctrl1_clr
    },
    {
        "CTRL1_TOG",
        "The GPMI control register 1 specifies additional control fields that a"
        "re not used on a per-transaction basis.",
        4, // Width in bytes
        0x0000006c, // Base address offset
        true, // Readable
        true, // Writable
        26, // Number of bitfields
        hw_gpmi_ctrl1_tog
    },
    {
        "TIMING0",
        "The GPMI timing register 0 specifies the timing parameters that are us"
        "ed by the cycle state machine to guarantee the various setup, hold and"
        " cycle times for the external media type.",
        4, // Width in bytes
        0x00000070, // Base address offset
        true, // Readable
        true, // Writable
        4, // Number of bitfields
        hw_gpmi_timing0
    },
    {
        "TIMING1",
        "The GPMI timing register 1 specifies the timeouts used when monitoring"
        " the NAND READY pin or the ATA IRQ and IOWAIT signals.",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_gpmi_timing1
    },
    {
        "TIMING2",
        "The GPMI timing register 2 specifies the double data rate timing param"
        "eters that are used by the cycle state machine to guarantee the variou"
        "s cs delay, pre-amble delay, post-amble delay, command/address delay, "
        "data delay, TCR, TRPSTH, and read latency cycle times for the external"
        " media type.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        9, // Number of bitfields
        hw_gpmi_timing2
    },
    {
        "DATA",
        "The GPMI DMA data transfer register is used by the DMA to read or writ"
        "e data to or from the ATA/NAND control state machine.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpmi_data
    },
    {
        "STAT",
        "The GPMI control and status register provides a read back path for var"
        "ious operational states of the GPMI controller.",
        4, // Width in bytes
        0x000000b0, // Base address offset
        true, // Readable
        false, // Writable
        16, // Number of bitfields
        hw_gpmi_stat
    },
    {
        "DEBUG",
        "The GPMI debug information register provides a read back path for diag"
        "nostics to determine the current operating state of the GPMI controlle"
        "r.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        false, // Writable
        4, // Number of bitfields
        hw_gpmi_debug
    },
    {
        "VERSION",
        "This register reflects the version number for the GPMI.",
        4, // Width in bytes
        0x000000d0, // Base address offset
        true, // Readable
        false, // Writable
        3, // Number of bitfields
        hw_gpmi_version
    },
    {
        "DEBUG2",
        "The GPMI Debug2 information register provides a read back path for dia"
        "gnostics to determine the cur­rent operating state of the GPMI contro"
        "ller.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        13, // Number of bitfields
        hw_gpmi_debug2
    },
    {
        "DEBUG3",
        "The GPMI Debug3 information register provides a read back path for dia"
        "gnostics to determine the cur­rent operating state of the GPMI contro"
        "ller.",
        4, // Width in bytes
        0x000000f0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_gpmi_debug3
    },
    {
        "READ_DDR_DLL_CTRL",
        "GPMI DDR Read Delay Loop Lock Control Register.",
        4, // Width in bytes
        0x00000100, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_gpmi_read_ddr_dll_ctrl
    },
    {
        "WRITE_DDR_DLL_CTRL",
        "GPMI DDR Write Delay Loop Lock Control Register.",
        4, // Width in bytes
        0x00000110, // Base address offset
        true, // Readable
        true, // Writable
        11, // Number of bitfields
        hw_gpmi_write_ddr_dll_ctrl
    },
    {
        "READ_DDR_DLL_STS",
        "GPMI Double Rate Read DLL Status Register, Read Only.",
        4, // Width in bytes
        0x00000120, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_gpmi_read_ddr_dll_sts
    },
    {
        "WRITE_DDR_DLL_STS",
        "GPMI Double Rate Write DLL Status Register, Read Only.",
        4, // Width in bytes
        0x00000130, // Base address offset
        true, // Readable
        false, // Writable
        6, // Number of bitfields
        hw_gpmi_write_ddr_dll_sts
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark GPT
#endif

// Bitfields in register GPT_CR.
static const field_t hw_gpt_cr[] =
{
    {
        "EN",
        "GPT Enable.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ENMOD",
        "GPT Enable mode.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGEN",
        "GPT debug mode enable.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WAITEN",
        "GPT Wait Mode enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DOZEEN",
        "GPT Doze Mode Enable.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPEN",
        "GPT Stop Mode enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "CLKSRC",
        "Clock Source select.",
        6, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRR",
        "Free-Run or Restart mode.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "EN_24M",
        "Enable 24MHz clock input from crystal.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SWR",
        "Software reset.",
        15, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IM1",
        "See IM2",
        16, // LSB
        17, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IM2",
        "IM2 (bits 19-18, Input Capture Channel 2 operating mode) IM1 (bits 17-"
        "16, Input Capture Channel 1 operating mode) The IMn bit field determin"
        "es the transition on the input pin (for Input capture channel n), whic"
        "h will trigger a capture event.",
        18, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM1",
        "See OM3",
        20, // LSB
        22, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM2",
        "See OM3",
        23, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OM3",
        "OM3 (bits 28-26) controls the Output Compare Channel 3 operating mode.",
        26, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FO1",
        "See F03",
        29, // LSB
        29, // MSB
        false, // Readable
        false // Writable
    },
    {
        "FO2",
        "See F03",
        30, // LSB
        30, // MSB
        false, // Readable
        false // Writable
    },
    {
        "FO3",
        "FO3 Force Output Compare Channel 3 FO2 Force Output Compare Channel 2 "
        "FO1 Force Output Compare Channel 1 The FOn bit causes the pin action p"
        "rogrammed for the timer Output Compare n pin (according to the OMn bit"
        "s in this register).",
        31, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_PR.
static const field_t hw_gpt_pr[] =
{
    {
        "PRESCALER",
        "Prescaler bits.",
        0, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "PRESCALER24M",
        "Prescaler bits.",
        12, // LSB
        15, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_SR.
static const field_t hw_gpt_sr[] =
{
    {
        "OF1",
        "See OF3",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF2",
        "See OF3",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF3",
        "OF3 Output Compare 3 Flag OF2 Output Compare 2 Flag OF1 Output Compare"
        " 1 Flag The OFn bit indicates that a compare event has occurred on Out"
        "put Compare channel n.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF1",
        "See IF2",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF2",
        "IF2 Input capture 2 Flag IF1 Input capture 1 Flag The IFn bit indicate"
        "s that a capture event has occurred on Input Capture channel n.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROV",
        "Rollover Flag.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_IR.
static const field_t hw_gpt_ir[] =
{
    {
        "OF1IE",
        "See OF3IE",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF2IE",
        "See OF3IE",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "OF3IE",
        "OF3IE Output Compare 3 Interrupt Enable OF2IE Output Compare 2 Interru"
        "pt Enable OF1IE Output Compare 1 Interrupt Enable The OFnIE bit contro"
        "ls the Output Compare Channel n interrupt.",
        2, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF1IE",
        "See IF2IE",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IF2IE",
        "IF2IE Input capture 2 Interrupt Enable IF1IE Input capture 1 Interrupt"
        " Enable The IFnIE bit controls the IFnIE Input Capture n Interrupt Ena"
        "ble.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "ROVIE",
        "Rollover Interrupt Enable.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_OCR1.
static const field_t hw_gpt_ocr1[] =
{
    {
        "COMP",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_OCR2.
static const field_t hw_gpt_ocr2[] =
{
    {
        "COMP",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_OCR3.
static const field_t hw_gpt_ocr3[] =
{
    {
        "COMP",
        "Compare Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_ICR1.
static const field_t hw_gpt_icr1[] =
{
    {
        "CAPT",
        "Capture Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_ICR2.
static const field_t hw_gpt_icr2[] =
{
    {
        "CAPT",
        "Capture Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register GPT_CNT.
static const field_t hw_gpt_cnt[] =
{
    {
        "COUNT",
        "Counter Value.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Registers in a GPT module.
static const reg_t hw_gpt[] =
{
    {
        "CR",
        "The GPT Control Register (GPT_CR) is used to program and configure GPT"
        " operations.",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_gpt_cr
    },
    {
        "PR",
        "The GPT Prescaler Register (GPT_PR) contains bits that determine the d"
        "ivide value of the clock that runs the counter.",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_gpt_pr
    },
    {
        "SR",
        "The GPT Status Register (GPT_SR) contains bits that indicate that a co"
        "unter has rolled over, and if any event has occurred on the Input Capt"
        "ure and Output Compare channels.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gpt_sr
    },
    {
        "IR",
        "The GPT Interrupt Register (GPT_IR) contains bits that control whether"
        " interrupts are generated after rollover, input capture and output com"
        "pare events.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_gpt_ir
    },
    {
        "OCR1",
        "The GPT Compare Register 1 (GPT_OCR1) holds the value that determines "
        "when a compare event will be generated on Output Compare Channel 1.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpt_ocr1
    },
    {
        "OCR2",
        "The GPT Compare Register 2 (GPT_OCR2) holds the value that determines "
        "when a compare event will be generated on Output Compare Channel 2.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpt_ocr2
    },
    {
        "OCR3",
        "The GPT Compare Register 3 (GPT_OCR3) holds the value that determines "
        "when a compare event will be generated on Output Compare Channel 3.",
        4, // Width in bytes
        0x00000018, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_gpt_ocr3
    },
    {
        "ICR1",
        "The GPT Input Capture Register 1 (GPT_ICR1) is a read-only register th"
        "at holds the value that was in the counter during the last capture eve"
        "nt on Input Capture Channel 1.",
        4, // Width in bytes
        0x0000001c, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpt_icr1
    },
    {
        "ICR2",
        "The GPT Input capture Register 2 (GPT_ICR2) is a read-only register wh"
        "ich holds the value that was in the counter during the last capture ev"
        "ent on input capture channel 2.",
        4, // Width in bytes
        0x00000020, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpt_icr2
    },
    {
        "CNT",
        "The GPT Counter Register (GPT_CNT) is the main counter's register.",
        4, // Width in bytes
        0x00000024, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_gpt_cnt
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark I2C
#endif

// Bitfields in register I2C_IADR.
static const field_t hw_i2c_iadr[] =
{
    {
        "ADR",
        "Slave address.",
        1, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_IFDR.
static const field_t hw_i2c_ifdr[] =
{
    {
        "IC",
        "I2C clock rate.",
        0, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_I2CR.
static const field_t hw_i2c_i2cr[] =
{
    {
        "RSTA",
        "Repeat start.",
        2, // LSB
        2, // MSB
        false, // Readable
        false // Writable
    },
    {
        "TXAK",
        "Transmit acknowledge enable.",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MTX",
        "Transmit/Receive mode select bit.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MSTA",
        "Master/Slave mode select bit.",
        5, // LSB
        5, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IIEN",
        "I2C interrupt enable.",
        6, // LSB
        6, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IEN",
        "I2C enable.",
        7, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_I2SR.
static const field_t hw_i2c_i2sr[] =
{
    {
        "RXAK",
        "Received acknowledge.",
        0, // LSB
        0, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IIF",
        "I2C interrupt.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SRW",
        "Slave read/write.",
        2, // LSB
        2, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAL",
        "Arbitration lost.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "IBB",
        "I2C bus busy bit.",
        5, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "IAAS",
        "I2C addressed as a slave bit.",
        6, // LSB
        6, // MSB
        true, // Readable
        false // Writable
    },
    {
        "ICF",
        "Data transferring bit.",
        7, // LSB
        7, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2C_I2DR.
static const field_t hw_i2c_i2dr[] =
{
    {
        "DATA",
        "Data Byte.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a I2C module.
static const reg_t hw_i2c[] =
{
    {
        "IADR",
        "",
        2, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2c_iadr
    },
    {
        "IFDR",
        "The I2C_IFDR provides a programmable prescaler to configure the clock "
        "for bit-rate selection.",
        2, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2c_ifdr
    },
    {
        "I2CR",
        "The I2C_I2CR is used to enable the I2C and the I2C interrupt.",
        2, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_i2c_i2cr
    },
    {
        "I2SR",
        "The I2C_I2SR contains bits that indicate transaction direction and sta"
        "tus.",
        2, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_i2c_i2sr
    },
    {
        "I2DR",
        "In Master Receive mode, reading the data register allows a read to occ"
        "ur and initiates the next byte to be received.",
        2, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2c_i2dr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark I2S
#endif

// Bitfields in register I2S_TCSR.
static const field_t hw_i2s_tcsr[] =
{
    {
        "FRDE",
        "Enables/disables DMA requests.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWDE",
        "Enables/disables DMA requests.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRIE",
        "Enables/disables FIFO request interrupts.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWIE",
        "Enables/disables FIFO warning interrupts.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FEIE",
        "Enables/disables FIFO error interrupts.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEIE",
        "Enables/disables sync error interrupts.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSIE",
        "Enables/disables word start interrupts.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRF",
        "Indicates that the number of words in an enabled transmit channel FIFO"
        " is less than or equal to the transmit FIFO watermark.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FWF",
        "Indicates that an enabled transmit FIFO is empty.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FEF",
        "Indicates that an enabled transmit FIFO has underrun.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEF",
        "Indicates that an error in the externally-generated frame sync has bee"
        "n detected.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSF",
        "Indicates that the start of the configured word has been detected.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SR",
        "When set, resets the internal transmitter logic including the FIFO poi"
        "nters.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FR",
        "Resets the FIFO pointers.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "BCE",
        "Enables the transmit bit clock, separately from the TE.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGE",
        "Enables/disables transmitter operation in Debug mode.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPE",
        "Configures transmitter operation in Stop mode.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TE",
        "Enables/disables the transmitter.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_TCR1.
static const field_t hw_i2s_tcr1[] =
{
    {
        "TFW",
        "Configures the watermark level for all enabled transmit channels.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_TCR2.
static const field_t hw_i2s_tcr2[] =
{
    {
        "DIV",
        "Divides down the audio master clock to generate the bit clock when con"
        "figured for an internal bit clock.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Configures the direction of the bit clock.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCP",
        "Configures the polarity of the bit clock.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MSEL",
        "Selects the audio Master Clock option used to generate an internally g"
        "enerated bit clock.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCI",
        "When this field is set and using an internally generated bit clock in "
        "either synchronous or asynchronous mode, the bit clock actually used b"
        "y the transmitter is delayed by the pad output delay (the transmitter "
        "is clocked by the pad input as if the clock was externally generated).",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "This field swaps the bit clock used by the transmitter.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYNC",
        "Configures between asynchronous and synchronous modes of operation.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_TCR3.
static const field_t hw_i2s_tcr3[] =
{
    {
        "WDFL",
        "Configures which word sets the start of word flag.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "TCE",
        "Enables the corresponding data channel for transmit operation.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_TCR4.
static const field_t hw_i2s_tcr4[] =
{
    {
        "FSD",
        "Configures the direction of the frame sync.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSP",
        "Configures the polarity of the frame sync.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MF",
        "Configures whether the LSB or the MSB is transmitted first.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYWD",
        "Configures the length of the frame sync in number of bit clocks.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRSZ",
        "Configures the number of words in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_TCR5.
static const field_t hw_i2s_tcr5[] =
{
    {
        "FBT",
        "Configures the bit index for the first bit transmitted for each word i"
        "n the frame.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "W0W",
        "Configures the number of bits in the first word in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WNW",
        "Configures the number of bits in each word, for each word except the f"
        "irst in the frame.",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_TDR0.
static const field_t hw_i2s_tdr0[] =
{
    {
        "TDR",
        "The corresponding TCR3[TCE] bit must be set before accessing the chann"
        "el's transmit data register.",
        0, // LSB
        31, // MSB
        false, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_TFR0.
static const field_t hw_i2s_tfr0[] =
{
    {
        "RFP",
        "FIFO read pointer for transmit data channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for transmit data channel.",
        16, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_TMR.
static const field_t hw_i2s_tmr[] =
{
    {
        "TWM",
        "Configures whether the transmit word is masked (transmit data pin tris"
        "tated and transmit data not read from FIFO) for the corresponding word"
        " in the frame.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_RCSR.
static const field_t hw_i2s_rcsr[] =
{
    {
        "FRDE",
        "Enables/disables DMA requests.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWDE",
        "Enables/disables DMA requests.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRIE",
        "Enables/disables FIFO request interrupts.",
        8, // LSB
        8, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FWIE",
        "Enables/disables FIFO warning interrupts.",
        9, // LSB
        9, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FEIE",
        "Enables/disables FIFO error interrupts.",
        10, // LSB
        10, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEIE",
        "Enables/disables sync error interrupts.",
        11, // LSB
        11, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSIE",
        "Enables/disables word start interrupts.",
        12, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRF",
        "Indicates that the number of words in an enabled receive channel FIFO "
        "is greater than the receive FIFO watermark.",
        16, // LSB
        16, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FWF",
        "Indicates that an enabled receive FIFO is full.",
        17, // LSB
        17, // MSB
        true, // Readable
        false // Writable
    },
    {
        "FEF",
        "Indicates that an enabled receive FIFO has overflowed.",
        18, // LSB
        18, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SEF",
        "Indicates that an error in the externally-generated frame sync has bee"
        "n detected.",
        19, // LSB
        19, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WSF",
        "Indicates that the start of the configured word has been detected.",
        20, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SR",
        "Resets the internal receiver logic including the FIFO pointers.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FR",
        "Resets the FIFO pointers.",
        25, // LSB
        25, // MSB
        false, // Readable
        false // Writable
    },
    {
        "BCE",
        "Enables the receive bit clock, separately from RE.",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "DBGE",
        "Enables/disables receiver operation in Debug mode.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "STOPE",
        "Configures receiver operation in Stop mode.",
        30, // LSB
        30, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RE",
        "Enables/disables the receiver.",
        31, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_RCR1.
static const field_t hw_i2s_rcr1[] =
{
    {
        "RFW",
        "Configures the watermark level for all enabled receiver channels.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_RCR2.
static const field_t hw_i2s_rcr2[] =
{
    {
        "DIV",
        "Divides down the audio master clock to generate the bit clock when con"
        "figured for an internal bit clock.",
        0, // LSB
        7, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCD",
        "Configures the direction of the bit clock.",
        24, // LSB
        24, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCP",
        "Configures the polarity of the bit clock.",
        25, // LSB
        25, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MSEL",
        "Selects the audio Master Clock option used to generate an internally g"
        "enerated bit clock.",
        26, // LSB
        27, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCI",
        "When this field is set and using an internally generated bit clock in "
        "either synchronous or asynchronous mode, the bit clock actually used b"
        "y the receiver is delayed by the pad output delay (the receiver is clo"
        "cked by the pad input as if the clock was externally generated).",
        28, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    {
        "BCS",
        "This field swaps the bit clock used by the receiver.",
        29, // LSB
        29, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYNC",
        "Configures between asynchronous and synchronous modes of operation.",
        30, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_RCR3.
static const field_t hw_i2s_rcr3[] =
{
    {
        "WDFL",
        "Configures which word the start of word flag is set.",
        0, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "RCE",
        "Enables the corresponding data channel for receive operation.",
        16, // LSB
        16, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_RCR4.
static const field_t hw_i2s_rcr4[] =
{
    {
        "FSD",
        "Configures the direction of the frame sync.",
        0, // LSB
        0, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSP",
        "Configures the polarity of the frame sync.",
        1, // LSB
        1, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FSE",
        "",
        3, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "MF",
        "Configures whether the LSB or the MSB is received first.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SYWD",
        "Configures the length of the frame sync in number of bit clocks.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "FRSZ",
        "Configures the number of words in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_RCR5.
static const field_t hw_i2s_rcr5[] =
{
    {
        "FBT",
        "Configures the bit index for the first bit received for each word in t"
        "he frame.",
        8, // LSB
        12, // MSB
        true, // Readable
        true // Writable
    },
    {
        "W0W",
        "Configures the number of bits in the first word in each frame.",
        16, // LSB
        20, // MSB
        true, // Readable
        true // Writable
    },
    {
        "WNW",
        "Configures the number of bits in each word, for each word except the f"
        "irst in the frame.",
        24, // LSB
        28, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_RDR0.
static const field_t hw_i2s_rdr0[] =
{
    {
        "RDR",
        "The corresponding RCR3[RCE] bit must be set before accessing the chann"
        "el's receive data register.",
        0, // LSB
        31, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_RFR0.
static const field_t hw_i2s_rfr0[] =
{
    {
        "RFP",
        "FIFO read pointer for receive data channel.",
        0, // LSB
        5, // MSB
        true, // Readable
        false // Writable
    },
    {
        "WFP",
        "FIFO write pointer for receive data channel.",
        16, // LSB
        21, // MSB
        true, // Readable
        false // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register I2S_RMR.
static const field_t hw_i2s_rmr[] =
{
    {
        "RWM",
        "Configures whether the receive word is masked (received data ignored a"
        "nd not written to receive FIFO) for the corresponding word in the fram"
        "e.",
        0, // LSB
        31, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Registers in a I2S module.
static const reg_t hw_i2s[] =
{
    {
        "TCSR",
        "",
        4, // Width in bytes
        0x00000000, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_i2s_tcsr
    },
    {
        "TCR1",
        "",
        4, // Width in bytes
        0x00000004, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2s_tcr1
    },
    {
        "TCR2",
        "This register must not be altered when TCSR[TE] is set.",
        4, // Width in bytes
        0x00000008, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_i2s_tcr2
    },
    {
        "TCR3",
        "This register must not be altered when TCSR[TE] is set.",
        4, // Width in bytes
        0x0000000c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_i2s_tcr3
    },
    {
        "TCR4",
        "This register must not be altered when TCSR[TE] is set.",
        4, // Width in bytes
        0x00000010, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_i2s_tcr4
    },
    {
        "TCR5",
        "This register must not be altered when TCSR[TE] is set.",
        4, // Width in bytes
        0x00000014, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_i2s_tcr5
    },
    {
        "TDR0",
        "",
        4, // Width in bytes
        0x00000020, // Base address offset
        false, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2s_tdr0
    },
    {
        "TFR0",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x00000040, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_i2s_tfr0
    },
    {
        "TMR",
        "This register is double-buffered and updates: When TCSR[TE] is first s"
        "et At the end of each frame.",
        4, // Width in bytes
        0x00000060, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2s_tmr
    },
    {
        "RCSR",
        "",
        4, // Width in bytes
        0x00000080, // Base address offset
        true, // Readable
        true, // Writable
        18, // Number of bitfields
        hw_i2s_rcsr
    },
    {
        "RCR1",
        "",
        4, // Width in bytes
        0x00000084, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2s_rcr1
    },
    {
        "RCR2",
        "This register must not be altered when RCSR[RE] is set.",
        4, // Width in bytes
        0x00000088, // Base address offset
        true, // Readable
        true, // Writable
        7, // Number of bitfields
        hw_i2s_rcr2
    },
    {
        "RCR3",
        "This register must not be altered when RCSR[RE] is set.",
        4, // Width in bytes
        0x0000008c, // Base address offset
        true, // Readable
        true, // Writable
        2, // Number of bitfields
        hw_i2s_rcr3
    },
    {
        "RCR4",
        "This register must not be altered when RCSR[RE] is set.",
        4, // Width in bytes
        0x00000090, // Base address offset
        true, // Readable
        true, // Writable
        6, // Number of bitfields
        hw_i2s_rcr4
    },
    {
        "RCR5",
        "This register must not be altered when RCSR[RE] is set.",
        4, // Width in bytes
        0x00000094, // Base address offset
        true, // Readable
        true, // Writable
        3, // Number of bitfields
        hw_i2s_rcr5
    },
    {
        "RDR0",
        "Reading this register introduces one additional peripheral clock wait "
        "state on each read.",
        4, // Width in bytes
        0x000000a0, // Base address offset
        true, // Readable
        false, // Writable
        1, // Number of bitfields
        hw_i2s_rdr0
    },
    {
        "RFR0",
        "The MSB of the read and write pointers is used to distinguish between "
        "FIFO full and empty conditions.",
        4, // Width in bytes
        0x000000c0, // Base address offset
        true, // Readable
        false, // Writable
        2, // Number of bitfields
        hw_i2s_rfr0
    },
    {
        "RMR",
        "This register is double-buffered and updates: When RCSR[RE] is first s"
        "et At the end of each frame This allows the masked words in each frame"
        " to change from frame to frame.",
        4, // Width in bytes
        0x000000e0, // Base address offset
        true, // Readable
        true, // Writable
        1, // Number of bitfields
        hw_i2s_rmr
    },
    { 0 } // Terminator
};

//------------------------------------------------------------------------------
#if __nonexistant__
#pragma mark IOMUXC
#endif

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_BOOT_MODE0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_boot_mode0[] =
{
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_BOOT_MODE1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_boot_mode1[] =
{
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_snvs_tamper0[] =
{
    {
        "MUX_MODE",
        "ALT5 mode is only valid when TAMPER PIN is used as GPIO.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER1.
static const field_t hw_iomuxc_sw_mux_ctl_pad_snvs_tamper1[] =
{
    {
        "MUX_MODE",
        "ALT5 mode is only valid when TAMPER PIN is used as GPIO.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER2.
static const field_t hw_iomuxc_sw_mux_ctl_pad_snvs_tamper2[] =
{
    {
        "MUX_MODE",
        "ALT5 mode is only valid when TAMPER PIN is used as GPIO.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER3.
static const field_t hw_iomuxc_sw_mux_ctl_pad_snvs_tamper3[] =
{
    {
        "MUX_MODE",
        "ALT5 mode is only valid when TAMPER PIN is used as GPIO.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER4.
static const field_t hw_iomuxc_sw_mux_ctl_pad_snvs_tamper4[] =
{
    {
        "MUX_MODE",
        "ALT5 mode is only valid when TAMPER PIN is used as GPIO.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER5.
static const field_t hw_iomuxc_sw_mux_ctl_pad_snvs_tamper5[] =
{
    {
        "MUX_MODE",
        "ALT5 mode is only valid when TAMPER PIN is used as GPIO.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER6.
static const field_t hw_iomuxc_sw_mux_ctl_pad_snvs_tamper6[] =
{
    {
        "MUX_MODE",
        "ALT5 mode is only valid when TAMPER PIN is used as GPIO.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER7.
static const field_t hw_iomuxc_sw_mux_ctl_pad_snvs_tamper7[] =
{
    {
        "MUX_MODE",
        "ALT5 mode is only valid when TAMPER PIN is used as GPIO.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER8.
static const field_t hw_iomuxc_sw_mux_ctl_pad_snvs_tamper8[] =
{
    {
        "MUX_MODE",
        "ALT5 mode is only valid when TAMPER PIN is used as GPIO.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_SNVS_TAMPER9.
static const field_t hw_iomuxc_sw_mux_ctl_pad_snvs_tamper9[] =
{
    {
        "MUX_MODE",
        "ALT5 mode is only valid when TAMPER PIN is used as GPIO.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_JTAG_MOD.
static const field_t hw_iomuxc_sw_mux_ctl_pad_jtag_mod[] =
{
    {
        "MUX_MODE",
        "Select 1 of 7 iomux modes to be used for pad: JTAG_MOD.",
        0, // LSB
        2, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_JTAG_TMS.
static const field_t hw_iomuxc_sw_mux_ctl_pad_jtag_tms[] =
{
    {
        "MUX_MODE",
        "Select 1 of 8 iomux modes to be used for pad: JTAG_TMS.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_JTAG_TDO.
static const field_t hw_iomuxc_sw_mux_ctl_pad_jtag_tdo[] =
{
    {
        "MUX_MODE",
        "Select 1 of 8 iomux modes to be used for pad: JTAG_TDO.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_JTAG_TDI.
static const field_t hw_iomuxc_sw_mux_ctl_pad_jtag_tdi[] =
{
    {
        "MUX_MODE",
        "Select 1 of 8 iomux modes to be used for pad: JTAG_TDI.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_JTAG_TCK.
static const field_t hw_iomuxc_sw_mux_ctl_pad_jtag_tck[] =
{
    {
        "MUX_MODE",
        "Select 1 of 8 iomux modes to be used for pad: JTAG_TCK.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_JTAG_TRST_B.
static const field_t hw_iomuxc_sw_mux_ctl_pad_jtag_trst_b[] =
{
    {
        "MUX_MODE",
        "Select 1 of 8 iomux modes to be used for pad: JTAG_TRST_B.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO00.
static const field_t hw_iomuxc_sw_mux_ctl_pad_gpio1_io00[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: GPIO1_IO00.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO01.
static const field_t hw_iomuxc_sw_mux_ctl_pad_gpio1_io01[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: GPIO1_IO01.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO02.
static const field_t hw_iomuxc_sw_mux_ctl_pad_gpio1_io02[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: GPIO1_IO02.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO03.
static const field_t hw_iomuxc_sw_mux_ctl_pad_gpio1_io03[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: GPIO1_IO03.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO04.
static const field_t hw_iomuxc_sw_mux_ctl_pad_gpio1_io04[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: GPIO1_IO04.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO05.
static const field_t hw_iomuxc_sw_mux_ctl_pad_gpio1_io05[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: GPIO1_IO05.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO06.
static const field_t hw_iomuxc_sw_mux_ctl_pad_gpio1_io06[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: GPIO1_IO06.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO07.
static const field_t hw_iomuxc_sw_mux_ctl_pad_gpio1_io07[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: GPIO1_IO07.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO08.
static const field_t hw_iomuxc_sw_mux_ctl_pad_gpio1_io08[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: GPIO1_IO08.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_GPIO1_IO09.
static const field_t hw_iomuxc_sw_mux_ctl_pad_gpio1_io09[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: GPIO1_IO09.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART1_TX_DATA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart1_tx_data[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART1_TX_DATA.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART1_RX_DATA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart1_rx_data[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART1_RX_DATA.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART1_CTS_B.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart1_cts_b[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART1_CTS_B.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART1_RTS_B.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart1_rts_b[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART1_RTS_B.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART2_TX_DATA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart2_tx_data[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART2_TX_DATA.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART2_RX_DATA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart2_rx_data[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART2_RX_DATA.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART2_CTS_B.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart2_cts_b[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART2_CTS_B.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART2_RTS_B.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart2_rts_b[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART2_RTS_B.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART3_TX_DATA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart3_tx_data[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART3_TX_DATA.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART3_RX_DATA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart3_rx_data[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART3_RX_DATA.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART3_CTS_B.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart3_cts_b[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART3_CTS_B.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART3_RTS_B.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart3_rts_b[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART3_RTS_B.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART4_TX_DATA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart4_tx_data[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART4_TX_DATA.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART4_RX_DATA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart4_rx_data[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART4_RX_DATA.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART5_TX_DATA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart5_tx_data[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART5_TX_DATA.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_UART5_RX_DATA.
static const field_t hw_iomuxc_sw_mux_ctl_pad_uart5_rx_data[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: UART5_RX_DATA.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the selected mux mode Input path no matter of MUX_MODE functiona"
        "lity.",
        4, // LSB
        4, // MSB
        true, // Readable
        true // Writable
    },
    { 0 } // Terminator
};

// Bitfields in register IOMUXC_SW_MUX_CTL_PAD_ENET1_RX_DATA0.
static const field_t hw_iomuxc_sw_mux_ctl_pad_enet1_rx_data0[] =
{
    {
        "MUX_MODE",
        "Select 1 of 9 iomux modes to be used for pad: ENET1_RX_DATA0.",
        0, // LSB
        3, // MSB
        true, // Readable
        true // Writable
    },
    {
        "SION",
        "Force the sele